/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillSortConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.IQueueSortable;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;

public class WriteOffQueueGroup {
    private String uniqueKey;
    private WriteOffMatchGroup group;
    private List<IWriteOffQueue> candidateQueues = new ArrayList<IWriteOffQueue>(16);
    private IWriteOffQueue mainQueue;
    private List<IWriteOffQueue> assistQueues = new ArrayList<IWriteOffQueue>(16);
    private BackWriteOffDetail detail = null;

    public WriteOffQueueGroup(WriteOffMatchGroup group) {
        this.group = group;
    }

    public void createFromList(List<IWriteOffQueue> queues) {
        this.candidateQueues.clear();
        this.assistQueues.clear();
        this.candidateQueues.addAll(queues);
        int i = 0;
        for (IWriteOffQueue queue : queues) {
            if (i == 0) {
                this.mainQueue = queue;
            } else {
                this.assistQueues.add(queue);
            }
            ++i;
        }
    }

    public void createPromoterQueue(List<WriteOffObject> writeOffObjects) {
        if (CollectionUtils.isEmpty(writeOffObjects)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u8fc7\u6ee4\u540e\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"WriteOffBillDispatcher_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        IQueueSortable iQueueSortable = this.getQueueSortable(writeOffObjects);
        this.candidateQueues.add(iQueueSortable);
        this.mainQueue = iQueueSortable;
    }

    public void createParticipantQueue(List<WriteOffObject> candidates) {
        if (CollectionUtils.isEmpty(candidates)) {
            WriteOffObjectQueue candidateQueue = new WriteOffObjectQueue(new ArrayList<BillSortConfig>(16), this.getSchemeContextConfig(), null);
            this.candidateQueues.add(candidateQueue);
            this.assistQueues.add(candidateQueue);
        } else {
            IQueueSortable candidateQueue = this.getQueueSortable(candidates);
            this.candidateQueues.add(candidateQueue);
            this.assistQueues.add(candidateQueue);
        }
    }

    public void addAutoWriteOffQueue(List<WriteOffObject> autoWfObjs) {
        WriteOffObjectQueue writeOffQueue = new WriteOffObjectQueue();
        for (WriteOffObject writeOffObject : autoWfObjs) {
            writeOffQueue.add(writeOffObject.getWriteOffObjectBase());
        }
        this.candidateQueues.add(writeOffQueue);
        this.assistQueues.add(writeOffQueue);
    }

    private IQueueSortable getQueueSortable(List<WriteOffObject> candidates) {
        WriteOffBillConfig writeOffBillConfig = candidates.get(0).getWriteOffBillConfig();
        String billAlias = writeOffBillConfig.getBillAlias();
        List<BillSortConfig> billSortConfigs = this.getSchemeConfig().getBillSortConfigsByBillTypeKey(billAlias);
        WriteOffObjectQueue candidateQueue = new WriteOffObjectQueue(billSortConfigs, this.getSchemeContextConfig(), writeOffBillConfig);
        for (WriteOffObject writeOffObject : candidates) {
            candidateQueue.add(writeOffObject.getWriteOffObjectBase());
        }
        return candidateQueue;
    }

    public void sort() {
        for (IWriteOffQueue queue : this.candidateQueues) {
            ((IQueueSortable)queue).sort();
        }
    }

    public List<IWriteOffQueue> getCandidateQueues() {
        return this.candidateQueues;
    }

    public IWriteOffQueue getMainQueue() {
        return this.mainQueue;
    }

    public List<IWriteOffQueue> getAssistQueues() {
        return this.assistQueues;
    }

    private SchemeContextConfig getSchemeContextConfig() {
        return this.getGroup().getSchemeContextConfig();
    }

    private SchemeConfig getSchemeConfig() {
        return this.getGroup().getSchemeConfig();
    }

    public WriteOffMatchGroup getGroup() {
        return this.group;
    }

    public String getUniqueKey() {
        if (StringUtils.isEmpty((String)this.uniqueKey)) {
            this.uniqueKey = DB.genStringId((String)"WriteOffQueueGroup");
        }
        return this.uniqueKey;
    }

    public void setUniqueKey(String groupUniqueKey) {
        this.uniqueKey = groupUniqueKey;
    }

    public void addBackWriteOffInfo(BackWriteOffDetail.AutoGeneration autoGeneration) {
        if (this.detail == null) {
            this.detail = new BackWriteOffDetail();
        }
        this.detail.addAutoBill(autoGeneration);
    }

    public String getDetail() {
        if (this.detail != null) {
            return JSONObject.toJSONString((Object)this.detail);
        }
        return null;
    }
}

