/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.UnWfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.kdtx.KdtxUnWriteOffService;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.log.UnWriteOffLog;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.DeleteAutoBill;
import org.apache.commons.lang3.ObjectUtils;

public class BackWfKdtxParamHolder {
    private static final Log logger = LogFactory.getLog(BackWfKdtxParamHolder.class);
    private WriteoffTemplateTypeEnum wfRecordTemplateEnum;
    private Map<String, Map<String, List<Object[]>>> sqlListMap = new HashMap<String, Map<String, List<Object[]>>>(16);
    private Map<Long, List<DynamicObject>> recordMap = new HashMap<Long, List<DynamicObject>>(16);
    private List<DeleteAutoBill> deleteAutoBills = new ArrayList<DeleteAutoBill>(16);
    private Set<String> businessInfos = new HashSet<String>(16);
    private Map<Long, WriteOffTypeConfig> wfTypeMap = new HashMap<Long, WriteOffTypeConfig>(8);
    private UnWriteOffLog unWriteOffLog = null;
    private UnWfPluginExtFactory unWfPluginExtFactory = new UnWfPluginExtFactory();
    private WriteOffParamManager writeOffParamManager;
    private Set<String> wfRecordSeqLocks;
    private String selectFields;

    public BackWfKdtxParamHolder(WriteoffTemplateTypeEnum wfRecordTemplateEnum) {
        this.wfRecordTemplateEnum = wfRecordTemplateEnum;
    }

    public void doKdtx() {
        if (TX.inTX()) {
            this.exectKdtx();
        } else {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    this.exectKdtx();
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private void exectKdtx() {
        long start = System.currentTimeMillis();
        this.buildBusinessKeys();
        KdtxUnWriteOffService service = new KdtxUnWriteOffService(this.unWriteOffLog, this.businessInfos, this.wfTypeMap, false, false);
        service.setWfRecordSeqLocks(this.getWfRecordSeqLocks());
        service.setSelectFields(this.getSelectFields());
        this.backPluginSql();
        service.deleteAutoGeneBillService(this.deleteAutoBills);
        service.kdtxUnWfPlugin(this.recordMap);
        service.kdtxDeleteWriteOffRecord(this.recordMap);
        service.kdtxBackWriteBill(this.sqlListMap, this.recordMap);
        long end = System.currentTimeMillis();
        logger.info("\u6267\u884c\u6700\u7ec8\u4e00\u81f4\u6027\u63a5\u53e3\u65f6\u95f4exectKdtx:" + (end - start) + "ms");
    }

    public void doCaKdtx(Map<String, Object> paramMap) {
        logger.info("\u6267\u884cBackWfKdtxParamHolder.doCaKdtx");
        if (TX.inTX()) {
            logger.info("\u6267\u884cBackWfKdtxParamHolder.doCaKdtx.inTx");
            this.exectCaKdtx(paramMap);
        } else {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    this.exectCaKdtx(paramMap);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        logger.info("\u6267\u884cdoCaKdtx\u5b8c\u6210");
    }

    private void exectCaKdtx(Map<String, Object> paramMap) {
        long start = System.currentTimeMillis();
        this.buildBusinessKeys();
        KdtxUnWriteOffService service = new KdtxUnWriteOffService(this.unWriteOffLog, this.businessInfos, this.wfTypeMap, true, false);
        this.backPluginSql();
        service.deleteAutoGeneBillService(this.deleteAutoBills);
        service.kdtxBackWriteBill(this.sqlListMap, this.recordMap);
        service.kdtxCaWriteOffRecord(this.recordMap, paramMap);
        service.kdtxUnWfPlugin(this.recordMap);
        long end = System.currentTimeMillis();
        logger.info("\u6267\u884c\u6700\u7ec8\u4e00\u81f4\u6027\u63a5\u53e3\u65f6\u95f4exectCaKdtx:" + (end - start) + "ms");
    }

    private void buildBusinessKeys() {
        for (Map.Entry<Long, List<DynamicObject>> record : this.recordMap.entrySet()) {
            List<DynamicObject> recordList = record.getValue();
            for (DynamicObject recordBill : recordList) {
                String recordType = recordBill.getDataEntityType().getName();
                this.businessInfos.add(recordType + "#" + recordBill.getPkValue());
            }
        }
    }

    private void backPluginSql() {
        for (Map.Entry<Long, List<DynamicObject>> entry : this.recordMap.entrySet()) {
            Long wfTypeId = entry.getKey();
            List<DynamicObject> records = entry.getValue();
            Map<String, Map<String, List<Object[]>>> stringMapMap = this.getUnWfPluginExtFactory().buildBackSql(records, this.getWfType(wfTypeId));
            CommonUtils.buildSqlMap(this.sqlListMap, stringMapMap);
            if (ObjectUtils.isEmpty(records)) continue;
            for (DynamicObject record : records) {
                record.set("headwfinfo_tag", (Object)"");
                DynamicObjectCollection recordEntries = record.getDynamicObjectCollection("entry");
                for (DynamicObject recordEntry : recordEntries) {
                    if (WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == this.wfRecordTemplateEnum) {
                        recordEntry.set("mainwfinfo_tag", (Object)"");
                        recordEntry.set("asswfinfo_tag", (Object)"");
                        continue;
                    }
                    if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN != this.wfRecordTemplateEnum && WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST != this.wfRecordTemplateEnum) continue;
                    recordEntry.set("wfinfo_tag", (Object)"");
                }
            }
        }
    }

    public void addSql(String dbRouteKey, String sql, Object[] param) {
        List<Object[]> objects;
        Map<String, List<Object[]>> stringListMap = this.sqlListMap.get(dbRouteKey);
        if (stringListMap == null) {
            stringListMap = new HashMap<String, List<Object[]>>(16);
        }
        if ((objects = stringListMap.get(sql)) == null) {
            objects = new ArrayList<Object[]>(16);
        }
        objects.add(param);
        stringListMap.put(sql, objects);
        this.sqlListMap.put(dbRouteKey, stringListMap);
    }

    public void addWfType(WriteOffTypeConfig typeConfig) {
        this.wfTypeMap.put(typeConfig.getId(), typeConfig);
    }

    public void addAutoBill(DeleteAutoBill autoBill) {
        this.deleteAutoBills.add(autoBill);
    }

    public void addWfRecord(DynamicObject record, WriteOffTypeConfig config) {
        List<DynamicObject> longListMap = this.recordMap.get(config.getId());
        if (longListMap == null) {
            longListMap = new ArrayList<DynamicObject>(16);
        }
        longListMap.add(record);
        this.recordMap.put(config.getId(), longListMap);
    }

    private WriteOffTypeConfig getWfType(Long typeId) {
        return this.wfTypeMap.get(typeId);
    }

    public Map<String, Map<String, List<Object[]>>> getSqlListMap() {
        return this.sqlListMap;
    }

    public List<DeleteAutoBill> getDeleteAutoBills() {
        return this.deleteAutoBills;
    }

    public Map<Long, List<DynamicObject>> getRecordMap() {
        return this.recordMap;
    }

    public UnWfPluginExtFactory getUnWfPluginExtFactory() {
        return this.unWfPluginExtFactory;
    }

    public BackWfKdtxParamHolder setUnWfPluginExtFactory(UnWfPluginExtFactory unWfPluginExtFactory) {
        this.unWfPluginExtFactory = unWfPluginExtFactory;
        return this;
    }

    public WriteOffParamManager getWriteOffParamManager() {
        return this.writeOffParamManager;
    }

    public BackWfKdtxParamHolder setWriteOffParamManager(WriteOffParamManager writeOffParamManager) {
        this.writeOffParamManager = writeOffParamManager;
        return this;
    }

    public void setWfTypeMap(Map<Long, WriteOffTypeConfig> wfTypeMap) {
        this.wfTypeMap = wfTypeMap;
    }

    public void setUnWriteOffLog(UnWriteOffLog unWriteOffLog) {
        this.unWriteOffLog = unWriteOffLog;
    }

    public void setWfRecordSeqLocks(Set<String> wfRecordSeqLocks) {
        this.wfRecordSeqLocks = wfRecordSeqLocks;
    }

    public Set<String> getWfRecordSeqLocks() {
        return this.wfRecordSeqLocks;
    }

    public String getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(String selectFields) {
        this.selectFields = selectFields;
    }
}

