/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.EntryBackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.impl.AbstractBackWfStrategy;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.DeleteAutoBill;

public class MainAssistBackWfStrategy
extends AbstractBackWfStrategy {
    @Override
    void wfRecordBackWf(DynamicObject wfRecord, DeleteAutoBill deleteAutoBill, WriteOffTypeConfig conf) {
        DynamicObjectCollection wfRecordEntryList = wfRecord.getDynamicObjectCollection("entry");
        this.headRevertWrite(wfRecord);
        for (DynamicObject wfRecordEntry : wfRecordEntryList) {
            this.entryRevertWrite(wfRecordEntry, deleteAutoBill);
        }
    }

    private void headRevertWrite(DynamicObject record) {
        String headWfInfo = record.getString("headwfinfo_tag");
        if (StringUtils.isEmpty((CharSequence)headWfInfo)) {
            return;
        }
        BackWriteOffDetail headWriteOffDetail = (BackWriteOffDetail)JSONObject.parseObject((String)headWfInfo, BackWriteOffDetail.class);
        EntryBackWriteOffDetail writeOffDetail = headWriteOffDetail.getDetail();
        if (writeOffDetail == null) {
            return;
        }
        String billType = record.getDynamicObject("billtype").getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        Long billId = record.getLong("billid");
        Long billEntryId = record.getLong("billentryid");
        this.backWriteBillField(dataEntityType, billId, billEntryId, writeOffDetail);
        CommonUtils.bkWtHeadOtherBill(headWfInfo, this.getHolder());
    }

    private void entryRevertWrite(DynamicObject wfRecordEntry, DeleteAutoBill deleteAutoBill) {
        Long billId = wfRecordEntry.getLong("e_billid");
        Set<Long> allAutoBilId = deleteAutoBill.getAllAutoBilId();
        if (allAutoBilId.contains(billId)) {
            return;
        }
        String wfInfo = wfRecordEntry.getString("wfinfo_tag");
        if (StringUtils.isEmpty((CharSequence)wfInfo)) {
            return;
        }
        this.revertWriteData(wfRecordEntry, wfInfo);
        CommonUtils.bkWtEntryOtherBill(wfInfo, this.getHolder());
    }

    private void revertWriteData(DynamicObject wfRecordEntry, String wfInfo) {
        Long billId = wfRecordEntry.getLong("e_billid");
        Long billEntryId = wfRecordEntry.getLong("e_billentryid");
        DynamicObject billTypeOb = wfRecordEntry.getDynamicObject("e_billtype");
        String billType = billTypeOb.getString("number");
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        EntryBackWriteOffDetail writeOffDetail = (EntryBackWriteOffDetail)JSONObject.parseObject((String)wfInfo, EntryBackWriteOffDetail.class);
        this.backWriteBillField(mainEntityType, billId, billEntryId, writeOffDetail);
    }

    private void backWriteBillField(MainEntityType backWriteEntityType, Long backWriteBillId, Long backWriteEntryId, EntryBackWriteOffDetail writeOffDetail) {
        List<EntryBackWriteOffDetail.BackWriteDetail> backWriteDetailList = writeOffDetail.getWfBackWriteDetailList();
        this.addSql(this.getHolder(), backWriteEntityType.getName(), backWriteBillId, backWriteEntryId, backWriteDetailList);
    }
}

