/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.DefaultStandardPluginFactory;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.DefaultWfPlugin;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.PluginFactory;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.CheckPluginProxy;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WfEndWriteBackPluginProxy;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.IWriteOffBasePlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IKdtxWfPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffStrategyPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WfPluginExtFactory {
    private static final Log logger = LogFactory.getLog(WfPluginExtFactory.class);

    public static List<IWriteOffStrategyPlugin> execute(WriteOffTypeConfig typeConfig) {
        List<IWriteOffStrategyPlugin> plugins = DefaultStandardPluginFactory.getWriteOffStartegyPlugin();
        PluginProxy<IWriteOffStrategyPlugin> pluginProxy = DefaultStandardPluginFactory.getWriteOffStartegyPluginProxy();
        plugins.addAll(pluginProxy.getPlugins());
        ArrayList<IWriteOffStrategyPlugin> strategyPluginList = new ArrayList<IWriteOffStrategyPlugin>(16);
        for (IWriteOffStrategyPlugin plugin : plugins) {
            if (!CommonUtils.isContain(plugin.getWriteOffTypeIds(), typeConfig.getId())) continue;
            strategyPluginList.add(plugin);
        }
        return strategyPluginList;
    }

    public static Map<String, Set<String>> getPrePareFieldMap(List<WriteOffTypeConfig> typeConfigs) {
        ArrayList<IWriteOffBasePlugin> plugins = new ArrayList<IWriteOffBasePlugin>(16);
        plugins.addAll(DefaultStandardPluginFactory.getPrepareKeyPlugins(null));
        plugins.addAll(DefaultStandardPluginFactory.getWriteOffCheckPluginProxy(null).getPlugins());
        plugins.addAll(DefaultStandardPluginFactory.getFilterPluginProxy(null).getPlugins());
        plugins.addAll(DefaultStandardPluginFactory.getMatchPluginProxy(null).getPlugins());
        plugins.addAll(DefaultStandardPluginFactory.getWriteOffPluginProxy(null).getPlugins());
        plugins.addAll(DefaultStandardPluginFactory.getWriteOffStartegyPluginProxy().getPlugins());
        plugins.addAll(DefaultStandardPluginFactory.getKDTXWfPluginProxy().getPlugins());
        HashSet<Long> typeIds = new HashSet<Long>(16);
        for (WriteOffTypeConfig config : typeConfigs) {
            typeIds.add(config.getId());
        }
        HashMap<String, Set<String>> propareFieldMap = new HashMap<String, Set<String>>(16);
        for (IWriteOffBasePlugin plugin : plugins) {
            IWriteOffBasePlugin basePlugin = plugin;
            if (!CommonUtils.isContain(basePlugin.getWriteOffTypeIds(), typeIds)) continue;
            Map<String, Set<String>> preparePropKey = basePlugin.preparePropKey();
            MapUtils.addSet(propareFieldMap, preparePropKey);
        }
        return propareFieldMap;
    }

    public static Map<String, Set<String>> getPrePareFieldMap(WriteOffTypeConfig typeConfig) {
        return WfPluginExtFactory.getPrePareFieldMap(Collections.singletonList(typeConfig));
    }

    public static boolean check(DynamicObject record, WriteOffTypeConfig typeConfig) {
        return WfPluginExtFactory.check(new PluginFactory(null), record, typeConfig);
    }

    public static boolean check(PluginFactory factory, DynamicObject record, WriteOffTypeConfig typeConfig) {
        CheckPluginProxy proxy = factory.createCheckPluignProxy(typeConfig);
        return proxy.check(record);
    }

    @Deprecated
    public static boolean checkWithoutException(DynamicObject record, WriteOffTypeConfig typeConfig) {
        DefaultWfPlugin wfPlugin = new DefaultWfPlugin(typeConfig.getId());
        wfPlugin.setWfExtParams(typeConfig.getWfExtParams());
        PluginProxy<IWriteOffCheckPlugin> pluginProxy = DefaultStandardPluginFactory.getWriteOffCheckPluginProxy(wfPlugin);
        List booleans = pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain(p.getWriteOffTypeIds(), typeConfig.getId())) {
                logger.info("\u6267\u884c\u6838\u9500\u6269\u5c55\u70b9checkWithoutException\u63d2\u4ef6\uff1a" + p.getClass().getSimpleName());
                if (!p.checkWithoutException(record)) {
                    return false;
                }
            }
            return true;
        });
        boolean present = booleans.stream().filter(a -> a == false).findAny().isPresent();
        return !present;
    }

    public static boolean checkWithoutException(PluginFactory factory, DynamicObject record, WriteOffTypeConfig typeConfig) {
        return factory.createCheckPluignProxy(typeConfig).checkWithoutException(record);
    }

    public static boolean isEndWriteBack(Long typeId, String dbRouteKey) {
        return WfPluginExtFactory.createEndWriteBackProxy(typeId, new HashMap<String, Object>()).isEndWriteBack(dbRouteKey);
    }

    public static WfEndWriteBackPluginProxy createEndWriteBackProxy(Long typeId, Map<String, Object> wfExtParams) {
        return new PluginFactory(null).createWfEndWriteBackPluginProxy(typeId, wfExtParams);
    }

    public static List<IKdtxWfPlugin> kdtxWfPlugin(Long typeId, Map<String, Object> wfExtParams) {
        List<IKdtxWfPlugin> plugins = DefaultStandardPluginFactory.getKDTXWfPlugin();
        PluginProxy<IKdtxWfPlugin> pluginProxy = DefaultStandardPluginFactory.getKDTXWfPluginProxy();
        plugins.addAll(pluginProxy.getPlugins());
        ArrayList<IKdtxWfPlugin> pluginList = new ArrayList<IKdtxWfPlugin>(16);
        for (IKdtxWfPlugin plugin : plugins) {
            if (!CommonUtils.isContain(plugin.getWriteOffTypeIds(), typeId)) continue;
            pluginList.add(plugin);
        }
        return pluginList;
    }

    public static IWriteOffMainFieldCalPlugin getWfMainFiledPlugin(String pluginField, Long wfTypeBillEntryId) {
        logger.info("getWfMainFiledPlugin\u83b7\u53d6\u4e3b\u5b57\u6bb5\u63d2\u4ef6\uff0c\u7c7b\u522b\u5355\u636e:" + wfTypeBillEntryId);
        List<IWriteOffMainFieldCalPlugin> plugins = DefaultStandardPluginFactory.getWfMainFiledPlugin();
        PluginProxy<IWriteOffMainFieldCalPlugin> pluginProxy = DefaultStandardPluginFactory.getWfMainFieldPluginProxy();
        plugins.addAll(pluginProxy.getPlugins());
        ArrayList<IWriteOffMainFieldCalPlugin> mainPluginList = new ArrayList<IWriteOffMainFieldCalPlugin>(16);
        for (IWriteOffMainFieldCalPlugin plugin : plugins) {
            boolean isWfBill = plugin.getWfTypeBillEntryId() != null && plugin.getWfTypeBillEntryId().contains(wfTypeBillEntryId);
            if (!isWfBill || !pluginField.equals(plugin.getPluginField())) continue;
            mainPluginList.add(plugin);
        }
        if (mainPluginList.size() != 1) {
            logger.info("\u52a8\u6001\u5b57\u6bb5\u5df2\u52a0\u8f7d\u7684\u63d2\u4ef6\u4fe1\u606f:" + plugins);
            logger.info("\u6838\u9500\u5355\u636e\u5206\u5f55id\u4e3a:" + wfTypeBillEntryId);
            String erroInfo = ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u53d6\u503c\u65b9\u5f0f\u4e3a\u52a8\u6001\u5b57\u6bb5\u65f6\uff0c\u9700\u8981\u914d\u7f6e\u4e00\u4e2a\u4e3b\u5b57\u6bb5\u63d2\u4ef6\u3002\u52a8\u6001\u5b57\u6bb5\u6807\u8bc6[%1$s]\uff0c\u4f7f\u7528\u5206\u5f55id[%2$s]", (String)"WriteOffColumnConfig_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            throw new KDBizException(String.format(erroInfo, pluginField, wfTypeBillEntryId));
        }
        return (IWriteOffMainFieldCalPlugin)mainPluginList.get(0);
    }

    public static IWriteOffMainFieldCalPlugin getWfMainFiledPlugin(String pluginName) {
        List<IWriteOffMainFieldCalPlugin> plugins = DefaultStandardPluginFactory.getWfMainFiledPlugin();
        PluginProxy<IWriteOffMainFieldCalPlugin> pluginProxy = DefaultStandardPluginFactory.getWfMainFieldPluginProxy();
        plugins.addAll(pluginProxy.getPlugins());
        ArrayList<IWriteOffMainFieldCalPlugin> mainPluginList = new ArrayList<IWriteOffMainFieldCalPlugin>(16);
        for (IWriteOffMainFieldCalPlugin plugin : plugins) {
            if (!pluginName.equals(plugin.getClass().getName())) continue;
            mainPluginList.add(plugin);
        }
        if (mainPluginList.size() != 1) {
            logger.info("\u6838\u9500\u5355\u636e\u63d2\u4ef6\u540d\u79f0\u4e3a:" + pluginName);
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u53d6\u503c\u65b9\u5f0f\u4e3a\u63d2\u4ef6\u65f6\uff0c\u9700\u8981\u914d\u7f6e\u4e00\u4e2a\u4e3b\u5b57\u6bb5\u63d2\u4ef6\u3002", (String)"WriteOffColumnConfig_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return (IWriteOffMainFieldCalPlugin)mainPluginList.get(0);
    }

    public static Map<String, String> botpParams(List<WriteOffObjectBase> writeOffObjects, WriteOffTypeConfig typeConfig) {
        return new PluginFactory(null).createWriteOffPluginProxy(typeConfig).botpParams(WfPluginExtFactory.batchWriteBaseChangeArgs(writeOffObjects));
    }

    public static void afterWfRecordStrategy(List<DynamicObject> records, Long typeId, String wfMode, Map<String, Object> wfExtParams) {
        new PluginFactory(null).createWriteOffPluginProxy(WriteOffTypeConfig.buildById(typeId), wfMode).afterWfRecordStrategy(records);
    }

    public static WriteOffObjectArgs writeObjectChangeArgs(WriteOffObject writeOffObject) {
        WriteOffObjectArgs args = new WriteOffObjectArgs(writeOffObject.getWriteOffObjectBase());
        return args;
    }

    public static List<WriteOffObjectArgs> batchWriteObjectChangeArgs(List<WriteOffObject> writeOffObjects) {
        ArrayList<WriteOffObjectArgs> list = new ArrayList<WriteOffObjectArgs>(16);
        for (WriteOffObject writeOffObject : writeOffObjects) {
            WriteOffObjectArgs args = WfPluginExtFactory.writeObjectChangeArgs(writeOffObject);
            list.add(args);
        }
        return list;
    }

    public static List<WriteOffObjectArgs> batchWriteBaseChangeArgs(List<WriteOffObjectBase> writeOffObjects) {
        ArrayList<WriteOffObjectArgs> list = new ArrayList<WriteOffObjectArgs>(16);
        for (WriteOffObjectBase base : writeOffObjects) {
            WriteOffObjectArgs args = new WriteOffObjectArgs(base);
            list.add(args);
        }
        return list;
    }
}

