/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.generate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillBotpConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.billgenerate.AutoGeneratorParam;
import kd.mpscmm.mscommon.writeoff.common.billgenerate.BOTPBillGenerator;
import kd.mpscmm.mscommon.writeoff.common.billgenerate.GenerateBillArgs;
import kd.mpscmm.mscommon.writeoff.common.billgenerate.GenerateResult;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.sdk.mpscmm.mscommon.writeoff.params.AutoBill;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WriteOffBillGenerator {
    private static final Log logger = LogFactory.getLog(WriteOffBillGenerator.class);
    private Set<String> successKeys = new HashSet<String>(8);
    private Set<String> allKeys = new HashSet<String>(8);
    private List<String> errorMessages = new ArrayList<String>(16);

    public AutoBill generate(AutoGeneratorParam param) {
        String key = param.getBotp().getSrcBillType() + param.getBotp().getTargetBillType();
        if (this.successKeys.contains(key)) {
            return null;
        }
        this.allKeys.add(key);
        String entry = this.getWfObjectMainField(param.getWriteOffObjects(), param.getTypeConfig());
        return this.dealAutoGenerator(param.getWriteOffObjects(), param.getTypeConfig(), entry, param.getBotp());
    }

    public void check() {
        if (this.successKeys.size() != this.allKeys.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u9500\u751f\u6210\u5355\u636e\u5931\u8d25\uff0c\u539f\u56e0\u4e3a:%s", (String)"WriteOffBillGenerator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), this.errorMessages));
        }
    }

    private String getWfObjectMainField(List<WriteOffObjectBase> writeOffObjects, WriteOffTypeConfig typeConfig) {
        WriteOffBillConfig writeOffBillConfig = typeConfig.getBillConfigsById((Long)writeOffObjects.get(0).getWfBillEntity().getPkValue());
        String writeOffBillMainField = writeOffBillConfig.getWriteOffColumnConfig().getWriteOffFieldKey();
        String[] fields = writeOffBillMainField.split("\\.");
        String entry = null;
        if (fields.length > 1) {
            entry = fields[fields.length - 2];
        }
        return entry;
    }

    private AutoBill dealAutoGenerator(List<WriteOffObjectBase> writeOffObjects, WriteOffTypeConfig typeConfig, String entry, BillBotpConfig botp) {
        try (TraceSpan span = Tracer.create((String)"WriteOffBillGenerator", (String)"dealAutoGenerator");){
            String targetBillTypeKey = botp.getTargetBillAlias();
            WriteOffBillConfig billConf = typeConfig.getBillConf(targetBillTypeKey);
            WriteOffColumnConfig writeOffColumnConfig = billConf.getWriteOffColumnConfig();
            WriteOffObjectBase writeOffBill = writeOffObjects.get(0);
            GenerateBillArgs args = new GenerateBillArgs(writeOffBill, botp.getTargetBillType(), botp.getBotpRule(), entry, writeOffColumnConfig, writeOffObjects);
            Map<String, String> paramMap = WfPluginExtFactory.botpParams(writeOffObjects, typeConfig);
            args.addParam(paramMap);
            GenerateResult generateResult = new BOTPBillGenerator().generateBill(args);
            if (generateResult.isSuccess()) {
                DynamicObject[] objs = generateResult.getBill().toArray(new DynamicObject[generateResult.getBill().size()]);
                DynamicObjectUtil.setBillIdAndNumber(generateResult.getBill());
                AutoBill autoBillData = this.buildAutoBillData(botp, objs);
                this.successKeys.add(args.getSourceBillType() + args.getTagBillType());
                AutoBill autoBill = autoBillData;
                return autoBill;
            }
            String errorMessage = String.format(ResManager.loadKDString((String)"\u6838\u9500\u751f\u6210\u5355\u636e\u5931\u8d25\uff0c\u539f\u56e0\u4e3a:%s", (String)"WriteOffBillGenerator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), generateResult.getFailReason());
            logger.info(errorMessage);
            this.errorMessages.add(errorMessage);
            AutoBill autoBill = null;
            return autoBill;
        }
    }

    private AutoBill buildAutoBillData(BillBotpConfig botp, DynamicObject[] bills) {
        AutoBill autoBill = new AutoBill(Arrays.asList(bills), Boolean.TRUE);
        autoBill.setBillType(botp.getTargetBillType());
        autoBill.setBillTypeKey(botp.getTargetBillAlias());
        autoBill.setBotpRule(botp.getBotpRule());
        autoBill.setFilterString(botp.getFilterString());
        autoBill.setNeedGenerate(botp.getNeedGenerate());
        return autoBill;
    }
}

