/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.kdtx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.AutoBilParam;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfParam;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.UnWfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.helper.DynamicSerializeHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.log.UnWriteOffLog;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IKdtxUnWfPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.AutoBillConf;
import kd.sdk.mpscmm.mscommon.writeoff.params.DeleteAutoBill;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class KdtxUnWriteOffService {
    private static final Log logger = LogFactory.getLog(KdtxUnWriteOffService.class);
    private List<String> businessInfos;
    Map<Long, WriteOffTypeConfig> wfTypeMap = new HashMap<Long, WriteOffTypeConfig>(8);
    private boolean isChargeOff = false;
    private boolean isAysn = false;
    private UnWriteOffLog unWriteOffLog;
    private Set<String> wfRecordSeqLocks;
    private String selectFields;

    public KdtxUnWriteOffService(UnWriteOffLog unWriteOffLog, Set<String> businessInfos, Map<Long, WriteOffTypeConfig> wfTypeMap, boolean isChargeOff, boolean isAysn) {
        this.businessInfos = new ArrayList<String>(businessInfos);
        this.wfTypeMap = wfTypeMap;
        this.isChargeOff = isChargeOff;
        this.isAysn = isAysn;
        this.unWriteOffLog = unWriteOffLog;
    }

    public void deleteAutoGeneBillService(List<DeleteAutoBill> autoBills) {
        HashMap<String, ArrayList<AutoBilParam>> map = new HashMap<String, ArrayList<AutoBilParam>>(16);
        for (DeleteAutoBill deleteAutoBill : autoBills) {
            List<AutoBillConf> autoBillConfigs = deleteAutoBill.getAutoBillConfigs();
            for (AutoBillConf billConf : autoBillConfigs) {
                String billType = billConf.getBillType();
                AutoBilParam bilParam = new AutoBilParam(billType, billConf.getWfTypeId(), billConf.getId());
                ArrayList<AutoBilParam> params = (ArrayList<AutoBilParam>)map.get(billType);
                if (params == null) {
                    params = new ArrayList<AutoBilParam>(16);
                }
                params.add(bilParam);
                map.put(billType, params);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            String billKey = (String)entry.getKey();
            List value = (List)entry.getValue();
            BackWfParam commonParam = new BackWfParam();
            commonParam.setBillNumber(billKey);
            commonParam.setAutoBilParams(value);
            String taskName = ResManager.loadKDString((String)"\u6838\u9500\u6a21\u578b\u81ea\u52a8\u751f\u6210\u5355\u636e\u53cd\u6838\u9500\u5904\u7406", (String)"KdtxUnWriteOffService_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            Long taskId = UnWriteOffLogHelper.addTaskEntry(this.unWriteOffLog, taskName, "msmod_backwf_autobill_delete", "AutoGenerateBillDeleteService", this.businessInfos.get(0), commonParam);
            commonParam.setTaskId(taskId);
            try {
                ECServiceHelper.execute("msmod_backwriteoff", "msmod_backwf_autobill_delete", "mpscmm", "mscommon", "AutoGenerateBillDeleteService", this.businessInfos, this.businessInfos.get(0), (Param)commonParam, this.isAysn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    public void kdtxBackWriteBill(Map<String, Map<String, List<Object[]>>> map, Map<Long, List<DynamicObject>> recordMap) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        Map<String, String[]> recordSerMap = this.resolveRecordMap(recordMap);
        for (Map.Entry<String, Map<String, List<Object[]>>> sqlBuilderEntry : map.entrySet()) {
            BackWfParam commonParam = new BackWfParam();
            String dbRout = sqlBuilderEntry.getKey();
            commonParam.setDbRout(dbRout);
            Map<String, List<Object[]>> value = sqlBuilderEntry.getValue();
            commonParam.setParam(value);
            commonParam.setSelectFields(this.selectFields);
            commonParam.setRecordMap(recordSerMap);
            commonParam.setChargeOff(this.isChargeOff);
            String taskName = ResManager.loadKDString((String)"\u53cd\u6838\u9500\u53cd\u5199\u539f\u59cb\u5355\u636e-\u3010{0}\u3011", (String)"KdtxUnWriteOffService_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{dbRout});
            Long taskId = UnWriteOffLogHelper.addTaskEntry(this.unWriteOffLog, taskName, "msmod_backwf_writebacsk", "ReWfBackWriteService", this.businessInfos.get(0), commonParam);
            commonParam.setTaskId(taskId);
            try {
                ECServiceHelper.execute("msmod_backwriteoff", "msmod_backwf_writeback", "mpscmm", "mscommon", dbRout, "ReWfBackWriteService", this.businessInfos, commonParam, this.businessInfos.get(0), this.isAysn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    public void kdtxUnWfPlugin(Map<Long, List<DynamicObject>> recordMap) {
        UnWfPluginExtFactory unWfPluginExtFactory = new UnWfPluginExtFactory();
        for (Map.Entry<Long, List<DynamicObject>> record : recordMap.entrySet()) {
            Long wfTypeId = record.getKey();
            List<DynamicObject> recordList = record.getValue();
            List<IKdtxUnWfPlugin> iKdtxUnWfPluginPlugins = unWfPluginExtFactory.kdtxBackWfPlugin(wfTypeId);
            for (IKdtxUnWfPlugin plugin : iKdtxUnWfPluginPlugins) {
                BackWfParam commonParam = new BackWfParam();
                List<Object> ids = recordList.stream().map(n -> n.getPkValue()).collect(Collectors.toList());
                commonParam.setBillNumber(recordList.get(0).getDataEntityType().getName());
                commonParam.setValue(plugin.getClass().getName());
                commonParam.setTypeId(wfTypeId);
                commonParam.setRecordIds(ids);
                String taskName = ResManager.loadKDString((String)"\u53cd\u6838\u9500\u6700\u7ec8\u4e00\u81f4\u6027\u63d2\u4ef6-\u3010{0}\u3011", (String)"KdtxUnWriteOffService_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{plugin.getClass().getSimpleName()});
                Long taskId = UnWriteOffLogHelper.addTaskEntry(this.unWriteOffLog, taskName, "msmod_backwf_plugin", "BackWfPluginService", this.businessInfos.get(0), commonParam);
                commonParam.setTaskId(taskId);
                try {
                    ECServiceHelper.execute("msmod_backwriteoff", "msmod_backwf_plugin", "mpscmm", "mscommon", "scm", "BackWfPluginService", this.businessInfos, commonParam, this.businessInfos.get(0), this.isAysn);
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u6027\u5931\u8d25\u3002", (Throwable)e);
                    throw new KDBizException(EngineLang.kdtxCallFail(e));
                }
            }
        }
    }

    private Map<String, String[]> resolveRecordMap(Map<Long, List<DynamicObject>> recordMap) {
        HashMap<String, String[]> recordSerMap = new HashMap<String, String[]>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : recordMap.entrySet()) {
            Long wfTypeId = entry.getKey();
            List<DynamicObject> recordList = entry.getValue();
            if (recordList.isEmpty()) continue;
            DynamicObject[] records = recordList.toArray(new DynamicObject[recordList.size()]);
            String[] serializes = DynamicSerializeHelper.serializeTwo(records);
            String key = wfTypeId + "#" + records[0].getDataEntityType().getName();
            recordSerMap.put(key, serializes);
        }
        return recordSerMap;
    }

    public void kdtxDeleteWriteOffRecord(Map<Long, List<DynamicObject>> recordMap) {
        this.wfRecordDeal(recordMap, null);
    }

    public void kdtxCaWriteOffRecord(Map<Long, List<DynamicObject>> recordMap, Map<String, Object> paramMap) {
        this.wfRecordDeal(recordMap, paramMap);
    }

    private void wfRecordDeal(Map<Long, List<DynamicObject>> recordMap, Map<String, Object> paramMap) {
        for (Map.Entry<Long, List<DynamicObject>> record : recordMap.entrySet()) {
            Long wfTypeId = record.getKey();
            BackWfParam commonParam = new BackWfParam();
            WriteOffTypeConfig writeOffTypeConfig = this.wfTypeMap.get(wfTypeId);
            String wfRecordNum = writeOffTypeConfig.getRecordNum();
            commonParam.setBillNumber(wfRecordNum);
            List<DynamicObject> recordList = record.getValue();
            if (CollectionUtils.isEmpty(recordList)) continue;
            List<Object> ids = recordList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            String dbRouteKey = recordList.get(0).getDataEntityType().getDBRouteKey();
            commonParam.setTypeId(wfTypeId);
            commonParam.setRecordIds(ids);
            commonParam.setWfRecordSeqLocks(this.getWfRecordSeqLocks());
            if (this.isChargeOff) {
                commonParam.setChargeOff(true);
                commonParam.setParamMap(paramMap);
            }
            String taskName = ResManager.loadKDString((String)"\u53cd\u6838\u9500\u5220\u9664\u6838\u9500\u8bb0\u5f55-\u3010{0}\u3011", (String)"KdtxUnWriteOffService_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{writeOffTypeConfig.getName()});
            Long taskId = UnWriteOffLogHelper.addTaskEntry(this.unWriteOffLog, taskName, "msmod_backwf_record_delete", "WriteOffRecordDeleteService", this.businessInfos.get(0), commonParam);
            commonParam.setTaskId(taskId);
            try {
                ECServiceHelper.execute("msmod_backwriteoff", "msmod_backwf_record_delete", "mpscmm", "mscommon", dbRouteKey, "WriteOffRecordDeleteService", this.businessInfos, commonParam, this.businessInfos.get(0), this.isAysn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    public void setWfRecordSeqLocks(Set<String> wfRecordSeqLocks) {
        this.wfRecordSeqLocks = wfRecordSeqLocks;
    }

    public Set<String> getWfRecordSeqLocks() {
        return this.wfRecordSeqLocks;
    }

    public void setSelectFields(String selectFields) {
        this.selectFields = selectFields;
    }
}

