/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.OperationUtil;

public class WfRollbackListener
implements CommitListener {
    private Map<String, List<Object>> billSaveSuccess;
    private boolean isWfRollBack = false;

    public WfRollbackListener(Map<String, List<Object>> billSaveSuccess) {
        this.billSaveSuccess = billSaveSuccess;
    }

    public WfRollbackListener(List<DynamicObject> writeoffRecords) {
        this.billSaveSuccess = new HashMap<String, List<Object>>(1);
        for (DynamicObject writeoffRecord : writeoffRecords) {
            String entityName = writeoffRecord.getDataEntityType().getName();
            List<Object> list = this.billSaveSuccess.get(entityName);
            if (list == null) {
                list = new ArrayList<Object>(16);
                this.billSaveSuccess.put(entityName, list);
            }
            list.add(writeoffRecord.getPkValue());
        }
    }

    public void onEnded(boolean rollbacked) {
        if (rollbacked || this.isWfRollBack) {
            try (TXHandle tx = TX.notSupported();){
                for (Map.Entry<String, List<Object>> bill : this.billSaveSuccess.entrySet()) {
                    String billKey = bill.getKey();
                    Object[] bills = bill.getValue().toArray();
                    OperationServiceHelper.executeOperate((String)"delete", (String)billKey, (Object[])bills, (OperateOption)OperationUtil.getOption());
                }
            }
        }
    }

    public void setWfRollBack(boolean wfRollBack) {
        this.isWfRollBack = wfRollBack;
    }
}

