/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.HintDataMatcher;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.HintData;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.AbstractWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.WFConditionFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.WFMatchFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffGroupHelper;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.MatchPluginProxy;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.lang.NounLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.ExtMatchInfo;

public class WriteOffBillMatcher {
    protected static final Log logger = LogFactory.getLog(WriteOffBillMatcher.class);
    protected static final String ID = "id";
    protected static final String WF_MAINFIELD_ID = "wfCalcFieldId";
    private MatchRelationConfig relationConfig;
    private WriteOffTypeConfig writeOffTypeConfig;
    private WriteOffMatchGroup writeOffMatchGroup;
    private WriteOffExecuteContext executeContext;
    private WriteOffTypeContext writeOffTypeContext;
    private List<IWFFilter> additionQFilter = new ArrayList<IWFFilter>(16);
    private Map<Object, BigDecimal> curMainFieldValueMap = null;
    private final WriteOffBillConfig writeOffBillConfig;
    private String billTypeEntity = null;
    private String mainField;
    private boolean isWfBillField = true;
    private String wfCalcFieldIdName;
    private IWriteOffMainFieldCalPlugin mainFieldCalClass;
    protected List<WriteOffMatchConditionInfo> writeOffMatchConditionInfos = new ArrayList<WriteOffMatchConditionInfo>(16);
    private QFilter matchConditionQFilter;

    public static WriteOffBillMatcher create(WriteOffMatchGroup writeOffMatchGroup, MatchRelationConfig relationConfig, WriteOffExecuteContext executeContext, WriteOffTypeContext writeOffTypeContext) {
        String targetBillTypeKey;
        WriteOffTypeConfig writeOffTypeConfig = writeOffMatchGroup.getTypeConfig();
        WriteOffBillConfig targetBillConfig = writeOffTypeConfig.getBillConf(targetBillTypeKey = relationConfig.getTargetBillTypeKey());
        if (targetBillConfig == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5339\u914d\u65b9\u5355\u636e\u914d\u7f6e\u3002", (String)"WriteOffBillMatcher_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return new WriteOffBillMatcher(writeOffTypeConfig, targetBillConfig, relationConfig, writeOffMatchGroup, executeContext, writeOffTypeContext, false);
    }

    protected WriteOffBillMatcher(WriteOffTypeConfig writeOffTypeConfig, WriteOffBillConfig writeOffBillConfig, MatchRelationConfig relationConfig, WriteOffMatchGroup writeOffMatchGroup, WriteOffExecuteContext executeContext, WriteOffTypeContext writeOffTypeContext, boolean isSelf) {
        this.relationConfig = relationConfig;
        this.writeOffTypeConfig = writeOffMatchGroup.getTypeConfig();
        this.writeOffMatchGroup = writeOffMatchGroup;
        this.executeContext = executeContext;
        this.writeOffTypeContext = writeOffTypeContext;
        this.writeOffBillConfig = writeOffBillConfig;
        this.initMatchInfo();
    }

    private void initMatchInfo() {
        this.billTypeEntity = this.relationConfig.getTargetBillType();
        WriteOffColumnConfig writeOffColumnConfig = this.writeOffBillConfig.getWriteOffColumnConfig();
        if (writeOffColumnConfig == null) {
            throw new KDBizException(EngineLang.NotCongfigMainField(this.writeOffBillConfig));
        }
        this.isWfBillField = writeOffColumnConfig.isWfBillField();
        this.mainField = writeOffColumnConfig.getWriteOffFieldKey();
        this.wfCalcFieldIdName = this.writeOffBillConfig.getWfCalcFieldIdName();
        this.mainFieldCalClass = writeOffColumnConfig.mainFieldCalClass();
    }

    public List<WriteOffObject> executeMatch() {
        List<DynamicObject> matchEntryDatas = this.getMatchResult();
        if (matchEntryDatas.isEmpty()) {
            return Collections.emptyList();
        }
        return this.handleMatchResult(matchEntryDatas);
    }

    public List<DynamicObject> getMatchResult() {
        Object matchedBillData;
        HintDataMatcher hintDataLoader = null;
        hintDataLoader = this.writeOffTypeContext != null ? this.writeOffTypeContext.getHintDataLoader() : new HintDataMatcher();
        Long matchId = this.relationConfig.getMatchId();
        String targetAlias = this.writeOffBillConfig.getBillAlias();
        ExtMatchInfo extMatchInfo = this.writeOffMatchGroup.getExtMatchInfo(this.billTypeEntity);
        if (extMatchInfo != null && extMatchInfo.isNotMatch()) {
            logger.info("\u6838\u9500\u5e73\u53f0\u6269\u5c55\u63d2\u4ef6\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\u3002");
            List<AbstractWFFilter> wfFilter = extMatchInfo.getWfFilter();
            for (AbstractWFFilter iwfFilter : wfFilter) {
                this.writeOffMatchConditionInfos.add(iwfFilter.getInfo());
            }
            return Collections.emptyList();
        }
        HintData hintData = hintDataLoader.getHintData(matchId, targetAlias);
        if (hintData != null) {
            if (hintData.isNoMatchData()) {
                logger.info("\u6838\u9500\u5e73\u53f0\u67e5\u8be2Hint\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\u3002");
                this.writeOffMatchConditionInfos.addAll(hintData.getConditionInfos());
                return Collections.emptyList();
            }
            String expressionStr = this.buildMatchExpression();
            Set<Long> linkInfo = hintData.getLinkInfo(this.writeOffMatchGroup.getWriteOffObjects());
            if (linkInfo != null) {
                if (linkInfo.isEmpty()) {
                    logger.info("\u6838\u9500\u5e73\u53f0\u67e5\u8be2BotpLink\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\u3002");
                    this.writeOffMatchConditionInfos.add(new WriteOffMatchConditionInfo(NounLang.botpLink(), "=", EngineLang.noBotpLink()));
                    return Collections.emptyList();
                }
                String botpLinkExpr = new WFMatchFilter(this.wfCalcFieldIdName, "in", linkInfo).toExpression();
                expressionStr = StringUtils.isNotEmpty((CharSequence)expressionStr) ? expressionStr + " and " + botpLinkExpr : botpLinkExpr;
                this.writeOffMatchConditionInfos.add(new WriteOffMatchConditionInfo(NounLang.botpLink(), "=", botpLinkExpr));
                matchedBillData = hintData.getMatchedBillByBotpLink(this.wfCalcFieldIdName, expressionStr, linkInfo);
            } else {
                Set<Object> ids;
                matchedBillData = extMatchInfo != null && !(ids = extMatchInfo.getIds()).isEmpty() ? hintData.getMatchedBillByIdHint(this.wfCalcFieldIdName, expressionStr, ids) : hintData.getMatchedBillByHintKey(this.wfCalcFieldIdName, expressionStr, this.writeOffMatchGroup.getWriteOffObjects());
            }
            if (CollectionUtils.isEmpty((Collection)matchedBillData)) {
                logger.info("\u6838\u9500\u5e73\u53f0Hint\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\uff1a" + this.billTypeEntity + ":" + expressionStr);
                return Collections.emptyList();
            }
            if (!hintData.isAlreadyGetIds()) {
                this.writeOffTypeContext.loadSnapShootMap(hintData.getHintDataIds(), this.billTypeEntity);
            }
        } else {
            QFilter queryFilter = this.buildMatchQFilter();
            matchedBillData = this.executeContext.getBillDataSource().queryBillData(this.billTypeEntity, this.mainFieldCalClass.mainFieldEntry(), queryFilter);
            if (CollectionUtils.isEmpty((Collection)matchedBillData)) {
                logger.info("\u6838\u9500\u5e73\u53f0\u67e5\u8be2\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\uff1a" + this.billTypeEntity + ":" + queryFilter.toString());
                return Collections.emptyList();
            }
            List<Object> idList = this.getMatchBillIds((List<DynamicObject>)matchedBillData);
            this.writeOffTypeContext.loadSnapShootMap(idList, this.billTypeEntity);
        }
        if (this.relationConfig.hasContainLogic()) {
            matchedBillData = this.relationConfig.executeContainLogic((List<DynamicObject>)matchedBillData, this.writeOffMatchGroup);
        }
        return matchedBillData;
    }

    private List<Object> getMatchBillIds(List<DynamicObject> matchedBillData) {
        List<Object> idList = matchedBillData.stream().map(n -> n.get(ID)).collect(Collectors.toList());
        if (idList.size() > this.getMaxHandleSize()) {
            throw new KDBizException(EngineLang.overMaxHandleBillSize(this.getMaxHandleSize()));
        }
        return idList;
    }

    private String buildMatchExpression() {
        List<IWFFilter> filters = this.buildMatchWFFilter(true);
        return IWFFilter.toSingleExpression(filters);
    }

    private QFilter buildMatchQFilter() {
        List<IWFFilter> filters = this.buildMatchWFFilter(false);
        return IWFFilter.toSingleQFilter(filters);
    }

    private List<IWFFilter> buildMatchWFFilter(boolean isHint) {
        List<AbstractWFFilter> pluginFilter;
        List<IWFFilter> wfExtQfilter;
        ArrayList<IWFFilter> filters = new ArrayList<IWFFilter>();
        List<IWFFilter> matchRuleFilter = this.relationConfig.buildMatchRuleFilter(this.writeOffMatchGroup, this.wfCalcFieldIdName, !isHint);
        filters.addAll(matchRuleFilter);
        if (this.isWfBillField) {
            WFMatchFilter qtyFilter = new WFMatchFilter(this.mainField, "!=", BigDecimal.ZERO);
            qtyFilter.setInfo(new WriteOffMatchConditionInfo(NounLang.mainField(this.mainField), "!=", String.valueOf(BigDecimal.ZERO)));
            filters.add(qtyFilter);
        }
        if ((wfExtQfilter = this.wfExtQfilter(this.billTypeEntity, this.wfCalcFieldIdName)) != null) {
            filters.addAll(wfExtQfilter);
        }
        if ((pluginFilter = this.writeOffMatchGroup.getPluginFilter(this.billTypeEntity)) != null) {
            filters.addAll(pluginFilter);
        }
        if (!isHint) {
            if (!this.additionQFilter.isEmpty()) {
                filters.addAll(this.additionQFilter);
            }
            List<WFConditionFilter> wfConditionFilters = this.writeOffBillConfig.getWfConditionFilters();
            filters.addAll(wfConditionFilters);
        }
        for (IWFFilter filter : filters) {
            AbstractWFFilter wfFilter;
            WriteOffMatchConditionInfo info;
            if (!(filter instanceof AbstractWFFilter) || (info = (wfFilter = (AbstractWFFilter)filter).getInfo()) == null) continue;
            this.writeOffMatchConditionInfos.add(info);
        }
        return filters;
    }

    protected List<IWFFilter> wfExtQfilter(String billTypeEntity, String wfCalcFieldIdName) {
        List<Object> fieldValue = this.writeOffMatchGroup.getMatchKeys();
        List<IWFFilter> wfExtQfilter = this.getMatchPluginProxy().getMatchFilters(fieldValue.get(fieldValue.size() - 1), billTypeEntity, wfCalcFieldIdName);
        if (wfExtQfilter != null && !wfExtQfilter.isEmpty()) {
            return wfExtQfilter;
        }
        return null;
    }

    private List<WriteOffObject> handleMatchResult(List<DynamicObject> matchEntryDatas) {
        ArrayList<WriteOffObject> targetBillList = new ArrayList<WriteOffObject>(12);
        for (DynamicObject entryDynamicObject : matchEntryDatas) {
            WriteOffObject rbWriteOffObject;
            WriteOffObject writeOffObject = WriteOffGroupHelper.buildWriteOffObject(this.writeOffTypeConfig, this.writeOffBillConfig, entryDynamicObject, this.writeOffTypeContext);
            if (this.curMainFieldValueMap != null) {
                Object entryPk = entryDynamicObject.get(this.wfCalcFieldIdName);
                BigDecimal curWFDecimal = this.curMainFieldValueMap.get(entryPk);
                WriteOffObjectManager.setManualInitLogicWriteOffNumber(writeOffObject.getWriteOffObjectBase(), curWFDecimal);
            } else if (this.writeOffTypeContext.isRBWriteOffTogether() && (rbWriteOffObject = this.writeOffTypeContext.getRBWriteOffObject(writeOffObject.getWriteOffObjectPk())) != null) {
                if (rbWriteOffObject.isWfComplete()) continue;
                writeOffObject = rbWriteOffObject;
            }
            if (writeOffObject.isCurWriteOffZero() || writeOffObject.isWfNumZero() || !this.writeOffBillConfig.checkHighCondtion(writeOffObject)) continue;
            targetBillList.add(writeOffObject);
        }
        return targetBillList;
    }

    private MatchPluginProxy getMatchPluginProxy() {
        return this.executeContext.getPluginFactory().createMatchPluginProxy(this.writeOffTypeConfig, this.relationConfig.getMatchRuleConfig());
    }

    private Integer getMaxHandleSize() {
        Integer maxHandleBillSize = this.executeContext.getWfParam().getMaxHandleBillSize();
        if (maxHandleBillSize != null) {
            return maxHandleBillSize;
        }
        return 5000;
    }

    public void addFilter(IWFFilter additionQFilter) {
        this.additionQFilter.add(additionQFilter);
    }

    public void addFilters(List<IWFFilter> additionQFilters) {
        this.additionQFilter.addAll(additionQFilters);
    }

    public void setCurMainFieldValueMap(Map<Object, BigDecimal> curMainFieldValueMap) {
        this.curMainFieldValueMap = curMainFieldValueMap;
    }

    public QFilter getMatchConditionQFilter() {
        return this.matchConditionQFilter;
    }

    public List<WriteOffMatchConditionInfo> getWriteOffMatchConditionInfos() {
        return this.writeOffMatchConditionInfos;
    }
}

