/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.record;

import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.AbstractWriteOffRecordStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.LeftRightRecordStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.MainAssistRecordStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.UpDownRecordStrategy;

public class WriteOffRecordStrategyFactory {
    public static AbstractWriteOffRecordStrategy getStrategy(WriteOffTypeConfig typeConfig, WriteOffExecuteContext executeContext) {
        AbstractWriteOffRecordStrategy recordStrategy;
        String writeType = typeConfig.getWriteoffType();
        if ("B".equals(writeType)) {
            throw new KDBizException("not support feeshare!");
        }
        switch (typeConfig.getWfRecordTemplateEnum()) {
            case TEMPLATE_LEFT_RIGHT: {
                recordStrategy = new LeftRightRecordStrategy();
                break;
            }
            case TEMPLATE_UP_DOWN: {
                recordStrategy = new UpDownRecordStrategy();
                break;
            }
            case TEMPLATE_MAIN_ASSIST: {
                recordStrategy = new MainAssistRecordStrategy();
                break;
            }
            default: {
                recordStrategy = new UpDownRecordStrategy();
            }
        }
        recordStrategy.setExecuteContext(executeContext);
        return recordStrategy;
    }
}

