/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.AbstractWriteOffRecordStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class LeftRightRecordStrategy
extends AbstractWriteOffRecordStrategy {
    @Override
    protected WriteOffRecordMapper generateRecordEntries(String recordBillEntryType, DynamicObject recordBill, List<IWriteOffQueue> writeOffQueues) {
        WriteOffRecordMapper recordMapper = new WriteOffRecordMapper();
        SchemeContextConfig schemeContextConfig = this.getSchemeContextConfig();
        List<Object> leftRightQueues = new ArrayList();
        leftRightQueues = schemeContextConfig.hasExcuteLastWhole() ? this.buildLastWholeLeftRightQueues(writeOffQueues) : this.buildLeftRightQueues(writeOffQueues);
        DynamicObjectCollection entries = recordBill.getDynamicObjectCollection(recordBillEntryType);
        int size = ((IWriteOffQueue)leftRightQueues.get(0)).size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = entries.addNew();
            entry.set("seq", (Object)(i + 1));
            WriteOffObjectBase leftWriteOffObject = ((IWriteOffQueue)leftRightQueues.get(0)).poll();
            this.setWriteOffValue(recordMapper, entry, leftWriteOffObject);
            this.setBillHeadMappingColumns(leftWriteOffObject, recordBill);
            if (leftRightQueues.size() > 1) {
                WriteOffObjectBase rightWriteOffObject = ((IWriteOffQueue)leftRightQueues.get(1)).poll();
                this.setBillHeadMappingColumns(rightWriteOffObject, recordBill);
                this.setWriteOffValue(recordMapper, entry, rightWriteOffObject);
                this.setDefaultValue(entry, rightWriteOffObject);
            }
            this.setDefaultValue(entry, leftWriteOffObject);
        }
        return recordMapper;
    }

    private void setWriteOffValue(WriteOffRecordMapper recordMapper, DynamicObject entry, WriteOffObjectBase writeOffObject) {
        if (writeOffObject != null) {
            recordMapper.mapping(writeOffObject, entry);
            super.setEntryColumns(writeOffObject, entry);
        }
    }

    private void setDefaultValue(DynamicObject entry, WriteOffObjectBase writeOffObject) {
        if (writeOffObject == null) {
            return;
        }
        WriteOffTypeConfig typeConfig = this.getTypeConfig();
        WriteOffBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
        BigDecimal writeOffNumber = writeOffObject.getWriteOffNumber();
        WriteOffBillConfig mainWfBill = this.getTypeConfig().getBillConfigs().get(0);
        if (mainWfBill.getBillAlias().equals(writeOffBillConfig.getBillAlias())) {
            this.initWriteOffObject(writeOffObject, entry, "billid", "billentryid", "billtype", "billno");
            if ("msmod_leftrtamounttpl".equals(typeConfig.getWfRecordTemplateNum())) {
                entry.set("curwfamount", (Object)writeOffNumber);
            } else {
                entry.set("qty", (Object)writeOffNumber);
            }
            writeOffObject.setMainWriteOff(Boolean.TRUE);
            entry.set("backwfop", (Object)ResManager.loadKDString((String)"\u5206\u5f55\u53cd\u6838\u9500", (String)"LeftRightRecordStrategy_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        } else {
            this.initWriteOffObject(writeOffObject, entry, "assbillid", "assbillentryid", "assbilltype", "assbillno");
            if ("msmod_leftrtamounttpl".equals(typeConfig.getWfRecordTemplateNum())) {
                entry.set("asscurwfamount", (Object)writeOffNumber);
            } else {
                entry.set("assqty", (Object)writeOffNumber);
            }
            entry.set("backwfop", (Object)ResManager.loadKDString((String)"\u5206\u5f55\u53cd\u6838\u9500", (String)"LeftRightRecordStrategy_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            writeOffObject.setMainWriteOff(Boolean.FALSE);
        }
    }

    private List<IWriteOffQueue> buildLeftRightQueues(List<IWriteOffQueue> writeOffQueues) {
        if (writeOffQueues.size() == 1) {
            return writeOffQueues;
        }
        SchemeContextConfig schemeContextConfig = this.getSchemeContextConfig();
        ArrayList<IWriteOffQueue> leftRightQueues = new ArrayList<IWriteOffQueue>();
        WriteOffObjectQueue leftQueue = new WriteOffObjectQueue();
        WriteOffObjectQueue rightQueue = new WriteOffObjectQueue();
        leftRightQueues.add(leftQueue);
        leftRightQueues.add(rightQueue);
        IWriteOffQueue leftCandidateQueue = writeOffQueues.get(0);
        IWriteOffQueue rightCandidateQueue = writeOffQueues.get(1);
        while (!leftCandidateQueue.isEmpty() || !rightCandidateQueue.isEmpty()) {
            WriteOffObjectBase leftWriteObject = leftCandidateQueue.peek();
            WriteOffObjectBase rightWriteObject = rightCandidateQueue.peek();
            boolean billIsWhole = leftWriteObject != null && leftWriteObject.getWhole() != false || rightWriteObject != null && rightWriteObject.getWhole() != false;
            Boolean isWhole = schemeContextConfig.isWhole() && billIsWhole;
            BigDecimal planWriteOffNumber = this.countWriteOffNumber(leftWriteObject, rightWriteObject);
            if (leftWriteObject == null || rightWriteObject == null) {
                if (!schemeContextConfig.isSingle()) break;
                leftQueue.add(leftCandidateQueue.poll());
                rightQueue.add(rightCandidateQueue.poll());
                continue;
            }
            if (schemeContextConfig.isManualWhole() || isWhole.booleanValue()) {
                leftQueue.add(leftCandidateQueue.poll());
                rightQueue.add(rightCandidateQueue.poll());
                continue;
            }
            if (WriteOffObjectManager.getLogicWriteOffNumber(leftWriteObject).abs().compareTo(planWriteOffNumber.abs()) > 0) {
                this.cutObjectAndWriteOff(leftQueue, leftCandidateQueue, leftWriteObject, planWriteOffNumber);
                rightQueue.add(rightCandidateQueue.poll());
                continue;
            }
            if (WriteOffObjectManager.getLogicWriteOffNumber(rightWriteObject).abs().compareTo(planWriteOffNumber.abs()) > 0) {
                leftQueue.add(leftCandidateQueue.poll());
                this.cutObjectAndWriteOff(rightQueue, rightCandidateQueue, rightWriteObject, planWriteOffNumber);
                continue;
            }
            leftQueue.add(leftCandidateQueue.poll());
            rightQueue.add(rightCandidateQueue.poll());
        }
        return leftRightQueues;
    }

    private List<IWriteOffQueue> buildLastWholeLeftRightQueues(List<IWriteOffQueue> writeOffQueues) {
        ArrayList<IWriteOffQueue> leftRightQueues = new ArrayList<IWriteOffQueue>();
        WriteOffObjectQueue leftQueue = new WriteOffObjectQueue();
        WriteOffObjectQueue rightQueue = new WriteOffObjectQueue();
        leftRightQueues.add(leftQueue);
        leftRightQueues.add(rightQueue);
        IWriteOffQueue leftCandidateQueue = writeOffQueues.get(0);
        IWriteOffQueue rightCandidateQueue = writeOffQueues.get(1);
        while (!leftCandidateQueue.isEmpty() && !rightCandidateQueue.isEmpty()) {
            leftQueue.add(leftCandidateQueue.poll());
            rightQueue.add(rightCandidateQueue.poll());
        }
        return leftRightQueues;
    }

    private void cutObjectAndWriteOff(IWriteOffQueue targetQueue, IWriteOffQueue sourceQueue, WriteOffObjectBase writeOffObject, BigDecimal planWriteOffNumber) {
        BigDecimal returnWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObject).subtract(planWriteOffNumber);
        WriteOffObjectBase planWriteOffObject = writeOffObject.clone();
        WriteOffObjectManager.setLogicWriteOffNumber(planWriteOffObject, planWriteOffNumber);
        WriteOffObjectManager.setLogicWriteOffNumberNotAss(writeOffObject, returnWriteOffNumber, planWriteOffObject.getWriteOffValues());
        sourceQueue.update(writeOffObject);
        targetQueue.add(planWriteOffObject);
    }

    private BigDecimal countWriteOffNumber(WriteOffObjectBase leftWriteObject, WriteOffObjectBase rightWriteObject) {
        if (leftWriteObject == null || rightWriteObject == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal leftLogicWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(leftWriteObject);
        BigDecimal rightLogicWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(rightWriteObject);
        if (leftLogicWriteOffNumber.abs().compareTo(rightLogicWriteOffNumber.abs()) < 0) {
            return leftLogicWriteOffNumber;
        }
        return rightLogicWriteOffNumber;
    }
}

