/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.AbstractWriteOffRecordStrategy;
import kd.mpscmm.mscommon.writeoff.common.helper.WfRecordVerifyRelationHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class MainAssistRecordStrategy
extends AbstractWriteOffRecordStrategy {
    @Override
    protected WriteOffRecordMapper generateRecordEntries(String recordBillEntryType, DynamicObject recordBill, List<IWriteOffQueue> writeOffQueues) {
        WriteOffRecordMapper recordMapper = new WriteOffRecordMapper();
        this.wfRecordSort(writeOffQueues);
        this.recordHeadSetValues(recordBill, writeOffQueues, recordMapper);
        this.recordEntrySetValues(recordBillEntryType, recordBill, writeOffQueues, recordMapper);
        return recordMapper;
    }

    private void recordEntrySetValues(String recordBillEntryType, DynamicObject recordBill, List<IWriteOffQueue> writeOffQueues, WriteOffRecordMapper recordMapper) {
        WriteOffObjectBase rightWriteOffObject;
        DynamicObjectCollection entries = recordBill.getDynamicObjectCollection(recordBillEntryType);
        if (writeOffQueues.size() > 1 && (rightWriteOffObject = writeOffQueues.get(1).poll()) != null && rightWriteOffObject.getWriteOffObject() != null) {
            DynamicObject entry = entries.addNew();
            WriteOffBillConfig writeOffBillConfig = this.getBillConfig(rightWriteOffObject);
            Integer seq = writeOffBillConfig.getSeq();
            boolean isRedBlue = seq == 1;
            recordMapper.mapping(rightWriteOffObject, entry, isRedBlue);
            this.setDefaultValue(entry, rightWriteOffObject);
            this.setHeadColumns(rightWriteOffObject, recordBill, false);
            this.setRbEntryColumns(rightWriteOffObject, entry, false);
        }
    }

    private void recordHeadSetValues(DynamicObject recordBill, List<IWriteOffQueue> writeOffQueues, WriteOffRecordMapper recordMapper) {
        WriteOffObjectBase poll = writeOffQueues.get(0).poll();
        this.wfObSetValue(recordBill, poll, recordMapper);
        Date writeOffDate = this.getSchemeContextConfig().getWriteOffDate();
        Long writeOffSeq = Long.valueOf(this.getExecuteContext().getSeq());
        recordBill.set("createtime", (Object)writeOffDate);
        recordBill.set("verifydate", (Object)writeOffDate);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        recordBill.set("creator", (Object)currentUserId);
        recordBill.set("writeofftypeid", (Object)this.getTypeConfig().getObj());
        recordBill.set("wfscheme", (Object)this.getSchemeContextConfig().getSchemeId());
        if (this.getSchemeContextConfig().isSingle()) {
            recordBill.set("verifyrelation", (Object)"single");
        } else {
            Long writeOffTypeId = this.getTypeConfig().getId();
            recordBill.set("verifyrelation", (Object)WfRecordVerifyRelationHelper.getVerifyRelation(writeOffTypeId));
        }
        recordBill.set("billstatus", (Object)"C");
        recordBill.set("wfseq", (Object)writeOffSeq);
        if (this.getExecuteContext().isFlowWriteOff()) {
            recordBill.set("verifytype", (Object)"auto");
        } else {
            recordBill.set("verifytype", (Object)"manual");
        }
    }

    private WriteOffObjectBase wfObSetValue(DynamicObject recordBill, WriteOffObjectBase poll, WriteOffRecordMapper recordMapper) {
        if (poll != null && poll.getWriteOffObject() != null) {
            this.setHeadColumns(poll, recordBill, true);
            Integer seq = this.getBillConfig(poll).getSeq();
            boolean isRedBlue = seq != 1;
            recordMapper.mapping(poll, recordBill, isRedBlue);
            this.initWriteOffObject(poll, recordBill, "billid", "billentryid", "billtype", "billno");
            BigDecimal writeOffNumber = poll.getWriteOffNumber();
            recordBill.set("verifybaseqty", (Object)writeOffNumber);
        }
        return poll;
    }

    private void setHeadColumns(WriteOffObjectBase writeOffObject, DynamicObject recordBill, boolean isMain) {
        if (writeOffObject != null) {
            boolean isLastWhole = this.getSchemeContextConfig().isLastWhole();
            WriteOffBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
            List<RecordColumnConfig> recordHeadColumnConfigs = this.getBillWfMapping(writeOffBillConfig).getRecordHeadColumnConfigs();
            for (RecordColumnConfig columnConfig : recordHeadColumnConfigs) {
                String targetColumn = columnConfig.getTargetColumn();
                String sourceColumn = columnConfig.getSourceColumn();
                if ("1".equals(columnConfig.getSelectValue())) {
                    this.setByExpression(writeOffObject, recordBill, targetColumn, columnConfig);
                    continue;
                }
                this.setByField(writeOffObject, recordBill, targetColumn, sourceColumn, isLastWhole);
            }
        }
    }

    private void setByField(WriteOffObjectBase writeOffObject, DynamicObject recordBill, String targetColumn, String sourceColumn, boolean isLastWhole) {
        if (writeOffObject.getWriteOffValues().containsKey(sourceColumn)) {
            BigDecimal bigDecimal = writeOffObject.getWriteOffValues().get(sourceColumn);
            recordBill.set(targetColumn, (Object)bigDecimal);
        } else {
            BillFieldInfoManager billFieldInfo = this.getExecuteContext().getBillFieldInfo();
            Object value = billFieldInfo.getObjWithTransDO(writeOffObject, sourceColumn);
            if (value instanceof DynamicObject) {
                value = DynamicObjectUtil.getMaterialMasterOb((DynamicObject)value);
            }
            recordBill.set(targetColumn, value);
            if ("verifyqty".equals(targetColumn) && isLastWhole) {
                recordBill.set(targetColumn, (Object)writeOffObject.getWriteOffNumber());
            }
        }
    }

    private void setDefaultValue(DynamicObject entry, WriteOffObjectBase writeOffObject) {
        if (writeOffObject == null) {
            return;
        }
        this.initWriteOffObject(writeOffObject, entry, "e_billid", "e_billentryid", "e_billtype", "e_billno");
        BigDecimal writeOffNumber = writeOffObject.getWriteOffNumber();
        entry.set("e_verifybaseqty", (Object)writeOffNumber);
    }

    protected void setRbEntryColumns(WriteOffObjectBase writeOffObject, DynamicObject entry, boolean isMain) {
        if (writeOffObject == null) {
            return;
        }
        WriteOffBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
        List<RecordColumnConfig> recordHeadColumnConfigs = this.getBillWfMapping(writeOffBillConfig).getRecordEntryColumnConfigs();
        this.setEntryColumn(writeOffObject, entry, recordHeadColumnConfigs);
    }

    private void wfRecordSort(List<IWriteOffQueue> writeOffQueues) {
        Collections.sort(writeOffQueues, new Comparator<IWriteOffQueue>(){

            @Override
            public int compare(IWriteOffQueue o1, IWriteOffQueue o2) {
                if (o1.peek() == null || o2.peek() == null) {
                    return 0;
                }
                Integer seqOne = MainAssistRecordStrategy.this.getBillConfig(o1.peek()).getSeq();
                Integer seqTwo = MainAssistRecordStrategy.this.getBillConfig(o2.peek()).getSeq();
                return seqOne.compareTo(seqTwo);
            }
        });
    }
}

