/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.AbstractWriteOffRecordStrategy;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class UpDownRecordStrategy
extends AbstractWriteOffRecordStrategy {
    @Override
    protected WriteOffRecordMapper generateRecordEntries(String recordBillEntryType, DynamicObject recordBill, List<IWriteOffQueue> writeOffQueues) {
        WriteOffRecordMapper recordMapper = new WriteOffRecordMapper();
        recordBill.set("wfmode", (Object)this.getExecuteContext().getWfMode());
        int i = 0;
        DynamicObjectCollection entries = recordBill.getDynamicObjectCollection(recordBillEntryType);
        this.wfRecordSort(writeOffQueues);
        for (IWriteOffQueue writeOffQueue : writeOffQueues) {
            while (!writeOffQueue.isEmpty()) {
                DynamicObject entry = entries.addNew();
                entry.set("seq", (Object)(++i));
                WriteOffObjectBase writeOffObject = writeOffQueue.poll();
                recordMapper.mapping(writeOffObject, entry);
                super.setEntryColumns(writeOffObject, entry);
                super.setBillHeadMappingColumns(writeOffObject, recordBill);
                this.initWriteOffObject(writeOffObject, entry, "billid", "billentryid", "billtype", "billno");
                BigDecimal writeOffNumber = writeOffObject.getWriteOffNumber();
                WriteOffTypeConfig typeConfig = this.getTypeConfig();
                if ("msmod_updownamounttpl".equals(typeConfig.getWfRecordTemplateNum())) {
                    entry.set("curwfamount", (Object)writeOffNumber);
                    continue;
                }
                entry.set("qty", (Object)writeOffNumber);
            }
        }
        return recordMapper;
    }

    private void wfRecordSort(List<IWriteOffQueue> writeOffQueues) {
        Collections.sort(writeOffQueues, new Comparator<IWriteOffQueue>(){

            @Override
            public int compare(IWriteOffQueue o1, IWriteOffQueue o2) {
                if (o1.peek() == null || o2.peek() == null) {
                    return 0;
                }
                Integer seqOne = UpDownRecordStrategy.this.getBillConfig(o1.peek()).getSeq();
                Integer seqTwo = UpDownRecordStrategy.this.getBillConfig(o2.peek()).getSeq();
                return seqOne.compareTo(seqTwo);
            }
        });
    }
}

