/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WFFieldInfo;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WriteOffObject
implements Cloneable {
    private WriteOffObjectBase writeOffObjectBase = new WriteOffObjectBase();
    private WriteOffTypeConfig typeConfig;
    private WriteOffBillConfig writeOffBillConfig;
    private WFFieldInfo mainColumn;

    public WriteOffObject clone() {
        try {
            WriteOffObject writeOffObject = (WriteOffObject)super.clone();
            String valuesMapStr = JSON.toJSONString(writeOffObject.getWriteOffValues());
            Map valuesMap = (Map)JSON.parse((String)valuesMapStr);
            for (Map.Entry entry : valuesMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Integer)) continue;
                BigDecimal bigDecimal = BigDecimal.valueOf(((Integer)value).intValue());
                entry.setValue(bigDecimal);
            }
            writeOffObject.getWriteOffObjectBase().setWriteOffValues(valuesMap);
            return writeOffObject;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriteOffObject)) {
            return false;
        }
        WriteOffObject that = (WriteOffObject)o;
        return Objects.equals(this.getWriteOffObjectPk(), this.getWriteOffObjectPk()) && Objects.equals(this.typeConfig.getId(), that.typeConfig.getId()) && Objects.equals(this.writeOffBillConfig.getBillAlias(), that.writeOffBillConfig.getBillAlias());
    }

    public int hashCode() {
        return Objects.hash(this.writeOffObjectBase.getPkValue(), this.typeConfig.getId(), this.writeOffBillConfig.getBillAlias());
    }

    public Object getValue(String key) {
        return this.writeOffObjectBase.getValue(key);
    }

    public Object getWriteOffObjectPk() {
        return this.writeOffObjectBase.getPkValue();
    }

    public Object getWriteOffBillPk() {
        return this.writeOffObjectBase.getWriteOffBillPk();
    }

    public String getWriteOffBillEntityName() {
        return this.getWriteOffBillConfig().getBillType();
    }

    public void setWriteOffObject(DynamicObject writeOffObject) {
        this.writeOffObjectBase.setWriteOffObject(writeOffObject);
    }

    public void setMainWriteOff(Boolean mainWriteOff) {
        this.writeOffObjectBase.setMainWriteOff(mainWriteOff);
    }

    public BigDecimal getWriteOffNumber() {
        return this.writeOffObjectBase.getWriteOffNumber();
    }

    public void setWriteOffNumber(BigDecimal writeOffNumber) {
        this.writeOffObjectBase.setWriteOffNumber(writeOffNumber);
    }

    public Map<String, BigDecimal> getWriteOffValues() {
        return this.writeOffObjectBase.getWriteOffValues();
    }

    public void setWriteOffValues(Map<String, BigDecimal> writeOffValues) {
        this.writeOffObjectBase.setWriteOffValues(writeOffValues);
    }

    public WriteOffTypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    public void setTypeConfig(WriteOffTypeConfig typeConfig) {
        this.writeOffObjectBase.setWfTypeEntity(typeConfig.getObj());
        this.typeConfig = typeConfig;
    }

    public WriteOffBillConfig getWriteOffBillConfig() {
        return this.writeOffBillConfig;
    }

    public void setWriteOffBillConfig(WriteOffBillConfig writeOffBillConfig) {
        this.writeOffBillConfig = writeOffBillConfig;
        this.writeOffObjectBase.setWfBillEntity(writeOffBillConfig.getObj());
        WriteOffColumnConfig config = writeOffBillConfig.getWriteOffColumnConfig();
        if (config != null) {
            this.writeOffObjectBase.setInvert(writeOffBillConfig.getWriteOffColumnConfig().getCalculationRule());
        }
    }

    public boolean isWfComplete() {
        return this.writeOffObjectBase.isWfComplete();
    }

    public boolean isBillObj() {
        return this.writeOffObjectBase.isBillObj();
    }

    public boolean isCurWriteOffZero() {
        return BigDecimal.ZERO.compareTo(this.writeOffObjectBase.getCurWriteOffNumber()) == 0;
    }

    public boolean isWfNumZero() {
        return BigDecimal.ZERO.compareTo(this.writeOffObjectBase.getWriteOffNumber()) == 0;
    }

    public void setCurWriteOffNumber(BigDecimal curWriteOffNumber) {
        this.writeOffObjectBase.setCurWriteOffNumber(curWriteOffNumber);
    }

    public WriteOffObjectBase getWriteOffObjectBase() {
        return this.writeOffObjectBase;
    }

    public void setWhole(Boolean whole) {
        this.writeOffObjectBase.setWhole(whole);
    }

    public void setPrimaryColumn(WFFieldInfo mainColumn) {
        this.mainColumn = mainColumn;
        this.writeOffObjectBase.setMainWFFieldIdKey(mainColumn.getWfCalcFieldIdName());
        this.writeOffObjectBase.setPrimaryColumn(mainColumn.getWriteOffFieldKey());
        this.writeOffObjectBase.setPrimaryColumnEObjId(String.valueOf(mainColumn.getId()));
    }

    public WFFieldInfo getMainColumn() {
        return this.mainColumn;
    }
}

