/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.formula.FormulaEngine;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WriteOffObjectManager {
    public static String expressionEntry(String expression, String billType) {
        String[] columns;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)expression, CRCondition.class);
        for (String column : columns = FormulaEngine.extractVariables((String)condition.getExpression())) {
            IDataEntityType parent;
            IDataEntityProperty property = dataEntityType.findProperty(column);
            if (property == null || (parent = property.getParent()) == null) continue;
            return parent.getName();
        }
        return null;
    }

    public static BigDecimal getLogicWriteOffNumber(WriteOffObjectBase writeOffObject) {
        if (writeOffObject.isInvert()) {
            return BigDecimal.ZERO.subtract(writeOffObject.getWriteOffNumber());
        }
        return writeOffObject.getWriteOffNumber();
    }

    public static void setLogicWriteOffNumber(WriteOffObjectBase writeOffObject, BigDecimal newWriteOffNumber) {
        writeOffObject.setLogicWriteOffNumber(newWriteOffNumber);
    }

    public static void setLogicWriteOffNumberNotAss(WriteOffObjectBase writeOffObject, BigDecimal newWriteOffNumber, Map<String, BigDecimal> assFields) {
        if (writeOffObject.isInvert()) {
            newWriteOffNumber = BigDecimal.ZERO.subtract(newWriteOffNumber);
        }
        writeOffObject.setWriteOffNumber(newWriteOffNumber);
        for (Map.Entry<String, BigDecimal> assValue : writeOffObject.getWriteOffValues().entrySet()) {
            String key = assValue.getKey();
            BigDecimal initValue = assValue.getValue();
            BigDecimal useValue = assFields.get(key);
            BigDecimal newValue = initValue.subtract(useValue);
            assValue.setValue(newValue);
        }
    }

    public static void setManualInitLogicWriteOffNumber(WriteOffObjectBase writeOffObject, BigDecimal newWriteOffNumber) {
        WriteOffObjectManager.setActualWriteOffNumber(writeOffObject, newWriteOffNumber);
    }

    public static void setActualWriteOffNumber(WriteOffObjectBase writeOffObject, BigDecimal newWriteOffNumber) {
        writeOffObject.setActualLogicWriteOffNumber(newWriteOffNumber);
    }

    public static List<WriteOffObject> cloneWriteOffObjects(List<WriteOffObject> writeOffObjects) {
        ArrayList<WriteOffObject> cloneWriteOffObjects = new ArrayList<WriteOffObject>(writeOffObjects.size());
        cloneWriteOffObjects.addAll(writeOffObjects);
        return cloneWriteOffObjects;
    }

    public static String getWriteOffMainFiledName(WriteOffObjectBase writeOffObject) {
        String[] primaryColumnSegments = writeOffObject.getPrimaryColumn().split("\\.");
        if (primaryColumnSegments.length > 1) {
            return primaryColumnSegments[primaryColumnSegments.length - 1];
        }
        return writeOffObject.getPrimaryColumn();
    }
}

