/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillSortConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractTemplateWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.SequenceWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.SingleWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.ValueEqualsWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.AgencyWriteOffStrategy;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffStrategyPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WriteOffStrategyExecutor {
    private static final Log logger = LogFactory.getLog(WriteOffStrategyExecutor.class);
    private SchemeContextConfig schemeContextConfig;
    private final WriteOffExecuteContext executeContext;
    private final WriteOffTypeContext writeOffTypeContext;

    public WriteOffStrategyExecutor(WriteOffTypeContext writeOffTypeContext) {
        this.writeOffTypeContext = writeOffTypeContext;
        this.executeContext = writeOffTypeContext.getExecuteContext();
    }

    public void setSchemeContextConfig(SchemeContextConfig schemeContextConfig) {
        this.schemeContextConfig = schemeContextConfig;
    }

    public void writeOff(List<WriteOffQueueGroup> queueGroups) {
        WriteOffTypeConfig typeConfig = this.writeOffTypeContext.getTypeConfig();
        this.executeContext.getPluginFactory().createWriteOffPluginProxy(typeConfig).beforeWriteOff(queueGroups);
        if (queueGroups.isEmpty()) {
            logger.info("\u63d2\u4ef6\u6267\u884cbeforeWriteOff\u540e\u5339\u914d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u6838\u9500\u3002");
        }
        WriteOffParamManager wfParam = this.writeOffTypeContext.getExecuteContext().getWfParam();
        List<IWriteOffStrategyPlugin> plugins = WfPluginExtFactory.execute(typeConfig);
        if (!CollectionUtils.isEmpty(plugins)) {
            IWriteOffStrategyPlugin writeOffStrategy = plugins.get(plugins.size() - 1);
            this.doBatchWriteOff(writeOffStrategy, queueGroups);
        } else {
            if ("B".equals(typeConfig.getObj().getString("writeofftype"))) {
                throw new KDBizException("not support feeshare type: " + typeConfig.getName());
            }
            if (wfParam.isNewAgency() && (WriteOffTypeIdConst.HXLB_WTDX_SALES.equals(typeConfig.getId()) || WriteOffTypeIdConst.HXLB_WTDX_SALES_RETURN.equals(typeConfig.getId()))) {
                this.doBatchWriteOff(new AgencyWriteOffStrategy(), this.batchPickRedQueues(queueGroups));
                this.doBatchWriteOff(new AgencyWriteOffStrategy(), queueGroups);
            } else if (this.schemeContextConfig.isSingle()) {
                SingleWriteOffStrategy singleWriteOffStrategy = new SingleWriteOffStrategy();
                this.doBatchWriteOff(singleWriteOffStrategy, queueGroups);
            } else if (this.schemeContextConfig.isOnlyEquals()) {
                this.doBatchWriteOff(new ValueEqualsWriteOffStrategy(), queueGroups);
            } else {
                if (this.schemeContextConfig.isEqualsFirst()) {
                    this.doBatchWriteOff(new ValueEqualsWriteOffStrategy(), queueGroups);
                }
                this.doBatchWriteOff(new SequenceWriteOffStrategy(), this.batchPickRedQueues(queueGroups));
                this.doBatchWriteOff(new SequenceWriteOffStrategy(), queueGroups);
            }
        }
    }

    private void doBatchWriteOff(IWriteOffStrategyPlugin writeOffStrategy, List<WriteOffQueueGroup> queueGroups) {
        WriteOffTypeConfig typeConfig = this.writeOffTypeContext.getTypeConfig();
        if (writeOffStrategy instanceof AbstractTemplateWriteOffStrategy) {
            AbstractTemplateWriteOffStrategy strategy = (AbstractTemplateWriteOffStrategy)writeOffStrategy;
            strategy.setExecuteContext(this.executeContext);
            strategy.setSnapShootHolder(this.writeOffTypeContext);
            strategy.setTypeConfig(typeConfig);
        }
        long startTime = System.currentTimeMillis();
        logger.info(String.format("\u6838\u9500\u7c7b\u522b\u3010%s\u3011\u6267\u884c\u6838\u9500\u7b56\u7565%s\u5f00\u59cb\u3002", typeConfig.getName(), writeOffStrategy.getClass().getSimpleName()));
        writeOffStrategy.batchExecute(this.schemeContextConfig, queueGroups);
        long endTime = System.currentTimeMillis();
        logger.info(String.format("\u6838\u9500\u7c7b\u522b\u3010%s\u3011\u6267\u884c\u6838\u9500\u7b56\u7565%s\u7ed3\u675f\uff0c\u8017\u65f6%sms\u3002", typeConfig.getName(), writeOffStrategy.getClass().getSimpleName(), endTime - startTime));
    }

    private List<WriteOffQueueGroup> batchPickRedQueues(List<WriteOffQueueGroup> queueGroups) {
        ArrayList<WriteOffQueueGroup> redWriteOffQueues = new ArrayList<WriteOffQueueGroup>(16);
        for (WriteOffQueueGroup queue : queueGroups) {
            redWriteOffQueues.add(this.pickRedQueues(queue));
        }
        return redWriteOffQueues;
    }

    private WriteOffQueueGroup pickRedQueues(WriteOffQueueGroup candidateQueues) {
        ArrayList<IWriteOffQueue> redQueues = new ArrayList<IWriteOffQueue>(10);
        for (IWriteOffQueue writeOffQueue : candidateQueues.getCandidateQueues()) {
            WriteOffObjectBase redObject;
            WriteOffObjectQueue redQueue = new WriteOffObjectQueue(new ArrayList<BillSortConfig>(16), this.schemeContextConfig, null);
            while ((redObject = writeOffQueue.pollRedObject()) != null) {
                redQueue.add(redObject);
            }
            redQueues.add(redQueue);
        }
        WriteOffQueueGroup redQueueGroup = new WriteOffQueueGroup(candidateQueues.getGroup());
        redQueueGroup.createFromList(redQueues);
        return redQueueGroup;
    }
}

