/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordStrategyFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.AbstractWriteOffRecordStrategy;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.PluginFactory;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.CheckPluginProxy;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WriteOffPluginProxy;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffStrategyPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;

public abstract class AbstractTemplateWriteOffStrategy
implements IWriteOffStrategyPlugin {
    private WriteOffTypeConfig typeConfig;
    private WriteOffTypeContext snapShootHolder;
    private WriteOffExecuteContext executeContext;
    private AbstractWriteOffRecordStrategy recordStrategy;
    protected static final Log logger = LogFactory.getLog(AbstractTemplateWriteOffStrategy.class);

    protected void handleRecords(SchemeContextConfig schemeContextConfig, List<WriteOffRecordMapper> records) {
        PluginFactory pluginFactory = this.getExecuteContext().getPluginFactory();
        WriteOffPluginProxy iWriteOffPluginProxy = pluginFactory.createWriteOffPluginProxy(this.getTypeConfig());
        iWriteOffPluginProxy.setSchemeContextConfig(schemeContextConfig);
        iWriteOffPluginProxy.beforeAllWfRecordsGenerate(records);
        CheckPluginProxy checkproxy = pluginFactory.createCheckPluignProxy(this.getTypeConfig());
        checkproxy.setSchemeContextConfig(schemeContextConfig);
        checkproxy.batchCheckRecords(records);
        this.addRecordMapper(records);
    }

    protected void addRecordInfo(WriteOffRecordMapper recordMapper) {
        this.getSnapShootHolder().addRecordBill(recordMapper);
    }

    protected final WriteOffRecordMapper writeOffRecord(WriteOffQueueGroup writeOffQueueGroup, SchemeContextConfig schemeContextConfig) {
        return this.writeOffRecord(writeOffQueueGroup.getCandidateQueues(), writeOffQueueGroup.getDetail(), schemeContextConfig);
    }

    protected final WriteOffRecordMapper writeOffRecord(List<IWriteOffQueue> writeOffQueues, String wbDetail, SchemeContextConfig schemeContextConfig) {
        WriteOffExecuteContext executeContext = this.getExecuteContext();
        if (this.recordStrategy == null) {
            this.recordStrategy = WriteOffRecordStrategyFactory.getStrategy(this.getTypeConfig(), executeContext);
            this.recordStrategy.setTypeConfig(this.getTypeConfig());
            this.recordStrategy.setSchemeContextConfig(schemeContextConfig);
        }
        return this.recordStrategy.generate(this.getTypeConfig(), writeOffQueues, wbDetail);
    }

    protected final void addRecordMapper(List<WriteOffRecordMapper> records) {
        for (WriteOffRecordMapper recordMapping : records) {
            this.getSnapShootHolder().addRecordBill(recordMapping);
        }
    }

    public final WriteOffTypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    public final void setTypeConfig(WriteOffTypeConfig typeConfig) {
        this.typeConfig = typeConfig;
    }

    public final WriteOffTypeContext getSnapShootHolder() {
        return this.snapShootHolder;
    }

    public final void setSnapShootHolder(WriteOffTypeContext snapShootHolder) {
        this.snapShootHolder = snapShootHolder;
    }

    public final WriteOffExecuteContext getExecuteContext() {
        return this.executeContext;
    }

    public final void setExecuteContext(WriteOffExecuteContext executeContext) {
        this.executeContext = executeContext;
    }
}

