/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.unwf;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillBotpConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.BackWfStrategyFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfKdtxParamHolder;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.impl.AbstractBackWfStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.AutoGenBillHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.BillFieldParseHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import kd.mpscmm.mscommon.writeoff.common.log.UnWriteOffLog;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.UnWfPluginFactory;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractUnWriteOffEngine {
    protected static final Log logger = LogFactory.getLog(AbstractUnWriteOffEngine.class);
    private String seq = null;
    private WriteOffParamManager writeOffParamManager = null;
    private Map<Long, WriteOffTypeConfig> typeConfigs = new HashMap<Long, WriteOffTypeConfig>(16);
    private UnWriteOffLog unWriteOffLog = null;

    protected String getSeq() {
        if (this.seq == null) {
            this.seq = WriteSeqHelper.getSeq();
        }
        return this.seq;
    }

    protected abstract UnWriteOffLog initUnWFLog();

    protected final UnWriteOffLog getUnWriteOffLog() {
        return this.unWriteOffLog;
    }

    protected abstract void execute();

    public void doExecute() {
        try {
            this.unWriteOffLog = this.initUnWFLog();
            this.execute();
            if (this.unWriteOffLog != null) {
                UnWriteOffLogHelper.saveLog(this.unWriteOffLog);
            }
        }
        catch (Exception e) {
            if (this.unWriteOffLog != null) {
                UnWriteOffLogHelper.saveFailLog(this.unWriteOffLog, e);
            }
            logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(e.getMessage());
        }
    }

    protected final WriteOffParamManager getWriteOffParamManager() {
        if (this.writeOffParamManager == null) {
            this.writeOffParamManager = WriteOffParamManager.create();
        }
        return this.writeOffParamManager;
    }

    protected final List<DynamicObject> wfRecordSort(Collection<DynamicObject> records) {
        ArrayList<DynamicObject> recordSortList = new ArrayList<DynamicObject>(records);
        Collections.sort(recordSortList, (record1, record2) -> ObjectUtils.compare((Comparable)record2.getDate("createtime"), (Comparable)record1.getDate("createtime")));
        return recordSortList;
    }

    private Map<Object, DynamicObject> getSeqRecords(List<DynamicObject> recordList, WriteoffTemplateTypeEnum wfTemplateType) {
        DynamicObject[] recordsFromDB;
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST != wfTemplateType) {
            return new HashMap<Object, DynamicObject>(1);
        }
        Set ids = recordList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        MainEntityType mainEntityType = (MainEntityType)recordList.get(0).getDataEntityType();
        HashSet<String> paramKeys = new HashSet<String>(8);
        HashSet<String> wfSeqs = new HashSet<String>(16);
        HashSet<Long> verifySeqs = new HashSet<Long>(16);
        for (DynamicObject record : recordList) {
            String wfSeq = record.getString("wfseq");
            String verifySeq = record.getString("verifyseq");
            if (!StringUtils.isEmpty((CharSequence)wfSeq)) {
                wfSeqs.add(wfSeq);
            }
            if (!StringUtils.isEmpty((CharSequence)verifySeq)) {
                verifySeqs.add(Long.valueOf(verifySeq));
            }
            String key = wfSeq + "&&" + verifySeq;
            paramKeys.add(key);
        }
        if (wfSeqs.isEmpty() && verifySeqs.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter filter = new QFilter("id", "not in", ids);
        if (!wfSeqs.isEmpty()) {
            filter.and("wfseq", "in", wfSeqs);
        }
        if (!verifySeqs.isEmpty()) {
            filter.and("verifyseq", "in", verifySeqs);
        }
        HashMap<Object, DynamicObject> recordsWithSameSeq = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject record : recordsFromDB = this.loadRecordsFromDB(mainEntityType, filter)) {
            String wfSeq = record.getString("wfseq");
            String verifySeq = record.getString("verifyseq");
            String key = wfSeq + "&&" + verifySeq;
            if (!paramKeys.contains(key)) continue;
            recordsWithSameSeq.put(record.get("id"), record);
        }
        return recordsWithSameSeq;
    }

    private DynamicObject[] loadRecordsFromDB(MainEntityType mainEntityType, QFilter filter) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)mainEntityType.getName(), (QFilter[])filter.toArray(), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
    }

    private void checkRecord(List<DynamicObject> records, WriteoffTemplateTypeEnum wfTemplateType) {
        if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN != wfTemplateType) {
            return;
        }
        Set recordIds = records.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        HashSet genBillIds = new HashSet(16);
        HashSet<String> genRecordWfNumbers = new HashSet<String>(16);
        for (DynamicObject record : records) {
            BackWriteOffDetail backWriteOffDetail = WriteOffRecordHelper.getWfInfo(record);
            List<BackWriteOffDetail.AutoGeneration> autoList = backWriteOffDetail.getAutoList();
            if (autoList == null || autoList.isEmpty()) continue;
            List collect = autoList.stream().map(BackWriteOffDetail.AutoGeneration::getBillId).collect(Collectors.toList());
            genBillIds.addAll(collect);
            String wfNumber = record.getString("wfnumber");
            genRecordWfNumbers.add(wfNumber);
        }
        if (genBillIds.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("entry.billId", "in", genBillIds);
        String recordEntity = records.get(0).getDataEntityType().getName();
        List allContainRecords = QueryServiceHelper.queryPrimaryKeys((String)recordEntity, (QFilter[])qFilter.toArray(), null, (int)-1);
        if (!recordIds.containsAll(allContainRecords)) {
            HashSet useBills = new HashSet(allContainRecords);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55(%1$s)\u7684\u81ea\u52a8\u751f\u6210\u5355\u636e\u88ab\u6838\u9500\u8bb0\u5f55\uff08%2$s\uff09\u6240\u5f15\u7528\uff0c\u8bf7\u5148\u5904\u7406\u5f15\u7528\u7684\u6838\u9500\u8bb0\u5f55\u3002", (String)"ReverseWriteOffEngine_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), String.valueOf(genRecordWfNumbers), JSONObject.toJSONString(useBills)));
        }
    }

    protected final Collection<DynamicObject> loadRecordsFromDB(String recordEntity, String selectProperties, QFilter recordFilter) {
        Object[] records;
        if (StringUtils.isBlank((CharSequence)selectProperties)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)recordEntity);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)recordEntity, (QFilter[])recordFilter.toArray(), null, (int)-1);
            records = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
        } else {
            records = BusinessDataServiceHelper.load((String)recordEntity, (String)selectProperties, (QFilter[])recordFilter.toArray());
        }
        if (ArrayUtils.isEmpty((Object[])records)) {
            return Collections.emptyList();
        }
        return Arrays.asList(records);
    }

    protected final BackWfKdtxParamHolder createHolder(WriteoffTemplateTypeEnum wfRecordTemplateEnum) {
        BackWfKdtxParamHolder holder = new BackWfKdtxParamHolder(wfRecordTemplateEnum);
        holder.setWriteOffParamManager(this.getWriteOffParamManager());
        holder.setWfTypeMap(this.typeConfigs);
        holder.setUnWriteOffLog(this.unWriteOffLog);
        return holder;
    }

    protected final void handleUnWfKDTXHolder(BackWfKdtxParamHolder holder, Collection<DynamicObject> recordEntities, WriteoffTemplateTypeEnum wfTemplateType) {
        this.handleUnWfKDTXHolder(holder, recordEntities, wfTemplateType, false);
    }

    protected final void handleUnWfKDTXHolder(BackWfKdtxParamHolder holder, Collection<DynamicObject> recordEntities, WriteoffTemplateTypeEnum wfTemplateType, boolean isChargeAgainst) {
        holder.setWriteOffParamManager(this.getWriteOffParamManager());
        List<DynamicObject> records = new ArrayList<DynamicObject>(recordEntities);
        if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfTemplateType) {
            this.checkRecord(records, wfTemplateType);
            records = this.wfRecordSort(records);
        } else if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == wfTemplateType) {
            Map<Object, DynamicObject> resultMap = this.getSeqRecords(records, wfTemplateType);
            records.addAll(resultMap.values());
        }
        this.batchCheck(holder, records, isChargeAgainst);
        this.canDeleteAutoBill(records);
        AbstractBackWfStrategy backWfStrategy = BackWfStrategyFactory.create(wfTemplateType, holder);
        backWfStrategy.setCa(isChargeAgainst);
        for (DynamicObject recordEntity : records) {
            DynamicObject wfTypeObj = recordEntity.getDynamicObject("writeofftypeid");
            if (wfTypeObj == null) continue;
            long wfTypeId = wfTypeObj.getLong("id");
            WriteOffTypeConfig typeConfig = this.getTypeConfig(wfTypeId);
            backWfStrategy.backWriteOff(typeConfig, recordEntity);
        }
    }

    protected void canDeleteAutoBill(Collection<DynamicObject> records) {
        HashMap allAutoBillMap = new HashMap(16);
        LinkedHashMap wfTypeToRecords = new LinkedHashMap(16);
        for (DynamicObject recordEntity : records) {
            DynamicObject wfTypeObj = recordEntity.getDynamicObject("writeofftypeid");
            if (wfTypeObj == null) continue;
            long wfTypeId = wfTypeObj.getLong("id");
            MapUtils.mapGetListValue(wfTypeToRecords, wfTypeId).add(recordEntity);
            Map<String, Set<Long>> autoBillMap = AutoGenBillHelper.collectAutoGenBillSet(recordEntity);
            if (autoBillMap.isEmpty()) continue;
            MapUtils.addSet(allAutoBillMap, autoBillMap);
        }
        if (allAutoBillMap.isEmpty()) {
            return;
        }
        List<WriteOffTypeConfig> typeConfigList = this.getTypeConfig(wfTypeToRecords.keySet());
        for (WriteOffTypeConfig writeOffTypeConfig : typeConfigList) {
            Long wfTypeId = writeOffTypeConfig.getId();
            List<WriteOffBillConfig> autoBillCfgs = writeOffTypeConfig.getBillConfigs();
            if (CollectionUtils.isEmpty(autoBillCfgs)) continue;
            for (WriteOffBillConfig autoBillCfg : autoBillCfgs) {
                if (CollectionUtils.isEmpty(autoBillCfg.getBillBotpConfigs())) continue;
                for (BillBotpConfig billBotpConfig : autoBillCfg.getBillBotpConfigs()) {
                    String filterString;
                    String targetBillEntity;
                    boolean canDelete;
                    String ruleId = billBotpConfig.getBotpRule();
                    String key = AutoGenBillHelper.buildKey(wfTypeId, ruleId);
                    Set autoBillIds = (Set)allAutoBillMap.get(key);
                    if (CollectionUtils.isEmpty((Collection)autoBillIds) || (canDelete = AutoGenBillHelper.canDelete(targetBillEntity = billBotpConfig.getTargetBillType(), filterString = billBotpConfig.getFilterString(), autoBillIds))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u5355\u636e\u4e0d\u6ee1\u8db3\u5220\u9664\u6761\u4ef6,\u4e0d\u5141\u8bb8\u53cd\u6838\u9500\u3002", (String)"AbstractBackWfStrategy_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                }
            }
        }
    }

    private void batchCheck(BackWfKdtxParamHolder holder, List<DynamicObject> recordEntities, boolean isChargeAgainst) {
        LinkedHashMap wfTypeToRecords = new LinkedHashMap(16);
        for (DynamicObject recordEntity : recordEntities) {
            DynamicObject wfTypeObj = recordEntity.getDynamicObject("writeofftypeid");
            if (wfTypeObj == null) continue;
            long wfTypeId = wfTypeObj.getLong("id");
            MapUtils.mapGetListValue(wfTypeToRecords, wfTypeId).add(recordEntity);
        }
        Map<Long, WriteOffTypeConfig> typeConfigMap = this.getTypeConfigMap(wfTypeToRecords.keySet());
        for (Map.Entry wfTypeToRecordsEntry : wfTypeToRecords.entrySet()) {
            Long wfTypeId = (Long)wfTypeToRecordsEntry.getKey();
            WriteOffTypeConfig typeConfig = typeConfigMap.get(wfTypeId);
            if (typeConfig == null) continue;
            List typeToRecords = (List)wfTypeToRecordsEntry.getValue();
            holder.getUnWfPluginExtFactory().batchCheck(typeToRecords, typeConfig, isChargeAgainst);
        }
    }

    protected final WriteOffTypeConfig getTypeConfig(Long wfTypeId) {
        List<WriteOffTypeConfig> typeConfigs = this.getTypeConfig(Collections.singletonList(wfTypeId));
        if (typeConfigs == null || typeConfigs.isEmpty()) {
            return null;
        }
        return typeConfigs.get(0);
    }

    protected final Map<Long, WriteOffTypeConfig> getTypeConfigMap(Collection<Long> wfTypeList) {
        List<WriteOffTypeConfig> typeConfig = this.getTypeConfig(wfTypeList);
        HashMap<Long, WriteOffTypeConfig> result = new HashMap<Long, WriteOffTypeConfig>(16);
        for (WriteOffTypeConfig config : typeConfig) {
            result.put(config.getId(), config);
        }
        return result;
    }

    protected final List<WriteOffTypeConfig> getTypeConfig(Collection<Long> wfTypeList) {
        ArrayList<WriteOffTypeConfig> resultConfigs = new ArrayList<WriteOffTypeConfig>(16);
        ArrayList<Long> needQueryWFTIds = new ArrayList<Long>(16);
        for (Long wfTypeId : wfTypeList) {
            WriteOffTypeConfig typeConfig = this.typeConfigs.get(wfTypeId);
            if (typeConfig != null) {
                resultConfigs.add(typeConfig);
                continue;
            }
            needQueryWFTIds.add(wfTypeId);
        }
        if (!needQueryWFTIds.isEmpty()) {
            QFilter typeFilter = new QFilter("id", "in", needQueryWFTIds);
            Map wfTypeObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])typeFilter.toArray());
            for (DynamicObject wfTypeObj : wfTypeObjs.values()) {
                WriteOffTypeConfig writeOffTypeConfig = WriteOffTypeConfig.build(wfTypeObj);
                this.typeConfigs.put(writeOffTypeConfig.getId(), writeOffTypeConfig);
                resultConfigs.add(writeOffTypeConfig);
            }
        }
        return resultConfigs;
    }

    protected Map<String, Set<String>> getAllProperty(List<Long> wfTypeIds, boolean isCa) {
        HashMap<String, Set<String>> allFieldMap = new HashMap<String, Set<String>>(4);
        for (Long wfTypeId : wfTypeIds) {
            Map<String, Set<String>> fieldMap = UnWfPluginFactory.getAllPluginPrepareKeys(wfTypeId, isCa);
            for (Map.Entry<String, Set<String>> entry : fieldMap.entrySet()) {
                String entityKey = entry.getKey();
                Set fields = (Set)allFieldMap.get(entityKey);
                if (null == fields) {
                    allFieldMap.put(entityKey, entry.getValue());
                    continue;
                }
                fields.addAll((Collection)entry.getValue());
            }
        }
        return allFieldMap;
    }

    protected String getSelectFields(Map<String, Set<String>> customBillFieldMap, List<WriteOffTypeConfig> wfTypeConfigs, String recordEntity, WriteoffTemplateTypeEnum wfRecordTemplateEnum) {
        Set<String> customBillFields;
        List<Long> typeIds = wfTypeConfigs.stream().map(item -> item.getId()).collect(Collectors.toList());
        Map<String, Set<String>> allFieldMap = this.getAllProperty(typeIds, false);
        Set<String> pluginFields = allFieldMap.get(recordEntity);
        Set<String> fields = BillFieldParseHelper.getBaseFieldsByTpl(wfRecordTemplateEnum);
        if (null != pluginFields) {
            fields.addAll(pluginFields);
        }
        if (null != (customBillFields = customBillFieldMap.get(recordEntity))) {
            fields.addAll(customBillFields);
        }
        String selectProperties = BillFieldParseHelper.buildSelectProperties(recordEntity, fields);
        return selectProperties;
    }
}

