/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.unwf;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.EntryBackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.unwf.AbstractUnWriteOffEngine;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.log.UnWriteOffLog;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import org.apache.commons.collections.CollectionUtils;

public class EntryBackWriteOffEngine
extends AbstractUnWriteOffEngine {
    private static final Log logger = LogFactory.getLog(EntryBackWriteOffEngine.class);
    private static final String WRITE_BACK_TYPE_ADD = "0";
    private static final String WRITE_BACK_TYPE_SUB = "1";
    private DynamicObject[] recordEntries;

    public EntryBackWriteOffEngine(DynamicObject[] recordEntries) {
        this.recordEntries = recordEntries;
    }

    @Override
    protected UnWriteOffLog initUnWFLog() {
        UnWriteOffLog unWriteOffLog = new UnWriteOffLog();
        UnWriteOffLogHelper.fillHeadLog(unWriteOffLog, this.getSeq(), "chargeAgainstRecordKey", "M");
        UnWriteOffLogHelper.addMatchCondition(unWriteOffLog, this.recordEntries);
        UnWriteOffLogHelper.addSrcBillInfo(unWriteOffLog, this.recordEntries, null);
        return unWriteOffLog;
    }

    @Override
    protected void execute() {
        DynamicObject entry = this.recordEntries[0];
        DynamicObject parent = (DynamicObject)entry.getParent();
        this.checkEntryData(parent);
        this.entryBackWf(entry);
        this.updateWfRecord(entry, parent);
    }

    private void checkEntryData(DynamicObject parent) {
        String wfInfoTag = parent.getString("headwfinfo_tag");
        BackWriteOffDetail backWriteOffDetail = (BackWriteOffDetail)JSONObject.parseObject((String)wfInfoTag, BackWriteOffDetail.class);
        if (backWriteOffDetail != null && CollectionUtils.isNotEmpty(backWriteOffDetail.getAutoList())) {
            String message = ResManager.loadKDString((String)"\u8be5\u6761\u6838\u9500\u8bb0\u5f55\u6709\u81ea\u52a8\u751f\u6210\u5355\u636e\uff0c\u4e0d\u80fd\u5728\u5206\u5f55\u4e0a\u8fdb\u884c\u53cd\u6838\u9500\u3002", (String)"AbstractBackWfStrategy_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            logger.warn(message);
            throw new KDBizException(message);
        }
    }

    private void entryBackWf(DynamicObject entry) {
        Long assBillId;
        Long billId = entry.getLong("billid");
        if (billId != 0L) {
            String billEntryId = entry.getString("billentryid");
            String billNo = entry.getString("billno");
            String wfInfo = entry.getString("mainwfinfo_tag");
            String billType = entry.getDynamicObject("billtype").getString("number");
            this.backWriteBill(billId, billEntryId, wfInfo, billType, billNo);
        }
        if ((assBillId = Long.valueOf(entry.getLong("assbillid"))) != 0L) {
            String assBillEntryId = entry.getString("assbillentryid");
            String billNo = entry.getString("billno");
            String assWfInfo = entry.getString("asswfinfo_tag");
            String assBillType = entry.getDynamicObject("assbilltype").getString("number");
            this.backWriteBill(assBillId, assBillEntryId, assWfInfo, assBillType, billNo);
        }
    }

    private void backWriteBill(Long billId, String billEntryId, String wfInfo, String billType, String billNo) {
        EntryBackWriteOffDetail writeOffDetail = (EntryBackWriteOffDetail)JSONObject.parseObject((String)wfInfo, EntryBackWriteOffDetail.class);
        if (writeOffDetail == null) {
            return;
        }
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billType);
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u5355\u636e\u62a5\u9519\uff1a" + billNo, (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5355\u636e%s\u62a5\u9519\u3002", (String)"UpDownBackWfStrategy_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), billNo) + e.getMessage());
        }
        DynamicObject entryDynamicObject = CommonUtils.getEntryDynamicObject(dynamicObject, writeOffDetail.getEntryName(), billEntryId);
        List<EntryBackWriteOffDetail.BackWriteDetail> backWriteDetailList = writeOffDetail.getBackWriteDetailList();
        for (EntryBackWriteOffDetail.BackWriteDetail backWriteDetail : backWriteDetailList) {
            BigDecimal result = entryDynamicObject.getBigDecimal(backWriteDetail.getBillField());
            if (WRITE_BACK_TYPE_ADD.equals(backWriteDetail.getWriteBackType())) {
                result = result.subtract(backWriteDetail.getValue());
            } else if (WRITE_BACK_TYPE_SUB.equals(backWriteDetail.getWriteBackType())) {
                result = result.add(backWriteDetail.getValue());
            }
            entryDynamicObject.set(backWriteDetail.getBillField(), (Object)result);
        }
        SaveServiceHelper.update((DynamicObject)entryDynamicObject);
    }

    private void updateWfRecord(DynamicObject entry, DynamicObject parent) {
        DynamicObjectCollection collection = parent.getDynamicObjectCollection("entry");
        collection.remove((Object)entry);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            OperationServiceHelper.executeOperate((String)"delete", (String)parent.getDataEntityType().getName(), (Object[])new Object[]{parent.getPkValue()}, (OperateOption)OperateOption.create());
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
        }
    }
}

