/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.unwf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.UnWfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.unwf.FlowBackWriteOffEngine;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.BillSelectFieldLoadHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffServerHelper;
import kd.mpscmm.mscommon.writeoff.common.log.UnWriteOffLog;

public class UnCheckWriteOffEngine
extends FlowBackWriteOffEngine {
    public UnCheckWriteOffEngine(DynamicObject[] billEntities, String operationKey) {
        super(billEntities, operationKey);
    }

    @Override
    protected void execute() {
        DynamicObject[] billEntities = this.getBillEntities();
        IDataEntityType entityType = billEntities[0].getDataEntityType();
        List<Object> billIds = Stream.of(billEntities).map(item -> item.get("id")).collect(Collectors.toList());
        List<WriteOffTypeConfig> typeConfigs = this.getGetWfTypes(entityType, this.getOperationKey());
        Set<Object> orgIdSet = WriteOffServerHelper.getWFPlanOrgSet(billEntities);
        UnWfPluginExtFactory unWfPluginExtFactory = new UnWfPluginExtFactory();
        unWfPluginExtFactory.setWriteOffParamManager(this.getWriteOffParamManager());
        List<Long> typeIds = typeConfigs.stream().map(item -> item.getId()).collect(Collectors.toList());
        Map<String, Set<String>> allFieldMap = this.getAllProperty(typeIds, false);
        for (int i = typeConfigs.size() - 1; i >= 0; --i) {
            Long orgId;
            boolean isWfPlan;
            WriteOffTypeConfig typeConfig = typeConfigs.get(i);
            if (WriteOffServerHelper.getAllWFPlanType().contains(typeConfig.getId()) && !orgIdSet.contains(0L) && !(isWfPlan = WriteOffServerHelper.isWriteOffPlan(orgIdSet, orgId = Long.valueOf(billEntities[0].getDynamicObject("org").getLong("id"))))) continue;
            String recordBillType = typeConfig.getRecordNum();
            WriteoffTemplateTypeEnum wfRecordTemplateEnum = typeConfig.getWfRecordTemplateEnum();
            if (StringUtils.isBlank((CharSequence)recordBillType)) continue;
            Map<String, Set<String>> customBillFieldMap = BillSelectFieldLoadHelper.loadFields(Collections.singletonList(recordBillType));
            List<Object> wfRecordIds = null;
            if (WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == wfRecordTemplateEnum) {
                wfRecordIds = UnCheckWriteOffEngine.queryLeftRightWfRecordIds(recordBillType, Collections.singletonList(typeConfig.getId()), billIds);
            } else if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfRecordTemplateEnum) {
                wfRecordIds = UnCheckWriteOffEngine.queryUpDownWfRecordIds(recordBillType, Collections.singletonList(typeConfig.getId()), billIds);
            } else if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == wfRecordTemplateEnum) {
                wfRecordIds = this.queryMainAssistWfRecordIds(recordBillType, Collections.singletonList(typeConfig.getId()), billIds);
            }
            if (wfRecordIds == null || wfRecordIds.isEmpty()) continue;
            String selectProperties = this.getSelectFields(customBillFieldMap, Collections.singletonList(typeConfig), recordBillType, wfRecordTemplateEnum);
            QFilter recordFilter = new QFilter("id", "in", wfRecordIds);
            Collection<DynamicObject> recordEntities = this.loadRecordsFromDB(recordBillType, selectProperties, recordFilter);
            unWfPluginExtFactory.batchCheck(new ArrayList<DynamicObject>(recordEntities), typeConfig, false);
            this.canDeleteAutoBill(recordEntities);
        }
    }

    @Override
    protected UnWriteOffLog initUnWFLog() {
        return null;
    }
}

