/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AutoGenBillHelper {
    public static String buildKey(Long wfTypeId, String botpRuleId) {
        return wfTypeId + "#" + botpRuleId;
    }

    public static Map<String, Set<Long>> collectAutoGenBillSet(DynamicObject record) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(4);
        if (null == record) {
            return resultMap;
        }
        DynamicObject wfType = record.getDynamicObject("writeofftypeid");
        Long wfTypeId = (Long)wfType.getPkValue();
        BackWriteOffDetail backWriteOffDetail = WriteOffRecordHelper.getWfInfo(record);
        if (null == backWriteOffDetail) {
            return resultMap;
        }
        List<BackWriteOffDetail.AutoGeneration> autoGenBillList = backWriteOffDetail.getAutoList();
        if (CollectionUtils.isEmpty(autoGenBillList)) {
            return resultMap;
        }
        for (BackWriteOffDetail.AutoGeneration autoGenBill : autoGenBillList) {
            String botpRuleId = autoGenBill.getBotpRule();
            String key = AutoGenBillHelper.buildKey(wfTypeId, botpRuleId);
            HashSet<Long> autoBillIds = (HashSet<Long>)resultMap.get(key);
            if (null == autoBillIds) {
                autoBillIds = new HashSet<Long>(2);
                resultMap.put(key, autoBillIds);
            }
            autoBillIds.add(autoGenBill.getBillId());
        }
        return resultMap;
    }

    public static boolean canDelete(String entityName, String filterString, Collection<Long> billIds) {
        if (StringUtils.isBlank((CharSequence)filterString)) {
            return true;
        }
        QFilter idFilter = new QFilter("id", "in", billIds);
        List dbIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])idFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)dbIds)) {
            return true;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterString, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (null != filterCondition) {
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), filterCondition);
            fb.buildFilter();
            filters.add(fb.getQFilter());
        }
        filters.add(new QFilter("id", "in", (Object)dbIds));
        List matchDbIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
        return matchDbIds.size() == dbIds.size();
    }
}

