/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.formula.FormulaEngine;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;

public class BillFieldParseHelper {
    public static Set<String> extractVariables(String filterString) {
        if (StringUtils.isBlank((CharSequence)filterString)) {
            return new HashSet<String>(2);
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterString, CRCondition.class);
        String expression = condition.getExpression();
        if (StringUtils.isBlank((CharSequence)expression)) {
            return new HashSet<String>(2);
        }
        Object[] columns = FormulaEngine.extractVariables((String)expression);
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return Collections.singleton("id");
        }
        return new HashSet<Object>(Arrays.asList(columns));
    }

    public static String buildSelectProperties(String entityKey, Set<String> fields) {
        if (null == entityKey || ObjectUtils.isEmpty(fields)) {
            return "id";
        }
        HashSet<String> fullPathFields = new HashSet<String>(4);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        for (String field : fields) {
            DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)field);
            if (null == property) continue;
            String fieldPath = property.getName();
            for (IDataEntityType parentEntityType = property.getParent(); null != parentEntityType && parentEntityType instanceof EntryType; parentEntityType = parentEntityType.getParent()) {
                fieldPath = parentEntityType.getName() + "." + fieldPath;
            }
            fullPathFields.add(fieldPath);
        }
        return StringUtils.join((Object[])fullPathFields.toArray(), (String)",");
    }

    public static Set<String> getBaseFieldsByTpl(WriteoffTemplateTypeEnum wfRecordTemplateEnum) {
        Set<String> baseFields = BillFieldParseHelper.getBaseInfoFieldsByTpl(wfRecordTemplateEnum);
        baseFields.add("headwfinfo_tag");
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == wfRecordTemplateEnum) {
            baseFields.add("entry.wfinfo_tag");
        } else if (WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == wfRecordTemplateEnum) {
            baseFields.add("entry.mainwfinfo_tag");
            baseFields.add("entry.asswfinfo_tag");
        } else if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfRecordTemplateEnum) {
            baseFields.add("entry.wfinfo_tag");
        }
        return baseFields;
    }

    public static Set<String> getBaseInfoFieldsByTpl(WriteoffTemplateTypeEnum wfRecordTemplateEnum) {
        HashSet<String> baseFields = new HashSet<String>(16);
        baseFields.add("id");
        baseFields.add("createtime");
        baseFields.add("writeofftypeid");
        baseFields.add("wfseq");
        baseFields.add("wfnumber");
        baseFields.add("entry.id");
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == wfRecordTemplateEnum) {
            baseFields.add("verifyseq");
            baseFields.add("billid");
            baseFields.add("billentryid");
            baseFields.add("billtype");
            baseFields.add("entry.e_billid");
            baseFields.add("entry.e_billentryid");
            baseFields.add("entry.e_billtype");
        } else if (WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == wfRecordTemplateEnum) {
            baseFields.add("entry.billid");
            baseFields.add("entry.billentryid");
            baseFields.add("entry.billtype");
            baseFields.add("entry.assbillid");
            baseFields.add("entry.assbillentryid");
            baseFields.add("entry.assbilltype");
        } else if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfRecordTemplateEnum) {
            baseFields.add("entry.billid");
            baseFields.add("entry.billentryid");
            baseFields.add("entry.billtype");
        }
        return baseFields;
    }
}

