/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.user.UserService;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class ConditionHelper {
    public static CRCondition parseCondtion(String condition) {
        return (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
    }

    public static QFilter getQFiltersFromConditon(String billType, CRCondition filterCondition) {
        FilterBuilder filter = ConditionHelper.buildFilter(billType, filterCondition);
        if (filter == null) {
            return null;
        }
        return filter.getQFilter();
    }

    public static BOSExpression getExpressionFromCondtion(String billType, CRCondition filterCondition) {
        FilterBuilder filter = ConditionHelper.buildFilter(billType, filterCondition);
        if (filter == null) {
            return null;
        }
        String[] filterStrings = filter.buildFilterScript();
        return new BOSExpression(filterStrings[0]);
    }

    public static BOSUDFunction[] createUdFunctions(BOSExpression function, ExpressionContext expContext) {
        if (function == null) {
            return null;
        }
        Set funcs = function.getFuncs();
        if (funcs.isEmpty()) {
            return new BOSUDFunction[0];
        }
        FunctionManage funcLib = FunctionManage.get();
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>(16);
        for (String funcName : funcs) {
            if (!funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)funcLib.getFuncMap().get(funcName)).getInstance(expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[0]);
    }

    public static FilterBuilder buildFilter(String billType, CRCondition filterCondition) {
        FilterCondition condition = filterCondition.getFilterCondition();
        if (condition == null) {
            return null;
        }
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billType), condition);
        UserService userService = new UserService();
        filterBuilder.setUserService((IUserService)userService);
        filterBuilder.buildFilter(false);
        return filterBuilder;
    }

    public static Map<String, Object> getValueFromWriteOffObjectBase(Set<String> params, WriteOffObjectBase billHeadObj) {
        HashMap<String, Object> paramValues = new HashMap<String, Object>(16);
        for (String param : params) {
            Object result = billHeadObj.getValue(param);
            paramValues.put(param, ConditionHelper.handleValue(result));
        }
        return paramValues;
    }

    public static Map<String, Object> getValueFromBillObj(Set<String> params, WriteOffObject billHeadObj) {
        return ConditionHelper.getValueFromWriteOffObjectBase(params, billHeadObj.getWriteOffObjectBase());
    }

    public static Map<String, Object> getValueFromBillEntryObj(Set<String> params, DynamicObject billEntryObj) {
        DynamicObject billHeadObj = (DynamicObject)billEntryObj.getParent();
        HashMap<String, Object> paramValues = new HashMap<String, Object>(16);
        BillEntityType entityType = (BillEntityType)billHeadObj.getDataEntityType();
        for (String param : params) {
            String[] splitProps = param.split("\\.");
            String propKey = splitProps[0];
            IDataEntityProperty prop = entityType.findProperty(propKey);
            IDataEntityType parentType = prop.getParent();
            DynamicObject curObj = parentType instanceof EntryType ? billEntryObj : billHeadObj;
            RowDataModel billEntry = CommonUtils.getBillEntry(curObj);
            paramValues.put(param, ConditionHelper.handleValue(billEntry.getValue(param)));
        }
        return paramValues;
    }

    private static Object handleValue(Object value) {
        if (value instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)value).getLocaleValue();
        }
        return value;
    }

    public static boolean checkHighCondition(String preCondition, DynamicObject checkObj, MainEntityType checkObjMainEntiy) {
        return ConditionHelper.checkHighCondition(checkObjMainEntiy, preCondition, checkObj);
    }

    public static boolean checkHighCondition(String highExpression, WriteOffObjectBase writeOffObjectBase, MainEntityType checkObjMainEntiy) {
        return ConditionHelper.checkHighCondition(checkObjMainEntiy, highExpression, writeOffObjectBase);
    }

    private static boolean checkHighCondition(MainEntityType type, String preCondition, final DynamicObject dynamicObject) {
        ExpressionContext context = new ExpressionContext(){

            public Boolean tryGetValue(String s, OutValue<Object> outValue) {
                Object o = dynamicObject.get(s);
                if (o == null) {
                    return Boolean.FALSE;
                }
                outValue.set(o);
                return Boolean.TRUE;
            }
        };
        return (Boolean)CalcExprParser.getExpressionValue((String)preCondition, (ExpressionContext)context, (FunctionManage)FunctionManage.get());
    }

    private static boolean checkHighCondition(MainEntityType type, String preCondition, final WriteOffObjectBase objbase) {
        ExpressionContext context = new ExpressionContext(){

            public Boolean tryGetValue(String s, OutValue<Object> outValue) {
                Object o = objbase.getValue(s);
                if (o == null) {
                    return Boolean.FALSE;
                }
                outValue.set(o);
                return Boolean.TRUE;
            }
        };
        return (Boolean)CalcExprParser.getExpressionValue((String)preCondition, (ExpressionContext)context, (FunctionManage)FunctionManage.get());
    }
}

