/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.util.List;
import kd.bos.context.KdtxRequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class ECServiceHelper {
    private static final Log logger = LogFactory.getLog(ECServiceHelper.class);
    private static final String DB_ROUTE_KEY = "scm";

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, Param param) throws KDException {
        ECServiceHelper.execute(scenesCode, branchScenesCode, cloudId, appId, DB_ROUTE_KEY, serviceName, param);
    }

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, List<String> businessInfo, String bizId, Param param) throws Exception {
        ECServiceHelper.execute(scenesCode, branchScenesCode, cloudId, appId, DB_ROUTE_KEY, serviceName, businessInfo, param, bizId, true);
    }

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, List<String> businessInfo, String bizId, Param param, boolean isAysnc) throws Exception {
        ECServiceHelper.execute(scenesCode, branchScenesCode, cloudId, appId, DB_ROUTE_KEY, serviceName, businessInfo, param, bizId, isAysnc);
    }

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String dbRoute, String serviceName, Param param) throws KDException {
        ECServiceHelper.execute(scenesCode, branchScenesCode, cloudId, appId, dbRoute, serviceName, param, (String)null, true);
    }

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, Param param, String bizId) throws KDException {
        ECServiceHelper.execute(scenesCode, branchScenesCode, cloudId, appId, DB_ROUTE_KEY, serviceName, param, bizId, true);
    }

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String dbRoute, String serviceName, Param param, String bizId) throws KDException {
        ECServiceHelper.execute(scenesCode, branchScenesCode, cloudId, appId, dbRoute, serviceName, param, bizId, true);
    }

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String dbRoute, String serviceName, List<String> businessInfo, Param param, String bizId) throws Exception {
        ECServiceHelper.execute(scenesCode, branchScenesCode, cloudId, appId, dbRoute, serviceName, businessInfo, param, bizId, true);
    }

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String dbRoute, String serviceName, List<String> businessInfo, Param param, String bizId, boolean isAysnc) throws KDException {
        long start = System.currentTimeMillis();
        logger.info(String.format("\u6267\u884cECServiceHelper\u5f00\u59cb[scenesCode\u3010%s\u3011\uff0cbranchScenesCode\u3010%s\u3011\uff0cserviceName\u3010%s\u3011]", scenesCode, branchScenesCode, serviceName));
        if (!TX.inTX()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6700\u7ec8\u4e00\u81f4\u6027\u670d\u52a1\u5fc5\u987b\u5728\u4e8b\u52a1\u5185\u6ce8\u518c\u3002", (String)"ECServiceHelper_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        if (KdtxRequestContext.get().isCommitted()) {
            logger.info("\u6267\u884cECServiceHelper.execute.begin,xid:" + KdtxRequestContext.get().getXid());
            ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)dbRoute));
        }
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param, (String)branchScenesCode, (String)bizId);
        if (!CollectionUtils.isEmpty(businessInfo)) {
            ECGlobalSession.setBusinessType((String)"ECServiceHelperExt");
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
        ECGlobalSession.setAsync((boolean)isAysnc);
        long end = System.currentTimeMillis();
        logger.info(String.format("\u6267\u884cECServiceHelper\u7ed3\u675f[scenesCode\u3010%s\u3011\uff0cbranchScenesCode\u3010%s\u3011\uff0cserviceName\u3010%s\u3011],\u8017\u65f6%sms", scenesCode, branchScenesCode, serviceName, end - start));
    }

    public static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String dbRoute, String serviceName, Param param, String bizId, boolean isAysnc) throws KDException {
        ECServiceHelper.execute(scenesCode, branchScenesCode, cloudId, appId, dbRoute, serviceName, null, param, bizId, isAysnc);
    }
}

