/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.log.UnWriteOffLog;
import org.apache.commons.lang3.ObjectUtils;

public class UnWriteOffLogHelper {
    private static final Log log = LogFactory.getLog(UnWriteOffLogHelper.class);

    public static UnWriteOffLog init() {
        UnWriteOffLog unWriteOffLog = new UnWriteOffLog();
        return unWriteOffLog;
    }

    public static void addMatchCondition(UnWriteOffLog unWriteOffLog, String recordEntity, String matchCondition, boolean matchStatus) {
        if (null == unWriteOffLog) {
            return;
        }
        unWriteOffLog.createMatchInfo(recordEntity, matchCondition, matchStatus);
    }

    public static void addMatchCondition(UnWriteOffLog unWriteOffLog, DynamicObject[] wfRecords) {
        if (null == unWriteOffLog) {
            return;
        }
        String wfRecordType = wfRecords[0].getDataEntityType().getName();
        List ids = Stream.of(wfRecords).map(item -> item.get("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        unWriteOffLog.createMatchInfo(wfRecordType, qFilter.toString(), ObjectUtils.isNotEmpty((Object)wfRecords));
    }

    public static Long addTaskEntry(UnWriteOffLog unWriteOffLog, String taskName, String branchcode, String taskClass, String businessid, Object paramInfo) {
        if (null == unWriteOffLog) {
            return null;
        }
        return unWriteOffLog.addTaskEntry(taskName, branchcode, taskClass, businessid, paramInfo);
    }

    public static void fillHeadLog(UnWriteOffLog unWriteOffLog, String seq, String operationKey, String unWfMode) {
        if (null == unWriteOffLog) {
            return;
        }
        unWriteOffLog.fillHeadLog(seq, operationKey, unWfMode);
    }

    public static void addSrcBillInfo(UnWriteOffLog unWriteOffLog, DynamicObject[] dataEntities, String billNoField) {
        if (null == unWriteOffLog) {
            return;
        }
        unWriteOffLog.addSrcBillInfo(dataEntities, billNoField);
    }

    public static void saveLog(UnWriteOffLog unWriteOffLog) {
        if (null == unWriteOffLog || null == unWriteOffLog.getLogObj()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{unWriteOffLog.getLogObj()});
            }
            catch (Exception e) {
                log.info("\u53cd\u6838\u9500\u6267\u884c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25", (Object)e);
            }
        }
    }

    public static void saveFailLog(UnWriteOffLog unWriteOffLog, Exception e) {
        if (null == unWriteOffLog) {
            return;
        }
        unWriteOffLog.setErrorMessage(e);
        UnWriteOffLogHelper.saveLog(unWriteOffLog);
    }

    public static String translateDBRoute(String dBRout) {
        switch (dBRout) {
            case "scm": {
                return ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u5e93", (String)"dbscm", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            }
            case "fi": {
                return ResManager.loadKDString((String)"\u8d22\u52a1\u5e93", (String)"dbfi", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            }
            case "cal": {
                return ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97\u5e93", (String)"dbcal", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            }
            case "phm": {
                return ResManager.loadKDString((String)"\u5236\u9020\u4e91\u5e93", (String)"dbphm", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            }
            case "drp": {
                return ResManager.loadKDString((String)"\u6e20\u9053\u5e93", (String)"dbdrp", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            }
            case "qmc": {
                return ResManager.loadKDString((String)"\u8d28\u91cf\u4e91", (String)"dbqmc", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            }
            case "icc": {
                return ResManager.loadKDString((String)"\u534f\u540c\u5e93", (String)"dbicc", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            }
            case "taxc": {
                return ResManager.loadKDString((String)"\u7a0e\u52a1\u5e93", (String)"dbtaxc", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            }
        }
        return dBRout;
    }
}

