/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WfRecordGroupHelper {
    public static List<List<IWriteOffQueue>> buildMainAsstQueues(List<IWriteOffQueue> writeOffQueues, SchemeContextConfig schemeContextConfig, WriteOffTypeConfig typeConfig) {
        return WfRecordGroupHelper.buildMainAsstQueues(writeOffQueues, schemeContextConfig, typeConfig, false);
    }

    public static List<List<IWriteOffQueue>> buildMainAsstQueues(List<IWriteOffQueue> writeOffQueues, SchemeContextConfig schemeContextConfig, WriteOffTypeConfig typeConfig, boolean isIgnoreWholeWf) {
        ArrayList<List<IWriteOffQueue>> leftRightQueues = new ArrayList<List<IWriteOffQueue>>(4);
        if (writeOffQueues.size() == 1) {
            IWriteOffQueue leftCandidateQueue = writeOffQueues.get(0);
            while (!leftCandidateQueue.isEmpty()) {
                ArrayList<WriteOffObjectQueue> leftRightQueueList = new ArrayList<WriteOffObjectQueue>(4);
                WriteOffObjectQueue leftQueue1 = new WriteOffObjectQueue();
                WriteOffObjectQueue rightQueue2 = new WriteOffObjectQueue();
                WriteOffObjectBase poll = leftCandidateQueue.poll();
                WriteOffBillConfig writeOffBillConfig = typeConfig.getBillConfigsById((Long)poll.getWfBillEntity().getPkValue());
                List<WriteOffBillConfig> billConfigs = typeConfig.getBillConfigs();
                leftQueue1.add(poll);
                List collect = billConfigs.stream().filter(n -> !n.getBillAlias().equals(writeOffBillConfig.getBillAlias())).collect(Collectors.toList());
                WriteOffObjectBase wf = new WriteOffObjectBase();
                wf.setWfBillEntity(((WriteOffBillConfig)collect.get(0)).getObj());
                rightQueue2.add(wf);
                leftRightQueueList.add(leftQueue1);
                leftRightQueueList.add(rightQueue2);
                leftRightQueues.add(leftRightQueueList);
            }
            return leftRightQueues;
        }
        WfRecordGroupHelper.wfRecordSort(writeOffQueues, typeConfig);
        IWriteOffQueue leftCandidateQueue = writeOffQueues.get(0);
        IWriteOffQueue rightCandidateQueue = writeOffQueues.get(1);
        while (!leftCandidateQueue.isEmpty() || !rightCandidateQueue.isEmpty()) {
            WriteOffObjectQueue rightQueue2;
            WriteOffObjectQueue leftQueue1;
            ArrayList<WriteOffObjectQueue> leftRightQueues1;
            boolean isWhole;
            WriteOffObjectBase leftWriteObject = leftCandidateQueue.peek();
            WriteOffObjectBase rightWriteObject = rightCandidateQueue.peek();
            boolean bl = isWhole = leftWriteObject != null && leftWriteObject.getWhole() != false || rightWriteObject != null && rightWriteObject.getWhole() != false;
            if ("1".equals(schemeContextConfig.getWfMode())) {
                boolean bl2 = isWhole = schemeContextConfig.isWhole() && isWhole;
            }
            if (isIgnoreWholeWf) {
                isWhole = false;
            }
            BigDecimal planWriteOffNumber = WfRecordGroupHelper.countWriteOffNumber(leftWriteObject, rightWriteObject);
            if (leftWriteObject == null || rightWriteObject == null) {
                if (!schemeContextConfig.isSingle()) break;
                leftRightQueues1 = new ArrayList<WriteOffObjectQueue>(4);
                leftQueue1 = new WriteOffObjectQueue();
                rightQueue2 = new WriteOffObjectQueue();
                leftQueue1.add(leftCandidateQueue.poll());
                rightQueue2.add(rightCandidateQueue.poll());
                leftRightQueues1.add(leftQueue1);
                leftRightQueues1.add(rightQueue2);
                leftRightQueues.add(leftRightQueues1);
                continue;
            }
            if (schemeContextConfig.isManualWhole() || isWhole) {
                ArrayList<WriteOffObjectQueue> leftRightQueuesOne = new ArrayList<WriteOffObjectQueue>(4);
                WriteOffObjectQueue leftQueueOne = new WriteOffObjectQueue();
                WriteOffObjectQueue rightQueueTwo = new WriteOffObjectQueue();
                leftQueueOne.add(leftCandidateQueue.poll());
                rightQueueTwo.add(rightCandidateQueue.poll());
                leftRightQueuesOne.add(leftQueueOne);
                leftRightQueuesOne.add(rightQueueTwo);
                leftRightQueues.add(leftRightQueuesOne);
                continue;
            }
            if (WriteOffObjectManager.getLogicWriteOffNumber(leftWriteObject).abs().compareTo(planWriteOffNumber.abs()) > 0) {
                leftRightQueues1 = new ArrayList(4);
                leftQueue1 = new WriteOffObjectQueue();
                rightQueue2 = new WriteOffObjectQueue();
                rightQueue2.add(rightCandidateQueue.poll());
                WfRecordGroupHelper.cutObjectAndWriteOff(leftQueue1, leftCandidateQueue, leftWriteObject, planWriteOffNumber);
                leftRightQueues1.add(leftQueue1);
                leftRightQueues1.add(rightQueue2);
                leftRightQueues.add(leftRightQueues1);
                continue;
            }
            if (WriteOffObjectManager.getLogicWriteOffNumber(rightWriteObject).abs().compareTo(planWriteOffNumber.abs()) > 0) {
                leftRightQueues1 = new ArrayList(4);
                leftQueue1 = new WriteOffObjectQueue();
                rightQueue2 = new WriteOffObjectQueue();
                leftQueue1.add(leftCandidateQueue.poll());
                WfRecordGroupHelper.cutObjectAndWriteOff(rightQueue2, rightCandidateQueue, rightWriteObject, planWriteOffNumber);
                leftRightQueues1.add(leftQueue1);
                leftRightQueues1.add(rightQueue2);
                leftRightQueues.add(leftRightQueues1);
                continue;
            }
            leftRightQueues1 = new ArrayList(4);
            leftQueue1 = new WriteOffObjectQueue();
            rightQueue2 = new WriteOffObjectQueue();
            leftQueue1.add(leftCandidateQueue.poll());
            rightQueue2.add(rightCandidateQueue.poll());
            leftRightQueues1.add(leftQueue1);
            leftRightQueues1.add(rightQueue2);
            leftRightQueues.add(leftRightQueues1);
        }
        return leftRightQueues;
    }

    public static List<List<IWriteOffQueue>> buildLastWholeMainAsstQueues(List<IWriteOffQueue> writeOffQueues, WriteOffTypeConfig typeConfig) {
        ArrayList<List<IWriteOffQueue>> leftRightQueues = new ArrayList<List<IWriteOffQueue>>(4);
        WfRecordGroupHelper.wfRecordSort(writeOffQueues, typeConfig);
        IWriteOffQueue leftCandidateQueue = writeOffQueues.get(0);
        IWriteOffQueue rightCandidateQueue = writeOffQueues.get(1);
        while (!leftCandidateQueue.isEmpty() && !rightCandidateQueue.isEmpty()) {
            ArrayList<WriteOffObjectQueue> leftRightQueueList = new ArrayList<WriteOffObjectQueue>(4);
            WriteOffObjectQueue leftQueue = new WriteOffObjectQueue();
            WriteOffObjectQueue rightQueue = new WriteOffObjectQueue();
            leftQueue.add(leftCandidateQueue.poll());
            rightQueue.add(rightCandidateQueue.poll());
            leftRightQueueList.add(leftQueue);
            leftRightQueueList.add(rightQueue);
            leftRightQueues.add(leftRightQueueList);
        }
        return leftRightQueues;
    }

    private static void cutObjectAndWriteOff(IWriteOffQueue targetQueue, IWriteOffQueue sourceQueue, WriteOffObjectBase writeOffObject, BigDecimal planWriteOffNumber) {
        BigDecimal returnWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObject).subtract(planWriteOffNumber);
        WriteOffObjectBase planWriteOffObject = writeOffObject.clone();
        WriteOffObjectManager.setLogicWriteOffNumber(planWriteOffObject, planWriteOffNumber);
        WriteOffObjectManager.setLogicWriteOffNumberNotAss(writeOffObject, returnWriteOffNumber, planWriteOffObject.getWriteOffValues());
        sourceQueue.update(writeOffObject);
        targetQueue.add(planWriteOffObject);
    }

    private static BigDecimal countWriteOffNumber(WriteOffObjectBase leftWriteObject, WriteOffObjectBase rightWriteObject) {
        if (leftWriteObject == null || rightWriteObject == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal leftLogicWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(leftWriteObject);
        BigDecimal rightLogicWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(rightWriteObject);
        if (leftLogicWriteOffNumber.abs().compareTo(rightLogicWriteOffNumber.abs()) < 0) {
            return leftLogicWriteOffNumber;
        }
        return rightLogicWriteOffNumber;
    }

    private static void wfRecordSort(List<IWriteOffQueue> writeOffQueues, final WriteOffTypeConfig typeConfig) {
        Collections.sort(writeOffQueues, new Comparator<IWriteOffQueue>(){

            @Override
            public int compare(IWriteOffQueue o1, IWriteOffQueue o2) {
                if (o1.peek() == null || o2.peek() == null) {
                    return 0;
                }
                WriteOffBillConfig writeOffBillConfig = typeConfig.getBillConfigsById((Long)o1.peek().getWfBillEntity().getPkValue());
                WriteOffBillConfig writeOffBillConfigTwo = typeConfig.getBillConfigsById((Long)o2.peek().getWfBillEntity().getPkValue());
                Integer seqOne = writeOffBillConfig.getSeq();
                Integer seqTwo = writeOffBillConfigTwo.getSeq();
                return seqOne.compareTo(seqTwo);
            }
        });
    }
}

