/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractCondtionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.GroupKeyResponse;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchConditionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WFFieldInfo;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.IWFSnapshotQtyHolder;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.util.MatcherUtil;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.PluginFactory;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;
import org.apache.commons.collections.CollectionUtils;

public class WriteOffGroupHelper {
    public static List<WriteOffObject> buildWriteOffObjects(WriteOffTypeConfig typeConfig, WriteOffBillConfig billConfig, DynamicObject billObject) {
        ArrayList<WriteOffObject> writeOffObjects = new ArrayList<WriteOffObject>(16);
        WriteOffObject writeOffObject = WriteOffGroupHelper.buildWriteOffObject(typeConfig, billConfig, billObject, null);
        writeOffObjects.add(writeOffObject);
        return writeOffObjects;
    }

    public static List<WriteOffObject> buildWriteOffObjects(WriteOffTypeConfig typeConfig, WriteOffBillConfig billConfig, DynamicObject billObject, IWFSnapshotQtyHolder wfSnapShootHolde) {
        ArrayList<WriteOffObject> writeOffObjects = new ArrayList<WriteOffObject>(16);
        WriteOffObject writeOffObject = WriteOffGroupHelper.buildWriteOffObject(typeConfig, billConfig, billObject, wfSnapShootHolde);
        writeOffObjects.add(writeOffObject);
        return writeOffObjects;
    }

    public static List<WriteOffObject> buildAutoWriteOffObjects(WriteOffTypeConfig typeConfig, WriteOffBillConfig billConfig, DynamicObject billObject) {
        ArrayList<WriteOffObject> writeOffObjects = new ArrayList<WriteOffObject>(16);
        IWriteOffMainFieldCalPlugin mainFieldCalClass = billConfig.getWriteOffColumnConfig().mainFieldCalClass();
        WFFieldInfo fieldInfo = billConfig.getWriteOffColumnConfig().getWfFieldInfo();
        List<DynamicObject> writeOffObjectList = mainFieldCalClass.parseWriteOffObj(billObject);
        for (DynamicObject entryObject : writeOffObjectList) {
            WriteOffObject writeOffObject = WriteOffGroupHelper.createWriteOffObject(typeConfig, billConfig, fieldInfo, entryObject);
            BigDecimal curWriteOffNum = writeOffObject.getWriteOffObjectBase().getCurWriteOffNumber();
            WriteOffGroupHelper.handleWriteOffNumber(billConfig, entryObject, writeOffObject, curWriteOffNum);
            writeOffObjects.add(writeOffObject);
        }
        return writeOffObjects;
    }

    public static WriteOffObject buildWriteOffObject(WriteOffTypeConfig typeConfig, WriteOffBillConfig billConfig, DynamicObject entryObject, IWFSnapshotQtyHolder wfSnapShootHolder) {
        WFFieldInfo fieldInfo = billConfig.getWriteOffColumnConfig().getWfFieldInfo();
        return WriteOffGroupHelper.buildWriteOffObject(typeConfig, billConfig, entryObject, wfSnapShootHolder, fieldInfo);
    }

    private static WriteOffObject buildWriteOffObject(WriteOffTypeConfig typeConfig, WriteOffBillConfig billConfig, DynamicObject entryObject, IWFSnapshotQtyHolder wfSnapShootHolder, WFFieldInfo mainColumn) {
        WriteOffObject writeOffObject = WriteOffGroupHelper.createWriteOffObject(typeConfig, billConfig, mainColumn, entryObject);
        BigDecimal subtractNum = BigDecimal.ZERO;
        if (wfSnapShootHolder != null) {
            BigDecimal curWriteOffNum = writeOffObject.getWriteOffObjectBase().getCurWriteOffNumber();
            subtractNum = curWriteOffNum.subtract(wfSnapShootHolder.getWriteOffQty(writeOffObject));
            WriteOffGroupHelper.handleWriteOffNumber(billConfig, entryObject, writeOffObject, subtractNum);
        }
        return writeOffObject;
    }

    private static WriteOffObject createWriteOffObject(WriteOffTypeConfig typeConfig, WriteOffBillConfig billConfig, WFFieldInfo mainColumn, DynamicObject entryObject) {
        WriteOffObject writeOffObject = new WriteOffObject();
        writeOffObject.setWriteOffObject(entryObject);
        writeOffObject.setTypeConfig(typeConfig);
        writeOffObject.setWriteOffBillConfig(billConfig);
        writeOffObject.setPrimaryColumn(mainColumn);
        Boolean whole = WriteOffGroupHelper.isWhole(billConfig, writeOffObject);
        writeOffObject.setWhole(whole);
        BigDecimal curWriteOffNum = mainColumn.getMainFieldCalClass().mainFieldCal(entryObject);
        writeOffObject.setCurWriteOffNumber(curWriteOffNum);
        if (BigDecimal.ZERO.compareTo(curWriteOffNum) != 0) {
            for (WriteOffColumnConfig wfColumn : billConfig.getWriteOffColumnConfigs()) {
                if (wfColumn.isWriteOffCalcField() || BigDecimal.ZERO.compareTo(curWriteOffNum) == 0) continue;
                BigDecimal assNum = wfColumn.mainFieldCalClass().mainFieldCal(entryObject);
                writeOffObject.getWriteOffValues().put(wfColumn.getWriteOffFieldKey(), assNum);
            }
        }
        return writeOffObject;
    }

    private static void handleWriteOffNumber(WriteOffBillConfig billConfig, DynamicObject entryObject, WriteOffObject writeOffObject, BigDecimal writeOffNumber) {
        writeOffObject.setWriteOffNumber(writeOffNumber);
        BigDecimal curWriteOffNum = writeOffObject.getWriteOffObjectBase().getCurWriteOffNumber();
        for (WriteOffColumnConfig wfColumn : billConfig.getWriteOffColumnConfigs()) {
            if (wfColumn.isWriteOffCalcField() || BigDecimal.ZERO.compareTo(curWriteOffNum) == 0) continue;
            BigDecimal assNum = wfColumn.mainFieldCalClass().mainFieldCal(entryObject);
            assNum = writeOffNumber.multiply(assNum).divide(curWriteOffNum, 10, RoundingMode.HALF_UP);
            writeOffObject.getWriteOffValues().put(wfColumn.getWriteOffFieldKey(), assNum);
        }
    }

    public static List<WriteOffObject> getMatchedObjAndRemove(AbstractCondtionConfig billOperateConfig, Collection<WriteOffObject> objs) {
        ArrayList<WriteOffObject> matchedObjs = new ArrayList<WriteOffObject>(objs.size());
        Iterator<WriteOffObject> iterator = objs.iterator();
        while (iterator.hasNext()) {
            WriteOffObject writeOffObject = iterator.next();
            if (!billOperateConfig.checkCondtion(writeOffObject) || !billOperateConfig.checkHighCondtion(writeOffObject)) continue;
            matchedObjs.add(writeOffObject);
            iterator.remove();
        }
        return matchedObjs;
    }

    public static List<WriteOffMatchGroup> groupByMatchRule(WriteOffTypeConfig typeConfig, WriteOffBillConfig billTypeConfig, SchemeContextConfig schemeContextConfig, SchemeConfig schemeConfig, MatchRuleConfig matchRuleConfig, List<WriteOffObject> writeOffObjects, PluginFactory pf) {
        List<WriteOffMatchGroup> groups = WriteOffGroupHelper.groupByMatchRule(billTypeConfig.getBillAlias(), matchRuleConfig, writeOffObjects, schemeContextConfig.isSingle(), pf);
        for (WriteOffMatchGroup matchGroup : groups) {
            matchGroup.setTypeConfig(typeConfig);
            matchGroup.setBillTypeConfig(billTypeConfig);
            matchGroup.setSchemeContextConfig(schemeContextConfig);
            matchGroup.setSchemeConfig(schemeConfig);
        }
        return groups;
    }

    public static List<WriteOffMatchGroup> groupByMatchRule(WriteOffTypeConfig typeConfig, WriteOffBillConfig billTypeConfig, SchemeConfig schemeConfig, MatchRuleConfig matchRuleConfig, List<WriteOffObject> writeOffObjects, PluginFactory pf) {
        List<WriteOffMatchGroup> groups = WriteOffGroupHelper.groupByMatchRule(billTypeConfig.getBillAlias(), matchRuleConfig, writeOffObjects, false, pf);
        for (WriteOffMatchGroup matchGroup : groups) {
            matchGroup.setTypeConfig(typeConfig);
            matchGroup.setBillTypeConfig(billTypeConfig);
            matchGroup.setSchemeConfig(schemeConfig);
        }
        return groups;
    }

    private static List<WriteOffMatchGroup> groupByMatchRule(String alias, MatchRuleConfig matchRuleConfig, List<WriteOffObject> writeOffObjects, boolean isSingle, PluginFactory pf) {
        ArrayList<WriteOffMatchGroup> writeOffMatchGroups = new ArrayList<WriteOffMatchGroup>(16);
        MatchRelationConfig matchConditionConfig = null;
        if (matchRuleConfig != null) {
            matchConditionConfig = matchRuleConfig.getFristByPromoter(alias);
        }
        if (matchConditionConfig == null || isSingle) {
            WriteOffMatchGroup writeOffMatchGroup = new WriteOffMatchGroup();
            writeOffMatchGroup.setMatchKeys(new ArrayList<Object>(0));
            writeOffMatchGroup.addWriteOffObjects(writeOffObjects);
            writeOffMatchGroups.add(writeOffMatchGroup);
        } else {
            HashMap<String, WriteOffMatchGroup> writeOffMatchGroupMap = new HashMap<String, WriteOffMatchGroup>(16);
            List<MatchConditionConfig> srcFieldList = matchConditionConfig.getMatchConditionConfigs();
            for (WriteOffObject writeOffObject : writeOffObjects) {
                WriteOffMatchGroup writeOffMatchGroup;
                ArrayList<Object> matchKeys;
                GroupKeyResponse groupKeyResponse = WriteOffGroupHelper.getGroupKey(writeOffObject, srcFieldList, matchKeys = new ArrayList<Object>(16), matchRuleConfig, pf);
                if (groupKeyResponse == null) continue;
                String groupKey = groupKeyResponse.getGroupKey();
                if (!writeOffMatchGroupMap.containsKey(groupKey)) {
                    writeOffMatchGroup = new WriteOffMatchGroup();
                    writeOffMatchGroup.setMatchKeys(matchKeys);
                    writeOffMatchGroup.setGroupKey(groupKey);
                    writeOffMatchGroup.addWriteOffObjects(new ArrayList<WriteOffObject>());
                    writeOffMatchGroupMap.put(groupKey, writeOffMatchGroup);
                }
                writeOffMatchGroup = (WriteOffMatchGroup)writeOffMatchGroupMap.get(groupKey);
                writeOffMatchGroup.getWriteOffObjects().add(writeOffObject);
            }
            writeOffMatchGroups = new ArrayList(writeOffMatchGroupMap.values());
        }
        return writeOffMatchGroups;
    }

    private static GroupKeyResponse getGroupKey(WriteOffObject writeOffObject, List<MatchConditionConfig> srcFieldList, List<Object> params, MatchRuleConfig matchRuleConfig, PluginFactory pf) {
        StringBuilder builder = new StringBuilder();
        GroupKeyResponse response = new GroupKeyResponse();
        BillEntityType dataEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)writeOffObject.getWriteOffBillEntityName());
        for (MatchConditionConfig fieldConfig : srcFieldList) {
            boolean isApField;
            Object fieldValue = WriteOffGroupHelper.getFieldValue(fieldConfig, writeOffObject.getWriteOffObjectBase());
            String field = fieldConfig.getSrcBillFieldKey();
            if (!fieldConfig.getEmptyEqual().booleanValue() && fieldConfig.checkEmptyValue(fieldValue)) {
                return null;
            }
            boolean bl = isApField = "ap_finapbill".equals(dataEntityType.getName()) && fieldValue != null && ("detailentry.e_sourcebillid".equals(field) || "detailentry.e_sourcebillentryid".equals(field));
            if (isApField) {
                if (StringUtils.isEmpty((CharSequence)((String)fieldValue))) {
                    params.add(0L);
                } else {
                    params.add(Long.parseLong((String)fieldValue));
                }
            } else {
                params.add(fieldValue);
            }
            if (fieldValue instanceof DynamicObject) {
                builder.append(((DynamicObject)fieldValue).getPkValue()).append("#@#");
                continue;
            }
            if (fieldValue instanceof Object[]) {
                List collect = Arrays.stream((Object[])fieldValue).map(n -> {
                    if (n instanceof DynamicObject) {
                        return ((DynamicObject)n).getPkValue();
                    }
                    return n;
                }).collect(Collectors.toList());
                builder.append(collect).append("#@#");
                continue;
            }
            builder.append(fieldValue).append("#@#");
        }
        List<MatchPluginResult> responses = pf.createMatchPluginProxy(writeOffObject.getTypeConfig(), matchRuleConfig).matchCondition(writeOffObject);
        if (CollectionUtils.isNotEmpty(responses)) {
            for (MatchPluginResult plugin : responses) {
                params.add(plugin.getMatchValue());
                builder.append(plugin.getMatchValue());
                response.addPluginConditionName(plugin.getMatchName());
            }
        }
        response.setGroupKey(builder.toString());
        return response;
    }

    private static Object getFieldValue(MatchConditionConfig field, WriteOffObjectBase writeOffObject) {
        Object value = writeOffObject.getValue(field.getSrcBillFieldKey());
        IDataEntityProperty srcPropType = field.getSrcPropType();
        if (srcPropType instanceof ItemClassProp) {
            return value;
        }
        if (MatcherUtil.isUseMasterid(srcPropType)) {
            String fieldKey = field.getSrcBillFieldKey() + ".masterid";
            value = writeOffObject.getValue(fieldKey);
        }
        return value;
    }

    public static Boolean isWhole(WriteOffBillConfig billConfig, WriteOffObject writeOffObject) {
        String wholeFieldKey = billConfig.getWholeFieldKey();
        if (StringUtils.isBlank((CharSequence)wholeFieldKey)) {
            return Boolean.FALSE;
        }
        return (Boolean)writeOffObject.getWriteOffObjectBase().getValue(wholeFieldKey);
    }
}

