/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;

public class WriteOffLogHelper {
    public static void saveLogs(Collection<WriteOffNLogInfo> logs) {
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(16);
        for (WriteOffNLogInfo writeOffNLogInfo : logs) {
            logObjs.add(writeOffNLogInfo.preSave());
        }
        try (TXHandle tx = TX.notSupported();){
            SaveServiceHelper.save((DynamicObject[])logObjs.toArray(new DynamicObject[logObjs.size()]));
        }
    }

    public static void saveLogsWithExeption(Collection<WriteOffNLogInfo> logs, Exception e) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(16);
        for (WriteOffNLogInfo writeOffNLogInfo : logs) {
            long logid = writeOffNLogInfo.getWfLogObj().getLong("id");
            ids.add(logid);
            String errorType = writeOffNLogInfo.getErrorType();
            writeOffNLogInfo.setErrorType(errorType == null ? "D" : errorType);
            writeOffNLogInfo.setErrorMessage(e);
            logObjs.add(writeOffNLogInfo.preSave());
        }
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"msmod_wf_nlog", (QFilter[])new QFilter("id", "in", ids).toArray());
            SaveServiceHelper.save((DynamicObject[])logObjs.toArray(new DynamicObject[logObjs.size()]));
        }
    }

    public static boolean isSuccessWriteBack(long taskId) {
        boolean exists = QueryServiceHelper.exists((String)"msmod_wf_nlog", (QFilter[])new QFilter("entryentity.id", "=", (Object)taskId).and("entryentity.taskstatus", "in", Arrays.asList("S", "W")).toArray());
        return exists;
    }

    public static void updateTaskLogSuccess(long logTaskId) {
        String sql = "update t_msmod_wfnlogentry set ftaskexectime = ? , ftaskstatus = 'S' where fentryid = ?";
        Object[] param = new Object[]{new Date(), logTaskId};
        try (TXHandle tx = TX.notSupported();){
            DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])param);
        }
    }

    public static void updateTaskLogFail(long logTaskId, String failReason) {
        String failStr = CommonUtils.cutStr(failReason, 250);
        String sql = "update t_msmod_wfnlogentry set ftaskexectime = ? , ftaskstatus = 'F' , ftaskexecinfo = ? where fentryid = ?";
        Object[] param = new Object[]{new Date(), failStr, logTaskId};
        try (TXHandle tx = TX.requiresNew();){
            DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])param);
        }
    }

    public static void updateTaskLogFail(long logTaskId, Exception e) {
        WriteOffLogHelper.updateTaskLogFail(logTaskId, e.getClass().getSimpleName() + ":" + e.getMessage());
    }

    public static void updateTaskLogWriteBack(long logTaskId, String dbRout) {
        String sql = "update t_msmod_wfnlogentry set ftaskexectime = ? , ftaskstatus = 'W' where fentryid = ?";
        Object[] param = new Object[]{new Date(), logTaskId};
        if ("scm".equals(dbRout)) {
            DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])param);
        } else {
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])param);
            }
        }
    }

    public static void updateTaskLogFailInfo(long logTaskId, Exception e) {
        String failStr = CommonUtils.cutStr(e.getClass().getSimpleName() + ":" + e.getMessage(), 250);
        String sql = "update t_msmod_wfnlogentry set ftaskexectime = ? , ftaskexecinfo = ? where fentryid = ?";
        Object[] param = new Object[]{new Date(), failStr, logTaskId};
        try (TXHandle tx = TX.requiresNew();){
            DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])param);
        }
    }

    @Deprecated
    public static String cutStr(String message, int size) {
        return CommonUtils.cutStr(message, size);
    }
}

