/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class WriteSeqHelper {
    public static String getSeq(String billType) {
        DynamicObject recordBill = BusinessDataServiceHelper.newDynamicObject((String)billType);
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        return CodeRuleServiceHelper.getNumber((String)billType, (DynamicObject)recordBill, (String)String.valueOf(orgId));
    }

    public static List<Integer> batchGetArApSeq(String wfRecord, String orgId, int size) {
        if ("cal_purwfrecord".equals(wfRecord)) {
            wfRecord = "ap_verifyrecord";
        }
        if ("cal_salwfrecord".equals(wfRecord)) {
            wfRecord = "ar_verifyrecord";
        }
        DynamicObject recordBill = BusinessDataServiceHelper.newDynamicObject((String)wfRecord);
        recordBill.set("org", (Object)orgId);
        Object[] settleSeqs = CodeRuleServiceHelper.getBatchNumber((String)wfRecord, (DynamicObject)recordBill, (String)orgId, (int)size);
        if (ObjectUtils.isEmpty((Object[])settleSeqs)) {
            throw new KDBizException(EngineLang.arapRecordNotExistCodeRule());
        }
        if (settleSeqs.length < size) {
            throw new KDBizException(EngineLang.arApNotGenerateEnoughSeq(wfRecord, size, settleSeqs.length, orgId));
        }
        ArrayList<Integer> seqs = new ArrayList<Integer>(size);
        for (Object settleSeq : settleSeqs) {
            seqs.add(Integer.valueOf((String)settleSeq));
        }
        return seqs;
    }

    public static Integer getArApSeq(String wfRecord, String orgId) {
        if ("cal_purwfrecord".equals(wfRecord)) {
            wfRecord = "ap_verifyrecord";
        }
        if ("cal_salwfrecord".equals(wfRecord)) {
            wfRecord = "ar_verifyrecord";
        }
        DynamicObject recordBill = BusinessDataServiceHelper.newDynamicObject((String)wfRecord);
        recordBill.set("org", (Object)orgId);
        String settleSeq = CodeRuleServiceHelper.getNumber((String)wfRecord, (DynamicObject)recordBill, (String)orgId);
        if (ObjectUtils.isEmpty((Object)settleSeq)) {
            throw new KDBizException(EngineLang.arapRecordNotExistCodeRule());
        }
        return Integer.valueOf(settleSeq);
    }

    public static String getCodeRule(DynamicObject bill) {
        String billEntity = bill.getDataEntityType().getName();
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)billEntity, (DynamicObject)bill, null);
        if (codeRuleInfo != null) {
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)bill);
        }
        return null;
    }

    public static boolean billCodeRuleIsExist(DynamicObject dynamicObject) {
        String name = dynamicObject.getDataEntityType().getName();
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.isExist(name, dynamicObject, "");
    }

    public static String getSeq() {
        long time = System.currentTimeMillis();
        SecureRandom sr = new SecureRandom();
        long round = Math.round((sr.nextDouble() + 1.0) * 1000.0);
        String timeRound = time + "" + round;
        return timeRound;
    }
}

