/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.lock;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class BizLockUtils {
    private static final Log logger = LogFactory.getLog(BizLockUtils.class);
    public static final String OPER_SETTLE = "wf";
    public static final String APP_NAME = "mpscmm";
    private static final int RETRY_COUNT_ALL = 10;
    public static final String SPIT_KEY = "&&";

    public static int doLock(Collection<String> needLockIds, String oper, String lockSign, String errorMessage) {
        IAppCache appCache = AppCache.get((String)("mpscmm-lock" + oper));
        boolean isGetLock = false;
        int retryCurrentCount = 0;
        for (int count = 10; count > 0; --count) {
            try {
                BizLockUtils.getLock(needLockIds, appCache, lockSign);
                int qty = 10 - count;
                logger.info("\u83b7\u53d6\u9501\u6210\u529f\uff0c\u91cd\u8bd5" + qty + "\u6b21");
                retryCurrentCount = qty;
                isGetLock = true;
                break;
            }
            catch (Exception e) {
                BizLockUtils.releaseLock(needLockIds, oper, lockSign);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e2) {
                    logger.error("\u7761\u7720\u5931\u8d25,", (Throwable)e2);
                }
                continue;
            }
        }
        if (!isGetLock) {
            BizLockUtils.releaseLock(needLockIds, oper, lockSign);
            throw new KDBizException(errorMessage);
        }
        return retryCurrentCount;
    }

    private static void getLock(Collection<String> needLockIds, IAppCache appCache, String lockSign) {
        long curTime = System.currentTimeMillis();
        for (String needLockId : needLockIds) {
            String lock = (String)appCache.get(needLockId, String.class);
            if (StringUtils.isEmpty((CharSequence)lock)) {
                appCache.put(needLockId, (Object)(lockSign + SPIT_KEY + curTime));
                continue;
            }
            String[] split = lock.split(SPIT_KEY);
            if (split.length > 1) {
                String time = split[1];
                Long startTime = Long.valueOf(time);
                long inTerTime = curTime - startTime;
                if (inTerTime > 600000L) {
                    appCache.remove(needLockId);
                    appCache.put(needLockId, (Object)(lockSign + SPIT_KEY + curTime));
                    continue;
                }
                throw new KDBizException(EngineLang.billLockFailed(needLockId));
            }
            throw new KDBizException(EngineLang.billLockFailed(needLockId));
        }
    }

    public static void releaseLock(Collection<String> releaseLockIds, String oper, String lockSign) {
        IAppCache appCache = AppCache.get((String)("mpscmm-lock" + oper));
        for (String releaseLock : releaseLockIds) {
            String lock = (String)appCache.get(releaseLock, String.class);
            if (lock != null) {
                String[] split = lock.split(SPIT_KEY);
                lock = split[0];
            }
            if (!lockSign.equals(lock)) continue;
            appCache.remove(releaseLock);
        }
    }

    public static Set<String> getLockWfBill(List<WriteOffObject> filterObjects, boolean isReEntry) {
        HashSet<String> setKey = new HashSet<String>(16);
        for (WriteOffObject wf : filterObjects) {
            String name = wf.getWriteOffBillEntityName();
            Object pkValue = wf.getWriteOffBillPk();
            String pk = isReEntry ? name + SPIT_KEY + pkValue + SPIT_KEY + "isReEntry" : name + SPIT_KEY + pkValue + SPIT_KEY + "isNotReEntry";
            setKey.add(pk);
        }
        return setKey;
    }
}

