/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class DbBizLockUtils {
    private static final Log logger = LogFactory.getLog(DbBizLockUtils.class);
    private static final int RETRY_COUNT_ALL = 10;
    public static final String SPIT_KEY = "&&";

    public static int doLock(Collection<String> needLockIds) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(12);
        for (String lockKey : needLockIds) {
            long time = System.currentTimeMillis();
            Long seq = Long.valueOf(WriteSeqHelper.getSeq());
            Object[] param = new Object[]{seq, lockKey, time};
            params.add(param);
        }
        String errorMessage = "";
        int retryCurrentCount = 0;
        boolean isGetLock = false;
        for (int count = 10; count > 0; --count) {
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)DbBizLockUtils.class.getName());){
                int qty = 10 - count;
                DbBizLockUtils.insertLockData(params, qty);
                retryCurrentCount = qty;
                isGetLock = true;
                break;
            }
            catch (Throwable throwable2) {
                tx.markRollback();
                errorMessage = throwable2.getMessage();
                logger.info("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u539f\u56e0\u4e3a:" + errorMessage);
            }
            DbBizLockUtils.deleteLockData();
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("\u7761\u7720\u5931\u8d25,", (Throwable)e);
            }
        }
        if (!isGetLock) {
            logger.error("\u52a0\u9501\u5931\u8d25");
            errorMessage = DbBizLockUtils.getErrorMssage(errorMessage);
            throw new KDBizException(errorMessage);
        }
        logger.info("\u63d2\u5165\u6570\u636e\u6210\u529f");
        return retryCurrentCount;
    }

    private static void deleteLockData() {
        long currentTime = System.currentTimeMillis();
        long time = currentTime - 600000L;
        Object[] objects = new Object[]{time};
        String deleteSql = "delete  from t_msmod_lock where fid in (select fid from t_msmod_lock where flocktime < ?)";
        boolean scm = DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)deleteSql, (Object[])objects);
    }

    private static void insertLockData(List<Object[]> params, int qty) {
        long start = System.currentTimeMillis();
        logger.info("\u83b7\u53d6\u9501\uff0c\u91cd\u8bd5" + qty + "\u6b21");
        String sql = "insert into t_msmod_lock (fid,flockkey,flocktime) VALUES (?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, params);
        logger.info("\u83b7\u53d6\u9501\u6210\u529f\uff0c\u91cd\u8bd5" + qty + "\u6b21");
        long end = System.currentTimeMillis();
        logger.info("\u5904\u7406\u65f6\u95f4" + (end - start) + "ms");
    }

    private static String getErrorMssage(String errorMessage) {
        if (errorMessage.contains("(flockkey)=")) {
            int i = errorMessage.indexOf("(flockkey)=(");
            int j = errorMessage.indexOf(") already exists");
            String substring = errorMessage.substring(i + 12, j);
            logger.info("\u622a\u53d6\u5b57\u7b26\u4e32\u4e3a: " + substring);
            String[] split = substring.split(SPIT_KEY);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)split[0]);
            String billNoField = ((BillEntityType)dataEntityType).getBillNo();
            QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(split[1]));
            DynamicObject object = QueryServiceHelper.queryOne((String)split[0], (String)billNoField, (QFilter[])qFilter.toArray());
            String billNo = "";
            if (object != null) {
                billNo = object.getString(billNoField);
            }
            errorMessage = EngineLang.specbillGetLockFail(billNo);
        } else {
            errorMessage = EngineLang.billGetLockFail();
        }
        return errorMessage;
    }

    public static void releaseLock(Collection<String> releaseLockIds) {
        String sql = "delete  from t_msmod_lock where flockkey in (" + DbBizLockUtils.collectionToStr(releaseLockIds) + ")";
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql);
        logger.info("\u91ca\u653e\u9501\u6210\u529f");
    }

    private static String collectionToStr(Collection<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (String object : list) {
            str.append('\'');
            str.append(object);
            str.append('\'');
            str.append(',');
        }
        String string = str.toString();
        return string.substring(0, string.length() - 1);
    }
}

