/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.log;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UnWriteOffLog {
    private final DynamicObject logObj;
    private String billEntity;
    private Set<String> billNos = new HashSet<String>(16);
    private Set<String> billIds = new HashSet<String>(16);

    public UnWriteOffLog() {
        this.logObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_unwflog");
        this.logObj.set("id", (Object)DB.genGlobalLongId());
        RequestContext requestContext = RequestContext.get();
        if (requestContext != null) {
            this.logObj.set("traceid", (Object)requestContext.getTraceId());
            this.logObj.set("creater", (Object)requestContext.getCurrUserId());
        }
        this.logObj.set("createdate", (Object)TimeServiceHelper.now());
    }

    public void fillHeadLog(String wfSeq, String opKey, String unWfMode) {
        DynamicObject newLogObj = this.getLogObj();
        newLogObj.set("status", (Object)"S");
        newLogObj.set("wfseq", (Object)wfSeq);
        newLogObj.set("operate", (Object)opKey);
        newLogObj.set("unwfmode", (Object)unWfMode);
    }

    public void addSrcBillInfo(DynamicObject[] entities, String billNoField) {
        this.billEntity = entities[0].getDataEntityType().getName();
        List billIds = Stream.of(entities).map(item -> item.getString("id")).collect(Collectors.toList());
        this.billIds.addAll(billIds);
        this.logObj.set("srcentitykey", (Object)this.billEntity);
        String idsStr = StringUtils.join(this.billIds, (String)",");
        this.logObj.set("srcfid", (Object)StringUtils.substring((String)idsStr, (int)0, (int)50));
        this.logObj.set("srcfid_tag", (Object)idsStr);
        if (StringUtils.isNotBlank((CharSequence)billNoField)) {
            List billNos = Stream.of(entities).map(item -> item.getString(billNoField)).collect(Collectors.toList());
            this.billNos.addAll(billNos);
            String billNoStr = StringUtils.join(this.billNos, (String)",");
            this.logObj.set("srcbillno", (Object)StringUtils.substring((String)billNoStr, (int)0, (int)50));
            this.logObj.set("srcbillno_tag", (Object)billNoStr);
        }
    }

    public void createMatchInfo(String recordType, String matchCondition, boolean matchStatus) {
        DynamicObjectCollection matchEntry = this.logObj.getDynamicObjectCollection("matchentry");
        DynamicObject newMatchRow = matchEntry.addNew();
        newMatchRow.set("seq", (Object)matchEntry.size());
        newMatchRow.set("wfrecodetype", (Object)recordType);
        newMatchRow.set("matchcondition_tag", (Object)matchCondition);
        newMatchRow.set("matchstatus", (Object)matchStatus);
        if (!matchStatus) {
            this.logObj.set("status", (Object)"N");
        }
    }

    public void setErrorMessage(Exception e) {
        this.getLogObj().set("status", (Object)"F");
        this.getLogObj().set("executeinfo", (Object)CommonUtils.cutStr(e.getMessage(), 200));
    }

    public Long addTaskEntry(String taskName, String branchcode, String taskClass, String businessid, Object reqInfo) {
        DynamicObjectCollection matchentry = this.logObj.getDynamicObjectCollection("matchentry");
        if (ObjectUtils.isEmpty((Object)matchentry)) {
            return null;
        }
        DynamicObject matchRow = (DynamicObject)matchentry.get(matchentry.size() - 1);
        DynamicObjectCollection taskEntry = matchRow.getDynamicObjectCollection("taskentry");
        DynamicObject newTaskRow = taskEntry.addNew();
        newTaskRow.set("seq", (Object)taskEntry.size());
        long entryId = DB.genGlobalLongId();
        newTaskRow.set("id", (Object)entryId);
        newTaskRow.set("taskClass", (Object)taskClass);
        newTaskRow.set("branchcode", (Object)branchcode);
        newTaskRow.set("businessid", (Object)businessid);
        newTaskRow.set("taskname", (Object)taskName);
        newTaskRow.set("taskexectime", (Object)TimeServiceHelper.now());
        newTaskRow.set("taskstatus", (Object)"A");
        boolean isLogKdtxParam = WriteOffParamManager.create().isLogKdtxParam();
        if (reqInfo != null && isLogKdtxParam) {
            String reqJson = SerializationUtils.toJsonString((Object)reqInfo);
            newTaskRow.set("reqinfo_tag", (Object)reqJson);
        }
        return entryId;
    }

    public DynamicObject getLogObj() {
        return this.logObj;
    }
}

