/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.util;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfKdtxParamHolder;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.EntryBackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.common.consts.PropertyDataType;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;
import org.apache.commons.lang3.StringUtils;

public class CommonUtils {
    private static final String BILL_STATUS = "billstatus";
    private static final String SPIT = "\\.";
    private static final String SPIT_FIELD = ".";

    public static boolean collectionIsEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static List<String> getAmoutAndQtyFieldList(DynamicObject billOb, String entry) {
        ArrayList<String> listFields = new ArrayList<String>(12);
        Map allFields = ((BillEntityType)billOb.getDataEntityType()).getAllFields();
        for (IDataEntityProperty pro : allFields.values()) {
            String field;
            String proDataType = CommonUtils.getProDataType(pro);
            if (!PropertyDataType.AMOUNT.getDataType().equals(proDataType) && !PropertyDataType.QTY.getDataType().equals(proDataType) || (field = CommonUtils.getField(pro, entry)) == null) continue;
            listFields.add(field);
        }
        return listFields;
    }

    private static String getField(IDataEntityProperty po, String entry) {
        IDataEntityType parent;
        String entryName;
        String name = po.getName();
        if ((entry = entry + SPIT_FIELD).equals(entryName = CommonUtils.getEntryName(parent = po.getParent(), ""))) {
            return name;
        }
        return null;
    }

    @SafeVarargs
    public static <T> List<T> getPlugins(T ... obs) {
        ArrayList<T> list = new ArrayList<T>(16);
        for (T ob : obs) {
            list.add(ob);
        }
        return list;
    }

    public static boolean isJump(Set<Long> writeOffTypeIds, Long id) {
        return !CommonUtils.isContain(writeOffTypeIds, id);
    }

    public static boolean isContain(Set<Long> writeOffTypeIds, Long id) {
        return writeOffTypeIds != null && writeOffTypeIds.contains(id);
    }

    public static boolean isContain(Set<Long> writeOffTypeIds, Set<Long> ids) {
        if (writeOffTypeIds == null || ids == null) {
            return false;
        }
        for (Long id : ids) {
            if (!writeOffTypeIds.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static String getEntryName(IDataEntityType entry, String entryName) {
        IDataEntityType parent;
        String name = entry.getName();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            entryName = name + SPIT_FIELD + entryName;
        }
        if ((parent = entry.getParent()) != null) {
            CommonUtils.getEntryName(parent, entryName);
        }
        return entryName;
    }

    public static String getProDataType(IDataEntityProperty property) {
        if (property instanceof BooleanProp) {
            return "boolean";
        }
        if (property instanceof LargeTextProp) {
            return ((LargeTextProp)property).getClientType();
        }
        if (property instanceof TextProp) {
            return "simpleText";
        }
        if (property instanceof PriceProp) {
            return "price";
        }
        if (property instanceof AmountProp) {
            return "amount";
        }
        if (property instanceof BigIntProp) {
            return "long";
        }
        if (property instanceof IntegerProp) {
            return "int";
        }
        if (property instanceof QtyProp) {
            return "qty";
        }
        if (property instanceof DecimalProp) {
            return "othernumber";
        }
        if (property instanceof DateProp) {
            return ((DateProp)property).getFilterControlType();
        }
        if (property instanceof MaterielProp) {
            return "material";
        }
        if (property instanceof OrgProp) {
            return ((OrgProp)property).getFilterControlType();
        }
        if (property instanceof UserProp) {
            return ((UserProp)property).getFilterControlType();
        }
        if (property instanceof ItemClassProp) {
            return "multibasedata";
        }
        if (property instanceof ComboProp) {
            return ((ComboProp)property).getFilterControlType();
        }
        if (property instanceof FlexProp) {
            return "flex";
        }
        if (property instanceof BasedataProp) {
            return "otherbasedata";
        }
        return "unknown";
    }

    public static String getBillNo(DynamicObject dataEntity) {
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        String billNoKey = ((BillEntityType)dataEntityType).getBillNo();
        String billNo = dataEntity.getString(billNoKey);
        return billNo;
    }

    public static String getBillNo(DynamicObject[] dataEntitys) {
        StringBuilder build = new StringBuilder();
        for (DynamicObject dataEntity : dataEntitys) {
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            String billNoKey = ((BillEntityType)dataEntityType).getBillNo();
            String billNo = dataEntity.getString(billNoKey);
            build.append(billNo);
            build.append(",");
        }
        String result = build.toString();
        result = result.substring(0, result.length() - 1);
        return build.toString();
    }

    public static String getDateString(Date date) {
        String result = "";
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            result = dateFormat.format(date);
        }
        return result;
    }

    public static String getDateString2(Date date) {
        String result = "";
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            result = dateFormat.format(date);
        }
        return result;
    }

    public static boolean isExistField(String billType, String field) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        IDataEntityProperty property = dataEntityType.findProperty(field);
        return property != null;
    }

    public static boolean isExistField(DynamicObject bill, String field) {
        DynamicProperty property = bill.getDynamicObjectType().getProperty(field);
        return property != null;
    }

    public static Set<Long> getIdSet(Long ... ids) {
        HashSet<Long> wfTypeIds = new HashSet<Long>(8);
        for (Long id : ids) {
            wfTypeIds.add(id);
        }
        return wfTypeIds;
    }

    public static String getWfBillKey(String billEntity, Object pk) {
        return billEntity + "&&" + pk;
    }

    public static String getWriteOffKey(String billEntity, Object pk, Object entryPk) {
        return billEntity + "&&" + pk + "&&" + entryPk;
    }

    @Deprecated
    public static RowDataModel getBillRowDataModel(WriteOffObjectBase wfObject) {
        DynamicObject writeOffBillResult = wfObject.getWriteOffObject();
        String entry = writeOffBillResult.getDynamicObjectType().getName();
        BillEntityType entryMainType = (BillEntityType)wfObject.getWFBillEntityType();
        RowDataModel rowDataModel = new RowDataModel(entry, (MainEntityType)entryMainType);
        rowDataModel.setRowContext(writeOffBillResult);
        return rowDataModel;
    }

    public static RowDataModel getBillEntry(DynamicObject entryDynamicObject) {
        String entryName = entryDynamicObject.getDataEntityType().getName();
        DynamicObject parent = (DynamicObject)entryDynamicObject.getParent();
        BillEntityType type = parent != null ? (BillEntityType)parent.getDataEntityType() : (BillEntityType)entryDynamicObject.getDataEntityType();
        RowDataModel rowDataModel = new RowDataModel(entryName, (MainEntityType)type);
        rowDataModel.setRowContext(entryDynamicObject);
        return rowDataModel;
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    public static DynamicObject getEntryDynamicObject(DynamicObject dynamicObject, String entryName, Object pkEntry) {
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u9500\u5bf9\u8c61\u62a5\u9519\u3002", (String)"CommonUtils_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        String name = dynamicObject.getDataEntityType().getName();
        if (name.equals(entryName)) {
            return dynamicObject;
        }
        DynamicObjectCollection entryList = dynamicObject.getDynamicObjectCollection(entryName);
        DynamicObject entry = entryList.stream().filter(n -> pkEntry.equals(String.valueOf(n.getPkValue()))).findFirst().orElse(null);
        if (entry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u9500\u5bf9\u8c61\u62a5\u9519\u3002", (String)"CommonUtils_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return entry;
    }

    public static void bkWtEntryOtherBill(String wfInfo, BackWfKdtxParamHolder holder) {
        EntryBackWriteOffDetail writeOffDetail = (EntryBackWriteOffDetail)JSONObject.parseObject((String)wfInfo, EntryBackWriteOffDetail.class);
        if (writeOffDetail == null) {
            return;
        }
        CommonUtils.buildBackWriteBill(writeOffDetail, holder);
    }

    public static void bkWtHeadOtherBill(String wfInfo, BackWfKdtxParamHolder holder) {
        BackWriteOffDetail writeOffDetail = (BackWriteOffDetail)JSONObject.parseObject((String)wfInfo, BackWriteOffDetail.class);
        if (writeOffDetail == null) {
            return;
        }
        EntryBackWriteOffDetail detail = writeOffDetail.getDetail();
        CommonUtils.buildBackWriteBill(detail, holder);
    }

    private static void buildBackWriteBill(EntryBackWriteOffDetail detail, BackWfKdtxParamHolder holder) {
        List<EntryBackWriteOffDetail.BackWriteDetail> backWriteDetailList = detail.getBackWriteDetailList();
        for (EntryBackWriteOffDetail.BackWriteDetail backWriteDetail : backWriteDetailList) {
            if (!"1".equals(backWriteDetail.getFlag())) continue;
            String rollbackSql = backWriteDetail.getRollbackSql();
            Object[] sqlParam = backWriteDetail.getSqlParam();
            String routeKey = backWriteDetail.getDbRouteKey();
            holder.addSql(routeKey, rollbackSql, sqlParam);
        }
    }

    @Deprecated
    public static QFilter removeBillStatusFilter(FilterBuilder filterBuilder, QFilter qFilter, Boolean isFilter) {
        if (filterBuilder == null) {
            return qFilter;
        }
        if (!isFilter.booleanValue()) {
            QFilter qFilterOne = filterBuilder.getQFilter();
            qFilter.and(qFilterOne);
            return qFilter;
        }
        List qFilterTwo = filterBuilder.getQFilters();
        for (QFilter next : qFilterTwo) {
            String property = next.getProperty();
            if (BILL_STATUS.equals(property)) continue;
            qFilter.and(next);
        }
        return qFilter;
    }

    public static void buildSqlMap(Map<String, Map<String, List<Object[]>>> map, Map<String, Map<String, List<Object[]>>> sqlMap) {
        for (Map.Entry<String, Map<String, List<Object[]>>> sql : sqlMap.entrySet()) {
            String key = sql.getKey();
            Map<String, List<Object[]>> value = sql.getValue();
            if (value == null) continue;
            map.putIfAbsent(key, new HashMap(16));
            Map<String, List<Object[]>> resultMap = map.get(key);
            for (Map.Entry<String, List<Object[]>> entry : value.entrySet()) {
                resultMap.putIfAbsent(entry.getKey(), new ArrayList(16));
                resultMap.get(entry.getKey()).addAll((Collection<Object[]>)entry.getValue());
            }
            map.put(key, resultMap);
        }
    }

    public static Set<String> buildBusinessKeys(DynamicObject recordBill, WriteOffTypeConfig typeConfig) {
        HashSet<String> businessInfos;
        block4: {
            block5: {
                block3: {
                    businessInfos = new HashSet<String>(16);
                    String recordType = recordBill.getDataEntityType().getName();
                    businessInfos.add(recordType + "#" + recordBill.getPkValue());
                    if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST != typeConfig.getWfRecordTemplateEnum()) break block3;
                    CommonUtils.addBusinessKey(recordBill, "billtype", "billid", businessInfos);
                    DynamicObjectCollection entryList = recordBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entryList) {
                        CommonUtils.addBusinessKey(entry, "e_billtype", "e_billid", businessInfos);
                    }
                    break block4;
                }
                if (WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT != typeConfig.getWfRecordTemplateEnum()) break block5;
                DynamicObjectCollection entryList = recordBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entryList) {
                    CommonUtils.addBusinessKey(entry, "billtype", "billid", businessInfos);
                    CommonUtils.addBusinessKey(entry, "assbilltype", "assbillid", businessInfos);
                }
                break block4;
            }
            if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN != typeConfig.getWfRecordTemplateEnum()) break block4;
            DynamicObjectCollection entryList = recordBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryList) {
                CommonUtils.addBusinessKey(entry, "billtype", "billid", businessInfos);
            }
        }
        return businessInfos;
    }

    private static void addBusinessKey(DynamicObject recordBill, String billTypeKey, String billIdKey, Set<String> businessInfos) {
        DynamicObject billType = recordBill.getDynamicObject(billTypeKey);
        if (billType != null) {
            String number = billType.getString("number");
            Long billId = recordBill.getLong(billIdKey);
            String key = number + "#" + billId;
            businessInfos.add(key);
        }
    }

    public static Set<String> wfTypeQfiterFieldPathDeal(String billType, Collection<String> fieldList) {
        HashSet<String> allFieldPathList = new HashSet<String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        for (String field : fieldList) {
            String[] split = field.split(SPIT);
            if (split.length <= 0) continue;
            String spitField = split[0];
            IDataEntityProperty property = dataEntityType.findProperty(spitField);
            if (property != null) {
                String parentPath = CommonUtils.getFieldParentPath(billType, property);
                allFieldPathList.add(parentPath + field);
                continue;
            }
            allFieldPathList.add(field);
        }
        return allFieldPathList;
    }

    private static String getFieldParentPath(String billType, IDataEntityProperty property) {
        StringBuilder builder = new StringBuilder();
        IDataEntityType parent = property.getParent();
        return CommonUtils.getFieldPath(parent, builder, billType).toString();
    }

    private static StringBuilder getFieldPath(IDataEntityType property, StringBuilder fieldPath, String billType) {
        if (property != null && !billType.equals(property.getName())) {
            fieldPath.insert(0, SPIT_FIELD);
            fieldPath.insert(0, property.getName());
            IDataEntityType parent = property.getParent();
            CommonUtils.getFieldPath(parent, fieldPath, billType);
        }
        return fieldPath;
    }

    public static boolean judgeWfBillIsSame(DynamicObject oldValue, DynamicObject newValue) {
        List<String> newWfBills = CommonUtils.getWfTypeBillList(newValue);
        List<String> oldWfBills = CommonUtils.getWfTypeBillList(oldValue);
        if (newWfBills.size() == oldWfBills.size()) {
            newWfBills.retainAll(oldWfBills);
            if (newWfBills.size() == oldWfBills.size()) {
                return true;
            }
        }
        return false;
    }

    private static List<String> getWfTypeBillList(DynamicObject newValue) {
        ArrayList<String> wfBills = new ArrayList<String>(16);
        DynamicObjectCollection wfBillEntry = newValue.getDynamicObjectCollection("writeoffbillentry");
        for (DynamicObject entry : wfBillEntry) {
            String wfbill = entry.getDynamicObject("writeoffbilltype").getString("number");
            wfBills.add(wfbill);
        }
        return wfBills;
    }

    public static String cutStr(String message, int size) {
        if (message != null && message.length() >= size) {
            message = message.substring(0, size - 4) + "...";
        }
        return message;
    }

    public static String strConnect(String ... strs) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : strs) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    public static String getLastKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return key;
        }
        String[] splitKey = key.split(SPIT);
        if (splitKey.length > 1) {
            return splitKey[splitKey.length - 1];
        }
        return key;
    }
}

