/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import org.apache.commons.collections.CollectionUtils;

public class DynamicObjectUtil {
    public static final String ID = "id";
    public static final String COMMA_STRING = ",";
    public static final String SPLIT_ESC = "\\.";
    public static final char SPLIT = '.';
    public static final String ENTITY_MATERIAL_BD = "bd_material";
    public static final String BD_SUPPLIER = "bd_supplier";
    public static final String BD_CUSTOMER = "bd_customer";
    public static final String ENTITY_MATERIAL_PUR = "bd_materialpurchaseinfo";
    public static final String ENTITY_MATERIAL_INV = "bd_materialinventoryinfo";
    public static final String ENTITY_MATERIAL_SAL = "bd_materialsalinfo";

    public static String getLastKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return key;
        }
        String[] splitKey = key.split(SPLIT_ESC);
        if (splitKey.length > 1) {
            return splitKey[splitKey.length - 1];
        }
        return key;
    }

    public static String getEntryKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return key;
        }
        String[] splitKey = key.split(SPLIT_ESC);
        if (splitKey.length > 1) {
            return splitKey[splitKey.length - 2];
        }
        return "";
    }

    public static Object getValue(DynamicObject obj, String key) {
        String[] strs = key.split(SPLIT_ESC);
        if (strs.length == 1) {
            return obj.get(key);
        }
        if (strs.length == 2) {
            DynamicObjectCollection entryentity = obj.getDynamicObjectCollection(strs[0]);
            if (entryentity.size() > 0) {
                return ((DynamicObject)entryentity.get(0)).get(strs[1]);
            }
            return null;
        }
        return null;
    }

    public static void setValue(DynamicObject obj, String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        obj.set(key, value);
    }

    public static DynamicObject setBillId(DynamicObject bill, String entrykey) {
        long billId = bill.getLong(ID);
        if (billId == 0L) {
            DynamicObjectType billtype = bill.getDynamicObjectType();
            long id = DB.genLongId((String)billtype.getAlias());
            bill.set(ID, (Object)id);
        }
        DynamicObjectUtil.setEntryId(bill, entrykey);
        return bill;
    }

    public static DynamicObject copyBillId(DynamicObject fromBill, DynamicObject tagBill) {
        long billId = tagBill.getLong(ID);
        String billtypeName = fromBill.getDynamicObjectType().getName();
        if (billId == 0L) {
            tagBill.set(ID, (Object)fromBill.getLong(ID));
        }
        Map entryKeys = ((MainEntityType)tagBill.getDataEntityType()).getAllEntities();
        for (Map.Entry entity : entryKeys.entrySet()) {
            String entryKey = (String)entity.getKey();
            EntityType value = (EntityType)entity.getValue();
            if (value instanceof LinkEntryType || billtypeName.equals(entryKey)) continue;
            DynamicObjectCollection billentries = tagBill.getDynamicObjectCollection(entryKey);
            DynamicObjectCollection formBillentries = fromBill.getDynamicObjectCollection(entryKey);
            List genLongIds = formBillentries.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            for (int i = 0; i < billentries.size(); ++i) {
                DynamicObject entry = (DynamicObject)billentries.get(i);
                long entryId = entry.getLong(ID);
                if (entryId != 0L) continue;
                entry.set(ID, genLongIds.get(i));
            }
        }
        return tagBill;
    }

    public static void setBillIdAndNumber(List<DynamicObject> bills) {
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (DynamicObject bill : bills) {
            if (bill == null) continue;
            DynamicObjectUtil.setBillId(bill);
            if (!StringUtils.isBlank((CharSequence)bill.getString("billno"))) continue;
            DynamicObjectUtil.setBillNo(bill);
        }
    }

    public static void setBillIds(List<DynamicObject> bills) {
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (DynamicObject bill : bills) {
            DynamicObjectUtil.setBillId(bill);
        }
    }

    public static void setCodeRule(List<DynamicObject> bills) {
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (DynamicObject bill : bills) {
            if (bill == null || StringUtils.isNotBlank((CharSequence)bill.getString("billno"))) continue;
            DynamicObjectUtil.setBillNo(bill);
        }
    }

    public static String setBillNo(DynamicObject bill) {
        String codeRule = WriteSeqHelper.getCodeRule(bill);
        if (StringUtils.isEmpty((CharSequence)codeRule)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u5355\u636e\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u7f16\u7801\u89c4\u5219\u3002", (String)"WriteOffBillGenerator_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), bill.getDataEntityType().getName()));
        }
        bill.set("billno", (Object)codeRule);
        return codeRule;
    }

    public static DynamicObject setBillId(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        String billtypeName = DynamicObjectUtil.setHeadId(bill);
        Map entryKeys = ((MainEntityType)bill.getDataEntityType()).getAllEntities();
        for (Map.Entry entity : entryKeys.entrySet()) {
            String entryKey = (String)entity.getKey();
            EntityType value = (EntityType)entity.getValue();
            if (value instanceof LinkEntryType || value instanceof SubEntryType || billtypeName.equals(entryKey)) continue;
            DynamicObjectUtil.setEntryId(bill, entryKey);
        }
        return bill;
    }

    public static String setHeadId(DynamicObject bill) {
        String billtypeName = bill.getDynamicObjectType().getName();
        long billId = bill.getLong(ID);
        if (billId == 0L) {
            DynamicObjectType billtype = bill.getDynamicObjectType();
            long id = DB.genLongId((String)billtype.getAlias());
            bill.set(ID, (Object)id);
        }
        return billtypeName;
    }

    private static void setEntryId(DynamicObject bill, String entryKey) {
        DynamicObjectCollection billentries = bill.getDynamicObjectCollection(entryKey);
        DynamicObjectType entryType = billentries.getDynamicObjectType();
        long[] genLongIds = DB.genLongIds((String)entryType.getAlias(), (int)billentries.size());
        for (int i = 0; i < billentries.size(); ++i) {
            DynamicObject entry = (DynamicObject)billentries.get(i);
            long entryId = entry.getLong(ID);
            if (entryId != 0L) continue;
            entry.set(ID, (Object)genLongIds[i]);
        }
    }

    public static DynamicObject setBilEntrylId(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        long billId = bill.getLong(ID);
        if (billId == 0L) {
            DynamicObjectType billtype = bill.getDynamicObjectType();
            long id = DB.genLongId((String)billtype.getAlias());
            bill.set(ID, (Object)id);
        }
        return bill;
    }

    public static Long getPkValue(DynamicObject obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getLong(ID);
    }

    public static Object getObjectName(Object value) {
        String materialEntity;
        if (value instanceof Object[]) {
            List collect = Arrays.stream((Object[])value).map(n -> {
                if (n instanceof DynamicObject) {
                    return DynamicObjectUtil.getMatchName((DynamicObject)n);
                }
                if (n instanceof Boolean) {
                    return DynamicObjectUtil.getBooleanStr((Boolean)n);
                }
                return n;
            }).collect(Collectors.toList());
            return collect;
        }
        if (value instanceof Boolean) {
            return DynamicObjectUtil.getBooleanStr((Boolean)value);
        }
        if (!(value instanceof DynamicObject)) {
            return value;
        }
        DynamicObject valObj = (DynamicObject)value;
        switch (materialEntity = valObj.getDataEntityType().getName()) {
            case "bd_materialinventoryinfo": 
            case "bd_materialpurchaseinfo": 
            case "bd_materialsalinfo": {
                return DynamicObjectUtil.getMatchName(valObj.getDynamicObject("masterid"));
            }
        }
        return DynamicObjectUtil.getMatchName(valObj);
    }

    private static Object getMatchName(DynamicObject value) {
        IDataEntityProperty property = (IDataEntityProperty)value.getDataEntityType().getProperties().get((Object)"name");
        IDataEntityProperty number = (IDataEntityProperty)value.getDataEntityType().getProperties().get((Object)"number");
        if (property != null) {
            Object name = value.get("name");
            if (number != null) {
                Object numberValue = value.get("number");
                name = name + "(" + numberValue + ")";
            }
            return name;
        }
        return value.getPkValue();
    }

    private static String getBooleanStr(boolean v) {
        String retValue = v ? ResManager.loadKDString((String)"\u662f", (String)"DynamicObjectUtil_TRUE", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"DynamicObjectUtil_FALSE", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        return retValue;
    }

    public static Object getObjectPk(Object value) {
        String materialEntity;
        if (value instanceof Object[]) {
            List collect = Arrays.stream((Object[])value).map(n -> {
                if (n instanceof DynamicObject) {
                    return ((DynamicObject)n).getPkValue();
                }
                return n;
            }).collect(Collectors.toList());
            return collect;
        }
        if (!(value instanceof DynamicObject)) {
            return value;
        }
        DynamicObject valObj = (DynamicObject)value;
        switch (materialEntity = valObj.getDataEntityType().getName()) {
            case "bd_materialinventoryinfo": 
            case "bd_materialpurchaseinfo": 
            case "bd_materialsalinfo": {
                return valObj.getDynamicObject("masterid").getPkValue();
            }
            case "bd_material": {
                return valObj.getPkValue();
            }
            case "bd_supplier": 
            case "bd_customer": {
                return valObj.get("masterid");
            }
        }
        return valObj.getPkValue();
    }

    public static DynamicObject getMaterialMasterObject(DynamicObject valObj) {
        String materialEntity;
        if (valObj == null) {
            return null;
        }
        switch (materialEntity = valObj.getDataEntityType().getName()) {
            case "bd_materialinventoryinfo": 
            case "bd_materialpurchaseinfo": 
            case "bd_materialsalinfo": {
                return valObj.getDynamicObject("masterid");
            }
            case "bd_material": {
                return valObj;
            }
        }
        return null;
    }

    public static Object getMaterialMasterOb(DynamicObject valObj) {
        String materialEntity;
        if (valObj == null) {
            return null;
        }
        switch (materialEntity = valObj.getDataEntityType().getName()) {
            case "bd_materialinventoryinfo": 
            case "bd_materialpurchaseinfo": 
            case "bd_materialsalinfo": {
                return valObj.get("masterid");
            }
            case "bd_material": {
                return valObj;
            }
        }
        return valObj;
    }

    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            toObj.set(keys[i], fromObj.get(keys[i]));
        }
    }

    public static void copyProperties(DynamicObject fromObj, DynamicObject toObj, Map propMap) {
        Iterator iteator = propMap.keySet().iterator();
        while (iteator.hasNext()) {
            String fromProp = iteator.next().toString();
            String toProp = propMap.get(fromProp).toString();
            toObj.set(toProp, fromObj.get(fromProp));
        }
    }

    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, Set<String> ignoreKeys, Map<String, String> convertKeysMap, boolean needCopyId) {
        DataEntityPropertyCollection toPs = toObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection fromPs = fromObj.getDataEntityType().getProperties();
        HashSet<String> fromPsSet = new HashSet<String>(fromPs.size());
        for (IDataEntityProperty dp : fromPs) {
            fromPsSet.add(dp.getName());
        }
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (!needCopyId) {
            ignoreKeys.add(ID);
        }
        String toKey = null;
        String fromKey = null;
        int len = toPs.size();
        for (int i = 0; i < len; ++i) {
            String value;
            toKey = ((IDataEntityProperty)toPs.get(i)).getName();
            if (ignoreKeys.contains(toKey)) continue;
            fromKey = convertKeysMap != null ? ((value = convertKeysMap.get(toKey)) != null ? value : toKey) : toKey;
            if (!fromPsSet.contains(fromKey)) continue;
            toObj.set(toKey, fromObj.get(fromKey));
        }
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj) {
        DynamicObjectUtil.copy(fromObj, toObj, null, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        DynamicObjectUtil.copy(fromObj, toObj, ignoreKeys, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Map<String, String> transKeyMap) {
        DynamicObjectUtil.copy(fromObj, toObj, null, transKeyMap);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (Object pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        ISimpleProperty primaryKeyObj = toObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        for (IDataEntityProperty pro : toPros) {
            Object value;
            String toProName;
            String fromProName = toProName = pro.getName();
            if (transKeyMap != null) {
                value = transKeyMap.get(fromProName);
                if (value != null) {
                    toProName = value;
                }
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            if (toProName.equals(primaryKey)) {
                toObj.set(toProName, null);
                continue;
            }
            value = fromObj.get(fromProName);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
                DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
                if (toEntity != null) {
                    toEntity.clear();
                    DynamicObjectType entityType = toEntity.getDynamicObjectType();
                    for (DynamicObject baseEntry : formEntity) {
                        DynamicObject newEntry = new DynamicObject(entityType);
                        DynamicObjectUtil.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                        toEntity.add((Object)newEntry);
                    }
                }
                toObj.set(toProName, (Object)toEntity);
                continue;
            }
            if (toObj.getDataEntityType().getProperties().get((Object)toProName) instanceof ItemClassProp) {
                toObj.set(toProName, (Object)((DynamicObject)value).getLong(ID));
                continue;
            }
            toObj.set(toProName, value);
        }
    }

    public static List<Map<String, Object>> dycsToMaps(DynamicObject[] dycs, Set<String> noEntryFieldKeys, String ... deepEntryKeys) {
        ArrayList<Map<String, Object>> billFieldValueMaps = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dyc : dycs) {
            Map<String, Object> billFieldValueMap = DynamicObjectUtil.dycToMap(dyc, noEntryFieldKeys, deepEntryKeys);
            billFieldValueMaps.add(billFieldValueMap);
        }
        return billFieldValueMaps;
    }

    public static Map<String, Object> dycToMap(DynamicObject dyc, Set<String> noEntryFieldKeys, String ... deepEntryKeys) {
        HashMap<String, Object> billFieldValueMap = new HashMap<String, Object>(16);
        if (dyc == null) {
            return billFieldValueMap;
        }
        String entity = dyc.getDataEntityType().getName();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        HashMap<String, Object> billFieldKeyValueMap = new HashMap<String, Object>(16);
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (String noEntryFieldKey : noEntryFieldKeys) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)noEntryFieldKey);
            if (property == null) continue;
            Object objValue = dyc.get(noEntryFieldKey);
            if (objValue instanceof DynamicObject) {
                objValue = ((DynamicObject)objValue).getPkValue();
            } else if (property instanceof DateTimeProp) {
                objValue = objValue == null ? null : Long.valueOf(((Date)objValue).getTime());
            }
            billFieldKeyValueMap.put(noEntryFieldKey, objValue);
        }
        for (String deepEntryKey : deepEntryKeys) {
            IDataEntityType deepEntryType = (IDataEntityType)entityType.getAllEntities().get(deepEntryKey);
            ArrayList<String> entryKeys = new ArrayList<String>(16);
            DynamicObjectUtil.getEntryKeys(deepEntryType, entryKeys, entity);
            DynamicObjectUtil.buildEntryMap(noEntryFieldKeys, entityType, dyc, billFieldKeyValueMap, entryKeys, 0);
        }
        return billFieldKeyValueMap;
    }

    public static DynamicObject[] mapsToDycs(List<Map<String, Object>> billFieldValueMaps, String entity, Set<String> noEntryFieldKeys, String ... deepEntryKeys) {
        ArrayList<DynamicObject> billDycs = new ArrayList<DynamicObject>(16);
        for (Map<String, Object> billFieldValueMap : billFieldValueMaps) {
            DynamicObject billDyc = DynamicObjectUtil.mapToDyc(billFieldValueMap, entity, noEntryFieldKeys, deepEntryKeys);
            if (billDyc == null) continue;
            billDycs.add(billDyc);
        }
        return billDycs.toArray(new DynamicObject[0]);
    }

    public static DynamicObject mapToDyc(Map<String, Object> billFieldValueMap, String entity, Set<String> noEntryFieldKeys, String ... deepEntryKeys) {
        if (billFieldValueMap == null || billFieldValueMap.isEmpty()) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entity, noEntryFieldKeys);
        DynamicObject billDyc = new DynamicObject(subDataEntityType);
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (Map.Entry<String, Object> fieldValueEntry : billFieldValueMap.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldValueEntry.getKey());
            if (property == null || property instanceof EntryProp) continue;
            Object objValue = fieldValueEntry.getValue();
            if (property instanceof DateTimeProp) {
                objValue = objValue == null ? null : new Date((Long)objValue);
            }
            billDyc.set(fieldValueEntry.getKey(), objValue);
        }
        for (String deepEntryKey : deepEntryKeys) {
            IDataEntityType deepEntryType = (IDataEntityType)entityType.getAllEntities().get(deepEntryKey);
            ArrayList<String> entryKeys = new ArrayList<String>(16);
            DynamicObjectUtil.getEntryKeys(deepEntryType, entryKeys, entity);
            DynamicObjectUtil.buildEntryDyc(entityType, billDyc, billFieldValueMap, entryKeys, 0);
        }
        return billDyc;
    }

    private static void buildEntryMap(Set<String> noEntryFieldKeys, MainEntityType entityType, DynamicObject parentDyc, Map<String, Object> parentFieldKeyValueMap, List<String> entryKeys, int entryIndex) {
        if (entryIndex >= entryKeys.size()) {
            return;
        }
        String curEntryKey = entryKeys.get(entryIndex);
        DataEntityPropertyCollection properties = ((EntityType)entityType.getAllEntities().get(curEntryKey)).getProperties();
        ArrayList<HashMap<String, Object>> entryKeyValueMaps = new ArrayList<HashMap<String, Object>>(16);
        DynamicObjectCollection entryDycs = parentDyc.getDynamicObjectCollection(curEntryKey);
        for (DynamicObject entryDyc : entryDycs) {
            HashMap<String, Object> entryFieldKeyValueMap = new HashMap<String, Object>(16);
            for (String noEntryFieldKey : noEntryFieldKeys) {
                if (!properties.containsKey((Object)noEntryFieldKey)) continue;
                entryFieldKeyValueMap.put(noEntryFieldKey, entryDyc.get(noEntryFieldKey));
            }
            DynamicObjectUtil.buildEntryMap(noEntryFieldKeys, entityType, entryDyc, entryFieldKeyValueMap, entryKeys, ++entryIndex);
            entryKeyValueMaps.add(entryFieldKeyValueMap);
        }
        parentFieldKeyValueMap.put(curEntryKey, entryKeyValueMaps);
    }

    private static void getEntryKeys(IDataEntityType entryType, List<String> entryKeys, String entity) {
        if (entryType != null && !entryType.getName().equals(entity)) {
            entryKeys.add(0, entryType.getName());
            DynamicObjectUtil.getEntryKeys(entryType.getParent(), entryKeys, entity);
        }
    }

    private static void buildEntryDyc(MainEntityType entityType, DynamicObject parentDyc, Map<String, Object> billFieldValueMap, List<String> entryKeys, int entryIndex) {
        if (entryIndex >= entryKeys.size()) {
            return;
        }
        String curEntryKey = entryKeys.get(entryIndex);
        List entryKeyValueMaps = (List)billFieldValueMap.get(curEntryKey);
        if (entryKeyValueMaps == null) {
            return;
        }
        DataEntityPropertyCollection properties = ((EntityType)entityType.getAllEntities().get(curEntryKey)).getProperties();
        DynamicObjectCollection entryDycs = parentDyc.getDynamicObjectCollection(curEntryKey);
        for (Map entryKeyValueMap : entryKeyValueMaps) {
            DynamicObject entryDyc = entryDycs.addNew();
            for (Map.Entry fieldValueEntry : entryKeyValueMap.entrySet()) {
                if (!properties.containsKey(fieldValueEntry.getKey())) continue;
                entryDyc.set((String)fieldValueEntry.getKey(), fieldValueEntry.getValue());
            }
            DynamicObjectUtil.buildEntryDyc(entityType, entryDyc, entryKeyValueMap, entryKeys, ++entryIndex);
        }
    }
}

