/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.AbstractWriteOffExtPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.IWriteOffBasePlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;

public abstract class AbstractWFPluginProxy<T extends IWriteOffBasePlugin>
implements IWriteOffBasePlugin {
    protected static final Log log = LogFactory.getLog(AbstractWFPluginProxy.class);
    private List<T> standardPlugins = new ArrayList<T>(16);
    private List<T> extPlugins = new ArrayList<T>(16);
    private WriteOffExecuteContext execContext;
    private WriteOffTypeConfig wftConfig;
    private SchemeContextConfig schemeContextConfig;
    private Map<String, Object> custMap = new HashMap<String, Object>();
    private Map<String, List<T>> methodPlugins = new HashMap<String, List<T>>(16);
    private WriteOffParamManager paramManager = null;

    public AbstractWFPluginProxy(WriteOffParamManager paramManager) {
        this.paramManager = paramManager;
    }

    public boolean isOnPlugin() {
        List<T> plugins = this.getAllPlugins();
        return plugins != null && !plugins.isEmpty();
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> allKeys = new HashMap<String, Set<String>>(16);
        List<T> allPlugins = this.getAllPlugins();
        for (IWriteOffBasePlugin t : allPlugins) {
            this.mapMerge(allKeys, t.preparePropKey());
        }
        return allKeys;
    }

    private void mapMerge(Map<String, Set<String>> tgtMap, Map<String, Set<String>> map) {
        if (tgtMap == null || map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<String>> mapEnty : map.entrySet()) {
            MapUtils.mapGetSetValue(tgtMap, mapEnty.getKey()).addAll((Collection<String>)mapEnty.getValue());
        }
    }

    public void setCustMap(Map<String, Object> custMap) {
        this.custMap = custMap;
    }

    public void setExecContext(WriteOffExecuteContext execContext) {
        this.execContext = execContext;
    }

    public void setTypeConfig(WriteOffTypeConfig typeConfig) {
        this.wftConfig = typeConfig;
    }

    public void setSchemeContextConfig(SchemeContextConfig schemeContextConfig) {
        this.schemeContextConfig = schemeContextConfig;
        ArrayList<T> plugins = new ArrayList<T>(16);
        plugins.addAll(this.getStandardPlugins());
        plugins.addAll(this.getExtPlugins());
        for (IWriteOffBasePlugin plugin : plugins) {
            if (!(plugin instanceof AbstractWriteOffExtPlugin)) continue;
            AbstractWriteOffExtPlugin extPlugin = (AbstractWriteOffExtPlugin)plugin;
            extPlugin.setSchemeContextConfig(schemeContextConfig);
        }
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return null;
    }

    protected final List<T> getStandardPlugins() {
        return this.standardPlugins;
    }

    public List<T> getExtPlugins() {
        return this.extPlugins;
    }

    public final List<T> getAllPlugins() {
        return this.getAllPlugins(null);
    }

    public final List<T> getAllPlugins(String methodName) {
        List<T> plugins = this.methodPlugins.get(methodName);
        if (plugins == null) {
            plugins = new ArrayList<T>(16);
            plugins.addAll(this.getStandardPlugins());
            plugins.addAll(this.getExtPlugins());
            for (IWriteOffBasePlugin t : plugins) {
                this.initPlugin(t);
            }
            Long wfTypeId = this.wfTypeId();
            if (StringUtils.isNotEmpty((String)methodName) && this.paramManager != null && wfTypeId != null && !MapUtils.isEmpty(this.paramManager.getBreakPluginMethods())) {
                Iterator<T> pluginIterator = plugins.iterator();
                while (pluginIterator.hasNext()) {
                    IWriteOffBasePlugin plugin = (IWriteOffBasePlugin)pluginIterator.next();
                    String pluginName = plugin.getClass().getSimpleName();
                    if (!this.paramManager.isBreakPlugin(wfTypeId, pluginName, methodName)) continue;
                    pluginIterator.remove();
                    String wfTypeName = null;
                    WriteOffTypeConfig typeConfig = this.getWriteOffTypeConfig();
                    wfTypeName = typeConfig != null ? typeConfig.getName() : String.valueOf(wfTypeId);
                    log.info(String.format("\u6838\u9500\u7c7b\u522b\u3010%s\u3011\u63d2\u4ef6\u3010%s\u3011\u65b9\u6cd5\u3010%s\u3011\u8fdb\u884c\u7194\u65ad\uff01", wfTypeName, pluginName, methodName));
                }
            }
            this.methodPlugins.put(methodName, plugins);
        }
        return plugins;
    }

    public final List<T> getAllPluginsWithLog(String methodName) {
        List<T> plugins = this.getAllPlugins(methodName);
        this.printLog(plugins, methodName);
        return plugins;
    }

    public final void addPlugins(List<T> standardPlugins, PluginProxy<T> pluginProxy) {
        for (IWriteOffBasePlugin standardPlugin : standardPlugins) {
            if (!this.isPluginAct(standardPlugin)) continue;
            this.standardPlugins.add(standardPlugin);
        }
        List plugins = pluginProxy.getPlugins();
        for (IWriteOffBasePlugin extPlugin : plugins) {
            if (!this.isPluginAct(extPlugin)) continue;
            this.extPlugins.add(extPlugin);
        }
    }

    protected final WriteOffTypeConfig getWriteOffTypeConfig() {
        return this.wftConfig;
    }

    protected SchemeContextConfig getSchemeContextConfig() {
        return this.schemeContextConfig;
    }

    protected boolean isPluginAct(T p) {
        if (p == null) {
            return false;
        }
        return CommonUtils.isContain(p.getWriteOffTypeIds(), this.wfTypeId());
    }

    protected Long wfTypeId() {
        WriteOffTypeConfig writeOffTypeConfig = this.getWriteOffTypeConfig();
        if (writeOffTypeConfig != null) {
            return writeOffTypeConfig.getId();
        }
        return 0L;
    }

    protected void initPlugin(IWriteOffBasePlugin plugin) {
        if (plugin instanceof AbstractWriteOffExtPlugin) {
            AbstractWriteOffExtPlugin extPlugin = (AbstractWriteOffExtPlugin)plugin;
            extPlugin.setCustMap(this.custMap);
            extPlugin.setExecuteContext(this.execContext);
            extPlugin.setWftConfig(this.wftConfig);
            extPlugin.setSchemeContextConfig(this.schemeContextConfig);
        }
    }

    protected final void printLog(List<? extends IWriteOffBasePlugin> plugins, String methodName) {
        if (plugins == null || plugins.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("\u6267\u884c\u6269\u5c55\u70b9\u3010" + methodName + "\u3011\u9700\u8981\u65e0\u53ef\u6267\u884c\u7684\u63d2\u4ef6\u3002");
            }
            return;
        }
        ArrayList<String> clazzNames = new ArrayList<String>(16);
        for (IWriteOffBasePlugin iWriteOffBasePlugin : plugins) {
            clazzNames.add(iWriteOffBasePlugin.getClass().getName());
        }
        if (this.wftConfig != null) {
            String wftName = this.wftConfig.getName();
            if (this.schemeContextConfig != null) {
                log.info("\u5f53\u524d\u6838\u9500\u7c7b\u522b\u3010" + wftName + "\u3011\u6838\u9500\u65b9\u6848\u3010" + this.schemeContextConfig.getSchemeId() + "\u3011 \u6267\u884c\u6269\u5c55\u70b9\u3010" + methodName + "\u3011\u9700\u8981\u6267\u884c\u4ee5\u4e0b\u63d2\u4ef6\uff1a" + String.valueOf(clazzNames));
            } else {
                log.info("\u5f53\u524d\u6838\u9500\u7c7b\u522b\u3010" + wftName + "\u3011 \u6267\u884c\u6269\u5c55\u70b9\u3010" + methodName + "\u3011\u9700\u8981\u6267\u884c\u4ee5\u4e0b\u63d2\u4ef6\uff1a" + String.valueOf(clazzNames));
            }
        } else {
            log.info("\u6267\u884c\u6269\u5c55\u70b9\u3010" + methodName + "\u3011\u9700\u8981\u6267\u884c\u4ee5\u4e0b\u63d2\u4ef6\uff1a" + String.valueOf(clazzNames));
        }
    }
}

