/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.FilterFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.QWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.AbstractWFPluginProxy;
import kd.mpscmm.mscommon.writeoff.lang.NounLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.ExtMatchInfo;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffGroupArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class MatchPluginProxy
extends AbstractWFPluginProxy<IMatchPlugin> {
    public static final Log log = LogFactory.getLog(MatchPluginProxy.class);
    private MatchRuleConfig matchRuleConfig = null;

    public MatchPluginProxy(WriteOffParamManager paramManager) {
        super(paramManager);
    }

    public void setMatchRuleConfig(MatchRuleConfig matchRuleConfig) {
        this.matchRuleConfig = matchRuleConfig;
    }

    @Override
    protected boolean isPluginAct(IMatchPlugin p) {
        return super.isPluginAct(p) && CommonUtils.isContain(p.getMachRuleIds(), (Long)this.matchRuleConfig.getObjId());
    }

    public String botpTrackRelation(DynamicObject srcConfigObj, DynamicObject tgtConfigObj) {
        List allPlugins = this.getAllPlugins("botpTrackRelation");
        if (allPlugins.isEmpty()) {
            return "trackNone";
        }
        IMatchPlugin lastPlugin = (IMatchPlugin)allPlugins.get(allPlugins.size() - 1);
        String botpTrackRelation = lastPlugin.botpTrackRelation(srcConfigObj, tgtConfigObj);
        return botpTrackRelation;
    }

    public List<MatchPluginResult> matchCondition(WriteOffObject writeOffObject) {
        return this.matchCondition(WfPluginExtFactory.writeObjectChangeArgs(writeOffObject));
    }

    private List<MatchPluginResult> matchCondition(WriteOffObjectArgs writeOffObject) {
        List allPlugins = this.getAllPlugins("matchCondition");
        if (allPlugins.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MatchPluginResult> list = new ArrayList<MatchPluginResult>(4);
        for (IMatchPlugin plugin : allPlugins) {
            List<MatchPluginResult> matchCondition = plugin.matchCondition(writeOffObject);
            if (matchCondition == null) continue;
            list.addAll(matchCondition);
        }
        return list;
    }

    public List<IWFFilter> getMatchFilters(Object value, String curEntity, String findEntity) {
        List plugins = this.getAllPlugins("getMatchFilter");
        if (plugins.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IWFFilter> filters = new ArrayList<IWFFilter>();
        for (IMatchPlugin p : plugins) {
            QFilter qf = p.getMatchFilter(value, curEntity, findEntity);
            if (qf == null) continue;
            QWFFilter createQFilter = FilterFactory.createQFilter(qf);
            createQFilter.setInfo(new WriteOffMatchConditionInfo(NounLang.extFilter(p.getClass()), null, String.valueOf(qf)));
            filters.add(createQFilter);
        }
        return filters;
    }

    public void batchSetGroupMatchFilter(String srcAlias, List<WriteOffMatchGroup> groups) {
        List plugins = this.getAllPluginsWithLog("batchSetMatchFilter");
        if (plugins.isEmpty()) {
            return;
        }
        HashMap<Integer, WriteOffMatchGroup> keyToGroup = new HashMap<Integer, WriteOffMatchGroup>(groups.size());
        ArrayList<WriteOffGroupArgs> groupArgs = new ArrayList<WriteOffGroupArgs>(groups.size());
        int i = 0;
        for (WriteOffMatchGroup writeOffMatchGroup : groups) {
            List<WriteOffObject> writeOffObjects = writeOffMatchGroup.getWriteOffObjects();
            ArrayList<WriteOffObjectBase> bases = new ArrayList<WriteOffObjectBase>(writeOffObjects.size());
            for (WriteOffObject writeOffObject : writeOffObjects) {
                bases.add(writeOffObject.getWriteOffObjectBase());
            }
            WriteOffGroupArgs args = new WriteOffGroupArgs(i, bases, writeOffMatchGroup.getMatchKeys());
            groupArgs.add(args);
            keyToGroup.put(i, writeOffMatchGroup);
            ++i;
        }
        try (TraceSpan trace = Tracer.create((String)"WriteOffPlugin-IMatchPlugin-batchSetGroupMatchFilter", (String)"batchSetGroupMatchFilter");){
            for (IMatchPlugin plugin : plugins) {
                plugin.batchSetMatchFilter(srcAlias, groupArgs);
                for (WriteOffGroupArgs args : groupArgs) {
                    Map<String, ExtMatchInfo> filters = args.getExtMatchInfos();
                    if (filters == null || filters.isEmpty()) continue;
                    WriteOffMatchGroup writeOffMatchGroup = (WriteOffMatchGroup)keyToGroup.get(args.getUniquekey());
                    for (Map.Entry<String, ExtMatchInfo> entrySet : filters.entrySet()) {
                        ExtMatchInfo extMatchInfo = entrySet.getValue();
                        extMatchInfo.initMatchFilter(plugin);
                        writeOffMatchGroup.addExtMatchInfo(entrySet.getKey(), extMatchInfo);
                    }
                }
            }
        }
    }
}

