/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.RecordMapping;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.AbstractWFPluginProxy;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.GeneratorBillWf;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WriteOffPluginProxy
extends AbstractWFPluginProxy<IWriteOffPlugin> {
    public WriteOffPluginProxy(WriteOffParamManager paramManager) {
        super(paramManager);
    }

    public List<QFilter> extendFlowBillObjFilter(String entity, DynamicObjectCollection billObjs) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        List plugins = this.getAllPlugins("extendFlowBillObjFilter");
        for (IWriteOffPlugin iWriteOffPlugin : plugins) {
            QFilter filter = iWriteOffPlugin.extendFlowBillObjFilter(entity, billObjs);
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters;
    }

    public void beforeWriteOff(List<WriteOffQueueGroup> queueGroups) {
        List plugins = this.getAllPlugins("afterMatch");
        for (IWriteOffPlugin plugin : plugins) {
            plugin.beforeWriteOff(queueGroups);
        }
    }

    @Deprecated
    public Map<String, String> botpParams(List<WriteOffObjectArgs> writeOffObjects) {
        HashMap<String, String> botpParamMap = new HashMap<String, String>(8);
        List plugins = this.getAllPlugins("botpParams");
        for (IWriteOffPlugin plugin : plugins) {
            botpParamMap.putAll(plugin.botpParams(writeOffObjects));
        }
        return botpParamMap;
    }

    @Deprecated
    public void generateBillDeal(List<IWriteOffQueue> list, List<GeneratorBillWf> generateBills) {
        List plugins = this.getAllPlugins("generateBillDeal");
        for (IWriteOffPlugin plugin : plugins) {
            plugin.generateBillDeal(list, generateBills);
        }
    }

    public void beforeAllWfRecordsGenerate(List<WriteOffRecordMapper> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        List plugins = this.getAllPluginsWithLog("beforeAllWfRecordGenerate");
        if (plugins.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> recordObjs = new ArrayList<DynamicObject>(16);
        for (WriteOffRecordMapper record : records) {
            DynamicObject recordBill = record.getRecordBill();
            recordObjs.add(recordBill);
        }
        try (TraceSpan trace = Tracer.create((String)"WriteOffPlugin-IWriteOffPlugin-beforeAllWfRecordsGenerate", (String)"beforeAllWfRecordsGenerate");){
            for (IWriteOffPlugin plugin : plugins) {
                plugin.beforeAllWfRecordGenerate(recordObjs);
            }
        }
    }

    public void beforeWfRecordGenerate(WriteOffRecordMapper recordMapping) {
        DynamicObject recordBill = recordMapping.getRecordBill();
        ArrayList<WriteOffObjectBase> objs = new ArrayList<WriteOffObjectBase>(16);
        for (RecordMapping recordMap : recordMapping.getRecordMappings()) {
            objs.add(recordMap.getWriteOffObject());
        }
        List plugins = this.getAllPlugins("beforeWfRecordGenerate");
        for (IWriteOffPlugin plugin : plugins) {
            plugin.beforeWfRecordGenerate(recordBill, objs);
        }
    }

    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        List plugins = this.getAllPluginsWithLog("buildBackSql");
        if (plugins.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, List<Object[]>>> map = new HashMap<String, Map<String, List<Object[]>>>(16);
        try (TraceSpan trace = Tracer.create((String)"WriteOffPlugin-IWriteOffPlugin-buildBackSql", (String)"buildBackSql");){
            for (IWriteOffPlugin plugin : plugins) {
                Map<String, Map<String, List<Object[]>>> sqlMap = plugin.buildBackSql(records);
                if (sqlMap == null) continue;
                CommonUtils.buildSqlMap(map, sqlMap);
            }
        }
        return map;
    }

    public void viewWfLog(List<DynamicObject> logs) {
        List plugins = this.getAllPlugins("viewWfLog");
        for (IWriteOffPlugin plugin : plugins) {
            plugin.viewWfLog(logs);
        }
    }

    public void afterWfRecordStrategy(List<DynamicObject> records) {
        List plugins = this.getAllPluginsWithLog("afterWfRecordStrategy");
        if (plugins.isEmpty()) {
            return;
        }
        try (TraceSpan trace = Tracer.create((String)"WriteOffPlugin-IWriteOffPlugin-afterWfRecordStrategy", (String)"afterWfRecordStrategy");){
            for (IWriteOffPlugin plugin : plugins) {
                plugin.afterWfRecordStrategy(records);
            }
        }
    }

    public void afterWfAutoGenerate(List<DynamicObject> generateBills) {
        List plugins = this.getAllPluginsWithLog("afterWfAutoGenerate");
        if (plugins.isEmpty()) {
            return;
        }
        try (TraceSpan trace = Tracer.create((String)"WriteOffPlugin-IWriteOffPlugin-afterWfAutoGenerate", (String)"afterWfAutoGenerate");){
            for (IWriteOffPlugin plugin : plugins) {
                plugin.afterWfAutoGenerate(generateBills);
            }
        }
    }
}

