/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.StdConfig;

public class BOTPHelper {
    private static final Log logger = LogFactory.getLog(BOTPHelper.class);

    public static List<DynamicObject> push(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks, Map<String, String> paramMap) {
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, targetEntity, ruleId, sourceBillPks, paramMap);
        if (!result.isSuccess()) {
            throw new KDBizException(new ErrorCode("botp", result.getMessage()), new Object[]{result.getBillReports()});
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        return result.loadTargetDataObjects(refDataProvider, mainType);
    }

    public static Map<String, Object> push4Result(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, targetEntity, ruleId, sourceBillPks);
        boolean fail = false;
        for (SourceBillReport billReport : result.getBillReports()) {
            if (billReport.isSuccess()) continue;
            fail = true;
            break;
        }
        if (!result.isSuccess() || fail) {
            map.put("convertResult", result);
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        map.put("trgBills", result.loadTargetDataObjects(refDataProvider, mainType));
        return map;
    }

    private static ConvertOperationResult getConvertOperationResult(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks) {
        logger.info("------BOTPHelper.push()------ ruleid = " + ruleId + ", srcEntity = " + sourceEntity + ", trgEntity = " + targetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (Long pk : sourceBillPks) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)pk);
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        if (ruleId != null) {
            args.setRuleId(ruleId);
        }
        args.addCustomParam("bos_max_push_rows", BOTPHelper.getMaxPushRows());
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        return ConvertServiceHelper.push((PushArgs)args);
    }

    private static ConvertOperationResult getConvertOperationResult(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks, Map<String, String> paramMap) {
        logger.info("------BOTPHelper.push()------ ruleid = " + ruleId + ", srcEntity = " + sourceEntity + ", trgEntity = " + targetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(32);
        for (Long pk : sourceBillPks) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)pk);
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        if (ruleId != null) {
            args.setRuleId(ruleId);
        }
        if (!paramMap.isEmpty()) {
            Set<Map.Entry<String, String>> entries = paramMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                args.addCustomParam(entry.getKey(), entry.getValue());
            }
        }
        args.addCustomParam("bos_max_push_rows", "20000");
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        return ConvertServiceHelper.push((PushArgs)args);
    }

    public static String getMaxPushRows() {
        String maxRows = StdConfig.get("bos_max_push_rows");
        return ObjectUtils.isEmpty((Object)maxRows) ? "20000" : maxRows;
    }

    public static Map<Long, List<Long>> loadNearUpBillIds(String entityNumber, String upEntityNumber, Long[] ids) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(ids.length);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)upEntityNumber, (String)upEntityNumber);
        Long upTableId = tableDefine.getTableId();
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)"", (Long[])ids);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return resultMap;
        }
        for (Long id : ids) {
            List nodes = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(id) == 0).collect(Collectors.toList());
            ArrayList srcPks = new ArrayList(10);
            for (BFRowLinkUpNode node : nodes) {
                List<BFRowLinkUpNode> sourceNodes = BOTPHelper.findSourceNodes(node, upTableId, id);
                List pkList = sourceNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
                srcPks.addAll(pkList);
            }
            if (srcPks.isEmpty()) continue;
            resultMap.put(id, srcPks);
        }
        return resultMap;
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(BOTPHelper.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }

    public static Map<Long, Set<Long>> loadTargetRowIdsMap(String sourceEntityName, String sourceEntryName, Long[] sourceEntryIds, String targetEntityName) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        Map<Long, Map<String, Set<Long>>> allTargetRowIdsMap = BOTPHelper.loadAllTargetRowIdsMap(sourceEntityName, sourceEntryName, sourceEntryIds);
        for (Map.Entry<Long, Map<String, Set<Long>>> entry : allTargetRowIdsMap.entrySet()) {
            Set specifiedTargetEntryIds = entry.getValue().getOrDefault(targetEntityName, new HashSet(16));
            if (ObjectUtils.isEmpty((Object)specifiedTargetEntryIds)) continue;
            result.put(entry.getKey(), specifiedTargetEntryIds);
        }
        return result;
    }

    public static Map<Long, Map<String, Set<Long>>> loadAllTargetRowIdsMap(String sourceEntityName, String sourceEntryName, Long[] sourceEntryIds) {
        HashMap<Long, Map<String, Set<Long>>> result = new HashMap<Long, Map<String, Set<Long>>>(16);
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)sourceEntityName, (String)sourceEntryName, (Long[])sourceEntryIds);
        if (bfRowLinkDownNodes == null || bfRowLinkDownNodes.size() < 1) {
            return result;
        }
        for (Long entryId : sourceEntryIds) {
            List nodes = bfRowLinkDownNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).collect(Collectors.toList());
            for (BFRowLinkDownNode node : nodes) {
                HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>();
                BOTPHelper.findTargetNodesByEntry(node, entryId, resultMap);
                result.put(entryId, resultMap);
            }
        }
        return result;
    }

    private static void findTargetNodesByEntry(BFRowLinkDownNode node, Long entryId, Map<String, Set<Long>> resultMap) {
        if (node.getRowId().getEntryId().compareTo(entryId) != 0) {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)node.getRowId().getMainTableId());
            String targetEntityName = tableDefine.getEntityNumber();
            Set<Long> exitsSet = resultMap.get(targetEntityName);
            if (exitsSet == null) {
                exitsSet = new HashSet<Long>();
                resultMap.put(targetEntityName, exitsSet);
            }
            exitsSet.add(node.getRowId().getEntryId());
        }
        for (BFRowLinkDownNode tNode : node.getTNodes().values()) {
            BOTPHelper.findTargetNodesByEntry(tNode, entryId, resultMap);
        }
    }
}

