/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class UnitConvertHelper {
    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = BigDecimal.ONE;
        if (srcUnitId.equals(desUnitId)) {
            return unitRate;
        }
        DynamicObject muConv1 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (!ObjectUtils.isEmpty((Object)muConv1) && muConv1.getInt("numerator") != 0) {
            unitRate = muConv1.getBigDecimal("numerator").divide(muConv1.getBigDecimal("denominator"), 10, RoundingMode.HALF_UP);
        } else {
            DynamicObject muConv2 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)desUnitId, (Long)srcUnitId);
            if (!ObjectUtils.isEmpty((Object)muConv2) && muConv2.getInt("numerator") != 0) {
                unitRate = muConv2.getBigDecimal("denominator").divide(muConv2.getBigDecimal("numerator"), 10, RoundingMode.HALF_UP);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ONE;
        }
        return unitRate;
    }

    public static BigDecimal getBaseunitqty(BigDecimal quantity, BigDecimal covertRate, DynamicObject baseUnit) {
        BigDecimal baseunitqty = BigDecimal.ZERO;
        if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        int precisionaccount = 4;
        int precision = 10;
        if (baseUnit == null) {
            baseunitqty = quantity.multiply(covertRate).setScale(precision, precisionaccount);
            return baseunitqty;
        }
        precisionaccount = baseUnit.getInt("precisionaccount");
        precision = baseUnit.getInt("precision");
        baseunitqty = precisionaccount == 2 ? quantity.multiply(covertRate).setScale(precision, 1) : (precisionaccount == 3 ? quantity.multiply(covertRate).setScale(precision, 0) : quantity.multiply(covertRate).setScale(precision, 4));
        return baseunitqty;
    }

    public static BigDecimal getUnitQty(BigDecimal baseQuantity, BigDecimal covertRate, DynamicObject unit) {
        BigDecimal unitQty = BigDecimal.ZERO;
        if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        if (!ObjectUtils.isEmpty((Object)unit)) {
            int precisionaccount = unit.getInt("precisionaccount");
            int precision = unit.getInt("precision");
            unitQty = precisionaccount == 2 ? baseQuantity.divide(covertRate, precision, 1) : (precisionaccount == 3 ? baseQuantity.divide(covertRate, precision, 0) : baseQuantity.divide(covertRate, precision, 4));
        } else {
            unitQty = baseQuantity.divide(covertRate).setScale(10, 4);
        }
        return unitQty;
    }
}

