/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.BOTPHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.BookDateHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.OperationHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.StdConfig;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.SystemParameterHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.vo.VerifyRecordVO;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.vo.aroriginal.NeedRepairObjVO;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class ArOriginalWFRecordWriteOffPlugin
implements IWriteOffPlugin,
IMatchPlugin {
    private static final Log logger = LogFactory.getLog(ArOriginalWFRecordWriteOffPlugin.class);
    private static final Long HXLB_AR_ORIGINAL_VERIFY_QTY_CORE = 1678144407779420160L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE = 1678148494499522560L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP = 1693748335779055616L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP = 1693749472343164928L;
    private static final Long PPGZ_AR_ORIGINAL_VERIFY_QTY_CORE = 1678162987858274304L;
    private static final Long PPGZ_AR_ORIGINAL_VERIFY_AMOUNT_CORE = 1678164631362742272L;
    private static final Long PPGZ_AR_ORIGINAL_VERIFY_QTY_BOTP = 1693752659301050368L;
    private static final Long PPGZ_AR_ORIGINAL_VERIFY_AMOUNT_BOTP = 1693752186385008640L;
    private Map<Long, DynamicObject> prepareRevcfmBillMap = new HashMap<Long, DynamicObject>(8);
    private Map<Long, Map<String, Object>> orgIdParamMap = new HashMap<Long, Map<String, Object>>(8);

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> preparePropKeyMap = new HashMap<String, Set<String>>(16);
        HashSet<String> finArSet = new HashSet<String>(16);
        finArSet.add("entry.e_measureunit.name");
        preparePropKeyMap.put("ar_finarbill", finArSet);
        HashSet<String> originalSet = new HashSet<String>(16);
        originalSet.add("sim_original_bill_item.oriunit");
        originalSet.add("sim_original_bill_item.taxrate");
        originalSet.add("sim_original_bill_item.unit");
        preparePropKeyMap.put("sim_original_bill", originalSet);
        return preparePropKeyMap;
    }

    @Override
    public Set<Long> getMachRuleIds() {
        return CommonUtils.getIdSet(PPGZ_AR_ORIGINAL_VERIFY_QTY_CORE, PPGZ_AR_ORIGINAL_VERIFY_AMOUNT_CORE);
    }

    @Override
    public List<MatchPluginResult> matchCondition(WriteOffObjectArgs writeOffObject) {
        MatchPluginResult response;
        String HXLB;
        Object taxrate;
        ArrayList<MatchPluginResult> results = new ArrayList<MatchPluginResult>(2);
        WriteOffObjectBase writeOffObjectBase = writeOffObject.getWriteOffObjectBase();
        String entityKey = writeOffObjectBase.getWFBillEntityName();
        DynamicObject typeConfig = writeOffObject.getTypeConfig();
        Object pkValue = typeConfig.getPkValue();
        BigDecimal taxrateValue = BigDecimal.ONE.negate();
        String unitName = "null";
        if ("ar_finarbill".equals(entityKey)) {
            taxrate = writeOffObjectBase.getValue("e_taxrate");
            String unit = (String)writeOffObjectBase.getValue("e_measureunit.name");
            if (!StringUtils.isEmpty((CharSequence)unit)) {
                unitName = unit;
            }
            if (taxrate != null) {
                taxrateValue = (BigDecimal)taxrate;
            }
        }
        if ("sim_original_bill".equals(entityKey)) {
            taxrate = (String)writeOffObjectBase.getValue("taxrate");
            String oriunit = (String)writeOffObjectBase.getValue("oriunit");
            if (!StringUtils.isEmpty((CharSequence)oriunit)) {
                unitName = oriunit;
            } else {
                String unit = (String)writeOffObjectBase.getValue("unit");
                if (!StringUtils.isEmpty((CharSequence)unit)) {
                    unitName = unit;
                }
            }
            if (taxrate != null && !"".equals(taxrate)) {
                taxrateValue = new BigDecimal((String)taxrate);
            }
        }
        if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP.equals(pkValue) || HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP.equals(pkValue)) {
            HXLB = "botp";
            response = new MatchPluginResult();
            response.setMatchValue(HXLB + "#" + taxrateValue + "#" + unitName);
            response.setMatchName("BOTP");
            response.setComparison("in");
            results.add(response);
        }
        if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE.equals(pkValue) || HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE.equals(pkValue)) {
            HXLB = "core";
            response = new MatchPluginResult();
            response.setMatchValue(HXLB + "#" + taxrateValue + "#" + unitName);
            response.setMatchName("CORE");
            response.setComparison("in");
            results.add(response);
        }
        return results;
    }

    @Override
    public Boolean matchCompare(MatchPluginResult response, Object srcValue) {
        return Boolean.TRUE;
    }

    @Override
    public QFilter getMatchFilter(Object value, String targetEntity, String targetEntryId) {
        if (value == null) {
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        Object[] values = value.toString().split("#");
        logger.info("------ArOriginalWFRecordWriteOffPlugin.getMatchFilter.values------" + Arrays.toString(values));
        Object hxlb = values[0];
        if ("botp".equals(hxlb)) {
            BigDecimal taxrate = new BigDecimal((String)values[1]);
            Object unitName = values[2];
            if (taxrate.compareTo(BigDecimal.ONE.negate()) == 0 || "null".equals(unitName)) {
                return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            }
            if ("ar_finarbill".equals(targetEntity)) {
                return new QFilter("entry.e_taxrate", "=", (Object)taxrate.multiply(new BigDecimal(100)).stripTrailingZeros()).and(new QFilter("entry.e_measureunit.name", "=", unitName));
            }
            if ("sim_original_bill".equals(targetEntity)) {
                return new QFilter("sim_original_bill_item.taxrate", "=", (Object)taxrate.divide(new BigDecimal("100")).stripTrailingZeros().toString()).and(new QFilter("sim_original_bill_item.oriunit", "=", unitName));
            }
        } else {
            BigDecimal taxrate = new BigDecimal((String)values[1]);
            Object unitName = values[2];
            if (taxrate.compareTo(BigDecimal.ONE.negate()) == 0 || "null".equals(unitName)) {
                return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            }
            if ("ar_finarbill".equals(targetEntity)) {
                QFilter filter = new QFilter("entry.e_taxrate", "=", (Object)taxrate.multiply(new BigDecimal("100")).stripTrailingZeros());
                filter.and(new QFilter("entry.e_measureunit.name", "=", unitName));
                return filter;
            }
            if ("sim_original_bill".equals(targetEntity)) {
                QFilter filter = new QFilter("sim_original_bill_item.taxrate", "=", (Object)taxrate.divide(new BigDecimal("100")).stripTrailingZeros().toString());
                filter.and(new QFilter("sim_original_bill_item.oriunit", "=", unitName));
                return filter;
            }
        }
        return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(HXLB_AR_ORIGINAL_VERIFY_QTY_CORE, HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP, HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE, HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP);
    }

    @Override
    public void beforeWfRecordGenerate(DynamicObject recordBill) {
    }

    @Override
    public void afterWfRecordStrategy(List<DynamicObject> records) {
        HashSet<Long> finArBillIdSet = new HashSet<Long>(8);
        HashSet<Long> originalBillIdSet = new HashSet<Long>(8);
        HashSet<Long> originalBillEntryIdSet = new HashSet<Long>(8);
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection entrys = recordBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                finArBillIdSet.add(entry.getLong("billentryid"));
                originalBillIdSet.add(entry.getLong("assbillid"));
                originalBillEntryIdSet.add(entry.getLong("assbillentryid"));
            }
        }
        DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"ar_finarbill", (String)this.getMainSelectors(), (QFilter[])new QFilter[]{new QFilter("entry.id", "in", finArBillIdSet)});
        Map<Long, DynamicObject> mainMap = mainCollection.stream().collect(Collectors.toMap(bill -> bill.getLong("entry.id"), bill -> bill));
        DynamicObjectCollection asstCollection = QueryServiceHelper.query((String)"sim_original_bill", (String)this.getAsstSelectors(), (QFilter[])new QFilter[]{new QFilter("sim_original_bill.id", "in", originalBillIdSet)}, (String)"sim_original_bill_item.seq asc");
        Map<Long, DynamicObject> asstMap = asstCollection.stream().collect(Collectors.toMap(bill -> bill.getLong("sim_original_bill_item.id"), bill -> bill));
        HashMap<Long, List> simOriginalIdToEntryInfoMap = new HashMap<Long, List>(8);
        for (Object bill2 : asstCollection) {
            long l = bill2.getLong("id");
            List entryList = simOriginalIdToEntryInfoMap.getOrDefault(l, new ArrayList(8));
            entryList.add(bill2);
            simOriginalIdToEntryInfoMap.put(l, entryList);
        }
        HashMap<Long, Long> baseEntryIdToDiscountEntryIdMap = new HashMap<Long, Long>(8);
        for (Map.Entry entry : simOriginalIdToEntryInfoMap.entrySet()) {
            Long originalId = (Long)entry.getKey();
            List simOriginalEntryList = (List)simOriginalIdToEntryInfoMap.get(originalId);
            int size = simOriginalEntryList.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject discountBill;
                DynamicObject bill3 = (DynamicObject)simOriginalEntryList.get(i);
                long entryId = bill3.getLong("sim_original_bill_item.id");
                if (!originalBillEntryIdSet.contains(entryId) || i + 1 >= size || !"1".equals((discountBill = (DynamicObject)simOriginalEntryList.get(i + 1)).getString("sim_original_bill_item.rowtype"))) continue;
                baseEntryIdToDiscountEntryIdMap.put(entryId, discountBill.getLong("sim_original_bill_item.id"));
            }
        }
        HashMap<Long, Map<String, BigDecimal>> discountEntryIdToAmtInfoMap = new HashMap<Long, Map<String, BigDecimal>>(8);
        for (Object original : asstCollection) {
            if (!"1".equals(original.getString("sim_original_bill_item.rowtype"))) continue;
            long discountEntryId = original.getLong("sim_original_bill_item.id");
            HashMap<String, BigDecimal> discountEntryFieldMap = new HashMap<String, BigDecimal>(8);
            BigDecimal issuedNum = original.getBigDecimal("sim_original_bill_item.issuednum");
            BigDecimal issuedTax = original.getBigDecimal("sim_original_bill_item.issuedtax");
            BigDecimal issuedAmt = original.getBigDecimal("sim_original_bill_item.issuedamount");
            BigDecimal issuedLocTax = original.getBigDecimal("sim_original_bill_item.fromissuedtax");
            BigDecimal issuedLocAmt = original.getBigDecimal("sim_original_bill_item.fromissuedamount");
            BigDecimal issuePriceTax = original.getBigDecimal("sim_original_bill_item.issuedtotaltaxamount");
            BigDecimal issueLocPriceTax = original.getBigDecimal("sim_original_bill_item.fromissuedtaxamount");
            BigDecimal amount = original.getBigDecimal("sim_original_bill_item.amount");
            BigDecimal fromamount = original.getBigDecimal("sim_original_bill_item.fromamount");
            BigDecimal tax = original.getBigDecimal("sim_original_bill_item.tax");
            BigDecimal fromtax = original.getBigDecimal("sim_original_bill_item.fromtax");
            BigDecimal taxamount = original.getBigDecimal("sim_original_bill_item.taxamount");
            BigDecimal fromtaxamount = original.getBigDecimal("sim_original_bill_item.fromtaxamount");
            discountEntryFieldMap.put("issuedNum", issuedNum);
            discountEntryFieldMap.put("issuedTax", issuedTax);
            discountEntryFieldMap.put("issuedAmt", issuedAmt);
            discountEntryFieldMap.put("issuedLocTax", issuedLocTax);
            discountEntryFieldMap.put("issuedLocAmt", issuedLocAmt);
            discountEntryFieldMap.put("issuePriceTax", issuePriceTax);
            discountEntryFieldMap.put("issueLocPriceTax", issueLocPriceTax);
            discountEntryFieldMap.put("amount", amount);
            discountEntryFieldMap.put("fromamount", fromamount);
            discountEntryFieldMap.put("tax", tax);
            discountEntryFieldMap.put("fromtax", fromtax);
            discountEntryFieldMap.put("taxamount", taxamount);
            discountEntryFieldMap.put("fromtaxamount", fromtaxamount);
            discountEntryIdToAmtInfoMap.put(discountEntryId, discountEntryFieldMap);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        for (DynamicObject record2 : records) {
            DynamicObjectCollection entrys = record2.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Map entryFieldMap;
                long asstEntryId = entry.getLong("assbillentryid");
                if (arrayList.contains(asstEntryId)) continue;
                arrayList.add(asstEntryId);
                Long discountEntryId = (Long)baseEntryIdToDiscountEntryIdMap.get(asstEntryId);
                if (ObjectUtils.isEmpty((Object)discountEntryId) || ObjectUtils.isEmpty((Object)(entryFieldMap = (Map)discountEntryIdToAmtInfoMap.get(discountEntryId)))) continue;
                DynamicObject original = asstMap.get(asstEntryId);
                BigDecimal issuedNum = original.getBigDecimal("sim_original_bill_item.issuednum");
                BigDecimal issuedTax = original.getBigDecimal("sim_original_bill_item.issuedtax");
                BigDecimal issuedAmt = original.getBigDecimal("sim_original_bill_item.issuedamount");
                BigDecimal issuedLocTax = original.getBigDecimal("sim_original_bill_item.fromissuedtax");
                BigDecimal issuedLocAmt = original.getBigDecimal("sim_original_bill_item.fromissuedamount");
                BigDecimal issuePriceTax = original.getBigDecimal("sim_original_bill_item.issuedtotaltaxamount");
                BigDecimal issueLocPriceTax = original.getBigDecimal("sim_original_bill_item.fromissuedtaxamount");
                BigDecimal amount = original.getBigDecimal("sim_original_bill_item.amount");
                BigDecimal fromamount = original.getBigDecimal("sim_original_bill_item.fromamount");
                BigDecimal tax = original.getBigDecimal("sim_original_bill_item.tax");
                BigDecimal fromtax = original.getBigDecimal("sim_original_bill_item.fromtax");
                BigDecimal taxamount = original.getBigDecimal("sim_original_bill_item.taxamount");
                BigDecimal fromtaxamount = original.getBigDecimal("sim_original_bill_item.fromtaxamount");
                entryFieldMap.merge("issuedNum", issuedNum, BigDecimal::add);
                entryFieldMap.merge("issuedTax", issuedTax, BigDecimal::add);
                entryFieldMap.merge("issuedAmt", issuedAmt, BigDecimal::add);
                entryFieldMap.merge("issuedLocTax", issuedLocTax, BigDecimal::add);
                entryFieldMap.merge("issuedLocAmt", issuedLocAmt, BigDecimal::add);
                entryFieldMap.merge("issuePriceTax", issuePriceTax, BigDecimal::add);
                entryFieldMap.merge("issueLocPriceTax", issueLocPriceTax, BigDecimal::add);
                entryFieldMap.merge("amount", amount, BigDecimal::add);
                entryFieldMap.merge("fromamount", fromamount, BigDecimal::add);
                entryFieldMap.merge("tax", tax, BigDecimal::add);
                entryFieldMap.merge("fromtax", fromtax, BigDecimal::add);
                entryFieldMap.merge("taxamount", taxamount, BigDecimal::add);
                entryFieldMap.merge("fromtaxamount", fromtaxamount, BigDecimal::add);
            }
        }
        for (DynamicObject record3 : records) {
            long verifyTypeId = record3.getLong("writeofftypeid.id");
            DynamicObjectCollection entrys = record3.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Map entryFieldMap;
                Long discountEntryId;
                Long mainEntryId = entry.getLong("billentryid");
                Long asstEntryId = entry.getLong("assbillentryid");
                DynamicObject mainBill = mainMap.get(mainEntryId);
                DynamicObject asstBill = asstMap.get(asstEntryId);
                if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == verifyTypeId || HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE == verifyTypeId) {
                    logger.info("ArOriginalWFRecordWriteOffPlugin afterWfRecordStrategy core satrt");
                    discountEntryId = (Long)baseEntryIdToDiscountEntryIdMap.get(asstEntryId);
                    this.fillMainVerifyRecordCore(entry, verifyTypeId, mainBill);
                    this.fillAsstVerifyRecordCore(entry, verifyTypeId, asstBill, discountEntryId, mainBill);
                    if (ObjectUtils.isEmpty((Object)discountEntryId) || ObjectUtils.isEmpty((Object)(entryFieldMap = (Map)discountEntryIdToAmtInfoMap.get(discountEntryId)))) continue;
                    logger.info("ArOriginalWFRecordWriteOffPlugin afterWfRecordStrategy core deal discount");
                    this.discountDealAsstAmtField(entry, entryFieldMap);
                    continue;
                }
                if (HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP != verifyTypeId && HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP != verifyTypeId) continue;
                discountEntryId = (Long)baseEntryIdToDiscountEntryIdMap.get(asstEntryId);
                if (ObjectUtils.isEmpty((Object)discountEntryId)) {
                    logger.info("ArOriginalWFRecordWriteOffPlugin afterWfRecordStrategy botp undiscount satrt");
                    this.fillMainVerifyRecordBotp(entry, verifyTypeId, mainBill, asstBill);
                    this.fillAsstVerifyRecordBotp(entry, asstBill);
                    continue;
                }
                entryFieldMap = (Map)discountEntryIdToAmtInfoMap.get(discountEntryId);
                if (ObjectUtils.isEmpty((Object)entryFieldMap)) continue;
                logger.info("ArOriginalWFRecordWriteOffPlugin afterWfRecordStrategy botp discount satrt");
                this.fillMainVerifyRecordBotpDiscount(entry, verifyTypeId, mainBill, entryFieldMap);
                this.fillAsstVerifyRecordBotpDiscount(entry, entryFieldMap);
            }
        }
        BookDateHelper.setVerifyBookAndBillDate(records, true);
        HashSet<Long> hxlbSet = new HashSet<Long>(8);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP);
        List<DynamicObject> arOriRecords = records.stream().filter(record -> !hxlbSet.contains(record.getLong("writeofftypeid.id"))).collect(Collectors.toList());
        logger.info("ArOriginalWFRecordWriteOffPlugin arOriRecord  size : " + arOriRecords.size());
        if (arOriRecords.size() < 1) {
            SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
            return;
        }
        this.handleMainTailDifference(arOriRecords);
        this.handleAsstTailDifference(arOriRecords, baseEntryIdToDiscountEntryIdMap, discountEntryIdToAmtInfoMap);
        SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
        this.printVerifyRecords(records);
        long verifyTypeId = arOriRecords.get(0).getLong("writeofftypeid.id");
        List<VerifyRecordVO> mainVerifyRecordList = this.buildDisMainBillParam(arOriRecords, verifyTypeId == HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE);
        List<VerifyRecordVO> asstVerifyRecordList = this.buildDisAsstBillParam(arOriRecords, verifyTypeId == HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE);
        this.buildFinArTailDiffBackSql(mainVerifyRecordList);
        this.buildFinArIssuedTailDiffBackSql(asstVerifyRecordList);
        this.buildOriginalTailDiffBackSql(asstVerifyRecordList);
        ArrayList<NeedRepairObjVO> repairObjVOS4AdjSrcBill = new ArrayList<NeedRepairObjVO>(2);
        ArrayList<NeedRepairObjVO> repairObjVOS4GenAdjBill = new ArrayList<NeedRepairObjVO>(2);
        this.filterNeedRepairFinAr(arOriRecords, repairObjVOS4AdjSrcBill, repairObjVOS4GenAdjBill);
        logger.info("ArOriginalWFRecordWriteOffPlugin afterWfRecordStrategy repairObjVOS4AdjSrcBill is : " + repairObjVOS4AdjSrcBill);
        logger.info("ArOriginalWFRecordWriteOffPlugin afterWfRecordStrategy repairObjVOS4GenAdjBill is : " + repairObjVOS4GenAdjBill);
        this.executeRepairTailData(repairObjVOS4AdjSrcBill);
        this.executeGenerateAdjBill(repairObjVOS4GenAdjBill);
        logger.info("ArOriginalWFRecordWriteOffPlugin afterWfRecordStrategy repairFinArTailData is over");
    }

    private void printVerifyRecords(List<DynamicObject> records) {
        StringBuilder printLog = new StringBuilder();
        printLog.append("verifyrecords info\uff1a");
        for (DynamicObject record : records) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal mainVerifyAmt = entry.getBigDecimal("verifyamt");
                BigDecimal asstVerifyAmt = entry.getBigDecimal("assverifyamt");
                printLog.append("mainVerifyAmt:").append(mainVerifyAmt).append(",");
                printLog.append("asstVerifyAmt:").append(asstVerifyAmt).append("|").append("\r\n");
            }
        }
        logger.info(printLog.toString());
    }

    private void executeGenerateAdjBill(List<NeedRepairObjVO> repairObjVOS) {
        logger.info("FiBotpCallBackService executeGenerateAdjBill, repairObjVOS.size " + repairObjVOS.size());
        if (repairObjVOS.isEmpty()) {
            return;
        }
        HashMap<Long, Map> adjustMap = new HashMap<Long, Map>(8);
        for (NeedRepairObjVO needRepairObjVO : repairObjVOS) {
            DynamicObject dynamicObject = needRepairObjVO.getFinArBill();
            long finArBillId = dynamicObject.getLong("id");
            Map entryMap = adjustMap.getOrDefault(finArBillId, new HashMap(2));
            DynamicObject detail = (DynamicObject)dynamicObject.getDynamicObjectCollection("entry").get(needRepairObjVO.getIndex());
            long entryId = detail.getLong("id");
            entryMap.put(entryId, needRepairObjVO);
            adjustMap.put(finArBillId, entryMap);
        }
        ArrayList<DynamicObject> saveFinArBills = new ArrayList<DynamicObject>(1);
        for (Map.Entry entry : adjustMap.entrySet()) {
            Map entryMap = (Map)entry.getValue();
            PushArgs pushArgs = this.getPushArgs(entryMap.values());
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            boolean success = pushResult.isSuccess();
            if (!success) {
                throw new KDBizException(new ErrorCode("InvoiceAdjustBill", pushResult.getMessage()), new Object[]{pushResult.getBillReports()});
            }
            IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"ar_finarbill");
            List finArBills = pushResult.loadTargetDataObjects(refDataProvider, mainType);
            for (DynamicObject finArBill : finArBills) {
                BigDecimal priceTaxTotal = BigDecimal.ZERO;
                BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal amountBase = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                BigDecimal taxLocAmt = BigDecimal.ZERO;
                BigDecimal adjustamt = BigDecimal.ZERO;
                BigDecimal adjustamtlocal = BigDecimal.ZERO;
                DynamicObjectCollection entryColl = finArBill.getDynamicObjectCollection("entry");
                Iterator iterator = entryColl.iterator();
                while (iterator.hasNext()) {
                    DynamicObject detail = (DynamicObject)iterator.next();
                    long sourceBillId = detail.getLong("e_srcentryid");
                    NeedRepairObjVO repairObjVO = (NeedRepairObjVO)entryMap.get(sourceBillId);
                    if (repairObjVO != null) {
                        BigDecimal diffTax = repairObjVO.getSimIssuedFormTax().add(detail.getBigDecimal("e_tax"));
                        BigDecimal diffTaxLocal = repairObjVO.getSimIssuedTax().add(detail.getBigDecimal("e_taxlocalamt"));
                        BigDecimal diffAmount = repairObjVO.getSimIssuedFormAmount().add(detail.getBigDecimal("e_amount"));
                        BigDecimal diffLocalAmt = repairObjVO.getSimIssuedAmount().add(detail.getBigDecimal("e_localamt"));
                        BigDecimal diffRecAmount = repairObjVO.getSimIssuedTotalFormTaxAmount().add(detail.getBigDecimal("e_recamount"));
                        BigDecimal diffRecLocalAmt = repairObjVO.getSimIssuedTotalTaxAmount().add(detail.getBigDecimal("e_reclocalamt"));
                        detail.set("e_tax", (Object)diffTax);
                        detail.set("e_taxlocalamt", (Object)diffTaxLocal);
                        detail.set("e_amount", (Object)diffAmount);
                        detail.set("e_localamt", (Object)diffLocalAmt);
                        detail.set("e_recamount", (Object)diffRecAmount);
                        detail.set("e_reclocalamt", (Object)diffRecLocalAmt);
                        detail.set("e_unlockamt", (Object)diffRecAmount);
                        detail.set("e_unsettleamt", (Object)diffRecAmount);
                        detail.set("e_unsettlelocalamt", (Object)diffRecLocalAmt);
                        detail.set("e_uninvoicedamt", (Object)diffRecAmount);
                        detail.set("e_uninvoicedlocalamt", (Object)diffRecLocalAmt);
                        detail.set("e_unverifyamt", (Object)diffAmount);
                        detail.set("e_unconfirmamt", (Object)diffAmount);
                        priceTaxTotal = priceTaxTotal.add(detail.getBigDecimal("e_recamount"));
                        priceTaxTotalBase = priceTaxTotalBase.add(detail.getBigDecimal("e_reclocalamt"));
                        amount = amount.add(detail.getBigDecimal("e_amount"));
                        amountBase = amountBase.add(detail.getBigDecimal("e_localamt"));
                        tax = tax.add(detail.getBigDecimal("e_tax"));
                        taxLocAmt = taxLocAmt.add(detail.getBigDecimal("e_taxlocalamt"));
                        adjustamt = adjustamt.add(detail.getBigDecimal("e_adjustamount"));
                        adjustamtlocal = adjustamtlocal.add(detail.getBigDecimal("e_adjustlocalamt"));
                        continue;
                    }
                    iterator.remove();
                }
                finArBill.set("recamount", (Object)priceTaxTotal);
                finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
                finArBill.set("amount", (Object)amount);
                finArBill.set("localamt", (Object)amountBase);
                finArBill.set("tax", (Object)tax);
                finArBill.set("taxlocamt", (Object)taxLocAmt);
                finArBill.set("unverifyamount", (Object)amount);
                finArBill.set("unsettleamount", (Object)priceTaxTotal);
                finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
                finArBill.set("uninvoicedamt", (Object)priceTaxTotal);
                finArBill.set("uninvoicedlocalamt", (Object)priceTaxTotalBase);
                finArBill.set("adjustamount", (Object)adjustamt);
                finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
                finArBill.set("billsrctype", (Object)"4");
                finArBill.set("adjusttype", (Object)"adjustinv");
                saveFinArBills.add(finArBill);
            }
        }
        if (saveFinArBills.isEmpty()) {
            return;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])saveFinArBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        if (!"false".equals(StdConfig.get("isInvoiceAdjustBillAutoAudit"))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "false");
            List successPkIds = operationResult.getSuccessPkIds();
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])successPkIds.toArray(new Object[0]), (OperateOption)operateOption);
            logger.info("FinArBillIssueCallbackService executeGenerateAdjBill submitResult is : " + submitResult.getAllErrorOrValidateInfo());
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])successPkIds.toArray(new Object[0]), (OperateOption)operateOption);
            logger.info("FinArBillIssueCallbackService executeGenerateAdjBill auditResult is : " + auditResult.getAllErrorOrValidateInfo());
            OperationResult coordinateapadjustResult = OperationServiceHelper.executeOperate((String)"coordinateapadjust", (String)"ar_finarbill", (Object[])successPkIds.toArray(new Object[0]), (OperateOption)OperateOption.create());
            logger.info("FinArBillIssueCallbackService executeGenerateAdjBill coordinateapadjustResult is : " + coordinateapadjustResult.getAllErrorOrValidateInfo());
        }
    }

    private PushArgs getPushArgs(Collection<NeedRepairObjVO> items) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(items.size());
        for (NeedRepairObjVO repairObjVO : items) {
            ListSelectedRow row = new ListSelectedRow();
            DynamicObject finArBill = repairObjVO.getFinArBill();
            DynamicObject detail = (DynamicObject)finArBill.getDynamicObjectCollection("entry").get(repairObjVO.getIndex());
            row.setPrimaryKeyValue(finArBill.get("id"));
            row.setEntryPrimaryKeyValue(detail.get("id"));
            row.setEntryEntityKey("ar_finarbill");
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber("ar_finarbill");
        args.setTargetEntityNumber("ar_finarbill");
        args.setSelectedRows(selectedRows);
        args.setRuleId("646772185041512448");
        args.addCustomParam("bos_max_push_rows", this.getMaxPushRows());
        return args;
    }

    private String getMaxPushRows() {
        String maxRows = StdConfig.get("bos_max_push_rows");
        return ObjectUtils.isEmpty((Object)maxRows) ? "20000" : maxRows;
    }

    private void executeRepairTailData(List<NeedRepairObjVO> repairObjVOS) {
        if (ObjectUtils.isEmpty(repairObjVOS)) {
            return;
        }
        Map<Long, Set<DynamicObject>> arOriginalMap = this.prepareArOriginalRecords(repairObjVOS);
        HashMap<Long, DynamicObject> needToSaveFinArBillMap = new HashMap<Long, DynamicObject>(repairObjVOS.size());
        HashMap<Long, DynamicObject> needToSaveRevcfmBillMap = new HashMap<Long, DynamicObject>(this.prepareRevcfmBillMap.size());
        HashMap<Long, DynamicObject> needToSaveArOriginalRecordMap = new HashMap<Long, DynamicObject>(arOriginalMap.size());
        DynamicObject[] arBillArray = (DynamicObject[])repairObjVOS.stream().map(NeedRepairObjVO::getFinArBill).toArray(DynamicObject[]::new);
        ArrayList<Map<String, Object>> addLogParamList = new ArrayList<Map<String, Object>>(arBillArray.length);
        HashMap<Long, Map<String, BigDecimal>> finArIdMap = new HashMap<Long, Map<String, BigDecimal>>(repairObjVOS.size());
        HashMap<Long, Map<String, BigDecimal>> revcfIdMap = new HashMap<Long, Map<String, BigDecimal>>(repairObjVOS.size());
        HashMap<Long, Map<String, BigDecimal>> arOriginalIdMap = new HashMap<Long, Map<String, BigDecimal>>(repairObjVOS.size());
        for (NeedRepairObjVO repairObjVO : repairObjVOS) {
            Object ar005;
            Object ar0052;
            DynamicObject finArBill = repairObjVO.getFinArBill();
            long finArBillId = finArBill.getLong("id");
            long orgId = finArBill.getLong("org.id");
            DynamicObject revcfmBill = this.prepareRevcfmBillMap.get(finArBillId);
            Set<DynamicObject> arOriginalSet = arOriginalMap.get(finArBillId);
            BigDecimal oldHeadRecAmount = finArBill.getBigDecimal("recamount");
            BigDecimal oldHeadRecLocalAmt = finArBill.getBigDecimal("reclocalamt");
            int precision = 2;
            DynamicObject currency = finArBill.getDynamicObject("currency");
            if (currency != null) {
                precision = currency.getInt("amtprecision");
            }
            int basePrecision = 2;
            DynamicObject baseCurrency = finArBill.getDynamicObject("basecurrency");
            if (baseCurrency != null) {
                basePrecision = baseCurrency.getInt("amtprecision");
            }
            if (repairObjVO.getSimIssuedTotalFormTaxAmount().compareTo(repairObjVO.getSimIssuedFormAmount().add(repairObjVO.getSimIssuedFormTax())) != 0) continue;
            int index = repairObjVO.getIndex();
            DynamicObject detail = (DynamicObject)finArBill.getDynamicObjectCollection("entry").get(index);
            BigDecimal diffTax = repairObjVO.getSimIssuedFormTax().subtract(detail.getBigDecimal("e_tax"));
            BigDecimal diffAmount = repairObjVO.getSimIssuedFormAmount().subtract(detail.getBigDecimal("e_amount"));
            BigDecimal diffTaxLocal = repairObjVO.getSimIssuedTax().subtract(detail.getBigDecimal("e_taxlocalamt"));
            BigDecimal diffLocalAmt = repairObjVO.getSimIssuedAmount().subtract(detail.getBigDecimal("e_localamt"));
            BigDecimal diffRecAmount = repairObjVO.getSimIssuedTotalFormTaxAmount().subtract(detail.getBigDecimal("e_recamount"));
            BigDecimal diffRecLocalAmt = repairObjVO.getSimIssuedTotalTaxAmount().subtract(detail.getBigDecimal("e_reclocalamt"));
            HashMap<String, BigDecimal> diffAmtMap = new HashMap<String, BigDecimal>(8);
            diffAmtMap.put("diffTax", diffTax);
            diffAmtMap.put("diffAmount", diffAmount);
            diffAmtMap.put("diffTaxLocal", diffTaxLocal);
            diffAmtMap.put("diffLocalAmt", diffLocalAmt);
            diffAmtMap.put("diffRecAmount", diffRecAmount);
            diffAmtMap.put("diffRecLocalAmt", diffRecLocalAmt);
            detail.set("e_amount", (Object)repairObjVO.getSimIssuedFormAmount());
            detail.set("e_tax", (Object)repairObjVO.getSimIssuedFormTax());
            detail.set("e_taxlocalamt", (Object)repairObjVO.getSimIssuedTax());
            detail.set("e_localamt", (Object)repairObjVO.getSimIssuedAmount());
            Map<String, Object> paramMap = this.orgIdParamMap.get(orgId);
            if (!ObjectUtils.isEmpty(paramMap) && (ar0052 = paramMap.get("ar_005")) != null) {
                BigDecimal confirmedAmt = detail.getBigDecimal("e_confirmedamt");
                if (((Boolean)ar0052).booleanValue()) {
                    if (BigDecimal.ZERO.compareTo(confirmedAmt) == 0) {
                        detail.set("e_unconfirmamt", (Object)repairObjVO.getSimIssuedFormAmount());
                    } else {
                        detail.set("e_confirmedamt", (Object)repairObjVO.getSimIssuedFormAmount());
                    }
                } else {
                    BigDecimal amount = detail.getBigDecimal("e_amount");
                    BigDecimal verifiedAmt = detail.getBigDecimal("e_verifiedamt");
                    if (amount.compareTo(confirmedAmt) > 0) {
                        detail.set("e_unconfirmamt", (Object)amount.subtract(confirmedAmt));
                    }
                    if (amount.compareTo(verifiedAmt) > 0) {
                        detail.set("e_unverifyamt", (Object)amount.subtract(verifiedAmt));
                        finArBill.set("unverifyamount", (Object)finArBill.getBigDecimal("unverifyamount").add(diffAmount));
                    }
                }
            }
            BigDecimal headAmount = finArBill.getBigDecimal("amount").add(diffAmount);
            BigDecimal headLocalAmt = finArBill.getBigDecimal("localamt").add(diffLocalAmt);
            finArBill.set("amount", (Object)headAmount);
            finArBill.set("localamt", (Object)headLocalAmt);
            finArBill.set("tax", (Object)finArBill.getBigDecimal("tax").add(diffTax));
            finArBill.set("taxlocamt", (Object)finArBill.getBigDecimal("taxlocamt").add(diffTaxLocal));
            if (BigDecimal.ZERO.compareTo(diffRecAmount) != 0 || BigDecimal.ZERO.compareTo(diffRecLocalAmt) != 0) {
                detail.set("e_recamount", (Object)repairObjVO.getSimIssuedTotalFormTaxAmount());
                detail.set("e_reclocalamt", (Object)repairObjVO.getSimIssuedTotalTaxAmount());
                detail.set("e_unlockamt", (Object)detail.getBigDecimal("e_unlockamt").add(diffRecAmount));
                detail.set("e_unsettleamt", (Object)detail.getBigDecimal("e_unsettleamt").add(diffRecAmount));
                detail.set("e_unsettlelocalamt", (Object)detail.getBigDecimal("e_unsettlelocalamt").add(diffRecLocalAmt));
                detail.set("e_invoicedamt", (Object)detail.getBigDecimal("e_invoicedamt").add(diffRecAmount));
                detail.set("e_invoicedlocalamt", (Object)detail.getBigDecimal("e_invoicedlocalamt").add(diffRecLocalAmt));
                DynamicObjectCollection planEntity = finArBill.getDynamicObjectCollection("planentity");
                BigDecimal planHasUseAmt = BigDecimal.ZERO;
                Object planHasUseLocalAmt = BigDecimal.ZERO;
                for (int i = 0; i < planEntity.size(); ++i) {
                    DynamicObject planRow = (DynamicObject)planEntity.get(i);
                    BigDecimal oldPlanPriceTax = planRow.getBigDecimal("planpricetax");
                    BigDecimal oldPlanPriceLocalTax = planRow.getBigDecimal("planpricetaxloc");
                    BigDecimal diffPlanAmt = BigDecimal.ZERO;
                    BigDecimal diffPlanLocalAmt = BigDecimal.ZERO;
                    if (i == planEntity.size() - 1) {
                        diffPlanAmt = diffRecAmount.subtract(planHasUseAmt);
                        diffPlanLocalAmt = diffRecLocalAmt.subtract((BigDecimal)planHasUseLocalAmt);
                    } else {
                        BigDecimal rate = oldPlanPriceTax.divide(oldHeadRecAmount, 10, 4);
                        diffPlanAmt = diffRecAmount.multiply(rate).setScale(precision, 4);
                        BigDecimal localRate = oldPlanPriceLocalTax.divide(oldHeadRecLocalAmt, 10, 4);
                        diffPlanLocalAmt = diffRecLocalAmt.multiply(localRate).setScale(basePrecision, 4);
                    }
                    planHasUseAmt = planHasUseAmt.add(diffPlanAmt);
                    planHasUseLocalAmt = ((BigDecimal)planHasUseLocalAmt).add(diffPlanLocalAmt);
                    planRow.set("planpricetax", (Object)planRow.getBigDecimal("planpricetax").add(diffPlanAmt));
                    planRow.set("planpricetaxloc", (Object)planRow.getBigDecimal("planpricetaxloc").add(diffPlanLocalAmt));
                    planRow.set("unplanlockamt", (Object)planRow.getBigDecimal("unplanlockamt").add(diffPlanAmt));
                    planRow.set("unplansettleamt", (Object)planRow.getBigDecimal("unplansettleamt").add(diffPlanAmt));
                    planRow.set("unplansettlelocamt", (Object)planRow.getBigDecimal("unplansettlelocamt").add(diffPlanLocalAmt));
                }
                finArBill.set("recamount", (Object)oldHeadRecAmount.add(diffRecAmount));
                finArBill.set("reclocalamt", (Object)finArBill.getBigDecimal("reclocalamt").add(diffRecLocalAmt));
                finArBill.set("unsettleamount", (Object)finArBill.getBigDecimal("unsettleamount").add(diffRecAmount));
                finArBill.set("unsettlelocalamt", (Object)finArBill.getBigDecimal("unsettlelocalamt").add(diffRecLocalAmt));
                finArBill.set("invoicedamt", (Object)finArBill.getBigDecimal("invoicedamt").add(diffRecAmount));
                finArBill.set("invoicedlocalamt", (Object)finArBill.getBigDecimal("invoicedlocalamt").add(diffRecLocalAmt));
                if ("settled".equals(finArBill.getString("settlestatus"))) {
                    finArBill.set("settlestatus", (Object)"partsettle");
                }
            }
            if (!ObjectUtils.isEmpty(paramMap) && (ar005 = paramMap.get("ar_005")) != null && ((Boolean)ar005).booleanValue() && revcfmBill != null) {
                DynamicObjectCollection revcfmEntry = revcfmBill.getDynamicObjectCollection("entry");
                logger.info("ArOriginalWFRecordWriteOffPlugin executeRepired revcfmBill size  = " + revcfmEntry.size());
                for (DynamicObject revcfmRow : revcfmEntry) {
                    if (detail.getLong("id") != revcfmRow.getLong("e_sourcebillentryid")) continue;
                    BigDecimal confirmAmt = revcfmRow.getBigDecimal("e_confirmamt").add(diffAmount);
                    revcfmRow.set("e_amount", (Object)repairObjVO.getSimIssuedFormAmount());
                    revcfmRow.set("e_localamt", (Object)repairObjVO.getSimIssuedAmount());
                    revcfmRow.set("e_confirmamt", (Object)confirmAmt);
                    BigDecimal confirmTax = revcfmRow.getBigDecimal("e_confirmtax");
                    logger.info("ArOriginalWFRecordWriteOffPlugin executeRepired confirmtax = " + confirmTax);
                    logger.info("ArOriginalWFRecordWriteOffPlugin executeRepired diffTax = " + diffTax);
                    BigDecimal confirmTaxLoc = revcfmRow.getBigDecimal("e_confirmloctax");
                    BigDecimal confirmAmtLoc = revcfmRow.getBigDecimal("e_confirmlocamt");
                    if (confirmTax == null || confirmTaxLoc == null || confirmAmtLoc == null) continue;
                    confirmTax = confirmTax.add(diffTax);
                    revcfmRow.set("e_confirmtax", (Object)confirmTax);
                    revcfmRow.set("e_confirmloctax", (Object)confirmTaxLoc.add(diffTaxLocal));
                    revcfmRow.set("e_confirmlocamt", (Object)confirmAmtLoc.add(diffLocalAmt));
                    revcfmRow.set("e_cfmpricetax", (Object)confirmAmt.add(confirmTax));
                    revcfmRow.set("e_cfmpricetaxbase", (Object)confirmAmtLoc.add(diffLocalAmt).add(confirmTaxLoc.add(diffTaxLocal)));
                    revcfmRow.set("e_recamt", (Object)confirmAmt);
                    revcfmRow.set("e_tax", (Object)revcfmRow.getBigDecimal("e_tax").add(diffTax));
                    revcfmRow.set("e_taxlocalamt", (Object)revcfmRow.getBigDecimal("e_taxlocalamt").add(diffTaxLocal));
                    revcfmRow.set("e_pricetaxtotal", (Object)revcfmRow.getBigDecimal("e_pricetaxtotal").add(diffRecAmount));
                    revcfmRow.set("e_pricetaxtotalbase", (Object)revcfmRow.getBigDecimal("e_pricetaxtotalbase").add(diffRecLocalAmt));
                }
                revcfmBill.set("amount", (Object)revcfmBill.getBigDecimal("amount").add(diffAmount));
                revcfmBill.set("localamt", (Object)revcfmBill.getBigDecimal("localamt").add(diffLocalAmt));
                revcfmBill.set("confirmamt", (Object)revcfmBill.getBigDecimal("confirmamt").add(diffAmount));
                revcfmBill.set("confirmlocamt", (Object)revcfmBill.getBigDecimal("confirmlocamt").add(diffLocalAmt));
                revcfmBill.set("tax", (Object)revcfmBill.getBigDecimal("tax").add(diffTax));
                revcfmBill.set("taxlocamt", (Object)revcfmBill.getBigDecimal("taxlocamt").add(diffTaxLocal));
                revcfmBill.set("pricetaxtotal", (Object)revcfmBill.getBigDecimal("pricetaxtotal").add(diffRecAmount));
                revcfmBill.set("pricetaxtotalbase", (Object)revcfmBill.getBigDecimal("pricetaxtotalbase").add(diffRecLocalAmt));
                long revcfId = revcfmBill.getLong("id");
                revcfIdMap.put(revcfId, diffAmtMap);
                needToSaveRevcfmBillMap.put(revcfId, revcfmBill);
            }
            if (arOriginalSet != null && arOriginalSet.size() != 0) {
                logger.info("ArOriginalWFRecordWriteOffPlugin executeRepired arOriginalSet size:" + arOriginalSet.size());
                long finArBillEntryId = detail.getLong("id");
                for (DynamicObject arOriginal : arOriginalSet) {
                    boolean verifyFieldRepaired = false;
                    long arOriginalId = arOriginal.getLong("id");
                    logger.info("---------ArOriginalWFRecordWriteOffPlugin executeRepired arOriginalId:" + arOriginalId);
                    long finArEntryId = detail.getLong("id");
                    DynamicObjectCollection entryColl = arOriginal.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entryColl) {
                        boolean isWrittenoff = entry.getBoolean("e_iswrittenoff");
                        boolean hasWrittenoff = entry.getBoolean("e_hadwrittenoff");
                        long mainBillEntryId = entry.getLong("billentryid");
                        logger.info("---------ArOriginalWFRecordWriteOffPlugin executeRepired mainBillEntryId:" + mainBillEntryId);
                        if (mainBillEntryId != finArBillEntryId) continue;
                        entry.set("amount", (Object)repairObjVO.getSimIssuedFormAmount());
                        entry.set("localamt", (Object)repairObjVO.getSimIssuedAmount());
                        entry.set("tax", (Object)repairObjVO.getSimIssuedFormTax());
                        entry.set("loctax", (Object)repairObjVO.getSimIssuedTax());
                        if (BigDecimal.ZERO.compareTo(diffRecAmount) != 0 || BigDecimal.ZERO.compareTo(diffRecLocalAmt) != 0) {
                            entry.set("pricetaxtotal", (Object)repairObjVO.getSimIssuedTotalFormTaxAmount());
                            entry.set("locpricetaxtotal", (Object)repairObjVO.getSimIssuedTotalTaxAmount());
                        }
                        if (isWrittenoff || hasWrittenoff || mainBillEntryId != finArEntryId || verifyFieldRepaired) continue;
                        entry.set("verifyamt", (Object)entry.getBigDecimal("verifyamt").add(diffAmount));
                        entry.set("verifylocamt", (Object)entry.getBigDecimal("verifylocamt").add(diffLocalAmt));
                        entry.set("verifytax", (Object)entry.getBigDecimal("verifytax").add(diffTax));
                        entry.set("verifyloctax", (Object)entry.getBigDecimal("verifyloctax").add(diffTaxLocal));
                        entry.set("verifypricetax", (Object)entry.getBigDecimal("verifypricetax").add(diffRecAmount));
                        entry.set("verifylocpricetax", (Object)entry.getBigDecimal("verifylocpricetax").add(diffRecLocalAmt));
                        verifyFieldRepaired = true;
                    }
                    arOriginalIdMap.put(arOriginalId, diffAmtMap);
                    needToSaveArOriginalRecordMap.put(arOriginalId, arOriginal);
                }
            }
            finArIdMap.put(finArBillId, diffAmtMap);
            needToSaveFinArBillMap.put(finArBillId, finArBill);
        }
        if (!ObjectUtils.isEmpty(needToSaveFinArBillMap)) {
            logger.info("ArOriginalWFRecordWriteOffPlugin execute finarbill save");
            DynamicObject[] needSaveFinArArray = needToSaveFinArBillMap.values().toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])needSaveFinArArray);
            this.addLog("ar_finarbill", arBillArray, addLogParamList, finArIdMap);
        }
        if (!ObjectUtils.isEmpty(needToSaveRevcfmBillMap)) {
            logger.info("ArOriginalWFRecordWriteOffPlugin execute revcfmBill save");
            DynamicObject[] needToSaveRevcfArray = needToSaveRevcfmBillMap.values().toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])needToSaveRevcfArray);
            this.addLog("ar_revcfmbill", this.prepareRevcfmBillMap.values().toArray(new DynamicObject[0]), addLogParamList, revcfIdMap);
        }
        if (!ObjectUtils.isEmpty(needToSaveArOriginalRecordMap)) {
            logger.info("ArOriginalWFRecordWriteOffPlugin execute aroriginalwfrecord save");
            DynamicObject[] needToSaveArOriginalArray = needToSaveArOriginalRecordMap.values().toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])needToSaveArOriginalArray);
            this.addLog("ar_originalwfrecord", (DynamicObject[])arOriginalMap.values().stream().flatMap(Collection::stream).distinct().toArray(DynamicObject[]::new), addLogParamList, arOriginalIdMap);
        }
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"ap_stdconfig", (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"aroriginaladdlog")});
        try {
            if (ObjectUtils.isEmpty((Object)queryOne) || "false".equals(queryOne.getString("key"))) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ArOriginalAdjustLogService", (String)"addLog", (Object[])new Object[]{JSON.toJSONString(addLogParamList)});
            }
        }
        catch (Exception e) {
            logger.info("ArOriginalWFRecordWriteOffPlugin to call addLogService failed : " + e.getMessage());
        }
    }

    private Map<Long, Set<DynamicObject>> prepareArOriginalRecords(List<NeedRepairObjVO> repairObjVOS) {
        HashSet<Long> repairFinArIds = new HashSet<Long>(repairObjVOS.size());
        HashSet<Long> orgIdSet = new HashSet<Long>(repairObjVOS.size());
        for (NeedRepairObjVO repairObjVO : repairObjVOS) {
            DynamicObject finArBill = repairObjVO.getFinArBill();
            orgIdSet.add(finArBill.getLong("org.id"));
            repairFinArIds.add(finArBill.getLong("id"));
        }
        DynamicObject[] arOriginalArray = BusinessDataServiceHelper.load((String)"ar_originalwfrecord", (String)"entry.billno,entry.amount,entry.localamt,entry.tax,entry.loctax,entry.pricetaxtotal,entry.locpricetaxtotal,entry.verifyqty,entry.verifyamt,entry.verifylocamt,entry.verifytax,entry.verifyloctax,entry.verifypricetax,entry.verifylocpricetax,entry.billid,entry.billentryid,entry.assverifyqty,entry.assverifyamt,entry.assverifylocamt,entry.assverifytax,entry.assverifyloctax,entry.assverifypricetax,entry.assverifylocpricetax,entry.assbillid,entry.assbillentryid,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIdSet), new QFilter("entry.billid", "in", repairFinArIds)});
        HashMap<Long, Set<DynamicObject>> resultMap = new HashMap<Long, Set<DynamicObject>>(arOriginalArray.length);
        for (DynamicObject arOriginal : arOriginalArray) {
            DynamicObjectCollection entryColl = arOriginal.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                long arBillId = entry.getLong("billid");
                Set arOriginalSet = resultMap.getOrDefault(arBillId, new HashSet(8));
                arOriginalSet.add(arOriginal);
                resultMap.put(arBillId, arOriginalSet);
            }
        }
        return resultMap;
    }

    private void filterNeedRepairFinAr(List<DynamicObject> records, List<NeedRepairObjVO> repairObjVOS4AdjSrcBill, List<NeedRepairObjVO> repairObjVOS4GenAdjBill) {
        HashSet<Long> arBillIdSet = new HashSet<Long>(records.size());
        for (DynamicObject record : records) {
            DynamicObjectCollection entryColl = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                arBillIdSet.add(entry.getLong("billid"));
            }
        }
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)this.getSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", arBillIdSet)});
        ArrayList<Long> finArOrgIds = new ArrayList<Long>(finArBills.length);
        ArrayList<Long> finArEntryIds = new ArrayList<Long>(finArBills.length);
        for (DynamicObject finArBill2 : finArBills) {
            finArOrgIds.add(finArBill2.getLong("org.id"));
            DynamicObjectCollection entry = finArBill2.getDynamicObjectCollection("entry");
            List rowIds = entry.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            if (ObjectUtils.isEmpty(rowIds)) continue;
            finArEntryIds.addAll(rowIds);
        }
        this.orgIdParamMap = SystemParameterHelper.batchGetAppParameters(Boolean.TRUE, finArOrgIds, "ar_026", "ar_005", "ar026_type");
        Map<Long, DynamicObject> adjustMap = this.prepareAdjustBill(finArOrgIds, arBillIdSet, finArEntryIds);
        this.prepareRevcfmBillMap = this.prepareRevcfmBills(arBillIdSet);
        Map<Long, Set<Long>> targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap("ar_finarbill", "entry", finArEntryIds.toArray(new Long[0]), "sim_original_bill");
        Set<Long> botpExistOriIdSet = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map<Long, Set<DynamicObject>> recordEntryIdOriginalMap = this.getRecordEntryIdOriginalMap(finArEntryIds, targetRowIdsMap);
        Map<Long, DynamicObject> simEntryObjMap = this.prepareSimBills(targetRowIdsMap);
        Map<Long, Set<DynamicObject>> finArEntryIdToVerifyRecordMap = this.getFinArEntryIdToVerifyRecordMap(finArEntryIds);
        HashMap needCompareAmtInfo = new HashMap(finArEntryIdToVerifyRecordMap.size());
        for (Map.Entry<Long, Set<DynamicObject>> entry : finArEntryIdToVerifyRecordMap.entrySet()) {
            Long finArEntryId = entry.getKey();
            Set<DynamicObject> verifyRecords = entry.getValue();
            for (DynamicObject verifyRecord : verifyRecords) {
                BigDecimal assverifyamt = verifyRecord.getBigDecimal("entry.assverifyamt");
                BigDecimal assverifylocamt = verifyRecord.getBigDecimal("entry.assverifylocamt");
                BigDecimal assverifytax = verifyRecord.getBigDecimal("entry.assverifytax");
                BigDecimal assverifyloctax = verifyRecord.getBigDecimal("entry.assverifyloctax");
                BigDecimal assverifypricetax = verifyRecord.getBigDecimal("entry.assverifypricetax");
                BigDecimal assverifylocpricetax = verifyRecord.getBigDecimal("entry.assverifylocpricetax");
                Map needCompareFinArEntryInfo = (Map)needCompareAmtInfo.get(finArEntryId);
                if (needCompareFinArEntryInfo == null) {
                    HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(1);
                    result.put("assverifyamt", assverifyamt);
                    result.put("assverifylocamt", assverifylocamt);
                    result.put("assverifytax", assverifytax);
                    result.put("assverifyloctax", assverifyloctax);
                    result.put("assverifypricetax", assverifypricetax);
                    result.put("assverifylocpricetax", assverifylocpricetax);
                    needCompareAmtInfo.put(finArEntryId, result);
                    continue;
                }
                needCompareFinArEntryInfo.put("assverifyamt", ((BigDecimal)needCompareFinArEntryInfo.get("assverifyamt")).add(assverifyamt));
                needCompareFinArEntryInfo.put("assverifylocamt", ((BigDecimal)needCompareFinArEntryInfo.get("assverifylocamt")).add(assverifylocamt));
                needCompareFinArEntryInfo.put("assverifytax", ((BigDecimal)needCompareFinArEntryInfo.get("assverifytax")).add(assverifytax));
                needCompareFinArEntryInfo.put("assverifyloctax", ((BigDecimal)needCompareFinArEntryInfo.get("assverifyloctax")).add(assverifyloctax));
                needCompareFinArEntryInfo.put("assverifypricetax", ((BigDecimal)needCompareFinArEntryInfo.get("assverifypricetax")).add(assverifypricetax));
                needCompareFinArEntryInfo.put("assverifylocpricetax", ((BigDecimal)needCompareFinArEntryInfo.get("assverifylocpricetax")).add(assverifylocpricetax));
            }
        }
        this.updateSimEntryObj(simEntryObjMap, recordEntryIdOriginalMap, botpExistOriIdSet, finArEntryIdToVerifyRecordMap);
        Map<Long, DynamicObject> idFinArBillMap = Arrays.stream(finArBills).collect(Collectors.toMap(finArBill -> finArBill.getLong("id"), finArBill -> finArBill));
        HashSet<Long> dealFinArIdSet = new HashSet<Long>(finArBills.length);
        Map<Long, Date> closeCountDateMap = this.getOrgCloseCountDate(finArOrgIds);
        for (DynamicObject record : records) {
            DynamicObjectCollection entryColl = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                ArrayList<NeedRepairObjVO> repairObjList = new ArrayList<NeedRepairObjVO>(2);
                boolean isNoRepair = false;
                long recordMainId = entry.getLong("billid");
                if (dealFinArIdSet.contains(recordMainId)) continue;
                dealFinArIdSet.add(recordMainId);
                DynamicObject finArBill3 = idFinArBillMap.get(recordMainId);
                long finArBillId = finArBill3.getLong("id");
                long orgId = finArBill3.getLong("org.id");
                Date closeDate = closeCountDateMap.get(orgId);
                if (closeDate != null && closeDate.compareTo(finArBill3.getDate("bookdate")) > 0) {
                    logger.info("ArOriginalWFRecordWriteOffPlugin is filtered , because by closeDate ;");
                    continue;
                }
                Map<String, Object> paramMap = this.orgIdParamMap.get(orgId);
                if (ObjectUtils.isEmpty(paramMap)) continue;
                Object ar026 = paramMap.get("ar_026");
                boolean isGenAdjBill = "1".equals(paramMap.get("ar026_type"));
                DynamicObject revcfmBill = this.prepareRevcfmBillMap.get(finArBillId);
                if (ar026 == null || !((Boolean)ar026).booleanValue()) {
                    logger.info("ArOriginalWFRecordWriteOffPlugin is filtered , because ar_026 is : " + ar026);
                    continue;
                }
                if (!isGenAdjBill && (finArBill3.getBoolean("isvoucher") || revcfmBill != null && revcfmBill.getBoolean("isvoucher"))) {
                    logger.info("ArOriginalWFRecordWriteOffPlugin is filt ered , because isvoucher is true");
                    continue;
                }
                BigDecimal unInvoicedAmt = finArBill3.getBigDecimal("uninvoicedamt");
                BigDecimal invoicedAmt = finArBill3.getBigDecimal("invoicedamt");
                BigDecimal recAmount = finArBill3.getBigDecimal("recamount");
                if (BigDecimal.ZERO.compareTo(unInvoicedAmt) != 0 || invoicedAmt.compareTo(recAmount) != 0) {
                    logger.info("ArOriginalWFRecordWriteOffPlugin is filtered,Because not fully invoiced uninvoicedamt = {},invoicedamt = {}, recamount={}", new Object[]{unInvoicedAmt, invoicedAmt, recAmount});
                    continue;
                }
                DynamicObjectCollection arEntry = finArBill3.getDynamicObjectCollection("entry");
                for (int i = 0; i < arEntry.size(); ++i) {
                    BigDecimal eSettledAmt;
                    NeedRepairObjVO repairObjVO = new NeedRepairObjVO();
                    DynamicObject detail = (DynamicObject)arEntry.get(i);
                    DynamicObject adjustBill = adjustMap.get(detail.getLong("id"));
                    if (adjustBill != null) {
                        isNoRepair = true;
                        break;
                    }
                    BigDecimal simIssuedAmount = BigDecimal.ZERO;
                    BigDecimal simIssuedTax = BigDecimal.ZERO;
                    BigDecimal simIssuedTotalTaxAmount = BigDecimal.ZERO;
                    BigDecimal simIssuedLocalAmt = BigDecimal.ZERO;
                    BigDecimal simIssuedLocalTax = BigDecimal.ZERO;
                    BigDecimal simIssuedTotalTaxLocalAmt = BigDecimal.ZERO;
                    Set<Long> simEntryIds = targetRowIdsMap.get(detail.getLong("id"));
                    if (!ObjectUtils.isEmpty(simEntryIds)) {
                        for (Long simEntryId : simEntryIds) {
                            DynamicObject simEntryObj = simEntryObjMap.get(simEntryId);
                            if (simEntryObj == null) continue;
                            BigDecimal tempAmt = simEntryObj.getBigDecimal("issuedamount").add(simEntryObj.getBigDecimal("amountdeviation"));
                            String validState = simEntryObj.getString("validstate");
                            String closeState = simEntryObj.getString("closestatus");
                            BigDecimal entryAmount = simEntryObj.getBigDecimal("amount");
                            if (!(!botpExistOriIdSet.contains(simEntryId) || entryAmount.compareTo(tempAmt) == 0 || "0".equals(validState) && "1".equals(closeState))) {
                                logger.info(String.format("ArOriginalWFRecordWriteOffPlugin is filtered,validState is [%s],tempAmt is [%s],amount is [%s],closeState is [%s]", validState, tempAmt, entryAmount, closeState));
                                isNoRepair = true;
                                break;
                            }
                            BigDecimal exrate = simEntryObj.getBigDecimal("exrate");
                            if (BigDecimal.ONE.compareTo(exrate) == 0) {
                                simIssuedAmount = simIssuedAmount.add(simEntryObj.getBigDecimal("issuedamount"));
                                simIssuedTax = simIssuedTax.add(simEntryObj.getBigDecimal("issuedtax"));
                                simIssuedTotalTaxAmount = simIssuedTotalTaxAmount.add(simEntryObj.getBigDecimal("issuedtotaltaxamount"));
                            } else {
                                simIssuedAmount = simIssuedAmount.add(simEntryObj.getBigDecimal("fromissuedamount"));
                                simIssuedTax = simIssuedTax.add(simEntryObj.getBigDecimal("fromissuedtax"));
                                simIssuedTotalTaxAmount = simIssuedTotalTaxAmount.add(simEntryObj.getBigDecimal("fromissuedtaxamount"));
                            }
                            simIssuedLocalAmt = simIssuedLocalAmt.add(simEntryObj.getBigDecimal("issuedamount"));
                            simIssuedLocalTax = simIssuedLocalTax.add(simEntryObj.getBigDecimal("issuedtax"));
                            simIssuedTotalTaxLocalAmt = simIssuedTotalTaxLocalAmt.add(simEntryObj.getBigDecimal("issuedtotaltaxamount"));
                        }
                    }
                    if (isNoRepair) break;
                    if (!isGenAdjBill && simIssuedTotalTaxAmount.compareTo(eSettledAmt = detail.getBigDecimal("e_settledamt")) < 0) {
                        logger.info(String.format("ArOriginalWFRecordWriteOffPlugin is filtered,simIssuedTotalTaxAmount is [%s],eSettledAmt is [%s]", simIssuedTotalTaxAmount, eSettledAmt));
                        continue;
                    }
                    long finArEntryId = detail.getLong("id");
                    BigDecimal eRecAmount = detail.getBigDecimal("e_recamount");
                    BigDecimal eRecLocalAmt = detail.getBigDecimal("e_reclocalamt");
                    BigDecimal eAmount = detail.getBigDecimal("e_amount");
                    BigDecimal eLocalAmount = detail.getBigDecimal("e_localamt");
                    BigDecimal eTax = detail.getBigDecimal("e_tax");
                    Map entryCompareAmtInfo = (Map)needCompareAmtInfo.get(finArEntryId);
                    logger.info(String.format("ArOriginalWFRecordWriteOffPlugin compare: eAmount is [%s],eTax is [%s],eRecAmount is [%s],entryCompareAmtInfo is [%s]", eAmount, eTax, eRecAmount, entryCompareAmtInfo));
                    if (ObjectUtils.isEmpty((Object)entryCompareAmtInfo)) continue;
                    if (eAmount.compareTo((BigDecimal)entryCompareAmtInfo.get("assverifyamt")) == 0 && eTax.compareTo((BigDecimal)entryCompareAmtInfo.get("assverifytax")) == 0 && eRecAmount.compareTo((BigDecimal)entryCompareAmtInfo.get("assverifypricetax")) == 0 && eLocalAmount.compareTo((BigDecimal)entryCompareAmtInfo.get("assverifylocamt")) == 0 && eRecLocalAmt.compareTo((BigDecimal)entryCompareAmtInfo.get("assverifylocpricetax")) == 0) {
                        logger.info(String.format("ArOriginalWFRecordWriteOffPlugin is filtered,eAmount is [%s],eTax is [%s],eRecAmount is [%s],entryCompareAmtInfo is [%s]", eAmount, eTax, eRecAmount, entryCompareAmtInfo));
                        continue;
                    }
                    repairObjVO.setFinArBill(finArBill3);
                    repairObjVO.setIndex(i);
                    repairObjVO.setSimIssuedAmount((BigDecimal)entryCompareAmtInfo.get("assverifylocamt"));
                    repairObjVO.setSimIssuedTax((BigDecimal)entryCompareAmtInfo.get("assverifyloctax"));
                    repairObjVO.setSimIssuedTotalTaxAmount((BigDecimal)entryCompareAmtInfo.get("assverifylocpricetax"));
                    repairObjVO.setSimIssuedFormAmount((BigDecimal)entryCompareAmtInfo.get("assverifyamt"));
                    repairObjVO.setSimIssuedFormTax((BigDecimal)entryCompareAmtInfo.get("assverifytax"));
                    repairObjVO.setSimIssuedTotalFormTaxAmount((BigDecimal)entryCompareAmtInfo.get("assverifypricetax"));
                    repairObjList.add(repairObjVO);
                }
                if (isNoRepair) continue;
                if (isGenAdjBill) {
                    repairObjVOS4GenAdjBill.addAll(repairObjList);
                    continue;
                }
                repairObjVOS4AdjSrcBill.addAll(repairObjList);
            }
        }
    }

    private void addLog(String entityName, DynamicObject[] billArray, List<Map<String, Object>> addLogParamList, Map<Long, Map<String, BigDecimal>> billIdMap) {
        for (DynamicObject bill : billArray) {
            HashMap<String, Object> addLogParamMap = new HashMap<String, Object>(8);
            addLogParamMap.put("entityName", entityName);
            addLogParamMap.put("opName", "afterRepairTailData");
            addLogParamMap.put("opDesc", entityName);
            addLogParamMap.put("ignoreLogParam", true);
            Map<String, Object> addObjJsonStrMap = this.addObjJsonStr(bill, entityName, billIdMap);
            addLogParamMap.put("objJsonStr", SerializationUtils.toJsonString(addObjJsonStrMap));
            if ("ar_finarbill".equals(entityName) || "ar_revcfmbill".equals(entityName)) {
                addLogParamMap.put("billno", bill.getString("billno"));
            } else {
                addLogParamMap.put("billno", "");
            }
            addLogParamList.add(addLogParamMap);
        }
    }

    private Map<String, Object> addObjJsonStr(DynamicObject bill, String entityName, Map<Long, Map<String, BigDecimal>> billIdMap) {
        long billId;
        Map<String, BigDecimal> diffMap;
        HashMap<String, Object> objJsonStrMap = new HashMap<String, Object>(8);
        if ("ar_finarbill".equals(entityName)) {
            BigDecimal amount = bill.getBigDecimal("amount");
            BigDecimal localAmt = bill.getBigDecimal("localamt");
            BigDecimal tax = bill.getBigDecimal("tax");
            BigDecimal locamtTax = bill.getBigDecimal("taxlocamt");
            BigDecimal recAmount = bill.getBigDecimal("recamount");
            BigDecimal recLocalAmt = bill.getBigDecimal("reclocalamt");
            objJsonStrMap.put("amount", amount);
            objJsonStrMap.put("localAmt", localAmt);
            objJsonStrMap.put("tax", tax);
            objJsonStrMap.put("locamtTax", locamtTax);
            objJsonStrMap.put("recAmount", recAmount);
            objJsonStrMap.put("recLocalAmt", recLocalAmt);
            return objJsonStrMap;
        }
        if ("ar_revcfmbill".equals(entityName)) {
            BigDecimal amount = bill.getBigDecimal("amount");
            BigDecimal localAmt = bill.getBigDecimal("localamt");
            BigDecimal confirmAmt = bill.getBigDecimal("confirmamt");
            BigDecimal confirmLocAmt = bill.getBigDecimal("confirmlocamt");
            objJsonStrMap.put("amount", amount);
            objJsonStrMap.put("localAmt", localAmt);
            objJsonStrMap.put("confirmAmt", confirmAmt);
            objJsonStrMap.put("confirmLocAmt", confirmLocAmt);
            return objJsonStrMap;
        }
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("entry");
        ArrayList<String> entryParamList = new ArrayList<String>(entryColl.size());
        if (entryColl.size() <= 100) {
            for (DynamicObject entry : entryColl) {
                HashMap<String, Object> entryParamMap = new HashMap<String, Object>(entryColl.size());
                BigDecimal entryAmt = entry.getBigDecimal("amount");
                BigDecimal entryLocAmt = entry.getBigDecimal("localamt");
                BigDecimal entryTax = entry.getBigDecimal("tax");
                BigDecimal entryLocTax = entry.getBigDecimal("loctax");
                BigDecimal entryPriceTax = entry.getBigDecimal("pricetaxtotal");
                BigDecimal entryLocPriceTaxTotal = entry.getBigDecimal("locpricetaxtotal");
                BigDecimal verifyAmt = entry.getBigDecimal("verifyamt");
                BigDecimal verifyLocAmt = entry.getBigDecimal("verifylocamt");
                BigDecimal verifyTax = entry.getBigDecimal("verifytax");
                BigDecimal verifyLocTax = entry.getBigDecimal("verifyloctax");
                BigDecimal verifyPriceTax = entry.getBigDecimal("verifypricetax");
                BigDecimal verifyLocPriceTax = entry.getBigDecimal("verifylocpricetax");
                entryParamMap.put("entryAmt", entryAmt);
                entryParamMap.put("entryLocAmt", entryLocAmt);
                entryParamMap.put("entryTax", entryTax);
                entryParamMap.put("entryLocTax", entryLocTax);
                entryParamMap.put("entryPriceTax", entryPriceTax);
                entryParamMap.put("entryLocPriceTaxTotal", entryLocPriceTaxTotal);
                entryParamMap.put("verifyAmt", verifyAmt);
                entryParamMap.put("verifyLocAmt", verifyLocAmt);
                entryParamMap.put("verifyTax", verifyTax);
                entryParamMap.put("verifyLocTax", verifyLocTax);
                entryParamMap.put("verifyPriceTax", verifyPriceTax);
                entryParamMap.put("verifyLocPriceTax", verifyLocPriceTax);
                entryParamMap.put("billno", entry.getString("billno"));
                entryParamList.add(JSONObject.toJSONString(entryParamMap));
            }
            objJsonStrMap.put("entry", entryParamList);
        }
        if (ObjectUtils.isEmpty(diffMap = billIdMap.get(billId = bill.getLong("id")))) {
            return objJsonStrMap;
        }
        objJsonStrMap.put("diffTax", diffMap.get("diffTax"));
        objJsonStrMap.put("diffAmount", diffMap.get("diffAmount"));
        objJsonStrMap.put("diffTaxLocal", diffMap.get("diffTaxLocal"));
        objJsonStrMap.put("diffLocalAmt", diffMap.get("diffLocalAmt"));
        objJsonStrMap.put("diffRecAmount", diffMap.get("diffRecAmount"));
        objJsonStrMap.put("diffRecLocalAmt", diffMap.get("diffRecAmount"));
        return objJsonStrMap;
    }

    private Map<Long, DynamicObject> prepareAdjustBill(List<Long> finArOrgIds, Set<Long> finArIds, List<Long> finArEntryIds) {
        DynamicObjectCollection adjustBillColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"entry.e_srcid,entry.e_srcentryid", (QFilter[])new QFilter[]{new QFilter("org.id", "in", finArOrgIds), new QFilter("entry.e_srcid", "in", finArIds), new QFilter("entry.e_srcentryid", "in", finArEntryIds), new QFilter("billsrctype", "=", (Object)"4"), new QFilter("billtype.number", "=", (Object)"arfin_borrowar_BT_S"), new QFilter("adjusttype", "=", (Object)"adjustinv"), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE)});
        return adjustBillColl.stream().collect(Collectors.toMap(bill -> bill.getLong("entry.e_srcentryid"), bill -> bill, (m, n) -> n));
    }

    private Map<Long, DynamicObject> prepareRevcfmBills(Set<Long> arBillIdSet) {
        DynamicObject[] revcfmBillArray = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"billno,sourcebillid,amount,localamt,confirmamt,confirmlocamt,verifystatus,entry.e_sourcebillentryid,entry.e_amount,entry.e_localamt,entry.e_confirmamt,entry.e_unverifyamt,org,unverifyamt,entry.e_recamt,entry.e_cfmpricetax,entry.e_cfmpricetaxbase,entry.e_confirmtax,entry.e_confirmloctax,entry.e_confirmlocamt,isvoucher,entry.e_tax,entry.e_taxlocalamt,entry.e_pricetaxtotal,entry.e_pricetaxtotalbase,tax,taxlocamt,pricetaxtotal,pricetaxtotalbase", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", arBillIdSet)});
        HashMap<Long, DynamicObject> revcfmMap = new HashMap<Long, DynamicObject>(revcfmBillArray.length);
        for (DynamicObject revcfmBill : revcfmBillArray) {
            Object ar005;
            long orgId = revcfmBill.getLong("org.id");
            Map<String, Object> paramMap = this.orgIdParamMap.get(orgId);
            if (ObjectUtils.isEmpty(paramMap) || (ar005 = paramMap.get("ar_005")) == null || !((Boolean)ar005).booleanValue()) continue;
            revcfmMap.put(revcfmBill.getLong("sourcebillid"), revcfmBill);
        }
        return revcfmMap;
    }

    private Map<Long, Date> getOrgCloseCountDate(List<Long> finArOrgIds) {
        HashMap<Long, Date> result = new HashMap<Long, Date>(finArOrgIds.size());
        if (!ObjectUtils.isEmpty(finArOrgIds)) {
            DataSet closeDateDataSet = QueryServiceHelper.queryDataSet((String)"queryCloseDateDataSet", (String)"ar_closeaccount", (String)"org,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", finArOrgIds)}, (String)"");
            for (Row row : closeDateDataSet) {
                result.put(row.getLong("org"), row.getDate("currentdate"));
            }
        }
        return result;
    }

    private String getSelectors() {
        return "billno,invoicedate,org,bookdate,settlestatus,asstact,basecurrency,currency,invoicecode,invoiceno,payproperty,relationpay,e_issueinvrecamt,e_uninvoicedamt,e_invoicedamt,issueinvrecamt,uninvoicedamt,invoicedamt,e_recamount,e_quantity,e_invoicedqty,e_uninvoicedqty,e_invoicecode,e_invoiceno,invoicedlocalamt,uninvoicedlocalamt,issueinvreclocalamt,e_taxunitprice,e_issueinvamt,e_issueinvtax,e_issueinvqty,e_invoicedlocalamt,e_uninvoicedlocalamt,e_issueinvlocalamt,e_issueinvlocaltax,e_issueinvreclocalamt,e_reclocalamt,e_settledamt,e_amount,e_localamt,e_tax,recamount,reclocalamt,amount,localamt,tax,e_confirmedamt,e_unverifyamt,e_unlockamt,e_unsettleamt,e_unsettlelocalamt,e_material,planpricetax,planpricetaxloc,unplanlockamt,unplansettleamt,unplansettlelocamt,unsettleamount,unsettlelocalamt,unverifyamount,e_verifiedamt,isvoucher,e_taxlocalamt,taxlocamt,e_expenseitem,entry.id,e_unconfirmamt";
    }

    private void fillMainVerifyRecordCore(DynamicObject entry, long verifyTypeId, DynamicObject mainBill) {
        BigDecimal mainVerifyValue = entry.getBigDecimal("qty");
        logger.info("------ArOriginalWFRecordWriteOffPlugin fillMainVerifyRecordCore mainVerifyValue------" + mainVerifyValue);
        DynamicObject currency = entry.getDynamicObject("currency");
        int amtprecision = currency.getInt("amtprecision");
        BigDecimal taxrate = entry.getBigDecimal("taxrate").divide(new BigDecimal(100));
        BigDecimal unInvoiceAmt = mainBill.getBigDecimal("entry.e_uninvoicedamt");
        BigDecimal unInvoiceLocAmt = mainBill.getBigDecimal("entry.e_uninvoicedlocalamt");
        BigDecimal taxUnitPrice = mainBill.getBigDecimal("entry.e_acttaxunitprice");
        BigDecimal unitPrice = mainBill.getBigDecimal("entry.e_actunitprice");
        String quotation = mainBill.getString("quotation");
        BigDecimal exchangerate = mainBill.getBigDecimal("exchangerate");
        BigDecimal amount = entry.getBigDecimal("amount");
        BigDecimal localAmt = entry.getBigDecimal("localamt");
        BigDecimal tax = entry.getBigDecimal("tax");
        BigDecimal locTax = entry.getBigDecimal("loctax");
        BigDecimal priceTaxtotal = entry.getBigDecimal("pricetaxtotal");
        BigDecimal locPriceTaxtotal = entry.getBigDecimal("locpricetaxtotal");
        BigDecimal billQty = entry.getBigDecimal("billqty");
        if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == verifyTypeId && billQty.compareTo(mainVerifyValue) == 0) {
            logger.info("------ArOriginalWFRecordWriteOffPlugin fillMainVerifyRecordCore QtyBenchBark all verify------");
            entry.set("verifyqty", (Object)mainVerifyValue);
            entry.set("verifyamt", (Object)amount);
            entry.set("verifylocamt", (Object)localAmt);
            entry.set("verifytax", (Object)tax);
            entry.set("verifyloctax", (Object)locTax);
            entry.set("verifypricetax", (Object)priceTaxtotal);
            entry.set("verifylocpricetax", (Object)locPriceTaxtotal);
        } else if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE == verifyTypeId && priceTaxtotal.compareTo(mainVerifyValue) == 0) {
            logger.info("-----ArOriginalWFRecordWriteOffPlugin fillMainVerifyRecordCore AmountBenchBark all verify------");
            if (BigDecimal.ZERO.compareTo(mainVerifyValue) < 0) {
                entry.set("verifyqty", (Object)BigDecimal.ONE);
            } else {
                entry.set("verifyqty", (Object)BigDecimal.ZERO);
            }
            entry.set("verifypricetax", (Object)unInvoiceAmt);
            entry.set("verifylocpricetax", (Object)unInvoiceLocAmt);
            entry.set("verifyamt", (Object)amount);
            entry.set("verifylocamt", (Object)localAmt);
            entry.set("verifytax", (Object)tax);
            entry.set("verifyloctax", (Object)locTax);
        } else if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == verifyTypeId) {
            logger.info("-----ArOriginalWFRecordWriteOffPlugin.fillMainVerifyRecordCore QtyBenchBark Part verify------");
            BigDecimal verifyPriceTax = mainVerifyValue.multiply(taxUnitPrice).setScale(amtprecision, RoundingMode.HALF_UP);
            BigDecimal verifyAmt = mainVerifyValue.multiply(unitPrice).setScale(amtprecision, RoundingMode.HALF_UP);
            this.mainVerifyFieldValue(entry, verifyAmt, verifyPriceTax, exchangerate, amtprecision, quotation, mainVerifyValue);
        } else {
            logger.info("-----ArOriginalWFRecordWriteOffPlugin.fillMainVerifyRecordCore AmountBenchBark Part verify------");
            BigDecimal verifyAmt = mainVerifyValue.divide(BigDecimal.ONE.add(taxrate), amtprecision, RoundingMode.HALF_UP);
            this.mainVerifyFieldValue(entry, verifyAmt, mainVerifyValue, exchangerate, amtprecision, quotation, BigDecimal.ZERO);
        }
    }

    private void fillMainVerifyRecordBotp(DynamicObject entry, long verifyTypeId, DynamicObject mainBill, DynamicObject asstBill) {
        BigDecimal mainVerifyValue = entry.getBigDecimal("qty");
        logger.info("------ArOriginalWFRecordWriteOffPlugin.fillMainVerifyRecordBotp.mainVerifyValue------" + mainVerifyValue);
        DynamicObject currency = entry.getDynamicObject("asscurrency");
        boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
        BigDecimal asstIssueTax = asstBill.getBigDecimal("sim_original_bill_item.issuedtax");
        BigDecimal asstIssueAmt = asstBill.getBigDecimal("sim_original_bill_item.issuedamount");
        BigDecimal asstIssuePriceTax = asstBill.getBigDecimal("sim_original_bill_item.issuedtotaltaxamount");
        BigDecimal asstIssueLocTax = asstBill.getBigDecimal("sim_original_bill_item.fromissuedtax");
        BigDecimal asstIssueLocAmt = asstBill.getBigDecimal("sim_original_bill_item.fromissuedamount");
        BigDecimal asstIssueLocPriceTax = asstBill.getBigDecimal("sim_original_bill_item.fromissuedtaxamount");
        if (HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP == verifyTypeId) {
            BigDecimal asstIssueQty = asstBill.getBigDecimal("sim_original_bill_item.issuednum");
            logger.info("------ArOriginalWFRecordWriteOffPlugin.fillMainVerifyRecordBotp.QtyBenchBark------" + asstIssueQty);
            entry.set("verifyqty", (Object)mainVerifyValue);
        } else if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP == verifyTypeId) {
            BigDecimal issueQty = mainBill.getBigDecimal("entry.e_issueinvqty");
            logger.info("------ArOriginalWFRecordWriteOffPlugin.fillMainVerifyRecordBotp.AmtBenchBark------" + issueQty);
            entry.set("verifyqty", (Object)issueQty);
        }
        entry.set("verifyloctax", (Object)asstIssueTax);
        entry.set("verifylocamt", (Object)asstIssueAmt);
        entry.set("verifylocpricetax", (Object)asstIssuePriceTax);
        if (isForm) {
            entry.set("verifytax", (Object)asstIssueLocTax);
            entry.set("verifyamt", (Object)asstIssueLocAmt);
            entry.set("verifypricetax", (Object)asstIssueLocPriceTax);
        } else {
            entry.set("verifytax", (Object)asstIssueTax);
            entry.set("verifyamt", (Object)asstIssueAmt);
            entry.set("verifypricetax", (Object)asstIssuePriceTax);
        }
    }

    private void fillMainVerifyRecordBotpDiscount(DynamicObject entry, long verifyTypeId, DynamicObject mainBill, Map<String, BigDecimal> entryFieldMap) {
        BigDecimal mainVerifyValue = entry.getBigDecimal("qty");
        logger.info("------ArOriginalWFRecordWriteOffPlugin.fillMainVerifyRecordBotpDiscount.mainVerifyValue------" + mainVerifyValue);
        DynamicObject currency = entry.getDynamicObject("asscurrency");
        boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
        BigDecimal issuedNum = entryFieldMap.get("issuedNum");
        BigDecimal issuedTax = entryFieldMap.get("issuedTax");
        BigDecimal issuedAmt = entryFieldMap.get("issuedAmt");
        BigDecimal issuedLocTax = entryFieldMap.get("issuedLocTax");
        BigDecimal issuedLocAmt = entryFieldMap.get("issuedLocAmt");
        BigDecimal issuedPriceTax = entryFieldMap.get("issuePriceTax");
        BigDecimal issuedLocPriceTax = entryFieldMap.get("issueLocPriceTax");
        entry.set("verifyamt", (Object)(isForm ? issuedLocAmt : issuedAmt));
        entry.set("verifylocamt", (Object)issuedAmt);
        entry.set("verifypricetax", (Object)(isForm ? issuedLocPriceTax : issuedPriceTax));
        entry.set("verifylocpricetax", (Object)issuedPriceTax);
        entry.set("verifytax", (Object)(isForm ? issuedLocTax : issuedTax));
        entry.set("verifyloctax", (Object)issuedTax);
        if (HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP == verifyTypeId) {
            entry.set("verifyqty", (Object)issuedNum);
        } else if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP == verifyTypeId) {
            BigDecimal issueQty = mainBill.getBigDecimal("entry.e_issueinvqty");
            entry.set("verifyqty", (Object)issueQty);
        }
    }

    private void mainVerifyFieldValue(DynamicObject entry, BigDecimal verifyAmt, BigDecimal verifyPriceTax, BigDecimal exchangerate, int amtprecision, String quotation, BigDecimal verifyQty) {
        BigDecimal verifyLocPriceTax;
        BigDecimal verifyLocAmt;
        if ("1".equals(quotation)) {
            verifyLocAmt = verifyAmt.divide(exchangerate, amtprecision, RoundingMode.HALF_UP);
            verifyLocPriceTax = verifyPriceTax.divide(exchangerate, amtprecision, RoundingMode.HALF_UP);
        } else {
            verifyLocAmt = verifyAmt.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP);
            verifyLocPriceTax = verifyPriceTax.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP);
        }
        entry.set("verifyqty", (Object)verifyQty);
        entry.set("verifyamt", (Object)verifyAmt);
        entry.set("verifylocamt", (Object)verifyLocAmt);
        entry.set("verifytax", (Object)verifyPriceTax.subtract(verifyAmt));
        entry.set("verifyloctax", (Object)verifyLocPriceTax.subtract(verifyLocAmt));
        entry.set("verifypricetax", (Object)verifyPriceTax);
        entry.set("verifylocpricetax", (Object)verifyLocPriceTax);
    }

    private void fillAsstVerifyRecordCore(DynamicObject entry, long verifyTypeId, DynamicObject asstBill, Long discountEntryId, DynamicObject mainBill) {
        BigDecimal asstVerifyValue = entry.getBigDecimal("assqty");
        logger.info("------ArOriginalWFRecordWriteOffPlugin fillAsstVerifyRecord asstVerifyValue------" + asstVerifyValue);
        BigDecimal asstaxrate = entry.getBigDecimal("asstaxrate").divide(new BigDecimal(100));
        DynamicObject currency = entry.getDynamicObject("asscurrency");
        int amtprecision = currency.getInt("amtprecision");
        String quotation = asstBill.getString("quotation");
        BigDecimal exchangerate = asstBill.getBigDecimal("exrate");
        BigDecimal assBillQty = entry.getBigDecimal("assbillqty");
        BigDecimal assPriceTaxTotal = entry.getBigDecimal("asspricetaxtotal");
        BigDecimal assLocPriceTaxTotal = entry.getBigDecimal("asslocpricetaxtotal");
        if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == verifyTypeId && assBillQty.compareTo(asstVerifyValue) == 0) {
            boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
            BigDecimal issuLocAmt = asstBill.getBigDecimal("sim_original_bill_item.issuedamount");
            BigDecimal issuAmt = isForm ? asstBill.getBigDecimal("sim_original_bill_item.fromissuedamount") : issuLocAmt;
            BigDecimal issuLocTax = asstBill.getBigDecimal("sim_original_bill_item.issuedtax");
            BigDecimal issuTax = isForm ? asstBill.getBigDecimal("sim_original_bill_item.fromissuedtax") : issuLocTax;
            BigDecimal issuLocPriceTax = asstBill.getBigDecimal("sim_original_bill_item.issuedtotaltaxamount");
            BigDecimal issuPriceTax = isForm ? asstBill.getBigDecimal("sim_original_bill_item.fromissuedtaxamount") : issuLocPriceTax;
            entry.set("assverifyqty", (Object)asstVerifyValue);
            entry.set("assverifyamt", (Object)issuAmt);
            entry.set("assverifylocamt", (Object)issuLocAmt);
            entry.set("assverifytax", (Object)issuTax);
            entry.set("assverifyloctax", (Object)issuLocTax);
            entry.set("assverifypricetax", (Object)issuPriceTax);
            entry.set("assverifylocpricetax", (Object)issuLocPriceTax);
        } else if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE == verifyTypeId && assPriceTaxTotal.compareTo(asstVerifyValue) == 0) {
            if (assPriceTaxTotal.compareTo(BigDecimal.ZERO) > 0) {
                entry.set("assverifyqty", (Object)BigDecimal.ONE);
            } else {
                entry.set("assverifyqty", (Object)BigDecimal.ZERO);
            }
            entry.set("assverifypricetax", (Object)assPriceTaxTotal);
            entry.set("assverifylocpricetax", (Object)assLocPriceTaxTotal);
            boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
            BigDecimal issuLocAmt = asstBill.getBigDecimal("sim_original_bill_item.issuedamount");
            BigDecimal issuAmt = isForm ? asstBill.getBigDecimal("sim_original_bill_item.fromissuedamount") : issuLocAmt;
            BigDecimal issuLocTax = asstBill.getBigDecimal("sim_original_bill_item.issuedtax");
            BigDecimal issuTax = isForm ? asstBill.getBigDecimal("sim_original_bill_item.fromissuedtax") : issuLocTax;
            entry.set("assverifyamt", (Object)issuAmt);
            entry.set("assverifylocamt", (Object)issuLocAmt);
            entry.set("assverifytax", (Object)issuTax);
            entry.set("assverifyloctax", (Object)issuLocTax);
        } else {
            BigDecimal asstTaxUnitPrice = asstBill.getBigDecimal("sim_original_bill_item.taxunitprice");
            BigDecimal mainTaxUnitPrice = mainBill.getBigDecimal("entry.e_taxunitprice");
            if (discountEntryId != null && discountEntryId != 0L && asstTaxUnitPrice.compareTo(mainTaxUnitPrice) == 0) {
                BigDecimal taxUnitPrice = mainBill.getBigDecimal("entry.e_acttaxunitprice");
                BigDecimal unitPrice = mainBill.getBigDecimal("entry.e_actunitprice");
                if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == verifyTypeId) {
                    BigDecimal verifyPriceTax = asstVerifyValue.multiply(taxUnitPrice).setScale(amtprecision, RoundingMode.HALF_UP);
                    BigDecimal verifyAmt = asstVerifyValue.multiply(unitPrice).setScale(amtprecision, RoundingMode.HALF_UP);
                    this.asstVerifyFieldValue(entry, verifyAmt, verifyPriceTax, exchangerate, amtprecision, quotation, asstVerifyValue);
                } else {
                    BigDecimal verifyAmt = asstVerifyValue.divide(BigDecimal.ONE.add(asstaxrate), amtprecision, RoundingMode.HALF_UP);
                    this.asstVerifyFieldValue(entry, verifyAmt, asstVerifyValue, exchangerate, amtprecision, quotation, BigDecimal.ZERO);
                }
            } else if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == verifyTypeId) {
                BigDecimal oriUnitPrice = asstBill.getBigDecimal("sim_original_bill_item.oriunitprice");
                if (BigDecimal.ZERO.compareTo(oriUnitPrice) == 0) {
                    boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
                    oriUnitPrice = isForm ? asstBill.getBigDecimal("sim_original_bill_item.fromprice") : asstBill.getBigDecimal("sim_original_bill_item.unitprice");
                }
                BigDecimal verifyAmt = asstVerifyValue.multiply(oriUnitPrice).setScale(amtprecision, RoundingMode.HALF_UP);
                BigDecimal verifyTax = verifyAmt.multiply(asstaxrate).setScale(amtprecision, RoundingMode.HALF_UP);
                BigDecimal verifyPriceTax = verifyAmt.add(verifyTax);
                this.asstVerifyFieldValue(entry, verifyAmt, verifyPriceTax, exchangerate, amtprecision, quotation, asstVerifyValue);
            } else {
                BigDecimal verifyAmt = asstVerifyValue.divide(BigDecimal.ONE.add(asstaxrate), amtprecision, RoundingMode.HALF_UP);
                this.asstVerifyFieldValue(entry, verifyAmt, asstVerifyValue, exchangerate, amtprecision, quotation, BigDecimal.ZERO);
            }
        }
    }

    private void discountDealAsstAmtField(DynamicObject entry, Map<String, BigDecimal> entryFieldMap) {
        DynamicObject currency = entry.getDynamicObject("asscurrency");
        boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
        BigDecimal amount = entryFieldMap.get("amount");
        BigDecimal fromamount = entryFieldMap.get("fromamount");
        BigDecimal tax = entryFieldMap.get("tax");
        BigDecimal fromtax = entryFieldMap.get("fromtax");
        BigDecimal taxamount = entryFieldMap.get("taxamount");
        BigDecimal fromtaxamount = entryFieldMap.get("fromtaxamount");
        entry.set("assamount", (Object)(isForm ? fromamount : amount));
        entry.set("asslocamt", (Object)amount);
        entry.set("asstax", (Object)(isForm ? fromtax : tax));
        entry.set("assloctax", (Object)tax);
        entry.set("asspricetaxtotal", (Object)(isForm ? fromtaxamount : taxamount));
        entry.set("asslocpricetaxtotal", (Object)taxamount);
    }

    private void fillAsstVerifyRecordBotp(DynamicObject entry, DynamicObject asstBill) {
        BigDecimal asstVerifyValue = entry.getBigDecimal("assqty");
        logger.info("------ArOriginalWFRecordWriteOffPlugin.fillAsstVerifyRecordBotp.asstVerifyValue------" + asstVerifyValue);
        DynamicObject currency = entry.getDynamicObject("asscurrency");
        boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
        BigDecimal assissuedQty = asstBill.getBigDecimal("sim_original_bill_item.issuednum");
        BigDecimal asstIssueTax = asstBill.getBigDecimal("sim_original_bill_item.issuedtax");
        BigDecimal asstIssueAmt = asstBill.getBigDecimal("sim_original_bill_item.issuedamount");
        BigDecimal asstIssuePriceTax = asstBill.getBigDecimal("sim_original_bill_item.issuedtotaltaxamount");
        BigDecimal asstIssueLocTax = asstBill.getBigDecimal("sim_original_bill_item.fromissuedtax");
        BigDecimal asstIssueLocAmt = asstBill.getBigDecimal("sim_original_bill_item.fromissuedamount");
        BigDecimal asstIssueLocPriceTax = asstBill.getBigDecimal("sim_original_bill_item.fromissuedtaxamount");
        entry.set("assverifyqty", (Object)assissuedQty);
        entry.set("assverifyloctax", (Object)asstIssueTax);
        entry.set("assverifylocamt", (Object)asstIssueAmt);
        entry.set("assverifylocpricetax", (Object)asstIssuePriceTax);
        if (isForm) {
            entry.set("assverifytax", (Object)asstIssueLocTax);
            entry.set("assverifyamt", (Object)asstIssueLocAmt);
            entry.set("assverifypricetax", (Object)asstIssueLocPriceTax);
        } else {
            entry.set("assverifytax", (Object)asstIssueTax);
            entry.set("assverifyamt", (Object)asstIssueAmt);
            entry.set("assverifypricetax", (Object)asstIssuePriceTax);
        }
    }

    private void fillAsstVerifyRecordBotpDiscount(DynamicObject entry, Map<String, BigDecimal> entryFieldMap) {
        BigDecimal asstVerifyValue = entry.getBigDecimal("assqty");
        logger.info("------ArOriginalWFRecordWriteOffPlugin.fillAsstVerifyRecordBotpDiscount.asstVerifyValue------" + asstVerifyValue);
        DynamicObject currency = entry.getDynamicObject("asscurrency");
        boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
        BigDecimal issuedNum = entryFieldMap.get("issuedNum");
        BigDecimal issuedTax = entryFieldMap.get("issuedTax");
        BigDecimal issuedAmt = entryFieldMap.get("issuedAmt");
        BigDecimal issuedLocTax = entryFieldMap.get("issuedLocTax");
        BigDecimal issuedLocAmt = entryFieldMap.get("issuedLocAmt");
        BigDecimal issuedPriceTax = entryFieldMap.get("issuePriceTax");
        BigDecimal issuedLocPriceTax = entryFieldMap.get("issueLocPriceTax");
        BigDecimal amount = entryFieldMap.get("amount");
        BigDecimal fromamount = entryFieldMap.get("fromamount");
        BigDecimal tax = entryFieldMap.get("tax");
        BigDecimal fromtax = entryFieldMap.get("fromtax");
        BigDecimal taxamount = entryFieldMap.get("taxamount");
        BigDecimal fromtaxamount = entryFieldMap.get("fromtaxamount");
        entry.set("assverifyqty", (Object)issuedNum);
        entry.set("assverifyamt", (Object)(isForm ? issuedLocAmt : issuedAmt));
        entry.set("assverifylocamt", (Object)issuedAmt);
        entry.set("assverifypricetax", (Object)(isForm ? issuedLocPriceTax : issuedPriceTax));
        entry.set("assverifylocpricetax", (Object)issuedPriceTax);
        entry.set("assverifytax", (Object)(isForm ? issuedLocTax : issuedTax));
        entry.set("assverifyloctax", (Object)issuedTax);
        entry.set("assamount", (Object)(isForm ? fromamount : amount));
        entry.set("asslocamt", (Object)amount);
        entry.set("asstax", (Object)(isForm ? fromtax : tax));
        entry.set("assloctax", (Object)tax);
        entry.set("asspricetaxtotal", (Object)(isForm ? fromtaxamount : taxamount));
        entry.set("asslocpricetaxtotal", (Object)taxamount);
    }

    private void asstVerifyFieldValue(DynamicObject entry, BigDecimal verifyAmt, BigDecimal verifyPriceTax, BigDecimal exchangerate, int amtprecision, String quotation, BigDecimal verifyQty) {
        BigDecimal verifyLocPriceTax;
        BigDecimal verifyLocAmt;
        if ("1".equals(quotation)) {
            verifyLocAmt = verifyAmt.divide(exchangerate, amtprecision, RoundingMode.HALF_UP);
            verifyLocPriceTax = verifyPriceTax.divide(exchangerate, amtprecision, RoundingMode.HALF_UP);
        } else {
            verifyLocAmt = verifyAmt.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP);
            verifyLocPriceTax = verifyPriceTax.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP);
        }
        entry.set("assverifyqty", (Object)verifyQty);
        entry.set("assverifyamt", (Object)verifyAmt);
        entry.set("assverifylocamt", (Object)verifyLocAmt);
        entry.set("assverifytax", (Object)verifyPriceTax.subtract(verifyAmt));
        entry.set("assverifyloctax", (Object)verifyLocPriceTax.subtract(verifyLocAmt));
        entry.set("assverifypricetax", (Object)verifyPriceTax);
        entry.set("assverifylocpricetax", (Object)verifyLocPriceTax);
    }

    private String getMainSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(16);
        selectors.add("entry.e_uninvoicedqty");
        selectors.add("entry.e_uninvoicedamt");
        selectors.add("entry.e_uninvoicedlocalamt");
        selectors.add("entry.e_acttaxunitprice");
        selectors.add("entry.e_actunitprice");
        selectors.add("entry.e_taxunitprice");
        selectors.add("entry.e_issueinvqty");
        selectors.add("entry.e_issueinvtax");
        selectors.add("entry.e_issueinvlocaltax");
        selectors.add("entry.e_issueinvamt");
        selectors.add("entry.e_issueinvlocalamt");
        selectors.add("entry.e_issueinvrecamt");
        selectors.add("entry.e_issueinvreclocalamt");
        selectors.add("entry.e_invoicecode");
        selectors.add("entry.e_invoiceno");
        selectors.add("invoicecode");
        selectors.add("invoiceno");
        selectors.add("entry.id");
        selectors.add("id");
        selectors.add("quotation");
        selectors.add("exchangerate");
        selectors.add("bookdate");
        return String.join((CharSequence)",", selectors);
    }

    private String getAsstSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(16);
        selectors.add("sim_original_bill_item.unpushnum");
        selectors.add("sim_original_bill_item.unpushamt");
        selectors.add("sim_original_bill_item.unpushlocalamt");
        selectors.add("sim_original_bill_item.oriunitprice");
        selectors.add("sim_original_bill_item.unitprice");
        selectors.add("sim_original_bill_item.fromprice");
        selectors.add("sim_original_bill_item.taxunitprice");
        selectors.add("sim_original_bill_item.id");
        selectors.add("exrate");
        selectors.add("quotation");
        selectors.add("sim_original_bill_item.fromissuedamount");
        selectors.add("sim_original_bill_item.fromissuedtax");
        selectors.add("sim_original_bill_item.fromissuedtaxamount");
        selectors.add("sim_original_bill_item.issuednum");
        selectors.add("sim_original_bill_item.issuedamount");
        selectors.add("sim_original_bill_item.issuedtax");
        selectors.add("sim_original_bill_item.issuedtotaltaxamount");
        selectors.add("sim_original_bill_item.corebillentryseq");
        selectors.add("sim_original_bill_item.rowtype");
        selectors.add("sim_original_bill_item.amount");
        selectors.add("sim_original_bill_item.tax");
        selectors.add("sim_original_bill_item.taxamount");
        selectors.add("sim_original_bill_item.fromamount");
        selectors.add("sim_original_bill_item.fromtax");
        selectors.add("sim_original_bill_item.fromtaxamount");
        selectors.add("id");
        return String.join((CharSequence)",", selectors);
    }

    private void handleLinkUpNodes(String curEntity, String curEntryKey, Long curId, Long curEntryId, String targetEntity, Set<Long> ids, Set<Long> entryIds) {
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (String)curEntryKey, (Long[])new Long[]{curId}, (Long[])new Long[]{curEntryId}, null);
        TableDefine tableDefine = EntityMetadataCache.loadMainTableDefine((String)targetEntity);
        Long upTableId = tableDefine.getTableId();
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            List<BFRowLinkUpNode> sourceNodes = ArOriginalWFRecordWriteOffPlugin.findSourceNodes(linkUpNode, upTableId, curId);
            for (BFRowLinkUpNode sourceNode : sourceNodes) {
                ids.add(sourceNode.getRowId().getBillId());
                entryIds.add(sourceNode.getRowId().getEntryId());
            }
        }
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(ArOriginalWFRecordWriteOffPlugin.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        if (records == null || records.size() < 1) {
            return new HashMap<String, Map<String, List<Object[]>>>(8);
        }
        HashMap<String, Map<String, List<Object[]>>> sqlListMaps = new HashMap<String, Map<String, List<Object[]>>>(8);
        logger.info("-------ArOriginalWFRecordWriteOffPlugin.buildBackSql.start-------");
        HashSet<Long> finArBillIdSet = new HashSet<Long>(8);
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection entrys = recordBill.getDynamicObjectCollection("entry");
            for (Object entry : entrys) {
                finArBillIdSet.add(entry.getLong("billentryid"));
            }
        }
        DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"ar_finarbill", (String)this.getMainSelectors(), (QFilter[])new QFilter[]{new QFilter("entry.id", "in", finArBillIdSet)});
        HashSet<Long> hxlbSet = new HashSet<Long>(8);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_QTY_CORE);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE);
        List arOriRecords = records.stream().filter(e -> hxlbSet.contains(e.getLong("writeofftypeid.id"))).collect(Collectors.toList());
        if (arOriRecords.size() < 1) {
            return sqlListMaps;
        }
        HashMap<Long, Map<String, String>> invNoMap = new HashMap<Long, Map<String, String>>(16);
        for (DynamicObject arBill : mainCollection) {
            HashMap entryInvMap = new HashMap(2);
            HashMap<String, String> headInvMap = new HashMap<String, String>(2);
            Long entryId = arBill.getLong("entry.id");
            Long id = arBill.getLong("id");
            entryInvMap.put("invNo", arBill.getString("entry.e_invoiceno"));
            entryInvMap.put("invCode", arBill.getString("entry.e_invoicecode"));
            invNoMap.put(entryId, entryInvMap);
            if (invNoMap.get(id) != null) continue;
            headInvMap.put("invNo", arBill.getString("invoiceno"));
            headInvMap.put("invCode", arBill.getString("invoicecode"));
            invNoMap.put(id, headInvMap);
        }
        logger.info("ArOriginalWFRecordWriteOffPlugin-\u51c6\u5907\u6784\u5efa\u81ea\u5b9a\u4e49\u53cd\u5199sql-records_size\uff1a" + arOriRecords.size());
        ArrayList<DisposeParam> disMainEntryInvNoList = new ArrayList<DisposeParam>(8);
        ArrayList<DisposeParam> disMainHeadInvNoList = new ArrayList<DisposeParam>(8);
        for (DynamicObject record : arOriRecords) {
            DynamicObjectCollection recordEntrys = record.getDynamicObjectCollection("entry");
            this.buildDisBillInfo(disMainEntryInvNoList, recordEntrys, invNoMap, false);
            this.buildDisBillInfo(disMainHeadInvNoList, recordEntrys, invNoMap, true);
        }
        Map<String, List<Object[]>> sqlLists = this.buildBackSqlByEntry(disMainEntryInvNoList, disMainHeadInvNoList);
        if (sqlLists.size() > 0) {
            sqlListMaps.put("fi", sqlLists);
        }
        return sqlListMaps;
    }

    private List<VerifyRecordVO> buildDisAsstBillParam(List<DynamicObject> arOriRecords, Boolean isAmount) {
        ArrayList<VerifyRecordVO> disAsstbillParamList = new ArrayList<VerifyRecordVO>(arOriRecords.size());
        for (DynamicObject arOriRecord : arOriRecords) {
            DynamicObjectCollection entryColl = arOriRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                BigDecimal verifyAmt = entry.getBigDecimal("assverifyamt");
                BigDecimal verifyLocAmt = entry.getBigDecimal("assverifylocamt");
                BigDecimal verifyTax = entry.getBigDecimal("assverifytax");
                BigDecimal verifyLocTax = entry.getBigDecimal("assverifyloctax");
                BigDecimal verifyPriceTax = entry.getBigDecimal("assverifypricetax");
                BigDecimal verifyLocPriceTax = entry.getBigDecimal("assverifylocpricetax");
                long billId = entry.getLong("billid");
                long billEntryId = entry.getLong("billentryid");
                long assBillId = entry.getLong("assbillid");
                long assBillEntryId = entry.getLong("assbillentryid");
                VerifyRecordVO verifyRecordVO = new VerifyRecordVO();
                verifyRecordVO.setMainId(billId);
                verifyRecordVO.setMainEntryId(billEntryId);
                verifyRecordVO.setAsstId(assBillId);
                verifyRecordVO.setAsstEntryId(assBillEntryId);
                verifyRecordVO.setIsAmount(isAmount);
                verifyRecordVO.setVerifyTaxDiff(verifyTax);
                verifyRecordVO.setVerifyLocTaxDiff(verifyLocTax);
                verifyRecordVO.setVerifyAmtDiff(verifyAmt);
                verifyRecordVO.setVerifyLocAmtDiff(verifyLocAmt);
                verifyRecordVO.setVerifyPriceTaxDiff(verifyPriceTax);
                verifyRecordVO.setVerifyLocPriceTaxDiff(verifyLocPriceTax);
                BigDecimal verifyAsstQty = entry.getBigDecimal("assverifyqty");
                BigDecimal verifyMainQty = entry.getBigDecimal("verifyqty");
                verifyRecordVO.setVerifyAsstQtyDiff(verifyAsstQty);
                verifyRecordVO.setVerifyMainQtyDiff(verifyMainQty);
                disAsstbillParamList.add(verifyRecordVO);
            }
        }
        return disAsstbillParamList;
    }

    private List<VerifyRecordVO> buildDisMainBillParam(List<DynamicObject> arOriRecords, boolean isAmount) {
        ArrayList<VerifyRecordVO> disMainbillParamList = new ArrayList<VerifyRecordVO>(arOriRecords.size());
        for (DynamicObject arOriRecord : arOriRecords) {
            DynamicObjectCollection entryColl = arOriRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                BigDecimal verifyPriceTax = entry.getBigDecimal("verifypricetax");
                BigDecimal verifyLocPriceTax = entry.getBigDecimal("verifylocpricetax");
                long billId = entry.getLong("billid");
                long billEntryId = entry.getLong("billentryid");
                VerifyRecordVO verifyRecordVO = new VerifyRecordVO();
                verifyRecordVO.setMainId(billId);
                verifyRecordVO.setMainEntryId(billEntryId);
                verifyRecordVO.setIsAmount(isAmount);
                verifyRecordVO.setVerifyPriceTaxDiff(verifyPriceTax);
                verifyRecordVO.setVerifyLocPriceTaxDiff(verifyLocPriceTax);
                BigDecimal verifyMainQty = entry.getBigDecimal("verifyqty");
                verifyRecordVO.setVerifyMainQtyDiff(verifyMainQty);
                disMainbillParamList.add(verifyRecordVO);
            }
        }
        return disMainbillParamList;
    }

    private void buildOriginalTailDiffBackSql(List<VerifyRecordVO> asstTailDiffrenceList) {
        if (asstTailDiffrenceList.size() > 0) {
            String updateOriginalEntrySql;
            String updateOriginalHeadSql;
            HashMap<Long, Long> asstEntryIdAndAsstId;
            Boolean isAmount = asstTailDiffrenceList.get(0).getIsAmount();
            ArrayList<Object[]> originalHeadSqlParams = new ArrayList<Object[]>(8);
            ArrayList<Object[]> originalEntrySqlParams = new ArrayList<Object[]>(8);
            if (isAmount.booleanValue()) {
                BigDecimal verifyLocPriceTaxDiff;
                asstEntryIdAndAsstId = new HashMap<Long, Long>(8);
                HashMap<Long, BigDecimal> arIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> arIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndQty = new HashMap<Long, BigDecimal>(8);
                updateOriginalHeadSql = "update t_sim_original_bill set fpushamount = fpushamount +?,funpushamount = funpushamount-?, fpushlocalamount = fpushlocalamount + ?,   funpushlocalamount = funpushlocalamount - ? where fid = ? ";
                updateOriginalEntrySql = "update t_sim_original_bill_item set fpushamt = fpushamt +?,funpushamt = funpushamt - ?, fpushlocalamt = fpushlocalamt + ?,funpushlocalamt = funpushlocalamt - ?, fpushnum = fpushnum + ?, funpushnum = funpushnum -? where fid = ? and fentryid = ?";
                for (VerifyRecordVO verifyRecordVO : asstTailDiffrenceList) {
                    Long asstEntryId = verifyRecordVO.getAsstEntryId();
                    Long asstId = verifyRecordVO.getAsstId();
                    verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                    BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                    BigDecimal verifyQtyDiff = verifyRecordVO.getVerifyAsstQtyDiff();
                    logger.info("buildOriginalTailDiffBackSql verifyLocPriceTaxDiff is {}", (Object)verifyLocPriceTaxDiff);
                    logger.info("buildOriginalTailDiffBackSql verifyQtyDiff is {}", (Object)verifyQtyDiff);
                    logger.info("buildOriginalTailDiffBackSql asstId is {}", (Object)asstId);
                    logger.info("buildOriginalTailDiffBackSql asstEntryId is {}", (Object)asstEntryId);
                    asstEntryIdAndAsstId.put(asstEntryId, asstId);
                    arIdAndPriceTax.merge(asstId, verifyPriceTaxDiff, BigDecimal::add);
                    arIdAndLocPriceTax.merge(asstId, verifyLocPriceTaxDiff, BigDecimal::add);
                    entryIdAndPriceTax.merge(asstEntryId, verifyPriceTaxDiff, BigDecimal::add);
                    entryIdAndLocPriceTax.merge(asstEntryId, verifyLocPriceTaxDiff, BigDecimal::add);
                    entryIdAndQty.merge(asstEntryId, verifyQtyDiff, BigDecimal::add);
                }
                for (Map.Entry entry : arIdAndLocPriceTax.entrySet()) {
                    Long id = (Long)entry.getKey();
                    BigDecimal verifyLocPriceTaxDiff2 = (BigDecimal)entry.getValue();
                    BigDecimal verifyPriceTax = (BigDecimal)arIdAndPriceTax.get(id);
                    Object[] param = new Object[]{verifyPriceTax, verifyPriceTax, verifyLocPriceTaxDiff2, verifyLocPriceTaxDiff2, id};
                    originalHeadSqlParams.add(param);
                }
                for (Map.Entry entry : entryIdAndLocPriceTax.entrySet()) {
                    Long entryId = (Long)entry.getKey();
                    Long id = (Long)asstEntryIdAndAsstId.get(entryId);
                    verifyLocPriceTaxDiff = (BigDecimal)entry.getValue();
                    BigDecimal verifyPriceTax = (BigDecimal)entryIdAndPriceTax.get(entryId);
                    BigDecimal qty = (BigDecimal)entryIdAndQty.get(entryId);
                    Object[] param = new Object[]{verifyPriceTax, verifyPriceTax, verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, qty, qty, id, entryId};
                    originalEntrySqlParams.add(param);
                }
            } else {
                BigDecimal verifyPriceTaxDiff;
                asstEntryIdAndAsstId = new HashMap(8);
                HashMap<Long, BigDecimal> arIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> arIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndQty = new HashMap<Long, BigDecimal>(8);
                updateOriginalHeadSql = "update t_sim_original_bill set fpushlocalamount = fpushlocalamount + ?,funpushlocalamount = funpushlocalamount - ?, fpushamount = fpushamount + ?, funpushamount = funpushamount - ? where fid = ? ";
                updateOriginalEntrySql = "update t_sim_original_bill_item set fpushnum = fpushnum + ?,funpushnum = funpushnum - ?, fpushlocalamt = fpushlocalamt + ?,funpushlocalamt = funpushlocalamt - ?,fpushamt = fpushamt +? , funpushamt = funpushamt - ? where fid = ? and fentryid = ?";
                for (VerifyRecordVO verifyRecordVO : asstTailDiffrenceList) {
                    Long asstEntryId = verifyRecordVO.getAsstEntryId();
                    Long asstId = verifyRecordVO.getAsstId();
                    BigDecimal verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                    BigDecimal verifyPriceTaxDiff2 = verifyRecordVO.getVerifyPriceTaxDiff();
                    BigDecimal verifyAsstQtyDiff = verifyRecordVO.getVerifyAsstQtyDiff();
                    logger.info("buildOriginalTailDiffBackSql verifyLocPriceTaxDiff is {}", (Object)verifyLocPriceTaxDiff);
                    logger.info("buildOriginalTailDiffBackSql verifyPriceTaxDiff is {}", (Object)verifyPriceTaxDiff2);
                    logger.info("buildOriginalTailDiffBackSql asstId is {}", (Object)asstId);
                    logger.info("buildOriginalTailDiffBackSql asstEntryId is {}", (Object)asstEntryId);
                    asstEntryIdAndAsstId.put(asstEntryId, asstId);
                    arIdAndLocPriceTax.merge(asstId, verifyLocPriceTaxDiff, BigDecimal::add);
                    arIdAndPriceTax.merge(asstId, verifyPriceTaxDiff2, BigDecimal::add);
                    entryIdAndLocPriceTax.merge(asstEntryId, verifyLocPriceTaxDiff, BigDecimal::add);
                    entryIdAndPriceTax.merge(asstEntryId, verifyPriceTaxDiff2, BigDecimal::add);
                    entryIdAndQty.merge(asstEntryId, verifyAsstQtyDiff, BigDecimal::add);
                }
                for (Map.Entry entry : arIdAndLocPriceTax.entrySet()) {
                    Long id = (Long)entry.getKey();
                    BigDecimal verifyLocPriceTaxDiff = (BigDecimal)entry.getValue();
                    verifyPriceTaxDiff = (BigDecimal)arIdAndPriceTax.get(id);
                    Object[] param = new Object[]{verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, verifyPriceTaxDiff, verifyPriceTaxDiff, id};
                    originalHeadSqlParams.add(param);
                }
                for (Map.Entry entry : entryIdAndLocPriceTax.entrySet()) {
                    Long entryId = (Long)entry.getKey();
                    Long id = (Long)asstEntryIdAndAsstId.get(entryId);
                    verifyPriceTaxDiff = (BigDecimal)entryIdAndPriceTax.get(entryId);
                    BigDecimal verifyLocPriceTaxDiff = (BigDecimal)entry.getValue();
                    BigDecimal verifyQty = (BigDecimal)entryIdAndQty.get(entryId);
                    Object[] param = new Object[]{verifyQty, verifyQty, verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, verifyPriceTaxDiff, verifyPriceTaxDiff, id, entryId};
                    originalEntrySqlParams.add(param);
                }
            }
            logger.info("update head sql {},headSqlParams {}", (Object)updateOriginalHeadSql, (Object)((Object)originalHeadSqlParams).toString());
            logger.info("update entry sql {},headSqlParams {}", (Object)updateOriginalEntrySql, (Object)((Object)originalEntrySqlParams).toString());
            try (TXHandle txHandle = TX.requiresNew();){
                if (originalEntrySqlParams.size() > 0) {
                    DB.executeBatch((DBRoute)new DBRoute("taxc"), (String)updateOriginalEntrySql, originalEntrySqlParams);
                }
                if (originalHeadSqlParams.size() > 0) {
                    DB.executeBatch((DBRoute)new DBRoute("taxc"), (String)updateOriginalHeadSql, originalHeadSqlParams);
                }
            }
        }
    }

    private void buildFinArIssuedTailDiffBackSql(List<VerifyRecordVO> asstTailDiffrence) {
        if (asstTailDiffrence.size() > 0) {
            String updateFinArEntrySql;
            String updateFinArHeadSql;
            Boolean isAmount = asstTailDiffrence.get(0).getIsAmount();
            ArrayList<Object[]> finArHeadSqlParams = new ArrayList<Object[]>(8);
            ArrayList<Object[]> finArEntrySqlParams = new ArrayList<Object[]>(8);
            if (isAmount.booleanValue()) {
                BigDecimal verifyMainQtyDiff;
                HashMap<Long, Long> mainEntryIdAndMainId = new HashMap<Long, Long>(8);
                HashMap<Long, BigDecimal> mainIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndLocTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndAmt = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndLocAmt = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndQty = new HashMap<Long, BigDecimal>(8);
                updateFinArHeadSql = "update t_ar_finarbill_e set fissueinvrecamt = fissueinvrecamt + ? , fissueinvreclocalamt = fissueinvreclocalamt + ? where fid =?";
                updateFinArEntrySql = "update t_ar_finarbillentry_e set fissueinvamt = fissueinvamt + ?,fissueinvlocalamt = fissueinvlocalamt +?,fissueinvtax = fissueinvtax + ?, fissueinvlocaltax = fissueinvlocaltax +?,fissueinvreclocalamt = fissueinvreclocalamt + ?,fissueinvrecamt = fissueinvrecamt + ?, fissueinvqty = fissueinvqty + ? where fid = ? and fentryid =? ";
                for (VerifyRecordVO verifyRecordVO : asstTailDiffrence) {
                    Long mainEntryId = verifyRecordVO.getMainEntryId();
                    Long mainId = verifyRecordVO.getMainId();
                    BigDecimal verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                    BigDecimal verifyTaxDiff = verifyRecordVO.getVerifyTaxDiff();
                    BigDecimal verifyLocTaxDiff = verifyRecordVO.getVerifyLocTaxDiff();
                    BigDecimal verifyAmtDiff = verifyRecordVO.getVerifyAmtDiff();
                    BigDecimal verifyLocAmtDiff = verifyRecordVO.getVerifyLocAmtDiff();
                    verifyMainQtyDiff = verifyRecordVO.getVerifyMainQtyDiff();
                    BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                    mainEntryIdAndMainId.put(mainEntryId, mainId);
                    mainIdAndPriceTax.merge(mainId, verifyPriceTaxDiff, BigDecimal::add);
                    mainIdAndLocPriceTax.merge(mainId, verifyLocPriceTaxDiff, BigDecimal::add);
                    mainEntryIdAndTax.merge(mainEntryId, verifyTaxDiff, BigDecimal::add);
                    mainEntryIdAndLocTax.merge(mainEntryId, verifyLocTaxDiff, BigDecimal::add);
                    mainEntryIdAndAmt.merge(mainEntryId, verifyAmtDiff, BigDecimal::add);
                    mainEntryIdAndLocAmt.merge(mainEntryId, verifyLocAmtDiff, BigDecimal::add);
                    mainEntryIdAndPriceTax.merge(mainEntryId, verifyPriceTaxDiff, BigDecimal::add);
                    mainEntryIdAndLocPriceTax.merge(mainEntryId, verifyLocPriceTaxDiff, BigDecimal::add);
                    mainEntryIdAndQty.merge(mainEntryId, verifyMainQtyDiff, BigDecimal::add);
                }
                for (Map.Entry entry : mainIdAndLocPriceTax.entrySet()) {
                    Long id = (Long)entry.getKey();
                    BigDecimal verifyLocPriceTaxDiff = (BigDecimal)entry.getValue();
                    BigDecimal verifyPriceTax = (BigDecimal)mainIdAndPriceTax.get(id);
                    Object[] param = new Object[]{verifyPriceTax, verifyLocPriceTaxDiff, id};
                    finArHeadSqlParams.add(param);
                }
                for (Map.Entry entry : mainEntryIdAndAmt.entrySet()) {
                    Long entryId = (Long)entry.getKey();
                    Long id = (Long)mainEntryIdAndMainId.get(entryId);
                    BigDecimal verifyAmtDiff = (BigDecimal)mainEntryIdAndAmt.get(entryId);
                    BigDecimal verifyLocAmtDiff = (BigDecimal)mainEntryIdAndLocAmt.get(entryId);
                    BigDecimal verifyTaxDiff = (BigDecimal)mainEntryIdAndTax.get(entryId);
                    BigDecimal verifyLocTaxDiff = (BigDecimal)mainEntryIdAndLocTax.get(entryId);
                    BigDecimal verifyLocPriceTax = (BigDecimal)mainEntryIdAndLocPriceTax.get(entryId);
                    verifyMainQtyDiff = (BigDecimal)mainEntryIdAndQty.get(entryId);
                    BigDecimal verifyPriceTax = (BigDecimal)mainEntryIdAndPriceTax.get(entryId);
                    Object[] param = new Object[]{verifyAmtDiff, verifyLocAmtDiff, verifyTaxDiff, verifyLocTaxDiff, verifyLocPriceTax, verifyPriceTax, verifyMainQtyDiff, id, entryId};
                    finArEntrySqlParams.add(param);
                }
            } else {
                BigDecimal verifyAsstQtyDiff;
                BigDecimal verifyLocTaxDiff;
                BigDecimal verifyTaxDiff;
                HashMap<Long, Long> mainEntryIdAndMainId = new HashMap<Long, Long>(8);
                HashMap<Long, BigDecimal> mainIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndLocTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndAmt = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndLocAmt = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> mainEntryIdAndQty = new HashMap<Long, BigDecimal>(8);
                updateFinArHeadSql = "update t_ar_finarbill_e set fissueinvreclocalamt = fissueinvreclocalamt + ?,fissueinvrecamt = fissueinvrecamt + ? where fid =?";
                updateFinArEntrySql = "update t_ar_finarbillentry_e set fissueinvamt = fissueinvamt + ?,fissueinvlocalamt = fissueinvlocalamt +?,fissueinvtax = fissueinvtax + ?, fissueinvlocaltax = fissueinvlocaltax +?,fissueinvreclocalamt = fissueinvreclocalamt + ?,fissueinvrecamt = fissueinvrecamt +?, fissueinvqty = fissueinvqty + ? where fid = ? and fentryid =? ";
                for (VerifyRecordVO verifyRecordVO : asstTailDiffrence) {
                    Long mainEntryId = verifyRecordVO.getMainEntryId();
                    Long mainId = verifyRecordVO.getMainId();
                    BigDecimal verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                    BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                    verifyTaxDiff = verifyRecordVO.getVerifyTaxDiff();
                    verifyLocTaxDiff = verifyRecordVO.getVerifyLocTaxDiff();
                    BigDecimal verifyAmtDiff = verifyRecordVO.getVerifyAmtDiff();
                    BigDecimal verifyLocAmtDiff = verifyRecordVO.getVerifyLocAmtDiff();
                    verifyAsstQtyDiff = verifyRecordVO.getVerifyAsstQtyDiff();
                    mainEntryIdAndMainId.put(mainEntryId, mainId);
                    mainIdAndLocPriceTax.merge(mainId, verifyLocPriceTaxDiff, BigDecimal::add);
                    mainIdAndPriceTax.merge(mainId, verifyPriceTaxDiff, BigDecimal::add);
                    mainEntryIdAndLocPriceTax.merge(mainEntryId, verifyLocPriceTaxDiff, BigDecimal::add);
                    mainEntryIdAndPriceTax.merge(mainEntryId, verifyPriceTaxDiff, BigDecimal::add);
                    mainEntryIdAndTax.merge(mainEntryId, verifyTaxDiff, BigDecimal::add);
                    mainEntryIdAndLocTax.merge(mainEntryId, verifyLocTaxDiff, BigDecimal::add);
                    mainEntryIdAndAmt.merge(mainEntryId, verifyAmtDiff, BigDecimal::add);
                    mainEntryIdAndLocAmt.merge(mainEntryId, verifyLocAmtDiff, BigDecimal::add);
                    mainEntryIdAndQty.merge(mainEntryId, verifyAsstQtyDiff, BigDecimal::add);
                }
                for (Map.Entry entry : mainIdAndLocPriceTax.entrySet()) {
                    Long id = (Long)entry.getKey();
                    BigDecimal verifyLocPriceTaxDiff = (BigDecimal)entry.getValue();
                    BigDecimal verifyPriceTaxDiff = (BigDecimal)mainIdAndPriceTax.get(id);
                    Object[] param = new Object[]{verifyLocPriceTaxDiff, verifyPriceTaxDiff, id};
                    finArHeadSqlParams.add(param);
                }
                for (Map.Entry entry : mainEntryIdAndAmt.entrySet()) {
                    Long entryId = (Long)entry.getKey();
                    Long id = (Long)mainEntryIdAndMainId.get(entryId);
                    BigDecimal verifyAmtDiff = (BigDecimal)mainEntryIdAndAmt.get(entryId);
                    BigDecimal verifyLocAmtDiff = (BigDecimal)mainEntryIdAndLocAmt.get(entryId);
                    verifyTaxDiff = (BigDecimal)mainEntryIdAndTax.get(entryId);
                    verifyLocTaxDiff = (BigDecimal)mainEntryIdAndLocTax.get(entryId);
                    BigDecimal verifyLocPriceTax = (BigDecimal)mainEntryIdAndLocPriceTax.get(entryId);
                    BigDecimal verifyPriceTaxDiff = (BigDecimal)mainEntryIdAndPriceTax.get(entryId);
                    verifyAsstQtyDiff = (BigDecimal)mainEntryIdAndQty.get(entryId);
                    Object[] param = new Object[]{verifyAmtDiff, verifyLocAmtDiff, verifyTaxDiff, verifyLocTaxDiff, verifyLocPriceTax, verifyPriceTaxDiff, verifyAsstQtyDiff, id, entryId};
                    finArEntrySqlParams.add(param);
                }
            }
            logger.info("update head sql {},headSqlParams {}", (Object)updateFinArHeadSql, (Object)((Object)finArHeadSqlParams).toString());
            logger.info("update entry sql {},headSqlParams {}", (Object)updateFinArEntrySql, (Object)((Object)finArEntrySqlParams).toString());
            if (finArEntrySqlParams.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateFinArEntrySql, finArEntrySqlParams);
            }
            if (finArHeadSqlParams.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateFinArHeadSql, finArHeadSqlParams);
            }
        }
    }

    private void buildFinArTailDiffBackSql(List<VerifyRecordVO> mainTailDiffrenceList) {
        if (mainTailDiffrenceList.size() > 0) {
            String updateEntrySql;
            String updateHeadSql;
            Boolean isAmount = mainTailDiffrenceList.get(0).getIsAmount();
            ArrayList<Object[]> headSqlParams = new ArrayList<Object[]>(8);
            ArrayList<Object[]> entrySqlParams = new ArrayList<Object[]>(8);
            if (isAmount.booleanValue()) {
                BigDecimal value;
                HashMap<Long, Long> entryIdAndArId = new HashMap<Long, Long>(8);
                HashMap<Long, BigDecimal> arIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> arIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndQty = new HashMap<Long, BigDecimal>(8);
                updateHeadSql = "update t_ar_finarbill_e set finvoicedamt = finvoicedamt + ?,funinvoicedamt = funinvoicedamt -?, finvoicedlocalamt = finvoicedlocalamt + ? , funinvoicedlocalamt = funinvoicedlocalamt - ? where fid = ?";
                updateEntrySql = "update t_ar_finarbillentry_e set finvoicedamt = finvoicedamt + ?, funinvoicedamt = funinvoicedamt -?, funinvoicedlocalamt = funinvoicedlocalamt - ?,finvoicedlocalamt = finvoicedlocalamt + ?, finvoicedqty = finvoicedqty + ?, funinvoicedqty = funinvoicedqty - ? where fid = ? and fentryid = ?";
                for (VerifyRecordVO verifyRecordVO : mainTailDiffrenceList) {
                    BigDecimal verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                    BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                    Long mainId = verifyRecordVO.getMainId();
                    Long mainEntryId = verifyRecordVO.getMainEntryId();
                    BigDecimal verifyQtyDiff = verifyRecordVO.getVerifyMainQtyDiff();
                    entryIdAndArId.put(mainEntryId, mainId);
                    arIdAndLocPriceTax.merge(mainId, verifyLocPriceTaxDiff, BigDecimal::add);
                    arIdAndPriceTax.merge(mainId, verifyPriceTaxDiff, BigDecimal::add);
                    entryIdAndLocPriceTax.merge(mainEntryId, verifyLocPriceTaxDiff, BigDecimal::add);
                    entryIdAndPriceTax.merge(mainEntryId, verifyPriceTaxDiff, BigDecimal::add);
                    entryIdAndQty.merge(mainEntryId, verifyQtyDiff, BigDecimal::add);
                }
                for (Map.Entry entry : arIdAndLocPriceTax.entrySet()) {
                    Long key = (Long)entry.getKey();
                    value = (BigDecimal)entry.getValue();
                    BigDecimal verifyPriceTax = (BigDecimal)arIdAndPriceTax.get(key);
                    Object[] param = new Object[]{verifyPriceTax, verifyPriceTax, value, value, key};
                    headSqlParams.add(param);
                }
                for (Map.Entry entry : entryIdAndLocPriceTax.entrySet()) {
                    Long entryId = (Long)entry.getKey();
                    value = (BigDecimal)entry.getValue();
                    Long id = (Long)entryIdAndArId.get(entryId);
                    BigDecimal qty = (BigDecimal)entryIdAndQty.get(entryId);
                    BigDecimal verifyPriceTax = (BigDecimal)entryIdAndPriceTax.get(entryId);
                    Object[] param = new Object[]{verifyPriceTax, verifyPriceTax, value, value, qty, qty, id, entryId};
                    entrySqlParams.add(param);
                }
            } else {
                BigDecimal verifyLocPriceTaxDiff;
                BigDecimal verifyPriceTaxDiff;
                updateHeadSql = "update t_ar_finarbill_e set finvoicedamt = finvoicedamt + ?,funinvoicedamt = funinvoicedamt - ?,finvoicedlocalamt = finvoicedlocalamt + ?, funinvoicedlocalamt = funinvoicedlocalamt - ? where fid = ?";
                updateEntrySql = "update t_ar_finarbillentry_e set finvoicedqty = finvoicedqty +?,funinvoicedqty = funinvoicedqty - ?, funinvoicedamt = funinvoicedamt - ?,finvoicedamt = finvoicedamt + ?,funinvoicedlocalamt = funinvoicedlocalamt-?,finvoicedlocalamt = finvoicedlocalamt + ? where fid = ? and fentryid = ?";
                HashMap<Long, Long> entryIdAndArId = new HashMap<Long, Long>(8);
                HashMap<Long, BigDecimal> arIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> arIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndLocPriceTax = new HashMap<Long, BigDecimal>(8);
                HashMap<Long, BigDecimal> entryIdAndQty = new HashMap<Long, BigDecimal>(8);
                for (VerifyRecordVO verifyRecordVO : mainTailDiffrenceList) {
                    Long mainId = verifyRecordVO.getMainId();
                    Long mainEntryId = verifyRecordVO.getMainEntryId();
                    BigDecimal verifyPriceTaxDiff2 = verifyRecordVO.getVerifyPriceTaxDiff();
                    BigDecimal verifyLocPriceTaxDiff2 = verifyRecordVO.getVerifyLocPriceTaxDiff();
                    BigDecimal verifyMainQtyDiff = verifyRecordVO.getVerifyMainQtyDiff();
                    entryIdAndArId.put(mainEntryId, mainId);
                    arIdAndPriceTax.merge(mainId, verifyPriceTaxDiff2, BigDecimal::add);
                    arIdAndLocPriceTax.merge(mainId, verifyLocPriceTaxDiff2, BigDecimal::add);
                    entryIdAndPriceTax.merge(mainEntryId, verifyPriceTaxDiff2, BigDecimal::add);
                    entryIdAndLocPriceTax.merge(mainEntryId, verifyLocPriceTaxDiff2, BigDecimal::add);
                    entryIdAndQty.merge(mainEntryId, verifyMainQtyDiff, BigDecimal::add);
                }
                for (Map.Entry entry : arIdAndPriceTax.entrySet()) {
                    Long id = (Long)entry.getKey();
                    verifyPriceTaxDiff = (BigDecimal)arIdAndPriceTax.get(id);
                    verifyLocPriceTaxDiff = (BigDecimal)arIdAndLocPriceTax.get(id);
                    Object[] param = new Object[]{verifyPriceTaxDiff, verifyPriceTaxDiff, verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, id};
                    headSqlParams.add(param);
                }
                for (Map.Entry entry : entryIdAndPriceTax.entrySet()) {
                    Long entryId = (Long)entry.getKey();
                    verifyPriceTaxDiff = (BigDecimal)entryIdAndPriceTax.get(entryId);
                    verifyLocPriceTaxDiff = (BigDecimal)entryIdAndLocPriceTax.get(entryId);
                    BigDecimal verifyQty = (BigDecimal)entryIdAndQty.get(entryId);
                    Long id = (Long)entryIdAndArId.get(entryId);
                    Object[] param = new Object[]{verifyQty, verifyQty, verifyPriceTaxDiff, verifyPriceTaxDiff, verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, id, entryId};
                    entrySqlParams.add(param);
                }
            }
            logger.info("update head sql {},headSqlParams {}", (Object)updateHeadSql, (Object)((Object)headSqlParams).toString());
            logger.info("update entry sql {},headSqlParams {}", (Object)updateEntrySql, (Object)((Object)entrySqlParams).toString());
            if (headSqlParams.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateHeadSql, headSqlParams);
            }
            if (entrySqlParams.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateEntrySql, entrySqlParams);
            }
        }
    }

    private void handleAsstTailDifference(List<DynamicObject> records, Map<Long, Long> entryIdMap, Map<Long, Map<String, BigDecimal>> discountValueMap) {
        Long billEntryId;
        DynamicObjectCollection entries;
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainIssuedAmt = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainIssuedAmtLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainIssuedTax = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainIssuedTaxLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainAmt = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainAmtLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainPriceTotal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainPriceTotalLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainTax = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainTaxLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainVerifyQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainInvoiceAmt = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> oriEntryIdAndEntryRemainInvoiceLocAmt = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> oriIds = new HashSet<Long>(8);
        HashSet<Long> oriEntryIds = new HashSet<Long>(8);
        HashSet<Long> recordIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            recordIds.add(record.getLong("id"));
            DynamicObjectCollection entries2 = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries2) {
                Long billId = entry.getLong("assbillid");
                Long billEntryId2 = entry.getLong("assbillentryid");
                oriIds.add(billId);
                oriEntryIds.add(billEntryId2);
            }
        }
        DynamicObjectCollection historyRecords = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,entry.id,entry.assbillid,entry.assbillentryid,entry.assverifyqty,entry.assverifyamt,entry.assverifylocamt,entry.assverifypricetax,entry.assverifylocpricetax,entry.assverifytax,entry.assverifyloctax", (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", oriIds), new QFilter("entry.assbillentryid", "in", oriEntryIds), new QFilter("id", "not in", recordIds)});
        DynamicObjectCollection originalBills = QueryServiceHelper.query((String)"sim_original_bill", (String)"id,sim_original_bill_item.id,sim_original_bill_item.issuedtax,sim_original_bill_item.issuedamount,sim_original_bill_item.fromissuedtax,sim_original_bill_item.fromissuedamount,sim_original_bill_item.issuednum,sim_original_bill_item.corebillentryseq,sim_original_bill_item.rowtype,sim_original_bill_item.amount,sim_original_bill_item.tax,sim_original_bill_item.taxamount,sim_original_bill_item.fromamount,sim_original_bill_item.fromtax,sim_original_bill_item.fromtaxamount,sim_original_bill_item.issuedtotaltaxamount,sim_original_bill_item.fromissuedtaxamount,sim_original_bill_item.unpushamt,sim_original_bill_item.unpushnum,sim_original_bill_item.unpushlocalamt", (QFilter[])new QFilter[]{new QFilter("id", "in", oriIds)});
        Map<Long, DynamicObject> originalBillMap = originalBills.stream().collect(Collectors.toMap(k -> k.getLong("sim_original_bill_item.id"), v -> v));
        for (DynamicObject record : records) {
            entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BigDecimal issuedLocAmt;
                BigDecimal issuedLocTax;
                BigDecimal issuedAmt;
                BigDecimal issuedTax;
                DynamicObject currency = entry.getDynamicObject("asscurrency");
                boolean isForm = !"cny".equalsIgnoreCase(currency.getString("number"));
                billEntryId = entry.getLong("assbillentryid");
                Long discountId = entryIdMap.get(billEntryId);
                if (!ObjectUtils.isEmpty((Object)discountId)) {
                    Map<String, BigDecimal> entryFieldMap;
                    if (ObjectUtils.isEmpty(discountValueMap) || ObjectUtils.isEmpty(entryFieldMap = discountValueMap.get(discountId))) continue;
                    issuedTax = entryFieldMap.get("issuedTax");
                    issuedAmt = entryFieldMap.get("issuedAmt");
                    issuedLocTax = entryFieldMap.get("issuedLocTax");
                    issuedLocAmt = entryFieldMap.get("issuedLocAmt");
                    BigDecimal amount = entryFieldMap.get("amount");
                    BigDecimal fromamount = entryFieldMap.get("fromamount");
                    BigDecimal tax = entryFieldMap.get("tax");
                    BigDecimal fromtax = entryFieldMap.get("fromtax");
                    BigDecimal taxamount = entryFieldMap.get("taxamount");
                    BigDecimal fromtaxamount = entryFieldMap.get("fromtaxamount");
                    oriEntryIdAndEntryRemainIssuedAmt.putIfAbsent(billEntryId, isForm ? issuedLocAmt : issuedAmt);
                    oriEntryIdAndEntryRemainIssuedTax.putIfAbsent(billEntryId, isForm ? issuedLocTax : issuedTax);
                    oriEntryIdAndEntryRemainIssuedAmtLocal.putIfAbsent(billEntryId, issuedAmt);
                    oriEntryIdAndEntryRemainIssuedTaxLocal.putIfAbsent(billEntryId, issuedTax);
                    oriEntryIdAndEntryRemainTax.putIfAbsent(billEntryId, isForm ? fromtax : tax);
                    oriEntryIdAndEntryRemainAmt.putIfAbsent(billEntryId, isForm ? fromamount : amount);
                    oriEntryIdAndEntryRemainPriceTotal.putIfAbsent(billEntryId, isForm ? fromtaxamount : taxamount);
                    oriEntryIdAndEntryRemainTaxLocal.putIfAbsent(billEntryId, tax);
                    oriEntryIdAndEntryRemainAmtLocal.putIfAbsent(billEntryId, amount);
                    oriEntryIdAndEntryRemainPriceTotalLocal.putIfAbsent(billEntryId, taxamount);
                    DynamicObject originalBill = originalBillMap.get(billEntryId);
                    BigDecimal unRelateAmt = originalBill.getBigDecimal("sim_original_bill_item.unpushamt");
                    BigDecimal unRelateLocAmt = originalBill.getBigDecimal("sim_original_bill_item.unpushlocalamt");
                    BigDecimal unRelateQty = originalBill.getBigDecimal("sim_original_bill_item.unpushnum");
                    oriEntryIdAndEntryRemainVerifyQty.putIfAbsent(billEntryId, unRelateQty);
                    oriEntryIdAndEntryRemainInvoiceAmt.putIfAbsent(billEntryId, unRelateAmt);
                    oriEntryIdAndEntryRemainInvoiceLocAmt.putIfAbsent(billEntryId, unRelateLocAmt);
                    continue;
                }
                DynamicObject originalBill = originalBillMap.get(billEntryId);
                issuedTax = originalBill.getBigDecimal("sim_original_bill_item.issuedtax");
                issuedAmt = originalBill.getBigDecimal("sim_original_bill_item.issuedamount");
                issuedLocTax = originalBill.getBigDecimal("sim_original_bill_item.fromissuedtax");
                issuedLocAmt = originalBill.getBigDecimal("sim_original_bill_item.fromissuedamount");
                BigDecimal unRelateAmt = originalBill.getBigDecimal("sim_original_bill_item.unpushamt");
                BigDecimal unRelateQty = originalBill.getBigDecimal("sim_original_bill_item.unpushnum");
                BigDecimal unRelateLocAmt = originalBill.getBigDecimal("sim_original_bill_item.unpushlocalamt");
                oriEntryIdAndEntryRemainIssuedAmt.putIfAbsent(billEntryId, isForm ? issuedLocAmt : issuedAmt);
                oriEntryIdAndEntryRemainIssuedTax.putIfAbsent(billEntryId, isForm ? issuedLocTax : issuedTax);
                oriEntryIdAndEntryRemainInvoiceAmt.putIfAbsent(billEntryId, unRelateAmt);
                oriEntryIdAndEntryRemainInvoiceLocAmt.putIfAbsent(billEntryId, unRelateLocAmt);
                oriEntryIdAndEntryRemainIssuedAmtLocal.putIfAbsent(billEntryId, issuedAmt);
                oriEntryIdAndEntryRemainIssuedTaxLocal.putIfAbsent(billEntryId, issuedTax);
                oriEntryIdAndEntryRemainVerifyQty.putIfAbsent(billEntryId, unRelateQty);
                BigDecimal amount = originalBill.getBigDecimal("sim_original_bill_item.amount");
                BigDecimal fromAmount = originalBill.getBigDecimal("sim_original_bill_item.fromamount");
                BigDecimal tax = originalBill.getBigDecimal("sim_original_bill_item.tax");
                BigDecimal fromTax = originalBill.getBigDecimal("sim_original_bill_item.fromtax");
                BigDecimal taxamount = originalBill.getBigDecimal("sim_original_bill_item.taxamount");
                BigDecimal fromTaxAmount = originalBill.getBigDecimal("sim_original_bill_item.fromtaxamount");
                oriEntryIdAndEntryRemainTax.putIfAbsent(billEntryId, isForm ? fromTax : tax);
                oriEntryIdAndEntryRemainAmt.putIfAbsent(billEntryId, isForm ? fromAmount : amount);
                oriEntryIdAndEntryRemainPriceTotal.putIfAbsent(billEntryId, isForm ? fromTaxAmount : taxamount);
                oriEntryIdAndEntryRemainTaxLocal.putIfAbsent(billEntryId, tax);
                oriEntryIdAndEntryRemainAmtLocal.putIfAbsent(billEntryId, amount);
                oriEntryIdAndEntryRemainPriceTotalLocal.putIfAbsent(billEntryId, taxamount);
            }
        }
        for (DynamicObject historyRecord : historyRecords) {
            Long billEntryId3 = historyRecord.getLong("entry.assbillentryid");
            BigDecimal historyVerifyQAmt = historyRecord.getBigDecimal("entry.assverifyamt");
            BigDecimal historyVerifyQAmtLocal = historyRecord.getBigDecimal("entry.assverifylocamt");
            BigDecimal historyVerifyQPriceTax = historyRecord.getBigDecimal("entry.assverifytax");
            BigDecimal historyVerifyQPriceTaxLocal = historyRecord.getBigDecimal("entry.assverifyloctax");
            oriEntryIdAndEntryRemainIssuedAmt.computeIfPresent(billEntryId3, (k, v) -> v.subtract(historyVerifyQAmt));
            oriEntryIdAndEntryRemainIssuedAmtLocal.computeIfPresent(billEntryId3, (k, v) -> v.subtract(historyVerifyQAmtLocal));
            oriEntryIdAndEntryRemainIssuedTax.computeIfPresent(billEntryId3, (k, v) -> v.subtract(historyVerifyQPriceTax));
            oriEntryIdAndEntryRemainIssuedTaxLocal.computeIfPresent(billEntryId3, (k, v) -> v.subtract(historyVerifyQPriceTaxLocal));
        }
        for (DynamicObject record : records) {
            entries = record.getDynamicObjectCollection("entry");
            long writeOffTypeId = record.getLong("writeofftypeid.id");
            for (DynamicObject entry : entries) {
                billEntryId = entry.getLong("assbillentryid");
                Long billId = entry.getLong("assbillid");
                BigDecimal assVerifyQty = entry.getBigDecimal("assverifyqty");
                BigDecimal assVerifyAmt = entry.getBigDecimal("assverifyamt");
                BigDecimal assVerifyLocAmt = entry.getBigDecimal("assverifylocamt");
                BigDecimal assverifyPriceTax = entry.getBigDecimal("assverifypricetax");
                BigDecimal assverifyLocPriceTax = entry.getBigDecimal("assverifylocpricetax");
                BigDecimal assverifyTax = entry.getBigDecimal("assverifytax");
                BigDecimal assverifyLocTax = entry.getBigDecimal("assverifyloctax");
                BigDecimal remainIssuedAmt = (BigDecimal)oriEntryIdAndEntryRemainIssuedAmt.get(billEntryId);
                BigDecimal remainIssuedLocAmt = (BigDecimal)oriEntryIdAndEntryRemainIssuedAmtLocal.get(billEntryId);
                BigDecimal remainPricetaxTotal = (BigDecimal)oriEntryIdAndEntryRemainInvoiceAmt.get(billEntryId);
                BigDecimal remainLocPricetaxTotal = (BigDecimal)oriEntryIdAndEntryRemainInvoiceLocAmt.get(billEntryId);
                BigDecimal remainIssuedTax = (BigDecimal)oriEntryIdAndEntryRemainIssuedTax.get(billEntryId);
                BigDecimal remainIssuedLocTax = (BigDecimal)oriEntryIdAndEntryRemainIssuedTaxLocal.get(billEntryId);
                if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == writeOffTypeId) {
                    BigDecimal remainQty = (BigDecimal)oriEntryIdAndEntryRemainVerifyQty.get(billEntryId);
                    BigDecimal assBillQty = entry.getBigDecimal("assbillqty");
                    if (remainQty == null) continue;
                    if (assVerifyQty.compareTo(remainQty) == 0 || assVerifyQty.compareTo(assBillQty) == 0) {
                        logger.info("ArOriginalWFRecordWriteOffPlugin handleAssTailDiffrence qty core set");
                        entry.set("assverifyqty", (Object)remainQty);
                        entry.set("assverifyamt", (Object)remainIssuedAmt);
                        entry.set("assverifylocamt", (Object)remainIssuedLocAmt);
                        entry.set("assverifypricetax", (Object)remainPricetaxTotal);
                        entry.set("assverifylocpricetax", (Object)remainLocPricetaxTotal);
                        entry.set("assverifytax", (Object)remainIssuedTax);
                        entry.set("assverifyloctax", (Object)remainIssuedLocTax);
                        entry.set("assamount", oriEntryIdAndEntryRemainAmt.get(billEntryId));
                        entry.set("asslocamt", oriEntryIdAndEntryRemainAmtLocal.get(billEntryId));
                        entry.set("asstax", oriEntryIdAndEntryRemainTax.get(billEntryId));
                        entry.set("assloctax", oriEntryIdAndEntryRemainTaxLocal.get(billEntryId));
                        entry.set("asspricetaxtotal", oriEntryIdAndEntryRemainPriceTotal.get(billEntryId));
                        entry.set("asslocpricetaxtotal", oriEntryIdAndEntryRemainPriceTotalLocal.get(billEntryId));
                        continue;
                    }
                    oriEntryIdAndEntryRemainVerifyQty.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyQty));
                    oriEntryIdAndEntryRemainIssuedAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyAmt));
                    oriEntryIdAndEntryRemainIssuedAmtLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyLocAmt));
                    oriEntryIdAndEntryRemainInvoiceAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(assverifyPriceTax));
                    oriEntryIdAndEntryRemainInvoiceLocAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(assverifyLocPriceTax));
                    oriEntryIdAndEntryRemainIssuedTax.computeIfPresent(billEntryId, (k, v) -> v.subtract(assverifyTax));
                    oriEntryIdAndEntryRemainIssuedTaxLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(assverifyLocTax));
                    continue;
                }
                if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE != writeOffTypeId) continue;
                BigDecimal priceTaxTotal = entry.getBigDecimal("asspricetaxtotal");
                if (remainPricetaxTotal == null) continue;
                if (assverifyPriceTax.compareTo(remainPricetaxTotal) == 0 || assverifyPriceTax.compareTo(priceTaxTotal) == 0) {
                    logger.info("ArOriginalWFRecordWriteOffPlugin handleAssTailDiffrence billEntryId" + billEntryId);
                    entry.set("assverifyqty", (Object)(priceTaxTotal.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ONE : BigDecimal.ZERO));
                    entry.set("assverifyamt", (Object)remainIssuedAmt);
                    entry.set("assverifylocamt", (Object)remainIssuedLocAmt);
                    entry.set("assverifypricetax", (Object)remainPricetaxTotal);
                    entry.set("assverifylocpricetax", (Object)remainLocPricetaxTotal);
                    entry.set("assverifytax", (Object)remainIssuedTax);
                    entry.set("assverifyloctax", (Object)remainIssuedLocTax);
                    entry.set("assamount", oriEntryIdAndEntryRemainAmt.get(billEntryId));
                    entry.set("asslocamt", oriEntryIdAndEntryRemainAmtLocal.get(billEntryId));
                    entry.set("asstax", oriEntryIdAndEntryRemainTax.get(billEntryId));
                    entry.set("assloctax", oriEntryIdAndEntryRemainTaxLocal.get(billEntryId));
                    entry.set("asspricetaxtotal", oriEntryIdAndEntryRemainPriceTotal.get(billEntryId));
                    entry.set("asslocpricetaxtotal", oriEntryIdAndEntryRemainPriceTotalLocal.get(billEntryId));
                    continue;
                }
                oriEntryIdAndEntryRemainIssuedAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyAmt));
                oriEntryIdAndEntryRemainIssuedAmtLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyLocAmt));
                oriEntryIdAndEntryRemainInvoiceAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(assverifyPriceTax));
                oriEntryIdAndEntryRemainInvoiceLocAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(assverifyLocPriceTax));
                oriEntryIdAndEntryRemainIssuedTax.computeIfPresent(billEntryId, (k, v) -> v.subtract(assverifyTax));
                oriEntryIdAndEntryRemainIssuedTaxLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(assverifyLocTax));
            }
        }
    }

    private void handleMainTailDifference(List<DynamicObject> records) {
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainAmt = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainAmtLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainTax = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainTaxLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainPriceTotal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainPriceTotalLocal = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> finIds = new HashSet<Long>(8);
        HashSet<Long> finEntryIds = new HashSet<Long>(8);
        HashSet<Long> recordIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            recordIds.add(record.getLong("id"));
            for (DynamicObject entry : entries) {
                Long billId = entry.getLong("billid");
                Long billEntryId = entry.getLong("billentryid");
                finIds.add(billId);
                finEntryIds.add(billEntryId);
                finEntryIdAndEntryRemainQty.putIfAbsent(billEntryId, entry.getBigDecimal("billqty"));
                finEntryIdAndEntryRemainAmt.putIfAbsent(billEntryId, entry.getBigDecimal("amount"));
                finEntryIdAndEntryRemainAmtLocal.putIfAbsent(billEntryId, entry.getBigDecimal("localamt"));
                finEntryIdAndEntryRemainTax.putIfAbsent(billEntryId, entry.getBigDecimal("tax"));
                finEntryIdAndEntryRemainTaxLocal.putIfAbsent(billEntryId, entry.getBigDecimal("loctax"));
                finEntryIdAndEntryRemainPriceTotal.putIfAbsent(billEntryId, entry.getBigDecimal("pricetaxtotal"));
                finEntryIdAndEntryRemainPriceTotalLocal.putIfAbsent(billEntryId, entry.getBigDecimal("locpricetaxtotal"));
            }
        }
        DynamicObjectCollection historyRecords = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,entry.id,entry.billid,entry.billentryid,entry.verifyqty,entry.verifyamt,entry.verifylocamt,entry.verifypricetax,entry.verifylocpricetax,entry.verifytax,entry.verifyloctax", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", finIds), new QFilter("entry.billentryid", "in", finEntryIds), new QFilter("id", "not in", recordIds)});
        for (DynamicObject historyRecord : historyRecords) {
            Long billEntryId = historyRecord.getLong("entry.billentryid");
            BigDecimal historyVerifyQty = historyRecord.getBigDecimal("entry.verifyqty");
            BigDecimal historyVerifyQAmt = historyRecord.getBigDecimal("entry.verifyamt");
            BigDecimal historyVerifyQAmtLocal = historyRecord.getBigDecimal("entry.verifylocamt");
            BigDecimal historyVerifyQPriceTax = historyRecord.getBigDecimal("entry.verifytax");
            BigDecimal historyVerifyQPriceTaxLocal = historyRecord.getBigDecimal("entry.verifyloctax");
            BigDecimal historyVerifyQPriceTotal = historyRecord.getBigDecimal("entry.verifypricetax");
            BigDecimal historyVerifyQPriceTotalLocal = historyRecord.getBigDecimal("entry.verifylocpricetax");
            finEntryIdAndEntryRemainQty.computeIfPresent(billEntryId, (k, v) -> v.subtract(historyVerifyQty));
            finEntryIdAndEntryRemainAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(historyVerifyQAmt));
            finEntryIdAndEntryRemainAmtLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(historyVerifyQAmtLocal));
            finEntryIdAndEntryRemainPriceTotal.computeIfPresent(billEntryId, (k, v) -> v.subtract(historyVerifyQPriceTotal));
            finEntryIdAndEntryRemainPriceTotalLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(historyVerifyQPriceTotalLocal));
            finEntryIdAndEntryRemainTax.computeIfPresent(billEntryId, (k, v) -> v.subtract(historyVerifyQPriceTax));
            finEntryIdAndEntryRemainTaxLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(historyVerifyQPriceTaxLocal));
        }
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            long writeOffTypeId = record.getLong("writeofftypeid.id");
            for (DynamicObject entry : entries) {
                Long billEntryId = entry.getLong("billentryid");
                BigDecimal verifyQty = entry.getBigDecimal("verifyqty");
                BigDecimal verifyAmt = entry.getBigDecimal("verifyamt");
                BigDecimal verifyLocAmt = entry.getBigDecimal("verifylocamt");
                BigDecimal verifyPriceTax = entry.getBigDecimal("verifypricetax");
                BigDecimal verifyLocPriceTax = entry.getBigDecimal("verifylocpricetax");
                BigDecimal verifyTax = entry.getBigDecimal("verifytax");
                BigDecimal verifyLocTax = entry.getBigDecimal("verifyloctax");
                BigDecimal remainAmt = (BigDecimal)finEntryIdAndEntryRemainAmt.get(billEntryId);
                BigDecimal remainLocAmt = (BigDecimal)finEntryIdAndEntryRemainAmtLocal.get(billEntryId);
                BigDecimal remainPriceTax = (BigDecimal)finEntryIdAndEntryRemainPriceTotal.get(billEntryId);
                BigDecimal remainLocPriceTax = (BigDecimal)finEntryIdAndEntryRemainPriceTotalLocal.get(billEntryId);
                BigDecimal remainTax = (BigDecimal)finEntryIdAndEntryRemainTax.get(billEntryId);
                BigDecimal remainLocTax = (BigDecimal)finEntryIdAndEntryRemainTaxLocal.get(billEntryId);
                if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == writeOffTypeId) {
                    BigDecimal billQty = entry.getBigDecimal("billqty");
                    BigDecimal remainQty = (BigDecimal)finEntryIdAndEntryRemainQty.get(billEntryId);
                    if (remainQty == null || billQty.compareTo(verifyQty) == 0) continue;
                    if (verifyQty.compareTo(remainQty) == 0) {
                        entry.set("verifyqty", (Object)remainQty);
                        entry.set("verifyamt", (Object)remainAmt);
                        entry.set("verifylocamt", (Object)remainLocAmt);
                        entry.set("verifypricetax", (Object)remainPriceTax);
                        entry.set("verifylocpricetax", (Object)remainLocPriceTax);
                        entry.set("verifytax", (Object)remainTax);
                        entry.set("verifyloctax", (Object)remainLocTax);
                        continue;
                    }
                    finEntryIdAndEntryRemainQty.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyQty));
                    finEntryIdAndEntryRemainAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyAmt));
                    finEntryIdAndEntryRemainAmtLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocAmt));
                    finEntryIdAndEntryRemainPriceTotal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyPriceTax));
                    finEntryIdAndEntryRemainPriceTotalLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocPriceTax));
                    finEntryIdAndEntryRemainTax.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyTax));
                    finEntryIdAndEntryRemainTaxLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocTax));
                    continue;
                }
                if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE != writeOffTypeId) continue;
                BigDecimal priceTaxTotal = entry.getBigDecimal("pricetaxtotal");
                if (remainPriceTax == null || priceTaxTotal.compareTo(verifyPriceTax) == 0) continue;
                if (verifyPriceTax.compareTo(remainPriceTax) == 0) {
                    entry.set("verifyqty", (Object)(priceTaxTotal.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ONE : BigDecimal.ZERO));
                    entry.set("verifyamt", (Object)remainAmt);
                    entry.set("verifylocamt", (Object)remainLocAmt);
                    entry.set("verifypricetax", (Object)remainPriceTax);
                    entry.set("verifylocpricetax", (Object)remainLocPriceTax);
                    entry.set("verifytax", (Object)remainTax);
                    entry.set("verifyloctax", (Object)remainLocTax);
                    continue;
                }
                finEntryIdAndEntryRemainAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyAmt));
                finEntryIdAndEntryRemainAmtLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocAmt));
                finEntryIdAndEntryRemainPriceTotal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyPriceTax));
                finEntryIdAndEntryRemainPriceTotalLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocPriceTax));
                finEntryIdAndEntryRemainTax.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyTax));
                finEntryIdAndEntryRemainTaxLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocTax));
            }
        }
    }

    private void buildDisBillInfo(List<DisposeParam> disMainParamByQtyList, DynamicObjectCollection recordEntrys, Map<Long, Map<String, String>> invNoMap, boolean isHead) {
        for (DynamicObject recordEntry : recordEntrys) {
            DisposeParam disposeMainParam = new DisposeParam();
            Long billEntryid = isHead ? recordEntry.getLong("billid") : recordEntry.getLong("billentryid");
            String invNo = recordEntry.getString("assinvoiceno");
            String invCode = recordEntry.getString("assinvoicecode");
            disposeMainParam.id = recordEntry.getLong("billid");
            disposeMainParam.entryId = billEntryid;
            Map<String, String> billInvNoMap = invNoMap.get(billEntryid);
            String billInvNo = billInvNoMap.get("invNo");
            String billInvCode = billInvNoMap.get("invCode");
            ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(billInvNo.split(", ")));
            ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(billInvCode.split(", ")));
            inCodesList.remove("");
            inNosList.remove("");
            if (StringUtils.isNotEmpty((CharSequence)invNo) && !inNosList.contains(invNo)) {
                inNosList.add(invNo);
            }
            if (StringUtils.isNotBlank((CharSequence)invCode) && !inCodesList.contains(invCode)) {
                inCodesList.add(invCode);
            }
            String dealInvNo = String.join((CharSequence)", ", inNosList);
            String dealInvCode = String.join((CharSequence)", ", inCodesList);
            disposeMainParam.invNo = dealInvNo;
            disposeMainParam.invCode = dealInvCode;
            billInvNoMap.put("invNo", dealInvNo);
            billInvNoMap.put("invCode", dealInvCode);
            invNoMap.put(billEntryid, billInvNoMap);
            disMainParamByQtyList.add(disposeMainParam);
        }
    }

    private Map<String, List<Object[]>> buildBackSqlByEntry(List<DisposeParam> disMainParamByEntryList, List<DisposeParam> disMainParamByHeadList) {
        Object disposeSql;
        Object[] param;
        ArrayList<Object[]> sqlParams;
        HashMap<String, List<Object[]>> sqlLists = new HashMap<String, List<Object[]>>();
        if (disMainParamByEntryList.size() > 0) {
            sqlParams = new ArrayList<Object[]>(disMainParamByEntryList.size());
            for (DisposeParam disposeParam : disMainParamByEntryList) {
                param = new Object[]{disposeParam.invCode, disposeParam.invNo, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_finarbillentry_e set finvoicecode =?,finvoiceno = ?  where fentryid =? and fid =?";
            sqlLists.put((String)disposeSql, sqlParams);
        }
        if (disMainParamByHeadList.size() > 0) {
            sqlParams = new ArrayList(disMainParamByHeadList.size());
            for (DisposeParam disposeParam : disMainParamByHeadList) {
                param = new Object[]{disposeParam.invCode, disposeParam.invNo, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_finarbill_e set finvoicecode =?,finvoiceno = ?  where fid =?";
            sqlLists.put((String)disposeSql, sqlParams);
        }
        return sqlLists;
    }

    public static Map<Long, Set<Long>> loadTargetRowIdsMap(String sourceEntityName, String sourceEntryName, Long[] sourceEntryIds, String targetEntityName) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        Map<Long, Map<String, Set<Long>>> allTargetRowIdsMap = ArOriginalWFRecordWriteOffPlugin.loadAllTargetRowIdsMap(sourceEntityName, sourceEntryName, sourceEntryIds);
        for (Map.Entry<Long, Map<String, Set<Long>>> entry : allTargetRowIdsMap.entrySet()) {
            Set specifiedTargetEntryIds = entry.getValue().getOrDefault(targetEntityName, new HashSet(16));
            if (ObjectUtils.isEmpty((Object)specifiedTargetEntryIds)) continue;
            result.put(entry.getKey(), specifiedTargetEntryIds);
        }
        return result;
    }

    public static Map<Long, Map<String, Set<Long>>> loadAllTargetRowIdsMap(String sourceEntityName, String sourceEntryName, Long[] sourceEntryIds) {
        HashMap<Long, Map<String, Set<Long>>> result = new HashMap<Long, Map<String, Set<Long>>>(16);
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)sourceEntityName, (String)sourceEntryName, (Long[])sourceEntryIds);
        if (bfRowLinkDownNodes == null || bfRowLinkDownNodes.size() < 1) {
            return result;
        }
        for (Long entryId : sourceEntryIds) {
            List nodes = bfRowLinkDownNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).collect(Collectors.toList());
            for (BFRowLinkDownNode node : nodes) {
                HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>();
                ArOriginalWFRecordWriteOffPlugin.findTargetNodesByEntry(node, entryId, resultMap);
                result.put(entryId, resultMap);
            }
        }
        return result;
    }

    private static void findTargetNodesByEntry(BFRowLinkDownNode node, Long entryId, Map<String, Set<Long>> resultMap) {
        if (node.getRowId().getEntryId().compareTo(entryId) != 0) {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)node.getRowId().getMainTableId());
            String targetEntityName = tableDefine.getEntityNumber();
            Set<Long> exitsSet = resultMap.get(targetEntityName);
            if (exitsSet == null) {
                exitsSet = new HashSet<Long>();
                resultMap.put(targetEntityName, exitsSet);
            }
            exitsSet.add(node.getRowId().getEntryId());
        }
        for (BFRowLinkDownNode tNode : node.getTNodes().values()) {
            ArOriginalWFRecordWriteOffPlugin.findTargetNodesByEntry(tNode, entryId, resultMap);
        }
    }

    private Map<Long, DynamicObject> prepareSimBills(Map<Long, Set<Long>> targetRowIdsMap) {
        Set simBillEntryId = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection simBillEntry = QueryServiceHelper.query((String)"sim_original_bill", (String)"sim_original_bill_item.id entryId,sim_original_bill_item.issuedamount issuedamount,sim_original_bill_item.issuedtax issuedtax,sim_original_bill_item.issuedtotaltaxamount issuedtotaltaxamount,sim_original_bill_item.amountdeviation amountdeviation,validstate,closestatus,sim_original_bill_item.amount amount,sim_original_bill_item.fromissuedamount fromissuedamount,sim_original_bill_item.fromissuedtax fromissuedtax,sim_original_bill_item.fromissuedtaxamount fromissuedtaxamount,sim_original_bill.exrate exrate", (QFilter[])new QFilter[]{new QFilter("sim_original_bill_item.id", "in", simBillEntryId)});
        return simBillEntry.stream().collect(Collectors.toMap(sim -> sim.getLong("entryId"), sim -> sim));
    }

    private Map<Long, Set<DynamicObject>> getRecordEntryIdOriginalMap(List<Long> finArEntryIds, Map<Long, Set<Long>> targetRowIdsMap) {
        HashMap<Long, Set<DynamicObject>> recordEntryIdOriginalMap = new HashMap<Long, Set<DynamicObject>>(8);
        HashSet<Long> hxlbSet = new HashSet<Long>(2);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,entry.billentryid,entry.assbillentryid,entry.assverifyamt,entry.assverifylocamt,entry.assverifytax,entry.assverifyloctax,entry.assverifypricetax,entry.assverifylocpricetax,entry.asscurrency,entry.assbasecurrency", (QFilter[])new QFilter[]{new QFilter("writeofftypeid", "not in", hxlbSet), new QFilter("entry.billentryid", "in", finArEntryIds)});
        logger.info("ArOriginalWFRecordWriteOffPlugin getRecordEntryIdOriginalMap records size" + records.size());
        for (DynamicObject record : records) {
            Long arEntryId = record.getLong("entry.billentryid");
            long oriId = record.getLong("entry.assbillentryid");
            Set originalEntryIdSet = targetRowIdsMap.getOrDefault(arEntryId, new HashSet(8));
            Set recordEntrySet = recordEntryIdOriginalMap.getOrDefault(oriId, new HashSet(8));
            originalEntryIdSet.add(oriId);
            recordEntrySet.add(record);
            recordEntryIdOriginalMap.put(oriId, recordEntrySet);
            targetRowIdsMap.put(arEntryId, originalEntryIdSet);
        }
        return recordEntryIdOriginalMap;
    }

    private Map<Long, Set<DynamicObject>> getFinArEntryIdToVerifyRecordMap(List<Long> finArEntryIds) {
        HashMap<Long, Set<DynamicObject>> result = new HashMap<Long, Set<DynamicObject>>(8);
        HashSet<Long> hxlbSet = new HashSet<Long>(2);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,entry.billentryid,entry.assbillentryid,entry.assverifyamt,entry.assverifylocamt,entry.assverifytax,entry.assverifyloctax,entry.assverifypricetax,entry.assverifylocpricetax,entry.asscurrency,entry.assbasecurrency", (QFilter[])new QFilter[]{new QFilter("writeofftypeid", "not in", hxlbSet), new QFilter("entry.billentryid", "in", finArEntryIds)});
        logger.info("ArOriginalWFRecordWriteOffPlugin getRecordEntryIdOriginalMap records size" + records.size());
        for (DynamicObject record : records) {
            Long arEntryId = record.getLong("entry.billentryid");
            Set recordEntrySet = result.getOrDefault(arEntryId, new HashSet(8));
            recordEntrySet.add(record);
            result.put(arEntryId, recordEntrySet);
        }
        return result;
    }

    private void updateSimEntryObj(Map<Long, DynamicObject> simEntryObjMap, Map<Long, Set<DynamicObject>> recordEntryIdOriginalMap, Set<Long> botpExistOriIdSet, Map<Long, Set<DynamicObject>> finArEntryIdToVerifyRecordMap) {
        if (ObjectUtils.isEmpty(recordEntryIdOriginalMap) || botpExistOriIdSet == null) {
            return;
        }
        for (Map.Entry<Long, Set<DynamicObject>> entry : recordEntryIdOriginalMap.entrySet()) {
            Long oriId = entry.getKey();
            Set<DynamicObject> recordOriginalSet = recordEntryIdOriginalMap.get(oriId);
            DynamicObject botpOriginal = simEntryObjMap.get(oriId);
            if (recordOriginalSet == null || botpOriginal == null) continue;
            BigDecimal issuedAmount = botpOriginal.getBigDecimal("issuedamount");
            BigDecimal issuedTax = botpOriginal.getBigDecimal("issuedtax");
            BigDecimal issuedPriceTax = botpOriginal.getBigDecimal("issuedtotaltaxamount");
            BigDecimal issuedLocAmount = botpOriginal.getBigDecimal("fromissuedamount");
            BigDecimal issuedLocTax = botpOriginal.getBigDecimal("fromissuedtax");
            BigDecimal issuedLocPriceTax = botpOriginal.getBigDecimal("fromissuedtaxamount");
            BigDecimal recordIssuedAmount = BigDecimal.ZERO;
            BigDecimal recordIssuedTax = BigDecimal.ZERO;
            BigDecimal recordIssuedPriceTax = BigDecimal.ZERO;
            BigDecimal recordIssuedLocAmount = BigDecimal.ZERO;
            BigDecimal recordIssuedLocTax = BigDecimal.ZERO;
            BigDecimal recordIssuedLocPriceTax = BigDecimal.ZERO;
            for (DynamicObject recordOriginal : recordOriginalSet) {
                long baseCurrency;
                boolean isSameCurr;
                BigDecimal recordAmount = recordOriginal.getBigDecimal("entry.assverifyamt");
                BigDecimal recordTax = recordOriginal.getBigDecimal("entry.assverifytax");
                BigDecimal recordPriceTax = recordOriginal.getBigDecimal("entry.assverifypricetax");
                BigDecimal recordLocAmount = recordOriginal.getBigDecimal("entry.assverifylocamt");
                BigDecimal recordLocTax = recordOriginal.getBigDecimal("entry.assverifyloctax");
                BigDecimal recordLocPriceTax = recordOriginal.getBigDecimal("entry.assverifylocpricetax");
                long currency = recordOriginal.getLong("entry.asscurrency");
                boolean bl = isSameCurr = currency == (baseCurrency = recordOriginal.getLong("entry.assbasecurrency"));
                if (botpExistOriIdSet.contains(oriId)) {
                    botpOriginal.set("issuedamount", (Object)issuedAmount.add(recordAmount));
                    botpOriginal.set("issuedtax", (Object)issuedTax.add(recordTax));
                    botpOriginal.set("issuedtotaltaxamount", (Object)issuedPriceTax.add(recordPriceTax));
                    botpOriginal.set("fromissuedamount", (Object)issuedLocAmount.add(recordLocAmount));
                    botpOriginal.set("fromissuedtax", (Object)issuedLocTax.add(recordLocTax));
                    botpOriginal.set("fromissuedtaxamount", (Object)issuedLocPriceTax.add(recordLocPriceTax));
                    simEntryObjMap.put(oriId, botpOriginal);
                    continue;
                }
                recordIssuedAmount = recordIssuedAmount.add(recordAmount);
                recordIssuedTax = recordIssuedTax.add(recordTax);
                recordIssuedPriceTax = recordIssuedPriceTax.add(recordPriceTax);
                recordIssuedLocAmount = recordIssuedLocAmount.add(recordLocAmount);
                recordIssuedLocTax = recordIssuedLocTax.add(recordLocTax);
                recordIssuedLocPriceTax = recordIssuedLocPriceTax.add(recordLocPriceTax);
                logger.info("ArOriginalWFRecordWriteOffPlugin updateSimEntryObj recordAmount " + recordAmount);
                logger.info("ArOriginalWFRecordWriteOffPlugin updateSimEntryObj recordIssuedAmount " + recordIssuedAmount);
                botpOriginal.set("issuedamount", (Object)recordIssuedLocAmount);
                botpOriginal.set("issuedtax", (Object)recordIssuedLocTax);
                botpOriginal.set("issuedtotaltaxamount", (Object)recordIssuedLocPriceTax);
                botpOriginal.set("fromissuedamount", (Object)(isSameCurr ? recordIssuedLocAmount : recordIssuedAmount));
                botpOriginal.set("fromissuedtax", (Object)(isSameCurr ? recordIssuedLocTax : recordIssuedTax));
                botpOriginal.set("fromissuedtaxamount", (Object)(isSameCurr ? recordIssuedLocPriceTax : recordIssuedPriceTax));
                botpOriginal.set("amountdeviation", (Object)BigDecimal.ZERO);
                simEntryObjMap.put(oriId, botpOriginal);
            }
        }
    }

    static class DisposeParam {
        long id;
        long entryId;
        String invNo;
        String invCode;

        DisposeParam() {
        }
    }
}

