/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffPlugin;

public class ArRevVerifyUnWriteOffPlugin
implements IUnWriteOffCheckPlugin,
IUnWriteOffPlugin {
    private static final Log logger = LogFactory.getLog(ArRevVerifyUnWriteOffPlugin.class);
    private static final long HXLB_AR_REV_VERIFY_QTY = 1566715159244716032L;
    private static final long HXLB_AR_REV_VERIFY_AMOUNT = 1569651463666271232L;

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(1566715159244716032L, 1569651463666271232L);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        fieldMap.put("ar_revcrm_verifyrecord", new HashSet<String>(Arrays.asList("writeofftypeid", "entry.revbillid", "entry.billid", "entry.billentryid", "entry.verifyqty", "entry.verifybaseqty", "entry.verifyamt", "entry.assbillid", "entry.assbillentryid", "entry.assverifyqty", "entry.assverifybaseqty", "entry.assverifyamt")));
        return fieldMap;
    }

    @Override
    public boolean check(DynamicObject recordBill) {
        return true;
    }

    @Override
    public void beforeWfRecordDelete(List<DynamicObject> records) {
        this.autoDeleteRevBill(records);
    }

    private void autoDeleteRevBill(List<DynamicObject> records) {
        Set revBillIds = records.stream().map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(entry -> entry.getLong("revbillid") != 0L).map(entry -> entry.getLong("revbillid")).collect(Collectors.toSet());
        if (revBillIds.size() == 0) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("backwriteoff_tag", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isshowmessage", String.valueOf(false));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        try (TXHandle tx = TX.notSupported();){
            List unAuditIds;
            OperationResult unAuditRes;
            QFilter q1 = new QFilter("id", "in", revBillIds);
            QFilter q2 = new QFilter("billstatus", "=", (Object)"C");
            DynamicObjectCollection queryRes = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id, billno", (QFilter[])new QFilter[]{q1, q2});
            if (queryRes != null && !queryRes.isEmpty() && (unAuditRes = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_revcfmbill", (Object[])(unAuditIds = queryRes.stream().map(d -> d.getLong("id")).collect(Collectors.toList())).toArray(), (OperateOption)option)) != null && !unAuditRes.isSuccess()) {
                List<String> errInfo = ArRevVerifyUnWriteOffPlugin.getErrOperationResultTip(unAuditRes);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5355\u636e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002\u9519\u8bef\u539f\u56e0\uff1a%s\u3002", (String)"ArRevVerifyUnWriteOffPlugin_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), errInfo));
            }
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)"ar_revcfmbill", (Object[])revBillIds.toArray(), (OperateOption)option);
            OperationServiceHelper.executeOperate((String)"delete", (String)"ar_revcfmbill", (Object[])revBillIds.toArray(), (OperateOption)option);
        }
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        HashMap<String, Map<String, List<Object[]>>> sqlListMaps = new HashMap<String, Map<String, List<Object[]>>>();
        logger.info("ArRevVerifyUnWriteOffPlugin-\u51c6\u5907\u6784\u5efa\u53cd\u5199sql-records_size\uff1a" + records.size());
        ArrayList<DisposeParam> disMainParamByQtyList = new ArrayList<DisposeParam>(8);
        ArrayList<DisposeParam> disMainParamByAmtList = new ArrayList<DisposeParam>(8);
        ArrayList<DisposeParam> disAsstParamByQtyList = new ArrayList<DisposeParam>(8);
        ArrayList<DisposeParam> disAsstParamByAmtList = new ArrayList<DisposeParam>(8);
        for (DynamicObject recordBill : records) {
            if (recordBill == null) continue;
            long verifyTypeId = recordBill.getLong("writeofftypeid.id");
            DynamicObjectCollection recordEntrys = recordBill.getDynamicObjectCollection("entry");
            if (recordEntrys == null || recordEntrys.isEmpty()) continue;
            this.buildDisBillInfo(disMainParamByQtyList, disMainParamByAmtList, disAsstParamByQtyList, disAsstParamByAmtList, verifyTypeId, recordEntrys);
        }
        Map<String, List<Object[]>> sqlLists = this.buildBackSql(disMainParamByQtyList, disMainParamByAmtList, disAsstParamByQtyList, disAsstParamByAmtList);
        logger.info("ArRevVerifyUnWriteOffPlugin-\u6784\u5efa\u53cd\u5199sql\u5b8c\u6bd5\uff0csqlLists_size\uff1a" + sqlLists.size());
        sqlListMaps.put("fi", sqlLists);
        return sqlListMaps;
    }

    private Map<String, List<Object[]>> buildBackSql(List<DisposeParam> disMainParamByQtyList, List<DisposeParam> disMainParamByAmtList, List<DisposeParam> disAstParamByQtyList, List<DisposeParam> disAstParamByAmtList) {
        Object disposeSql;
        Object[] param;
        ArrayList<Object[]> sqlParams;
        HashMap<String, List<Object[]>> sqlLists = new HashMap<String, List<Object[]>>();
        if (disMainParamByQtyList.size() > 0) {
            sqlParams = new ArrayList<Object[]>(disMainParamByQtyList.size());
            for (DisposeParam disposeParam : disMainParamByQtyList) {
                param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyAmt, disposeParam.verifyAmt, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_finarbillentry set fconfirmedqty =fconfirmedqty - ?,funconfirmqty = funconfirmqty + ?,fconfirmedamt = fconfirmedamt - ?, funconfirmamt = funconfirmamt + ? where fentryid =? and fid =?";
            sqlLists.put((String)disposeSql, (List<Object[]>)sqlParams);
        }
        if (disMainParamByAmtList.size() > 0) {
            sqlParams = new ArrayList(disMainParamByAmtList.size());
            for (DisposeParam disposeParam : disMainParamByAmtList) {
                param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyBaseQty, disposeParam.verifyBaseQty, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_finarbillentry set fconfirmedqty =fconfirmedqty - ?,funconfirmqty = funconfirmqty + ?,fconfirmedbaseqty = fconfirmedbaseqty - ?, funconfirmbaseqty = funconfirmbaseqty + ? where fentryid =? and fid =?";
            sqlLists.put((String)disposeSql, (List<Object[]>)sqlParams);
        }
        if (disAstParamByQtyList.size() > 0) {
            sqlParams = new ArrayList(disAstParamByQtyList.size());
            for (DisposeParam disposeParam : disAstParamByQtyList) {
                param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyAmt, disposeParam.verifyAmt, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_revcfmbillentry set frecqty =frecqty - ?,funrecqty = funrecqty + ?,frecamt = frecamt - ?, funrecamt = funrecamt + ? where fentryid =? and fid =?";
            sqlLists.put((String)disposeSql, sqlParams);
        }
        if (disAstParamByAmtList.size() > 0) {
            sqlParams = new ArrayList(disAstParamByAmtList.size());
            for (DisposeParam disposeParam : disAstParamByAmtList) {
                param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyBaseQty, disposeParam.verifyBaseQty, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_revcfmbillentry set frecqty =frecqty - ?,funrecqty = funrecqty + ?,frecbaseqty = frecbaseqty - ?, funrecbaseqty = funrecbaseqty + ? where fentryid =? and fid =?";
            sqlLists.put((String)disposeSql, sqlParams);
        }
        return sqlLists;
    }

    private void buildDisBillInfo(List<DisposeParam> disMainParamByQtyList, List<DisposeParam> disMainParamByAmtList, List<DisposeParam> disAsstParamByQtyList, List<DisposeParam> disAsstParamByAmtList, long verifyTypeId, DynamicObjectCollection recordEntrys) {
        for (DynamicObject recordEntry : recordEntrys) {
            DisposeParam disposeMainParam = new DisposeParam();
            disposeMainParam.id = recordEntry.getLong("billid");
            disposeMainParam.entryId = recordEntry.getLong("billentryid");
            disposeMainParam.verifyQty = recordEntry.getBigDecimal("verifyqty");
            disposeMainParam.verifyBaseQty = recordEntry.getBigDecimal("verifybaseqty");
            disposeMainParam.verifyAmt = recordEntry.getBigDecimal("verifyamt");
            DisposeParam disposeAsstParam = new DisposeParam();
            disposeAsstParam.id = recordEntry.getLong("assbillid");
            disposeAsstParam.entryId = recordEntry.getLong("assbillentryid");
            disposeAsstParam.verifyQty = recordEntry.getBigDecimal("assverifyqty");
            disposeAsstParam.verifyBaseQty = recordEntry.getBigDecimal("assverifybaseqty");
            disposeAsstParam.verifyAmt = recordEntry.getBigDecimal("assverifyamt");
            if (1566715159244716032L == verifyTypeId) {
                disMainParamByQtyList.add(disposeMainParam);
                disAsstParamByQtyList.add(disposeAsstParam);
                continue;
            }
            disMainParamByAmtList.add(disposeMainParam);
            disAsstParamByAmtList.add(disposeAsstParam);
        }
    }

    private static List<String> getErrOperationResultTip(OperationResult res) {
        if (res == null) {
            return new ArrayList<String>(8);
        }
        ArrayList errInfo = new ArrayList(5);
        errInfo.addAll(res.getAllErrorInfo());
        List errValidateInfo = res.getAllErrorOrValidateInfo();
        if (errValidateInfo != null && !errValidateInfo.isEmpty()) {
            errValidateInfo.forEach(e -> errInfo.add((OperateErrorInfo)e));
        }
        ArrayList<String> errMsg = new ArrayList<String>(5);
        errInfo.forEach(info -> {
            if (ErrorLevel.Info != info.getLevel()) {
                errMsg.add(info.getMessage());
            }
        });
        if (errMsg.isEmpty()) {
            errMsg.add(res.getMessage());
        }
        return errMsg;
    }

    static class DisposeParam {
        long id;
        long entryId;
        BigDecimal verifyBaseQty;
        BigDecimal verifyQty;
        BigDecimal verifyAmt;

        DisposeParam() {
        }
    }
}

