/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.plugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.BOTPHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.BookDateHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.OperationHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.UnitConvertHelper;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;

public class ArRevVerifyWriteOffPlugin
implements IWriteOffPlugin {
    private static final Log logger = LogFactory.getLog(ArRevVerifyWriteOffPlugin.class);
    private final List<Long> needDisTailDiffMainBillEntryIds = new ArrayList<Long>(8);
    private final List<Long> needDisTailDiffAsstBillEntryIds = new ArrayList<Long>(8);
    private static final long HXLB_AR_REV_VERIFY_QTY = 1566715159244716032L;
    private static final long HXLB_AR_REV_VERIFY_AMOUNT = 1569651463666271232L;
    private String wfMode;

    public ArRevVerifyWriteOffPlugin(String wfMode) {
        this.wfMode = wfMode;
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(1566715159244716032L, 1569651463666271232L);
    }

    @Override
    public void beforeWfRecordGenerate(DynamicObject recordBill) {
        if ("2".equals(this.wfMode)) {
            recordBill.set("verifytype", (Object)"manual");
        } else if ("3".equals(this.wfMode)) {
            recordBill.set("verifytype", (Object)"manual");
        } else if ("1".equals(this.wfMode)) {
            recordBill.set("verifytype", (Object)"auto");
        }
    }

    @Override
    public void afterWfRecordStrategy(List<DynamicObject> records) {
        logger.info("ArRevVerifyWriteOffPlugin.afterWfRecordStrategy start");
        BookDateHelper.setVerifyDate(records, true);
        for (DynamicObject record : records) {
            long verifyTypeId = record.getLong("writeofftypeid.id");
            DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                this.fillMainVerifyRecord(entry, verifyTypeId);
                this.fillAsstVerifyRecord(entry, verifyTypeId);
            }
        }
        DynamicObjectCollection mainVerifyInfo = QueryServiceHelper.query((String)"ar_revcrm_verifyrecord", (String)String.join((CharSequence)",", this.getMainSelectors()), (QFilter[])new QFilter[]{new QFilter("entry.billentryid", "in", this.needDisTailDiffMainBillEntryIds)});
        DynamicObjectCollection asstVerifyInfo = QueryServiceHelper.query((String)"ar_revcrm_verifyrecord", (String)String.join((CharSequence)",", this.getAsstSelectors()), (QFilter[])new QFilter[]{new QFilter("entry.assbillentryid", "in", this.needDisTailDiffAsstBillEntryIds)});
        Map<Long, VerifyRecordParam> mainEntryIdToVerifyFieldTotal = this.buildMainVerifyFieldTotalMap(mainVerifyInfo);
        Map<Long, VerifyRecordParam> asstEntryIdToVerifyFieldTotal = this.buildAsstVerifyFieldTotalMap(asstVerifyInfo);
        ArrayList<DisposeParam> disMainParamByQtyList = new ArrayList<DisposeParam>(8);
        ArrayList<DisposeParam> disMainParamByAmtList = new ArrayList<DisposeParam>(8);
        ArrayList<DisposeParam> disAsstParamByQtyList = new ArrayList<DisposeParam>(8);
        ArrayList<DisposeParam> disAsstParamByAmtList = new ArrayList<DisposeParam>(8);
        for (DynamicObject record : records) {
            long verifyTypeId = record.getLong("writeofftypeid.id");
            DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                this.disposeMainTailDifference(mainEntryIdToVerifyFieldTotal, entry, verifyTypeId);
                this.disposeAsstTailDifference(asstEntryIdToVerifyFieldTotal, entry, verifyTypeId);
                this.buildDisMainBillParam(disMainParamByQtyList, disMainParamByAmtList, entry, verifyTypeId);
                this.buildDisAsstBillParam(disAsstParamByQtyList, disAsstParamByAmtList, entry, verifyTypeId);
                this.fillVerifyRecordDifference(entry);
            }
        }
        SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
        this.disposeMainBill(disMainParamByQtyList, disMainParamByAmtList);
        this.disposeAsstBill(disAsstParamByQtyList, disAsstParamByAmtList);
        this.autoPushRevBill(records);
    }

    private void autoPushRevBill(List<DynamicObject> records) {
        logger.info("ArRevVerifyWriteOffPlugin.autoPushRevBill start");
        String generateRevBillStatus = this.getGenerateRevBillStatus();
        ArrayList<Long> needPushRevBillIds = new ArrayList<Long>(8);
        ArrayList<String> needPushRevBillKey = new ArrayList<String>(8);
        for (DynamicObject record : records) {
            DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                if (entry.getBigDecimal("verifydiffamt").compareTo(BigDecimal.ZERO) == 0) continue;
                Long assbillid = entry.getLong("assbillid");
                needPushRevBillIds.add(assbillid);
                needPushRevBillKey.add(entry.getLong("billentryid") + "" + entry.getLong("assbillentryid"));
            }
        }
        if (needPushRevBillIds.size() > 0) {
            logger.info("ArRevVerifyWriteOffPlugin.autoPushRevBill:needPushRevBillIds.size > 0");
            List trgBills = new ArrayList(needPushRevBillIds.size());
            ArrayList<DynamicObject> needSaveTrgBills = new ArrayList<DynamicObject>(needPushRevBillIds.size());
            Map<String, Object> resultMap = BOTPHelper.push4Result("ar_revcfmbill", "ar_revcfmbill", "1634679300408203264", needPushRevBillIds);
            Object convertResult = resultMap.get("convertResult");
            if (convertResult != null) {
                ConvertOperationResult result = (ConvertOperationResult)convertResult;
                ErrorCode ec = new ErrorCode("botp", result.getMessage());
                throw new KDBizException(ec, new Object[0]);
            }
            trgBills = (List)resultMap.get("trgBills");
            Map<Long, DynamicObject> srcIdToRevBillMap = trgBills.stream().collect(Collectors.toMap(trgBill -> trgBill.getLong("sourcebillid"), trgBill -> trgBill));
            HashMap<String, DynamicObject> uniqueIdToRevBillMap = new HashMap<String, DynamicObject>(8);
            for (DynamicObject record : records) {
                Date verifyDate = record.getDate("createtime");
                DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
                Map<String, List<DynamicObject>> idToEntryMap = entrys.stream().collect(Collectors.groupingBy(e -> e.getLong("billid") + "" + e.getLong("assbillid")));
                for (Map.Entry<String, List<DynamicObject>> row : idToEntryMap.entrySet()) {
                    List<DynamicObject> recordEntrys = row.getValue();
                    Long revBillId = recordEntrys.get(0).getLong("assbillid");
                    Long mainBillId = recordEntrys.get(0).getLong("billid");
                    ArrayList<Long> assbillentryids = new ArrayList<Long>(8);
                    for (DynamicObject recordEntry : recordEntrys) {
                        String key = recordEntry.getLong("billentryid") + "" + recordEntry.getLong("assbillentryid");
                        if (!needPushRevBillKey.contains(key)) continue;
                        assbillentryids.add(recordEntry.getLong("assbillentryid"));
                    }
                    DynamicObject trgBill2 = srcIdToRevBillMap.get(revBillId);
                    if (ObjectUtils.isEmpty((Object)trgBill2)) continue;
                    CloneUtils clone = new CloneUtils(false, true);
                    DynamicObject trgBillCopy = (DynamicObject)clone.clone((IDataEntityBase)trgBill2);
                    DynamicObjectCollection trgBillEntrys = trgBillCopy.getDynamicObjectCollection("entry");
                    Iterator entryIterator = trgBillEntrys.iterator();
                    while (entryIterator.hasNext()) {
                        DynamicObject entry = (DynamicObject)entryIterator.next();
                        Long srcBillEntryId = entry.getLong("e_sourcebillentryid");
                        if (assbillentryids.contains(srcBillEntryId)) continue;
                        entryIterator.remove();
                    }
                    if (trgBillEntrys.size() <= 0) continue;
                    this.repairRevCfmBill(trgBillCopy, recordEntrys, verifyDate);
                    needSaveTrgBills.add(trgBillCopy);
                    uniqueIdToRevBillMap.put(record.getString("id") + mainBillId.toString() + revBillId.toString(), trgBillCopy);
                }
            }
            logger.info("ArRevVerifyWriteOffPlugin.autoPushRevBill:needSaveTrgBills.size:" + needSaveTrgBills.size());
            long[] revcfmGenIds = ID.genLongIds((int)needSaveTrgBills.size());
            int i = 0;
            for (DynamicObject trgbill : needSaveTrgBills) {
                trgbill.set("id", (Object)revcfmGenIds[i]);
                trgbill.set("billsrctype", (Object)"9");
                ++i;
            }
            logger.info("ArRevVerifyWriteOffPlugin.autoPushRevBill:generateRevBillStatus:" + generateRevBillStatus);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("WF", "false");
            option.setVariableValue("mutex_writeback", "false");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])needSaveTrgBills.toArray(new DynamicObject[0]), (OperateOption)option);
            OperationHelper.assertResult(saveResult);
            DynamicObject[] revCfmAdjusts = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)saveResult.getSuccessPkIds())});
            Map<Long, String> revCfmIdToBillNoMap = Arrays.stream(revCfmAdjusts).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("billno")));
            this.writeBackRevBillNo(records, uniqueIdToRevBillMap, revCfmIdToBillNoMap);
            if ("save".equals(generateRevBillStatus)) {
                return;
            }
            try {
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_revcfmbill", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                OperationHelper.assertResult(submitResult);
                if ("submit".equals(generateRevBillStatus)) {
                    return;
                }
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
                OperationHelper.assertResult(auditResult);
            }
            catch (Exception e2) {
                OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"nocheckdel", (String)"ar_revcfmbill", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                OperationHelper.assertResult(deleteResult);
                throw e2;
            }
        }
    }

    private List<Object> getNeedSubmitPks(List<DynamicObject> needSaveTrgBills, OperationResult saveResult) {
        HashSet<Long> errIds = new HashSet<Long>(8);
        for (DynamicObject needSaveTrgBill : needSaveTrgBills) {
            BigDecimal confirmrate = needSaveTrgBill.getBigDecimal("confirmrate");
            if (confirmrate.abs().compareTo(new BigDecimal("100")) <= 0) continue;
            errIds.add(needSaveTrgBill.getLong("id"));
        }
        List saveSuccessPkIds = saveResult.getSuccessPkIds();
        Iterator iterator = saveSuccessPkIds.iterator();
        while (iterator.hasNext()) {
            Long id = (Long)iterator.next();
            if (!errIds.contains(id)) continue;
            iterator.remove();
        }
        return saveSuccessPkIds;
    }

    private void writeBackRevBillNo(List<DynamicObject> records, Map<String, DynamicObject> uniqueIdToRevBillMap, Map<Long, String> revCfmIdToBillNoMap) {
        for (DynamicObject record : records) {
            DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                if (entry.getBigDecimal("verifydiffamt").compareTo(BigDecimal.ZERO) == 0) continue;
                String key = record.getString("id") + entry.getString("billid") + entry.getString("assbillid");
                DynamicObject revBill = uniqueIdToRevBillMap.get(key);
                Long id = revBill.getLong("id");
                entry.set("revbillid", (Object)id);
                entry.set("revbillno", (Object)revCfmIdToBillNoMap.get(id));
            }
        }
        SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
    }

    private Date getMaxDate(DynamicObject entry, String mainDateKey, String assDateKey, Date targetDate) {
        Date assDate;
        Date tempDate;
        Date mainDate = entry.getDate(mainDateKey);
        Date date = tempDate = mainDate.after(assDate = entry.getDate(assDateKey)) ? mainDate : assDate;
        targetDate = ObjectUtils.isEmpty((Object)targetDate) ? tempDate : (targetDate.after(tempDate) ? targetDate : tempDate);
        return targetDate;
    }

    private void repairRevCfmBill(DynamicObject trgBillCopy, List<DynamicObject> recordEntrys, Date verifyDate) {
        String quotation;
        Date exratedate = null;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocalamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal confirmamt = BigDecimal.ZERO;
        BigDecimal confirmlocamt = BigDecimal.ZERO;
        BigDecimal unverifyamt = BigDecimal.ZERO;
        DynamicObjectCollection trgBillEntrys = trgBillCopy.getDynamicObjectCollection("entry");
        for (DynamicObject trgBillEntry : trgBillEntrys) {
            for (DynamicObject entry : recordEntrys) {
                if (trgBillEntry.getLong("e_sourcebillentryid") != entry.getLong("assbillentryid")) continue;
                trgBillEntry.set("e_confirmamt", (Object)trgBillEntry.getBigDecimal("e_confirmamt").add(entry.getBigDecimal("verifydiffamt")));
                trgBillEntry.set("e_confirmtax", (Object)trgBillEntry.getBigDecimal("e_confirmtax").add(entry.getBigDecimal("verifydifftax")));
                trgBillEntry.set("e_cfmpricetax", (Object)trgBillEntry.getBigDecimal("e_cfmpricetax").add(entry.getBigDecimal("verifydiffpricetax")));
                exratedate = this.getMaxDate(entry, "exratedate", "assexratedate", exratedate);
            }
            BigDecimal e_confirmamt = trgBillEntry.getBigDecimal("e_confirmamt");
            BigDecimal e_amount = trgBillEntry.getBigDecimal("e_amount");
            amount = amount.add(e_amount);
            localamt = localamt.add(trgBillEntry.getBigDecimal("e_localamt"));
            tax = tax.add(trgBillEntry.getBigDecimal("e_tax"));
            taxlocalamt = taxlocalamt.add(trgBillEntry.getBigDecimal("e_taxlocalamt"));
            pricetaxtotal = pricetaxtotal.add(trgBillEntry.getBigDecimal("e_pricetaxtotal"));
            pricetaxtotalbase = pricetaxtotalbase.add(trgBillEntry.getBigDecimal("e_pricetaxtotalbase"));
            confirmamt = confirmamt.add(e_confirmamt);
            unverifyamt = unverifyamt.add(e_confirmamt);
            if (e_amount.compareTo(BigDecimal.ZERO) == 0) {
                trgBillEntry.set("e_confirmrate", (Object)new BigDecimal("100"));
            } else {
                BigDecimal confirmRate = e_confirmamt.multiply(BigDecimal.valueOf(100L)).divide(e_amount, 2, 4);
                confirmRate = confirmRate.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.01") : confirmRate;
                trgBillEntry.set("e_confirmrate", (Object)confirmRate);
            }
            trgBillEntry.set("e_quantity", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_baseunitqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_confirmqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_confirmbaseqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_unverifyamt", (Object)e_confirmamt);
            trgBillEntry.set("e_verifiedamt", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_verifybaseqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_unverifybaseqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_unrecqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_unrecbaseqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_recqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_recbaseqty", (Object)BigDecimal.ZERO);
            trgBillEntry.set("e_recamt", (Object)e_confirmamt);
            trgBillEntry.set("e_unrecamt", (Object)BigDecimal.ZERO);
        }
        Long currencyId = trgBillCopy.getLong("currency.id");
        Long basecurrencyId = trgBillCopy.getLong("basecurrency.id");
        int localPrecision = trgBillCopy.getInt("basecurrency.amtprecision");
        Long exratetableId = trgBillCopy.getLong("exratetable.id");
        BigDecimal exchangeRate = ArRevVerifyWriteOffPlugin.getExchangeRate(exratetableId, currencyId, basecurrencyId, quotation = trgBillCopy.getString("quotation"), exratedate);
        if (ObjectUtils.isEmpty((Object)exchangeRate)) {
            exchangeRate = trgBillCopy.getBigDecimal("exchangerate");
        }
        if (!ObjectUtils.isEmpty((Object)exchangeRate)) {
            for (DynamicObject trgBillEntry : trgBillEntrys) {
                BigDecimal e_confirmloctax;
                BigDecimal e_confirmlocamt;
                if ("1".equals(quotation)) {
                    e_confirmlocamt = trgBillEntry.getBigDecimal("e_confirmamt").divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                    e_confirmloctax = trgBillEntry.getBigDecimal("e_confirmtax").divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                } else {
                    e_confirmlocamt = trgBillEntry.getBigDecimal("e_confirmamt").multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                    e_confirmloctax = trgBillEntry.getBigDecimal("e_confirmtax").multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                }
                trgBillEntry.set("e_confirmlocamt", (Object)e_confirmlocamt);
                trgBillEntry.set("e_confirmloctax", (Object)e_confirmloctax);
                trgBillEntry.set("e_cfmpricetaxbase", (Object)e_confirmlocamt.add(e_confirmloctax));
                confirmlocamt = confirmlocamt.add(e_confirmlocamt);
            }
        }
        trgBillCopy.set("exchangerate", (Object)exchangeRate);
        trgBillCopy.set("exratedate", exratedate);
        trgBillCopy.set("amount", (Object)amount);
        trgBillCopy.set("localamt", (Object)localamt);
        trgBillCopy.set("tax", (Object)tax);
        trgBillCopy.set("taxlocamt", (Object)taxlocalamt);
        trgBillCopy.set("pricetaxtotal", (Object)pricetaxtotal);
        trgBillCopy.set("pricetaxtotalbase", (Object)pricetaxtotalbase);
        trgBillCopy.set("confirmamt", (Object)confirmamt);
        trgBillCopy.set("confirmlocamt", (Object)confirmlocamt);
        trgBillCopy.set("unverifyamt", (Object)unverifyamt);
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            trgBillCopy.set("confirmrate", (Object)new BigDecimal("100"));
        } else {
            BigDecimal confirmRate = confirmamt.multiply(BigDecimal.valueOf(100L)).divide(amount, 2, 4);
            confirmRate = confirmRate.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.01") : confirmRate;
            trgBillCopy.set("confirmrate", (Object)confirmRate);
        }
        trgBillCopy.set("bizdate", (Object)verifyDate);
    }

    private void disposeAsstBill(List<DisposeParam> disAstParamByQtyList, List<DisposeParam> disAstParamByAmtList) {
        Object disposeSql;
        Object[] param;
        ArrayList<Object[]> sqlParams;
        logger.info("ArRevVerifyWriteOffPlugin.disposeAsstBill start");
        if (disAstParamByQtyList.size() > 0) {
            sqlParams = new ArrayList<Object[]>(disAstParamByQtyList.size());
            for (DisposeParam disposeParam : disAstParamByQtyList) {
                param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyAmt, disposeParam.verifyAmt, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_revcfmbillentry set frecqty =frecqty + ?,funrecqty = funrecqty - ?,frecamt = frecamt + ?, funrecamt = funrecamt - ? where fentryid =? and fid =?";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)disposeSql, sqlParams);
        }
        if (disAstParamByAmtList.size() > 0) {
            sqlParams = new ArrayList(disAstParamByAmtList.size());
            for (DisposeParam disposeParam : disAstParamByAmtList) {
                param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyBaseQty, disposeParam.verifyBaseQty, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_revcfmbillentry set frecqty =frecqty + ?,funrecqty = funrecqty - ?,frecbaseqty = frecbaseqty + ?, funrecbaseqty = funrecbaseqty - ? where fentryid =? and fid =?";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)disposeSql, sqlParams);
        }
    }

    private void disposeMainBill(List<DisposeParam> disMainParamByQtyList, List<DisposeParam> disMainParamByAmtList) {
        Object disposeSql;
        Object[] param;
        ArrayList<Object[]> sqlParams;
        logger.info("ArRevVerifyWriteOffPlugin.disposeMainBill start");
        if (disMainParamByQtyList.size() > 0) {
            sqlParams = new ArrayList<Object[]>(disMainParamByQtyList.size());
            for (DisposeParam disposeParam : disMainParamByQtyList) {
                param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyAmt, disposeParam.verifyAmt, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_finarbillentry set fconfirmedqty =fconfirmedqty + ?,funconfirmqty = funconfirmqty - ?,fconfirmedamt = fconfirmedamt + ?, funconfirmamt = funconfirmamt - ? where fentryid =? and fid = ?";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)disposeSql, sqlParams);
        }
        if (disMainParamByAmtList.size() > 0) {
            sqlParams = new ArrayList(disMainParamByAmtList.size());
            for (DisposeParam disposeParam : disMainParamByAmtList) {
                param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyBaseQty, disposeParam.verifyBaseQty, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            disposeSql = "update t_ar_finarbillentry set fconfirmedqty =fconfirmedqty + ?,funconfirmqty = funconfirmqty - ?,fconfirmedbaseqty = fconfirmedbaseqty + ?, funconfirmbaseqty = funconfirmbaseqty - ? where fentryid =? and fid = ?";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)disposeSql, sqlParams);
        }
    }

    private void buildDisMainBillParam(List<DisposeParam> disMainParamByQtyList, List<DisposeParam> disMainParamByAmtList, DynamicObject entry, long verifyTypeId) {
        DisposeParam disposeParam = new DisposeParam();
        disposeParam.id = entry.getLong("billid");
        disposeParam.entryId = entry.getLong("billentryid");
        disposeParam.verifyAmt = entry.getBigDecimal("verifyamt");
        disposeParam.verifyQty = entry.getBigDecimal("verifyqty");
        disposeParam.verifyBaseQty = entry.getBigDecimal("verifybaseqty");
        if (1566715159244716032L == verifyTypeId) {
            disMainParamByQtyList.add(disposeParam);
        } else {
            disMainParamByAmtList.add(disposeParam);
        }
    }

    private void buildDisAsstBillParam(List<DisposeParam> disAsstParamByQtyList, List<DisposeParam> disAsstParamByAmtList, DynamicObject entry, long verifyTypeId) {
        DisposeParam disposeParam = new DisposeParam();
        disposeParam.id = entry.getLong("assbillid");
        disposeParam.entryId = entry.getLong("assbillentryid");
        disposeParam.verifyAmt = entry.getBigDecimal("assverifyamt");
        disposeParam.verifyQty = entry.getBigDecimal("assverifyqty");
        disposeParam.verifyBaseQty = entry.getBigDecimal("assverifybaseqty");
        if (1566715159244716032L == verifyTypeId) {
            disAsstParamByQtyList.add(disposeParam);
        } else {
            disAsstParamByAmtList.add(disposeParam);
        }
    }

    private void fillVerifyRecordDifference(DynamicObject entry) {
        entry.set("verifydiffamt", (Object)entry.getBigDecimal("verifyamt").subtract(entry.getBigDecimal("assverifyamt")));
        entry.set("verifydifflocamt", (Object)entry.getBigDecimal("verifylocamt").subtract(entry.getBigDecimal("assverifylocamt")));
        entry.set("verifydifftax", (Object)entry.getBigDecimal("verifytax").subtract(entry.getBigDecimal("assverifytax")));
        entry.set("verifydiffloctax", (Object)entry.getBigDecimal("verifyloctax").subtract(entry.getBigDecimal("assverifyloctax")));
        entry.set("verifydiffpricetax", (Object)entry.getBigDecimal("verifypricetax").subtract(entry.getBigDecimal("assverifypricetax")));
        entry.set("verifydifflocpricetax", (Object)entry.getBigDecimal("verifylocpricetax").subtract(entry.getBigDecimal("assverifylocpricetax")));
    }

    private void disposeMainTailDifference(Map<Long, VerifyRecordParam> mainEntryIdToVerifyFieldTotal, DynamicObject entry, long verifyTypeId) {
        if (!this.needDisTailDiffMainBillEntryIds.contains(entry.getLong("billentryid"))) {
            return;
        }
        VerifyRecordParam mainVerifyRecordParam = mainEntryIdToVerifyFieldTotal.get(entry.getLong("billentryid"));
        if (1566715159244716032L == verifyTypeId) {
            BigDecimal verifyBaseQtyTotal;
            BigDecimal billBaseQty = entry.getBigDecimal("billbaseqty");
            if (billBaseQty.compareTo(verifyBaseQtyTotal = mainVerifyRecordParam.verifyBaseQty.add(entry.getBigDecimal("qty"))) == 0) {
                entry.set("verifyqty", (Object)entry.getBigDecimal("billqty").subtract(mainVerifyRecordParam.verifyQty));
                entry.set("verifyamt", (Object)entry.getBigDecimal("amount").subtract(mainVerifyRecordParam.verifyAmt));
                entry.set("verifylocamt", (Object)entry.getBigDecimal("localamt").subtract(mainVerifyRecordParam.verifyLocAmt));
                entry.set("verifytax", (Object)entry.getBigDecimal("tax").subtract(mainVerifyRecordParam.verifyTax));
                entry.set("verifyloctax", (Object)entry.getBigDecimal("loctax").subtract(mainVerifyRecordParam.verifyLocTax));
                entry.set("verifypricetax", (Object)entry.getBigDecimal("pricetaxtotal").subtract(mainVerifyRecordParam.verifyPriceTax));
                entry.set("verifylocpricetax", (Object)entry.getBigDecimal("locpricetaxtotal").subtract(mainVerifyRecordParam.verifyLocPriceTax));
            }
        } else {
            BigDecimal verifyAmtTotal;
            BigDecimal amount = entry.getBigDecimal("amount");
            if (amount.compareTo(verifyAmtTotal = mainVerifyRecordParam.verifyAmt.add(entry.getBigDecimal("qty"))) == 0) {
                entry.set("verifyqty", (Object)entry.getBigDecimal("billqty"));
                entry.set("verifybaseqty", (Object)entry.getBigDecimal("billbaseqty"));
                entry.set("verifylocamt", (Object)entry.getBigDecimal("localamt").subtract(mainVerifyRecordParam.verifyLocAmt));
                entry.set("verifytax", (Object)entry.getBigDecimal("tax").subtract(mainVerifyRecordParam.verifyTax));
                entry.set("verifyloctax", (Object)entry.getBigDecimal("loctax").subtract(mainVerifyRecordParam.verifyLocTax));
                entry.set("verifypricetax", (Object)entry.getBigDecimal("pricetaxtotal").subtract(mainVerifyRecordParam.verifyPriceTax));
                entry.set("verifylocpricetax", (Object)entry.getBigDecimal("locpricetaxtotal").subtract(mainVerifyRecordParam.verifyLocPriceTax));
            }
        }
        mainVerifyRecordParam.verifyBaseQty = mainVerifyRecordParam.verifyBaseQty.add(entry.getBigDecimal("verifybaseqty"));
        mainVerifyRecordParam.verifyAmt = mainVerifyRecordParam.verifyAmt.add(entry.getBigDecimal("verifyamt"));
        mainVerifyRecordParam.verifyQty = mainVerifyRecordParam.verifyQty.add(entry.getBigDecimal("verifyqty"));
        mainVerifyRecordParam.verifyLocAmt = mainVerifyRecordParam.verifyLocAmt.add(entry.getBigDecimal("verifylocamt"));
        mainVerifyRecordParam.verifyTax = mainVerifyRecordParam.verifyTax.add(entry.getBigDecimal("verifytax"));
        mainVerifyRecordParam.verifyLocTax = mainVerifyRecordParam.verifyLocTax.add(entry.getBigDecimal("verifyloctax"));
        mainVerifyRecordParam.verifyPriceTax = mainVerifyRecordParam.verifyPriceTax.add(entry.getBigDecimal("verifypricetax"));
        mainVerifyRecordParam.verifyLocPriceTax = mainVerifyRecordParam.verifyLocPriceTax.add(entry.getBigDecimal("verifylocpricetax"));
    }

    private void disposeAsstTailDifference(Map<Long, VerifyRecordParam> asstEntryIdToVerifyFieldTotal, DynamicObject entry, long verifyTypeId) {
        if (!this.needDisTailDiffAsstBillEntryIds.contains(entry.getLong("assbillentryid"))) {
            return;
        }
        VerifyRecordParam asstVerifyRecordParam = asstEntryIdToVerifyFieldTotal.get(entry.getLong("assbillentryid"));
        if (1566715159244716032L == verifyTypeId) {
            BigDecimal verifyBaseQtyTotal;
            BigDecimal cfmBaseQty = entry.getBigDecimal("asscfmbaseqty");
            if (cfmBaseQty.compareTo(verifyBaseQtyTotal = asstVerifyRecordParam.verifyBaseQty.add(entry.getBigDecimal("assqty"))) == 0) {
                entry.set("assverifyqty", (Object)entry.getBigDecimal("asscfmqty").subtract(asstVerifyRecordParam.verifyQty));
                entry.set("assverifyamt", (Object)entry.getBigDecimal("asscfmamt").subtract(asstVerifyRecordParam.verifyAmt));
                entry.set("assverifylocamt", (Object)entry.getBigDecimal("asscfmlocamt").subtract(asstVerifyRecordParam.verifyLocAmt));
                entry.set("assverifytax", (Object)entry.getBigDecimal("asscfmtax").subtract(asstVerifyRecordParam.verifyTax));
                entry.set("assverifyloctax", (Object)entry.getBigDecimal("asscfmloctax").subtract(asstVerifyRecordParam.verifyLocTax));
                entry.set("assverifypricetax", (Object)entry.getBigDecimal("asscfmpricetax").subtract(asstVerifyRecordParam.verifyPriceTax));
                entry.set("assverifylocpricetax", (Object)entry.getBigDecimal("asscfmpricetaxbase").subtract(asstVerifyRecordParam.verifyLocPriceTax));
            }
        } else {
            BigDecimal verifyAmtTotal;
            BigDecimal amount = entry.getBigDecimal("asscfmamt");
            if (amount.compareTo(verifyAmtTotal = asstVerifyRecordParam.verifyAmt.add(entry.getBigDecimal("assqty"))) == 0) {
                entry.set("assverifyqty", (Object)entry.getBigDecimal("asscfmqty"));
                entry.set("assverifybaseqty", (Object)entry.getBigDecimal("asscfmbaseqty"));
                entry.set("assverifylocamt", (Object)entry.getBigDecimal("asscfmlocamt").subtract(asstVerifyRecordParam.verifyLocAmt));
                entry.set("assverifytax", (Object)entry.getBigDecimal("asscfmtax").subtract(asstVerifyRecordParam.verifyTax));
                entry.set("assverifyloctax", (Object)entry.getBigDecimal("asscfmloctax").subtract(asstVerifyRecordParam.verifyLocTax));
                entry.set("assverifypricetax", (Object)entry.getBigDecimal("asscfmpricetax").subtract(asstVerifyRecordParam.verifyPriceTax));
                entry.set("assverifylocpricetax", (Object)entry.getBigDecimal("asscfmpricetaxbase").subtract(asstVerifyRecordParam.verifyLocPriceTax));
            }
        }
        asstVerifyRecordParam.verifyBaseQty = asstVerifyRecordParam.verifyBaseQty.add(entry.getBigDecimal("assverifybaseqty"));
        asstVerifyRecordParam.verifyAmt = asstVerifyRecordParam.verifyAmt.add(entry.getBigDecimal("assverifyamt"));
        asstVerifyRecordParam.verifyQty = asstVerifyRecordParam.verifyQty.add(entry.getBigDecimal("assverifyqty"));
        asstVerifyRecordParam.verifyLocAmt = asstVerifyRecordParam.verifyLocAmt.add(entry.getBigDecimal("assverifylocamt"));
        asstVerifyRecordParam.verifyTax = asstVerifyRecordParam.verifyTax.add(entry.getBigDecimal("assverifytax"));
        asstVerifyRecordParam.verifyLocTax = asstVerifyRecordParam.verifyLocTax.add(entry.getBigDecimal("assverifyloctax"));
        asstVerifyRecordParam.verifyPriceTax = asstVerifyRecordParam.verifyPriceTax.add(entry.getBigDecimal("assverifypricetax"));
        asstVerifyRecordParam.verifyLocPriceTax = asstVerifyRecordParam.verifyLocPriceTax.add(entry.getBigDecimal("assverifylocpricetax"));
    }

    private Map<Long, VerifyRecordParam> buildMainVerifyFieldTotalMap(DynamicObjectCollection mainVerifyInfo) {
        HashMap<Long, VerifyRecordParam> mainEntryIdToVerifyFieldTotal = new HashMap<Long, VerifyRecordParam>(mainVerifyInfo.size());
        for (DynamicObject row : mainVerifyInfo) {
            VerifyRecordParam verifyRecordParam = (VerifyRecordParam)mainEntryIdToVerifyFieldTotal.get(row.getLong("entry.billentryid"));
            BigDecimal verifyamt = row.getBigDecimal("entry.verifyamt");
            BigDecimal verifylocamt = row.getBigDecimal("entry.verifylocamt");
            BigDecimal verifytax = row.getBigDecimal("entry.verifytax");
            BigDecimal verifyloctax = row.getBigDecimal("entry.verifyloctax");
            BigDecimal verifypricetax = row.getBigDecimal("entry.verifypricetax");
            BigDecimal verifylocpricetax = row.getBigDecimal("entry.verifylocpricetax");
            BigDecimal verifyqty = row.getBigDecimal("entry.verifyqty");
            BigDecimal verifybaseqty = row.getBigDecimal("entry.verifybaseqty");
            if (ObjectUtils.isEmpty((Object)verifyRecordParam)) {
                verifyRecordParam = new VerifyRecordParam();
                verifyRecordParam.verifyAmt = verifyamt;
                verifyRecordParam.verifyLocAmt = verifylocamt;
                verifyRecordParam.verifyTax = verifytax;
                verifyRecordParam.verifyLocTax = verifyloctax;
                verifyRecordParam.verifyPriceTax = verifypricetax;
                verifyRecordParam.verifyLocPriceTax = verifylocpricetax;
                verifyRecordParam.verifyQty = verifyqty;
                verifyRecordParam.verifyBaseQty = verifybaseqty;
            } else {
                verifyRecordParam.verifyAmt = verifyRecordParam.verifyAmt.add(verifyamt);
                verifyRecordParam.verifyLocAmt = verifyRecordParam.verifyLocAmt.add(verifylocamt);
                verifyRecordParam.verifyTax = verifyRecordParam.verifyTax.add(verifytax);
                verifyRecordParam.verifyLocTax = verifyRecordParam.verifyLocTax.add(verifyloctax);
                verifyRecordParam.verifyPriceTax = verifyRecordParam.verifyPriceTax.add(verifypricetax);
                verifyRecordParam.verifyLocPriceTax = verifyRecordParam.verifyLocPriceTax.add(verifylocpricetax);
                verifyRecordParam.verifyQty = verifyRecordParam.verifyQty.add(verifyqty);
                verifyRecordParam.verifyBaseQty = verifyRecordParam.verifyBaseQty.add(verifybaseqty);
            }
            mainEntryIdToVerifyFieldTotal.put(row.getLong("entry.billentryid"), verifyRecordParam);
        }
        return mainEntryIdToVerifyFieldTotal;
    }

    private Map<Long, VerifyRecordParam> buildAsstVerifyFieldTotalMap(DynamicObjectCollection asstVerifyInfo) {
        HashMap<Long, VerifyRecordParam> asstEntryIdToVerifyFieldTotal = new HashMap<Long, VerifyRecordParam>(asstVerifyInfo.size());
        for (DynamicObject row : asstVerifyInfo) {
            VerifyRecordParam verifyRecordParam = (VerifyRecordParam)asstEntryIdToVerifyFieldTotal.get(row.getLong("entry.assbillentryid"));
            BigDecimal verifyamt = row.getBigDecimal("entry.assverifyamt");
            BigDecimal verifylocamt = row.getBigDecimal("entry.assverifylocamt");
            BigDecimal verifytax = row.getBigDecimal("entry.assverifytax");
            BigDecimal verifyloctax = row.getBigDecimal("entry.assverifyloctax");
            BigDecimal verifypricetax = row.getBigDecimal("entry.assverifypricetax");
            BigDecimal verifylocpricetax = row.getBigDecimal("entry.assverifylocpricetax");
            BigDecimal verifyqty = row.getBigDecimal("entry.assverifyqty");
            BigDecimal verifybaseqty = row.getBigDecimal("entry.assverifybaseqty");
            if (ObjectUtils.isEmpty((Object)verifyRecordParam)) {
                verifyRecordParam = new VerifyRecordParam();
                verifyRecordParam.verifyAmt = verifyamt;
                verifyRecordParam.verifyLocAmt = verifylocamt;
                verifyRecordParam.verifyTax = verifytax;
                verifyRecordParam.verifyLocTax = verifyloctax;
                verifyRecordParam.verifyPriceTax = verifypricetax;
                verifyRecordParam.verifyLocPriceTax = verifylocpricetax;
                verifyRecordParam.verifyQty = verifyqty;
                verifyRecordParam.verifyBaseQty = verifybaseqty;
            } else {
                verifyRecordParam.verifyAmt = verifyRecordParam.verifyAmt.add(verifyamt);
                verifyRecordParam.verifyLocAmt = verifyRecordParam.verifyLocAmt.add(verifylocamt);
                verifyRecordParam.verifyTax = verifyRecordParam.verifyTax.add(verifytax);
                verifyRecordParam.verifyLocTax = verifyRecordParam.verifyLocTax.add(verifyloctax);
                verifyRecordParam.verifyPriceTax = verifyRecordParam.verifyPriceTax.add(verifypricetax);
                verifyRecordParam.verifyLocPriceTax = verifyRecordParam.verifyLocPriceTax.add(verifylocpricetax);
                verifyRecordParam.verifyQty = verifyRecordParam.verifyQty.add(verifyqty);
                verifyRecordParam.verifyBaseQty = verifyRecordParam.verifyBaseQty.add(verifybaseqty);
            }
            asstEntryIdToVerifyFieldTotal.put(row.getLong("entry.assbillentryid"), verifyRecordParam);
        }
        return asstEntryIdToVerifyFieldTotal;
    }

    private void fillMainVerifyRecord(DynamicObject entry, long verifyTypeId) {
        BigDecimal verifyLocTax;
        BigDecimal verifyLocAmt;
        BigDecimal verifyAmt;
        BigDecimal taxrate = entry.getBigDecimal("taxrate").divide(new BigDecimal("100"));
        String quotation = entry.getString("quotation");
        DynamicObject currency = entry.getDynamicObject("currency");
        int precision = currency.getInt("amtprecision");
        DynamicObject basecur = entry.getDynamicObject("basecurrency");
        int basePrecision = basecur.getInt("amtprecision");
        BigDecimal exchangeRate = entry.getBigDecimal("exchangerate");
        BigDecimal billbaseqty = entry.getBigDecimal("billbaseqty");
        BigDecimal amount = entry.getBigDecimal("amount");
        BigDecimal qty = entry.getBigDecimal("qty");
        if (1566715159244716032L == verifyTypeId && billbaseqty.compareTo(qty) == 0) {
            this.mainAllVerifyFillData(entry);
            return;
        }
        if (1569651463666271232L == verifyTypeId && amount.compareTo(qty) == 0) {
            this.mainAllVerifyFillData(entry);
            return;
        }
        this.needDisTailDiffMainBillEntryIds.add(entry.getLong("billentryid"));
        if (1566715159244716032L == verifyTypeId) {
            BigDecimal convertRate = entry.getBigDecimal("unitcoefficient");
            BigDecimal unitprice = entry.getBigDecimal("unitprice");
            BigDecimal actunitprice = entry.getBigDecimal("actunitprice");
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal verifyqty = UnitConvertHelper.getUnitQty(qty, convertRate, unit);
            verifyAmt = amount.compareTo(BigDecimal.ZERO) == 0 && unitprice.compareTo(BigDecimal.ZERO) != 0 ? BigDecimal.ZERO : verifyqty.multiply(actunitprice).setScale(precision, RoundingMode.HALF_UP);
            entry.set("verifybaseqty", (Object)qty);
            entry.set("verifyqty", (Object)verifyqty);
        } else {
            verifyAmt = qty;
        }
        BigDecimal verifyTax = verifyAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
        if ("1".equals(quotation)) {
            verifyLocAmt = verifyAmt.divide(exchangeRate, basePrecision, RoundingMode.HALF_UP);
            verifyLocTax = verifyTax.divide(exchangeRate, basePrecision, RoundingMode.HALF_UP);
        } else {
            verifyLocAmt = verifyAmt.multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
            verifyLocTax = verifyTax.multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
        }
        entry.set("verifyamt", (Object)verifyAmt);
        entry.set("verifylocamt", (Object)verifyLocAmt);
        entry.set("verifytax", (Object)verifyTax);
        entry.set("verifyloctax", (Object)verifyLocTax);
        entry.set("verifypricetax", (Object)verifyAmt.add(verifyTax));
        entry.set("verifylocpricetax", (Object)verifyLocAmt.add(verifyLocTax));
    }

    private void fillAsstVerifyRecord(DynamicObject entry, long verifyTypeId) {
        BigDecimal verifyLocTax;
        BigDecimal verifyLocAmt;
        BigDecimal verifyAmt;
        BigDecimal taxrate = entry.getBigDecimal("asstaxrate").divide(new BigDecimal("100"));
        String quotation = entry.getString("assquotation");
        DynamicObject currency = entry.getDynamicObject("asscurrency");
        int precision = currency.getInt("amtprecision");
        DynamicObject basecur = entry.getDynamicObject("assbasecurrency");
        int basePrecision = basecur.getInt("amtprecision");
        BigDecimal exchangeRate = entry.getBigDecimal("assexchangerate");
        BigDecimal billbaseqty = entry.getBigDecimal("asscfmbaseqty");
        BigDecimal amount = entry.getBigDecimal("asscfmamt");
        BigDecimal qty = entry.getBigDecimal("assqty");
        if (1566715159244716032L == verifyTypeId && billbaseqty.compareTo(qty) == 0) {
            this.asstAllVerifyFillData(entry);
            return;
        }
        if (1569651463666271232L == verifyTypeId && amount.compareTo(qty) == 0) {
            this.asstAllVerifyFillData(entry);
            return;
        }
        this.needDisTailDiffAsstBillEntryIds.add(entry.getLong("assbillentryid"));
        if (1566715159244716032L == verifyTypeId) {
            BigDecimal convertRate = entry.getBigDecimal("assunitcoefficient");
            BigDecimal unitprice = entry.getBigDecimal("assunitprice");
            BigDecimal actunitprice = entry.getBigDecimal("assactunitprice");
            DynamicObject unit = entry.getDynamicObject("assunit");
            BigDecimal verifyqty = UnitConvertHelper.getUnitQty(qty, convertRate, unit);
            verifyAmt = amount.compareTo(BigDecimal.ZERO) == 0 && unitprice.compareTo(BigDecimal.ZERO) != 0 ? BigDecimal.ZERO : verifyqty.multiply(actunitprice).setScale(precision, RoundingMode.HALF_UP);
            entry.set("assverifybaseqty", (Object)qty);
            entry.set("assverifyqty", (Object)verifyqty);
        } else {
            verifyAmt = qty;
        }
        BigDecimal verifyTax = verifyAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
        if ("1".equals(quotation)) {
            verifyLocAmt = verifyAmt.divide(exchangeRate, basePrecision, RoundingMode.HALF_UP);
            verifyLocTax = verifyTax.divide(exchangeRate, basePrecision, RoundingMode.HALF_UP);
        } else {
            verifyLocAmt = verifyAmt.multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
            verifyLocTax = verifyTax.multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
        }
        entry.set("assverifyamt", (Object)verifyAmt);
        entry.set("assverifylocamt", (Object)verifyLocAmt);
        entry.set("assverifytax", (Object)verifyTax);
        entry.set("assverifyloctax", (Object)verifyLocTax);
        entry.set("assverifypricetax", (Object)verifyAmt.add(verifyTax));
        entry.set("assverifylocpricetax", (Object)verifyLocAmt.add(verifyLocTax));
    }

    private List<String> getMainSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(6);
        selectors.add("entry.verifyamt");
        selectors.add("entry.verifylocamt");
        selectors.add("entry.verifytax");
        selectors.add("entry.verifyloctax");
        selectors.add("entry.verifypricetax");
        selectors.add("entry.verifylocpricetax");
        selectors.add("entry.verifyqty");
        selectors.add("entry.verifybaseqty");
        selectors.add("entry.billentryid");
        return selectors;
    }

    private List<String> getAsstSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(6);
        selectors.add("entry.assverifyamt");
        selectors.add("entry.assverifylocamt");
        selectors.add("entry.assverifytax");
        selectors.add("entry.assverifyloctax");
        selectors.add("entry.assverifypricetax");
        selectors.add("entry.assverifylocpricetax");
        selectors.add("entry.assverifyqty");
        selectors.add("entry.assverifybaseqty");
        selectors.add("entry.assbillentryid");
        return selectors;
    }

    public static BigDecimal getExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, String quotation, Date exrateDate) {
        boolean isIndirect;
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L || srcCurrencyId.equals(destCurrencyId)) {
            return exchangeRate;
        }
        quotation = ObjectUtils.isEmpty((Object)quotation) ? ((isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate)) ? "2" : "1") : ("0".equals(quotation) ? "1" : "2");
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)exrateDate);
        return exchangeRate;
    }

    private void mainAllVerifyFillData(DynamicObject entry) {
        entry.set("verifybaseqty", (Object)entry.getBigDecimal("billbaseqty"));
        entry.set("verifyqty", (Object)entry.getBigDecimal("billqty"));
        entry.set("verifyamt", (Object)entry.getBigDecimal("amount"));
        entry.set("verifylocamt", (Object)entry.getBigDecimal("localamt"));
        entry.set("verifytax", (Object)entry.getBigDecimal("tax"));
        entry.set("verifyloctax", (Object)entry.getBigDecimal("loctax"));
        entry.set("verifypricetax", (Object)entry.getBigDecimal("pricetaxtotal"));
        entry.set("verifylocpricetax", (Object)entry.getBigDecimal("locpricetaxtotal"));
    }

    private void asstAllVerifyFillData(DynamicObject entry) {
        entry.set("assverifybaseqty", (Object)entry.getBigDecimal("asscfmbaseqty"));
        entry.set("assverifyqty", (Object)entry.getBigDecimal("asscfmqty"));
        entry.set("assverifyamt", (Object)entry.getBigDecimal("asscfmamt"));
        entry.set("assverifylocamt", (Object)entry.getBigDecimal("asscfmlocamt"));
        entry.set("assverifytax", (Object)entry.getBigDecimal("asscfmtax"));
        entry.set("assverifyloctax", (Object)entry.getBigDecimal("asscfmloctax"));
        entry.set("assverifypricetax", (Object)entry.getBigDecimal("asscfmpricetax"));
        entry.set("assverifylocpricetax", (Object)entry.getBigDecimal("asscfmpricetaxbase"));
    }

    private String getGenerateRevBillStatus() {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"ap_stdconfig", (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"generateRevBillStatus")});
        if (!ObjectUtils.isEmpty((Object)queryOne)) {
            return queryOne.getString("value");
        }
        return "audit";
    }

    public String getWfMode() {
        return this.wfMode;
    }

    public void setWfMode(String wfMode) {
        this.wfMode = wfMode;
    }

    static class DisposeParam {
        long id;
        long entryId;
        BigDecimal verifyBaseQty;
        BigDecimal verifyQty;
        BigDecimal verifyAmt;

        DisposeParam() {
        }
    }

    static class VerifyRecordParam {
        BigDecimal verifyBaseQty;
        BigDecimal verifyQty;
        BigDecimal verifyAmt;
        BigDecimal verifyLocAmt;
        BigDecimal verifyTax;
        BigDecimal verifyLocTax;
        BigDecimal verifyPriceTax;
        BigDecimal verifyLocPriceTax;

        VerifyRecordParam() {
        }
    }
}

