/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.plugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.param.IWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.ManualAutoWfReqParam;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.AbstractWriteOffExtPlugin;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.BOTPHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.OperationHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.UnitConvertHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.price.AbstractPriceCalculator;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.price.IPriceCalculate;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.price.PriceLocalCalculator;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.price.PriceTotalCalculator;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.price.TaxUnitPriceCalculator;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.price.UnitPriceCalculator;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IKdtxWfPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;

public class BusRedBlueVerifyWriteOffPlugin
extends AbstractWriteOffExtPlugin
implements IWriteOffPlugin,
IKdtxWfPlugin {
    private static final Log logger = LogFactory.getLog(BusRedBlueVerifyWriteOffPlugin.class);
    private boolean isAr;
    private String wfMode;

    public BusRedBlueVerifyWriteOffPlugin(String wfMode) {
        this.wfMode = wfMode;
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_AP_BUSBILL_QTY, WriteOffTypeIdConst.HXLB_AP_BUSBILL_AMOUNT, WriteOffTypeIdConst.HXLB_AR_BUSBILL_QTY, WriteOffTypeIdConst.HXLB_AR_BUSBILL_AMOUNT);
    }

    @Override
    public void beforeWfRecordGenerate(DynamicObject recordBill) {
        if ("2".equals(this.wfMode)) {
            recordBill.set("verifytype", (Object)"manual");
        } else if ("3".equals(this.wfMode)) {
            recordBill.set("verifytype", (Object)"manual");
        } else if ("1".equals(this.wfMode)) {
            recordBill.set("verifytype", (Object)"auto");
        }
    }

    @Override
    public void afterWfRecordStrategy(List<DynamicObject> records) {
        logger.info("BusRedBlueVerifyWriteOffPlugin.afterWfRecordStrategy start");
        logger.info("BusRedBlueVerifyWriteOffPlugin.afterWfRecordStrategy end");
    }

    @Override
    public void kdtxWfPlugin(List<DynamicObject> records, Map<String, Object> param) {
        logger.info("BusRedBlueVerifyWriteOffPlugin.kdtxWfPlugin start");
        if (records.size() == 0) {
            return;
        }
        this.isAr = this.isAr(records.get(0));
        DynamicObject[] recordArray = BusinessDataServiceHelper.load((Object[])records.stream().map(record -> record.getLong("id")).toArray(Object[]::new), (DynamicObjectType)records.get(0).getDynamicObjectType());
        ArrayList<DynamicObject> verifyRecords = new ArrayList<DynamicObject>(recordArray.length);
        verifyRecords.addAll(Arrays.asList(recordArray));
        logger.info("BusRedBlueVerifyWriteOffPlugin.afterWfRecordStrategy reload records size" + records.size());
        DynamicObject[] busBills = this.getNeedPushBusBills(verifyRecords);
        Map<Long, BusEntryParam> busEntryMap = this.getBusEntryParamMap(busBills);
        this.fillAndSaveVerifyRecord(verifyRecords, busEntryMap);
        List<Long> needPushBusBillIds = Arrays.stream(busBills).map(busBill -> busBill.getLong("id")).collect(Collectors.toList());
        this.executeWoff(needPushBusBillIds, verifyRecords, param);
        logger.info("BusRedBlueVerifyWriteOffPlugin.kdtxWfPlugin end");
    }

    @Override
    public Map<String, Object> getKdtxWfPluginParam(List<Map<String, Object>> recordMapping) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        WriteOffExecuteContext executeContext = this.getExecuteContext();
        IWriteOffReqParam reqParam = executeContext.getReqParam();
        if (reqParam instanceof ManualAutoWfReqParam) {
            ManualAutoWfReqParam manualAutoWfReqParam = (ManualAutoWfReqParam)reqParam;
            for (Map.Entry<String, Object> entry : manualAutoWfReqParam.getParams().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                paramMap.put(key, value);
            }
        }
        return paramMap;
    }

    private DynamicObject[] getNeedPushBusBills(List<DynamicObject> records) {
        HashSet<Long> busBilIds = new HashSet<Long>(8);
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection entries = recordBill.getDynamicObjectCollection("entry");
            logger.info("getNeedPushBusBills.entries" + entries.size());
            for (DynamicObject entry : entries) {
                long mainBillId = entry.getLong("billid");
                long asstBillId = entry.getLong("assbillid");
                logger.info("getNeedPushBusBills.mainBillId:" + mainBillId + ",asstBillId\uff1a" + asstBillId);
                busBilIds.add(mainBillId);
                busBilIds.add(asstBillId);
            }
        }
        String busBillEntity = this.isAr ? "ar_busbill" : "ap_busbill";
        return BusinessDataServiceHelper.load((String)busBillEntity, (String)"id,entryid,quotation,exchangerate,currency,basecurrency,e_unitcoefficient,e_measureunit,e_baseunit,e_actunitprice,e_acttaxunitprice,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", busBilIds)});
    }

    private Map<Long, BusEntryParam> getBusEntryParamMap(DynamicObject[] busBills) {
        HashMap<Long, BusEntryParam> busEntryMap = new HashMap<Long, BusEntryParam>(8);
        for (DynamicObject busBill : busBills) {
            logger.info("getBusEntryParamMap.busBill id:" + busBill.getLong("id") + ",status\uff1a" + busBill.getString("billstatus"));
            DynamicObjectCollection entries = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BusEntryParam param = new BusEntryParam();
                param.exchangerate = busBill.getBigDecimal("exchangerate");
                param.quotation = busBill.getString("quotation");
                DynamicObject currency = busBill.getDynamicObject("currency");
                int scale = currency == null ? 2 : currency.getInt("amtprecision");
                DynamicObject basecurrency = busBill.getDynamicObject("basecurrency");
                int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
                param.currencyPrecision = scale;
                param.baseCurrencyPrecision = baseScale;
                param.unitcoefficient = entry.getBigDecimal("e_unitcoefficient");
                param.actunitprice = entry.getBigDecimal("e_actunitprice");
                param.unitPrecision = entry.getDynamicObject("e_measureunit");
                param.baseunitPrecision = entry.getDynamicObject("e_baseunit");
                busEntryMap.put(entry.getLong("id"), param);
            }
        }
        return busEntryMap;
    }

    private void fillAndSaveVerifyRecord(List<DynamicObject> records, Map<Long, BusEntryParam> busEntryMap) {
        for (DynamicObject recordBill : records) {
            DynamicObject payProperty = recordBill.getDynamicObject("payproperty");
            boolean isAmtFlag = payProperty.getBoolean("isbasedonamt");
            DynamicObjectCollection entries = recordBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                if (isAmtFlag) {
                    this.fillVerifyRecordByAmt(entry, busEntryMap);
                    continue;
                }
                this.fillVerifyRecordByQty(entry, busEntryMap);
            }
        }
        SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
    }

    private void fillVerifyRecordByAmt(DynamicObject entry, Map<Long, BusEntryParam> busEntryMap) {
        BigDecimal mainVerifyValue = entry.getBigDecimal("qty");
        BigDecimal asstVerifyValue = entry.getBigDecimal("assqty");
        BusEntryParam mainParam = busEntryMap.get(entry.getLong("billentryid"));
        BigDecimal mainVerifyQty = new BigDecimal(1);
        entry.set("verifyqty", (Object)mainVerifyQty);
        entry.set("baseqty", (Object)UnitConvertHelper.getBaseunitqty(mainVerifyQty, mainParam.unitcoefficient, mainParam.baseunitPrecision));
        BigDecimal mainAmount = mainVerifyValue.setScale(mainParam.currencyPrecision, RoundingMode.HALF_UP);
        entry.set("amount", (Object)mainAmount);
        entry.set("localamount", (Object)this.getLocalAmt(mainAmount, mainParam.quotation, mainParam.exchangerate, mainParam.baseCurrencyPrecision));
        BusEntryParam asstParam = busEntryMap.get(entry.getLong("assbillentryid"));
        BigDecimal asstVerifyQty = new BigDecimal(-1);
        entry.set("asstverifyqty", (Object)asstVerifyQty);
        entry.set("asstbaseqty", (Object)UnitConvertHelper.getBaseunitqty(asstVerifyQty, asstParam.unitcoefficient, asstParam.baseunitPrecision));
        BigDecimal asstAmount = asstVerifyValue.setScale(asstParam.currencyPrecision, RoundingMode.HALF_UP);
        entry.set("asstamount", (Object)asstAmount);
        entry.set("asstlocalamount", (Object)this.getLocalAmt(asstAmount, asstParam.quotation, asstParam.exchangerate, asstParam.baseCurrencyPrecision));
    }

    private void fillVerifyRecordByQty(DynamicObject entry, Map<Long, BusEntryParam> busEntryMap) {
        BigDecimal mainVerifyValue = entry.getBigDecimal("qty");
        BigDecimal asstVerifyValue = entry.getBigDecimal("assqty");
        BusEntryParam mainParam = busEntryMap.get(entry.getLong("billentryid"));
        BigDecimal mainVerifyQty = this.getQtyByUnitPresicion(mainVerifyValue, mainParam.unitPrecision);
        entry.set("verifyqty", (Object)mainVerifyQty);
        entry.set("baseqty", (Object)UnitConvertHelper.getBaseunitqty(mainVerifyQty, mainParam.unitcoefficient, mainParam.baseunitPrecision));
        BigDecimal mainAmount = mainVerifyQty.multiply(mainParam.actunitprice).setScale(mainParam.currencyPrecision, RoundingMode.HALF_UP);
        entry.set("amount", (Object)mainAmount);
        entry.set("localamount", (Object)this.getLocalAmt(mainAmount, mainParam.quotation, mainParam.exchangerate, mainParam.baseCurrencyPrecision));
        BusEntryParam asstParam = busEntryMap.get(entry.getLong("assbillentryid"));
        BigDecimal asstVerifyQty = this.getQtyByUnitPresicion(asstVerifyValue, asstParam.unitPrecision);
        entry.set("asstverifyqty", (Object)asstVerifyQty);
        entry.set("asstbaseqty", (Object)UnitConvertHelper.getBaseunitqty(asstVerifyQty, asstParam.unitcoefficient, asstParam.baseunitPrecision));
        BigDecimal asstAmount = asstVerifyQty.multiply(asstParam.actunitprice).setScale(asstParam.currencyPrecision, RoundingMode.HALF_UP);
        entry.set("asstamount", (Object)asstAmount);
        entry.set("asstlocalamount", (Object)this.getLocalAmt(asstAmount, asstParam.quotation, asstParam.exchangerate, asstParam.baseCurrencyPrecision));
    }

    private void executeWoff(List<Long> busBillIds, List<DynamicObject> records, Map<String, Object> param) {
        DynamicObject[] busWoffBills;
        Map<Long, PushedEntryParam> pushedEntryParamMap = this.getPushedEntryParamMap(records);
        String busBillEntity = this.isAr ? "ar_busbill" : "ap_busbill";
        String arWriteoffRuleId = "697561685841434624";
        String apWriteoffRuleId = "712748085842822144";
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (!"bizdate".equals(entry.getKey())) continue;
            paramMap.put(entry.getKey(), entry.getValue().toString());
        }
        logger.info(((Object)paramMap).toString());
        paramMap.put("woffmode", "batch");
        paramMap.put("isselfwoff", "true");
        List<DynamicObject> pushedBusBills = BOTPHelper.push(busBillEntity, busBillEntity, this.isAr ? "697561685841434624" : "712748085842822144", busBillIds, paramMap);
        logger.info("BusRedBlueVerifyWriteOffPlugin.executeWoff.pushed bill size:" + pushedBusBills.size());
        for (DynamicObject pushedBusBill : pushedBusBills) {
            DynamicObject payProperty = pushedBusBill.getDynamicObject("payproperty");
            boolean isAmtFlag = payProperty.getBoolean("isbasedonamt");
            DynamicObject[] entries = pushedBusBill.getDynamicObjectCollection("entry");
            Iterator itr = entries.iterator();
            while (itr.hasNext()) {
                DynamicObject entry = (DynamicObject)itr.next();
                long srcEntryId = entry.getLong("e_srcentryid");
                PushedEntryParam pushedEntryParam = pushedEntryParamMap.get(srcEntryId);
                if (pushedEntryParam == null) {
                    itr.remove();
                    continue;
                }
                if (isAmtFlag) {
                    BigDecimal needWoffAmt = pushedEntryParam.entryNeedWoffAmt;
                    this.recalculateEntryByAmt(pushedBusBill, entry, needWoffAmt);
                    continue;
                }
                BigDecimal needWoffQty = pushedEntryParam.entryNeedWoffQty;
                this.recalculateEntryByQty(pushedBusBill, entry, needWoffQty);
            }
            this.recalculateHead(pushedBusBill);
        }
        this.setBusBillNumber(pushedBusBills);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"nocontrolsubmit", (String)busBillEntity, (DynamicObject[])pushedBusBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)busBillEntity, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(auditResult);
        for (DynamicObject woffBusBill : busWoffBills = BusinessDataServiceHelper.load((String)busBillEntity, (String)"id,entryid,e_srcentryid,isverifybusiness", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)auditResult.getSuccessPkIds())})) {
            woffBusBill.set("isverifybusiness", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.update((DynamicObject[])busWoffBills);
        HashMap<Long, BusWoffBillInfo> srcEntryIdToBusWoffInfo = new HashMap<Long, BusWoffBillInfo>(8);
        for (DynamicObject busWoffBill : busWoffBills) {
            long busWoffBillId = busWoffBill.getLong("id");
            DynamicObjectCollection entries = busWoffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long entryId = entry.getLong("id");
                long srcEntryId = entry.getLong("e_srcentryid");
                BusWoffBillInfo info = new BusWoffBillInfo();
                info.id = busWoffBillId;
                info.entryId = entryId;
                srcEntryIdToBusWoffInfo.put(srcEntryId, info);
            }
        }
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long mainEntryId = entry.getLong("billentryid");
                long asstEntryId = entry.getLong("assbillentryid");
                BusWoffBillInfo mainWoffBillInfo = (BusWoffBillInfo)srcEntryIdToBusWoffInfo.get(mainEntryId);
                BusWoffBillInfo asstWoffBillInfo = (BusWoffBillInfo)srcEntryIdToBusWoffInfo.get(asstEntryId);
                entry.set("woffbillid", (Object)mainWoffBillInfo.id);
                entry.set("woffbillentryId", (Object)mainWoffBillInfo.entryId);
                entry.set("asstwoffbillid", (Object)asstWoffBillInfo.id);
                entry.set("asstwoffbillentryId", (Object)asstWoffBillInfo.entryId);
            }
        }
        SaveServiceHelper.update((DynamicObject[])records.toArray(new DynamicObject[0]));
    }

    private Map<Long, PushedEntryParam> getPushedEntryParamMap(List<DynamicObject> records) {
        HashMap<Long, PushedEntryParam> entryParamMap = new HashMap<Long, PushedEntryParam>(8);
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection entries = recordBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long mainEntryId = entry.getLong("billentryid");
                long asstEntryId = entry.getLong("assbillentryid");
                PushedEntryParam entryParam = new PushedEntryParam();
                entryParam.entryNeedWoffAmt = entry.getBigDecimal("asstamount");
                entryParam.entryNeedWoffQty = entry.getBigDecimal("asstverifyqty");
                PushedEntryParam mainEntryParam = (PushedEntryParam)entryParamMap.get(mainEntryId);
                if (mainEntryParam == null) {
                    PushedEntryParam entryParamReverse = new PushedEntryParam();
                    entryParamReverse.entryNeedWoffAmt = entryParam.entryNeedWoffAmt.negate();
                    entryParamReverse.entryNeedWoffQty = entryParam.entryNeedWoffQty.negate();
                    entryParamMap.put(mainEntryId, entryParamReverse);
                } else {
                    mainEntryParam.entryNeedWoffAmt = mainEntryParam.entryNeedWoffAmt.add(entryParam.entryNeedWoffAmt.negate());
                    mainEntryParam.entryNeedWoffQty = mainEntryParam.entryNeedWoffQty.add(entryParam.entryNeedWoffQty.negate());
                }
                PushedEntryParam asstEntryParam = (PushedEntryParam)entryParamMap.get(asstEntryId);
                if (asstEntryParam == null) {
                    entryParamMap.put(asstEntryId, entryParam);
                    continue;
                }
                asstEntryParam.entryNeedWoffAmt = asstEntryParam.entryNeedWoffAmt.add(entryParam.entryNeedWoffAmt);
                asstEntryParam.entryNeedWoffQty = asstEntryParam.entryNeedWoffQty.add(entryParam.entryNeedWoffQty);
            }
        }
        return entryParamMap;
    }

    private void recalculateEntryByQty(DynamicObject busBill, DynamicObject entry, BigDecimal needWoffQty) {
        BigDecimal woffBillQty;
        BigDecimal billQty = entry.getBigDecimal("e_quantity");
        if (billQty.compareTo(woffBillQty = needWoffQty.negate()) != 0) {
            AbstractPriceCalculator calculator;
            BigDecimal exchangerate = busBill.getBigDecimal("exchangerate");
            boolean includeTax = busBill.getBoolean("isincludetax");
            DynamicObject currency = busBill.getDynamicObject("currency");
            int scale = currency == null ? 2 : currency.getInt("amtprecision");
            DynamicObject basecurrency = busBill.getDynamicObject("basecurrency");
            int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
            String quotation = busBill.getString("quotation");
            BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
            String discountMode = entry.getString("e_discountmode");
            BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
            BigDecimal discountAmt = entry.getBigDecimal("e_discountamount");
            BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
            DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
            if (includeTax) {
                BigDecimal taxUnitPrice = entry.getBigDecimal("e_taxunitprice");
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    discountAmt = discountRate.multiply(woffBillQty).setScale(baseScale, RoundingMode.HALF_UP);
                }
                calculator = new TaxUnitPriceCalculator(woffBillQty, taxUnitPrice, taxRate, discountMode, discountRate, scale, BigDecimal.ZERO, discountAmt);
            } else {
                BigDecimal unitPrice = entry.getBigDecimal("e_unitprice");
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    discountAmt = discountRate.multiply(woffBillQty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(baseScale, RoundingMode.HALF_UP);
                }
                calculator = new UnitPriceCalculator(woffBillQty, unitPrice, taxRate, discountMode, discountRate, scale, BigDecimal.ZERO, discountAmt);
            }
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangerate, baseScale, quotation);
            localCalculator.calculate();
            entry.set("e_tax", (Object)localCalculator.getTax());
            entry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
            entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
            entry.set("e_amount", (Object)localCalculator.getAmount());
            entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
            entry.set(this.isAr ? "e_recamount" : "e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal());
            entry.set(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_uninvoicedamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_uninvoicedlocamt", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_unwoffamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_unwofflocamt", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_unwofftax", (Object)localCalculator.getTax());
            entry.set("e_unwofftaxlocal", (Object)localCalculator.getTaxlocal());
            entry.set("e_unwoffnotaxamt", (Object)localCalculator.getAmount());
            entry.set("e_unwoffnotaxlocamt", (Object)localCalculator.getAmountlocal());
            entry.set("e_uninvnotaxamt", (Object)localCalculator.getAmount());
            entry.set("e_uninvnotaxlocalamt", (Object)localCalculator.getAmountlocal());
            entry.set("e_quantity", (Object)woffBillQty);
            entry.set("e_uninvoicedqty", (Object)woffBillQty);
            entry.set("e_unwoffqty", (Object)woffBillQty);
            entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(woffBillQty, covertRate, baseUnit));
            if (this.isAr) {
                entry.set("e_unrelateinvamt", (Object)localCalculator.getPricetaxtotal());
                entry.set("e_unrelateinvlocamt", (Object)localCalculator.getPricetaxtotallocal());
                entry.set("e_unrelateinvqty", (Object)woffBillQty);
            }
        }
    }

    private void recalculateEntryByAmt(DynamicObject busBill, DynamicObject entry, BigDecimal needWoffAmt) {
        BigDecimal woffBillAmt;
        BigDecimal billAmt = entry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal");
        if (billAmt.compareTo(woffBillAmt = needWoffAmt.negate()) != 0) {
            BigDecimal exchangerate = busBill.getBigDecimal("exchangerate");
            boolean includeTax = busBill.getBoolean("isincludetax");
            DynamicObject currency = busBill.getDynamicObject("currency");
            int scale = currency == null ? 2 : currency.getInt("amtprecision");
            DynamicObject basecurrency = busBill.getDynamicObject("basecurrency");
            int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
            String quotation = busBill.getString("quotation");
            BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
            BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
            DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
            BigDecimal qty = entry.getBigDecimal("e_quantity");
            if (qty == null) {
                qty = BigDecimal.ZERO;
            }
            if (!entry.getBoolean("e_ispresent")) {
                qty = new BigDecimal(woffBillAmt.compareTo(BigDecimal.ZERO));
            }
            String discountMode = "NULL";
            BigDecimal discountRate = BigDecimal.ZERO;
            PriceTotalCalculator calculator = new PriceTotalCalculator(qty, woffBillAmt, taxRate, discountMode, discountRate, scale);
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangerate, baseScale, quotation);
            localCalculator.calculate();
            BigDecimal amount = localCalculator.getAmount();
            BigDecimal localamt = localCalculator.getAmountlocal();
            BigDecimal tax = localCalculator.getTax();
            BigDecimal taxlocalamt = localCalculator.getTaxlocal();
            entry.set("e_tax", (Object)tax);
            entry.set("e_taxlocalamt", (Object)taxlocalamt);
            entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
            entry.set("e_amount", (Object)amount);
            entry.set("e_localamt", (Object)localamt);
            entry.set(this.isAr ? "e_recamount" : "e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal());
            entry.set(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_uninvoicedamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_uninvoicedlocamt", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_unwoffamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_unwofflocamt", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_unwofftax", (Object)tax);
            entry.set("e_unwofftaxlocal", (Object)taxlocalamt);
            entry.set("e_unwoffnotaxamt", (Object)amount);
            entry.set("e_unwoffnotaxlocamt", (Object)localamt);
            entry.set("e_uninvnotaxamt", (Object)amount);
            entry.set("e_uninvnotaxlocalamt", (Object)localamt);
            entry.set("e_quantity", (Object)qty);
            entry.set("e_uninvoicedqty", (Object)qty);
            entry.set("e_unwoffqty", (Object)qty);
            entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(qty, covertRate, baseUnit));
            entry.set("e_discountmode", (Object)discountMode);
            entry.set("e_discountrate", (Object)discountRate);
            if (this.isAr) {
                entry.set("e_unrelateinvamt", (Object)localCalculator.getPricetaxtotal());
                entry.set("e_unrelateinvlocamt", (Object)localCalculator.getPricetaxtotallocal());
                entry.set("e_unrelateinvqty", (Object)qty);
            }
        }
    }

    private void recalculateHead(DynamicObject pushedBusBill) {
        BigDecimal taxTotal = BigDecimal.ZERO;
        BigDecimal taxLocalTotal = BigDecimal.ZERO;
        BigDecimal amountTotal = BigDecimal.ZERO;
        BigDecimal localAmtTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxLocalTotal = BigDecimal.ZERO;
        DynamicObjectCollection entries = pushedBusBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            taxTotal = taxTotal.add(entry.getBigDecimal("e_tax"));
            taxLocalTotal = taxLocalTotal.add(entry.getBigDecimal("e_taxlocalamt"));
            amountTotal = amountTotal.add(entry.getBigDecimal("e_amount"));
            localAmtTotal = localAmtTotal.add(entry.getBigDecimal("e_localamt"));
            priceTaxTotal = priceTaxTotal.add(entry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal"));
            priceTaxLocalTotal = priceTaxLocalTotal.add(entry.getBigDecimal(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase"));
        }
        pushedBusBill.set("tax", (Object)taxTotal);
        pushedBusBill.set("taxlocamt", (Object)taxLocalTotal);
        pushedBusBill.set("amount", (Object)amountTotal);
        pushedBusBill.set("localamt", (Object)localAmtTotal);
        pushedBusBill.set(this.isAr ? "recamount" : "pricetaxtotal", (Object)priceTaxTotal);
        pushedBusBill.set(this.isAr ? "reclocalamt" : "pricetaxtotalbase", (Object)priceTaxLocalTotal);
        pushedBusBill.set("uninvoicedamt", (Object)priceTaxTotal);
        pushedBusBill.set("uninvoicedlocamt", (Object)priceTaxLocalTotal);
        pushedBusBill.set("unwoffamt", (Object)priceTaxTotal);
        pushedBusBill.set("unwofflocamt", (Object)priceTaxLocalTotal);
        pushedBusBill.set("unwoffnotaxamt", (Object)amountTotal);
        pushedBusBill.set("unwoffnotaxlocamt", (Object)localAmtTotal);
        pushedBusBill.set("unwofftax", (Object)taxTotal);
        pushedBusBill.set("unwofftaxlocal", (Object)taxLocalTotal);
        if (this.isAr) {
            pushedBusBill.set("unrelateinvamt", (Object)priceTaxTotal);
            pushedBusBill.set("unrelateinvlocamt", (Object)priceTaxLocalTotal);
        }
    }

    private void setBusBillNumber(List<DynamicObject> trgBills) {
        String busBillEntity = this.isAr ? "ar_busbill" : "ap_busbill";
        Map<String, List<DynamicObject>> orgPkGroup = trgBills.stream().collect(Collectors.groupingBy(bill -> bill.getDynamicObject("org").getPkValue().toString()));
        orgPkGroup.forEach((key, targetBills) -> {
            int size = targetBills.size();
            Object[] numbers = CodeRuleServiceHelper.getBatchNumber((String)busBillEntity, (DynamicObject)((DynamicObject)targetBills.get(0)), (String)key, (int)size);
            if (ObjectUtils.isEmpty((Object[])numbers) || numbers.length < size) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4f30\u5355\u7f16\u7801\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u3002", (String)"FinWoffService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            int i = 0;
            for (DynamicObject trgBusBill : targetBills) {
                trgBusBill.set("billno", numbers[i]);
                ++i;
            }
        });
    }

    private BigDecimal getQtyByUnitPresicion(BigDecimal verifyValue, DynamicObject unit) {
        BigDecimal result;
        if (unit == null) {
            result = verifyValue.setScale(10, 4);
        } else {
            int precisionaccount = unit.getInt("precisionaccount");
            int precision = unit.getInt("precision");
            result = precisionaccount == 2 ? verifyValue.setScale(precision, 1) : (precisionaccount == 3 ? verifyValue.setScale(precision, 0) : verifyValue.setScale(precision, 4));
        }
        return result;
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchangerate, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchangerate, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchangerate).setScale(precision, RoundingMode.HALF_UP);
    }

    private boolean isAr(DynamicObject recordBill) {
        String verifyRecordEntity = recordBill.getDataEntityType().getName();
        return !"ap_bus_verifyrecord".equals(verifyRecordEntity);
    }

    public String getWfMode() {
        return this.wfMode;
    }

    public void setWfMode(String wfMode) {
        this.wfMode = wfMode;
    }

    static class BusWoffBillInfo {
        Long id;
        Long entryId;

        BusWoffBillInfo() {
        }
    }

    static class PushedEntryParam {
        BigDecimal entryNeedWoffAmt;
        BigDecimal entryNeedWoffQty;

        PushedEntryParam() {
        }
    }

    static class BusEntryParam {
        String quotation;
        BigDecimal exchangerate;
        BigDecimal unitcoefficient;
        DynamicObject unitPrecision;
        DynamicObject baseunitPrecision;
        BigDecimal actunitprice;
        int currencyPrecision;
        int baseCurrencyPrecision;

        BusEntryParam() {
        }
    }
}

