/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.plugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.BookDateHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.UnitConvertHelper;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class FinArSaloutWfRecordWriteOffPlugin
implements IWriteOffPlugin,
IMatchPlugin {
    private static final Log logger = LogFactory.getLog(FinArSaloutWfRecordWriteOffPlugin.class);
    private final Map<String, BigDecimal> unitRateConvMap = new HashMap<String, BigDecimal>(8);
    private static final Long HXLB_AR_SAL_BOTP = 1682538187484133376L;
    private static final Long HXLB_AR_SAL_CORE = 1679120508043735040L;
    private static final Long PPGZ_AR_SAL_BOTP = 1682628186049181696L;
    private static final Long PPGZ_AR_SAL_CORE = 1680362254467615744L;
    private static final String AR_APPID = "/BBRH+122=39";

    @Override
    public Set<Long> getMachRuleIds() {
        return CommonUtils.getIdSet(PPGZ_AR_SAL_CORE);
    }

    @Override
    public List<MatchPluginResult> matchCondition(WriteOffObjectArgs writeOffObject) {
        ArrayList<MatchPluginResult> results = new ArrayList<MatchPluginResult>(2);
        WriteOffObjectBase writeOffObjectBase = writeOffObject.getWriteOffObjectBase();
        String entityKey = writeOffObjectBase.getWFBillEntityName();
        DynamicObject typeConfig = writeOffObject.getTypeConfig();
        if (HXLB_AR_SAL_CORE.equals(typeConfig.getPkValue())) {
            Object value;
            String coreBillType = "null";
            if ("ar_finarbill".equals(entityKey) && !ObjectUtils.isEmpty((Object)(value = writeOffObjectBase.getValue("e_corebilltype")))) {
                coreBillType = (String)value;
            }
            if ("im_saloutbill".equals(entityKey) && !ObjectUtils.isEmpty((Object)(value = writeOffObjectBase.getValue("mainbillentity")))) {
                coreBillType = (String)value;
            }
            MatchPluginResult response = new MatchPluginResult();
            response.setMatchValue(HXLB_AR_SAL_CORE + "#" + coreBillType);
            response.setMatchName("CORE");
            response.setComparison("=");
            results.add(response);
        }
        return results;
    }

    @Override
    public Boolean matchCompare(MatchPluginResult response, Object srcValue) {
        return Boolean.TRUE;
    }

    @Override
    public QFilter getMatchFilter(Object value, String targetEntity, String targetEntryId) {
        if (value == null) {
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        String[] values = value.toString().split("#");
        Long hxlb = Long.parseLong(values[0]);
        if (HXLB_AR_SAL_CORE.equals(hxlb)) {
            if ("null".equals(values[1])) {
                return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            }
            String coreBillType = values[1];
            if ("ar_finarbill".equals(targetEntity)) {
                return new QFilter("entry.e_corebilltype", "=", (Object)coreBillType);
            }
            if ("im_saloutbill".equals(targetEntity)) {
                return new QFilter("billentry.mainbillentity", "=", (Object)coreBillType);
            }
        }
        return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(HXLB_AR_SAL_BOTP, HXLB_AR_SAL_CORE);
    }

    @Override
    public void beforeWfRecordGenerate(DynamicObject recordBill) {
        DynamicObjectCollection entries = recordBill.getDynamicObjectCollection("entry");
        if (entries == null || entries.size() < 1) {
            return;
        }
        for (DynamicObject entry : entries) {
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal assQty = entry.getBigDecimal("assqty");
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            DynamicObject measureUnit = entry.getDynamicObject("unit");
            BigDecimal unitRateConv = this.getUnitRateConv(material, baseUnit, measureUnit);
            BigDecimal verifyQty = UnitConvertHelper.getUnitQty(qty, unitRateConv, measureUnit);
            entry.set("verifyqty", (Object)verifyQty);
            entry.set("verifybaseqty", (Object)qty);
            DynamicObject currency = entry.getDynamicObject("currency");
            int pricePrecision = currency.getInt("amtprecision");
            DynamicObject baseCurrency = entry.getDynamicObject("basecurrency");
            int pricePrecisionBase = baseCurrency.getInt("amtprecision");
            String quotation = entry.getString("quotation");
            BigDecimal exchangeRate = entry.getBigDecimal("exchangerate");
            BigDecimal amount = entry.getBigDecimal("amount");
            BigDecimal amountLoc = entry.getBigDecimal("localamt");
            BigDecimal priceTaxTotal = entry.getBigDecimal("pricetaxtotal");
            BigDecimal priceTaxTotalLoc = entry.getBigDecimal("pricetaxtotalbase");
            BigDecimal unitPrice = entry.getBigDecimal("unitprice");
            BigDecimal taxUnitPrice = entry.getBigDecimal("taxunitprice");
            BigDecimal verifyAmt = BigDecimal.ZERO;
            BigDecimal verifyLocAmt = BigDecimal.ZERO;
            BigDecimal verifyPriceTotal = BigDecimal.ZERO;
            BigDecimal verifyLocPriceTotal = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(amount) != 0) {
                BigDecimal billBaseQty = entry.getBigDecimal("billbaseqty");
                if (billBaseQty.compareTo(qty) == 0) {
                    verifyAmt = amount;
                    verifyPriceTotal = priceTaxTotal;
                    verifyLocAmt = amountLoc;
                    verifyLocPriceTotal = priceTaxTotalLoc;
                } else {
                    verifyAmt = verifyQty.multiply(unitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
                    verifyPriceTotal = verifyQty.multiply(taxUnitPrice).setScale(pricePrecision, RoundingMode.HALF_UP);
                    if ("1".equals(quotation)) {
                        verifyLocAmt = verifyAmt.divide(exchangeRate, pricePrecisionBase, RoundingMode.HALF_UP);
                        verifyLocPriceTotal = verifyPriceTotal.divide(exchangeRate, pricePrecisionBase, RoundingMode.HALF_UP);
                    } else {
                        verifyLocAmt = verifyAmt.multiply(exchangeRate).setScale(pricePrecisionBase, RoundingMode.HALF_UP);
                        verifyLocPriceTotal = verifyPriceTotal.multiply(exchangeRate).setScale(pricePrecisionBase, RoundingMode.HALF_UP);
                    }
                }
            }
            BigDecimal verifyTax = verifyPriceTotal.subtract(verifyAmt);
            BigDecimal verifyLocTax = verifyLocPriceTotal.subtract(verifyLocAmt);
            entry.set("verifyamt", (Object)verifyAmt);
            entry.set("verifylocamt", (Object)verifyLocAmt);
            entry.set("verifypricetotal", (Object)verifyPriceTotal);
            entry.set("verifylocpricetotal", (Object)verifyLocPriceTotal);
            entry.set("verifytax", (Object)verifyTax);
            entry.set("verifyloctax", (Object)verifyLocTax);
            DynamicObject assMaterial = entry.getDynamicObject("assmaterial");
            DynamicObject assBaseUnit = entry.getDynamicObject("assbaseunit");
            DynamicObject assMeasureUnit = entry.getDynamicObject("assunit");
            BigDecimal assUnitRateConv = this.getUnitRateConv(assMaterial, assBaseUnit, assMeasureUnit);
            BigDecimal assVerifyQty = UnitConvertHelper.getUnitQty(assQty, assUnitRateConv, assMeasureUnit);
            entry.set("assverifyqty", (Object)assVerifyQty);
            entry.set("assverifybaseqty", (Object)assQty);
            DynamicObject assCurrency = entry.getDynamicObject("asscurrency");
            int assPricePrecision = assCurrency.getInt("amtprecision");
            DynamicObject assBaseCurrency = entry.getDynamicObject("assbasecurrency");
            int assPricePrecisionBase = assBaseCurrency.getInt("amtprecision");
            String assQuotation = entry.getString("assquotation");
            BigDecimal assExchangeRate = entry.getBigDecimal("assexchangerate");
            BigDecimal assAmount = entry.getBigDecimal("assamount");
            BigDecimal assAmountLoc = entry.getBigDecimal("asslocamt");
            BigDecimal assPriceTaxTotal = entry.getBigDecimal("asspricetaxtotal");
            BigDecimal assPriceTaxTotalLoc = entry.getBigDecimal("asspricetaxtotalbase");
            BigDecimal assUnitPrice = entry.getBigDecimal("assunitprice");
            BigDecimal assTaxUnitPrice = entry.getBigDecimal("asstaxunitprice");
            BigDecimal assVerifyAmt = BigDecimal.ZERO;
            BigDecimal assVerifyLocAmt = BigDecimal.ZERO;
            BigDecimal assVerifyPriceTotal = BigDecimal.ZERO;
            BigDecimal assVerifyLocPriceTotal = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(assAmount) != 0) {
                BigDecimal assBillBaseQty = entry.getBigDecimal("assbillbaseqty");
                if (assBillBaseQty.compareTo(assQty) == 0) {
                    assVerifyAmt = assAmount;
                    assVerifyPriceTotal = assPriceTaxTotal;
                    assVerifyLocAmt = assAmountLoc;
                    assVerifyLocPriceTotal = assPriceTaxTotalLoc;
                } else {
                    assVerifyAmt = assVerifyQty.multiply(assUnitPrice).setScale(assPricePrecision, RoundingMode.HALF_UP);
                    assVerifyPriceTotal = assVerifyQty.multiply(assTaxUnitPrice).setScale(assPricePrecision, RoundingMode.HALF_UP);
                    if ("1".equals(assQuotation)) {
                        assVerifyLocAmt = assVerifyAmt.divide(assExchangeRate, assPricePrecisionBase, RoundingMode.HALF_UP);
                        assVerifyLocPriceTotal = assVerifyPriceTotal.divide(assExchangeRate, assPricePrecisionBase, RoundingMode.HALF_UP);
                    } else {
                        assVerifyLocAmt = assVerifyAmt.multiply(assExchangeRate).setScale(assPricePrecisionBase, RoundingMode.HALF_UP);
                        assVerifyLocPriceTotal = assVerifyPriceTotal.multiply(assExchangeRate).setScale(assPricePrecisionBase, RoundingMode.HALF_UP);
                    }
                }
            }
            BigDecimal assVerifyTax = assVerifyPriceTotal.subtract(assVerifyAmt);
            BigDecimal assVerifyLocTax = assVerifyLocPriceTotal.subtract(assVerifyLocAmt);
            entry.set("assverifyamt", (Object)assVerifyAmt);
            entry.set("assverifylocamt", (Object)assVerifyLocAmt);
            entry.set("assverifypricetotal", (Object)assVerifyPriceTotal);
            entry.set("assverifylocpricetotal", (Object)assVerifyLocPriceTotal);
            entry.set("assverifytax", (Object)assVerifyTax);
            entry.set("assverifyloctax", (Object)assVerifyLocTax);
        }
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        Map<String, List<Object[]>> scmcSqlMap;
        if (records == null || records.size() < 1) {
            return new HashMap<String, Map<String, List<Object[]>>>(8);
        }
        List<DifferentailVO> mainDifferential = this.handleMainTailDifference(records);
        List<DifferentailVO> assDifferential = this.handleAssTailDifference(records);
        BookDateHelper.setVerifyDate(records, true);
        SaveServiceHelper.update((DynamicObject[])records.toArray(new DynamicObject[0]));
        Map<String, List<Long>> statusAndIdMap = this.handelFinArBillVerifyStatus(records);
        HashMap<String, Map<String, List<Object[]>>> sqlListMaps = new HashMap<String, Map<String, List<Object[]>>>(8);
        Map<String, List<Object[]>> fiSqlMap = this.buildFinArStatusSql(statusAndIdMap);
        this.buildFinArDifferential(fiSqlMap, mainDifferential);
        if (fiSqlMap.size() > 0) {
            sqlListMaps.put("fi", fiSqlMap);
        }
        if ((scmcSqlMap = this.buildSaloutDiferential(assDifferential)).size() > 0) {
            sqlListMaps.put("scm", scmcSqlMap);
        }
        return sqlListMaps;
    }

    @Override
    public void afterWfRecordStrategy(List<DynamicObject> records) {
        if (records == null || records.size() < 1) {
            return;
        }
        List<DynamicObject> arSalRecords = records.stream().filter(e -> HXLB_AR_SAL_CORE.equals(e.getLong("writeofftypeid.id"))).collect(Collectors.toList());
        if (arSalRecords.size() < 1) {
            return;
        }
        try {
            List<Map<String, Object>> paramList = this.buildArToSalParam(arSalRecords);
            List<Map<String, Object>> salOrderParamList = paramList.stream().filter(map -> "salorder".equals(map.get("wbtype"))).collect(Collectors.toList());
            List<Map<String, Object>> salContractParamList = paramList.stream().filter(map -> "salcontract".equals(map.get("wbtype"))).collect(Collectors.toList());
            if (salOrderParamList.size() > 0) {
                ArrayList<Map<String, Object>> salOrderParamHasSourceList = new ArrayList<Map<String, Object>>(8);
                for (Map map2 : salOrderParamList) {
                    if (map2.get("sourcebilltype") != null) {
                        map2.remove("sourcebilltype");
                        continue;
                    }
                    salOrderParamHasSourceList.add(map2);
                }
                this.disposeSalOrderService(salOrderParamHasSourceList);
                this.disposeSalContractService(salOrderParamList);
            }
            if (salContractParamList.size() > 0) {
                this.disposeSalContractService(salContractParamList);
            }
        }
        catch (RuntimeException e2) {
            throw new KDBizException(e2.getMessage());
        }
    }

    private Map<String, List<Object[]>> buildFinArStatusSql(Map<String, List<Long>> statusAndIdMap) {
        HashMap<String, List<Object[]>> fiSqlMap = new HashMap<String, List<Object[]>>(8);
        if (statusAndIdMap.size() > 0) {
            String sql = "update t_ar_finarbill set fverifystatus = ? where fid = ?";
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(8);
            for (Map.Entry<String, List<Long>> statusIdEntry : statusAndIdMap.entrySet()) {
                String key = statusIdEntry.getKey();
                List<Long> value = statusIdEntry.getValue();
                for (Long id : value) {
                    Object[] param = new Object[]{key, id};
                    sqlParams.add(param);
                }
            }
            if (sqlParams.size() > 0) {
                fiSqlMap.put(sql, sqlParams);
            }
        }
        return fiSqlMap;
    }

    private void buildFinArDifferential(Map<String, List<Object[]>> fiSqlMap, List<DifferentailVO> mainDifferential) {
        if (mainDifferential.size() > 0) {
            Number value;
            Long key;
            String headSql = "update t_ar_finarbill set funverifyamount = funverifyamount - ? where fid = ?";
            String entrySql = "update t_ar_finarbillentry set funverifyqty = funverifyqty - ?,fverifiedqty = fverifiedqty + ?,funverifyamt = funverifyamt - ?,fverifiedamt = fverifiedamt + ? where fid = ? and fentryid = ?";
            ArrayList<Object[]> headSqlParams = new ArrayList<Object[]>(8);
            ArrayList<Object[]> entrSqlParams = new ArrayList<Object[]>(8);
            HashMap<Long, Long> entryIdAndArId = new HashMap<Long, Long>(8);
            HashMap<Long, BigDecimal> arIdAndUnVerifyAmt = new HashMap<Long, BigDecimal>(8);
            HashMap<Long, BigDecimal> entryIdAndAmt = new HashMap<Long, BigDecimal>(8);
            HashMap<Long, BigDecimal> entryIdAndQty = new HashMap<Long, BigDecimal>(8);
            for (DifferentailVO differentailVO : mainDifferential) {
                BigDecimal verifyQtyDiff = differentailVO.getVerifyQtyDiff();
                BigDecimal verifyAmtDiff = differentailVO.getVerifyAmtDiff();
                if (BigDecimal.ZERO.compareTo(verifyQtyDiff) == 0 && BigDecimal.ZERO.compareTo(verifyAmtDiff) == 0) continue;
                Long id = differentailVO.getId();
                Long entryId = differentailVO.getEntryId();
                entryIdAndArId.put(entryId, id);
                if (BigDecimal.ZERO.compareTo(verifyAmtDiff) != 0) {
                    arIdAndUnVerifyAmt.merge(id, verifyAmtDiff, BigDecimal::add);
                }
                entryIdAndQty.merge(entryId, verifyQtyDiff, BigDecimal::add);
                entryIdAndAmt.merge(entryId, verifyAmtDiff, BigDecimal::add);
            }
            for (Map.Entry entry : arIdAndUnVerifyAmt.entrySet()) {
                key = (Long)entry.getKey();
                value = (BigDecimal)entry.getValue();
                Object[] param = new Object[]{value, key};
                headSqlParams.add(param);
            }
            if (headSqlParams.size() > 0) {
                fiSqlMap.put(headSql, headSqlParams);
            }
            for (Map.Entry entry : entryIdAndArId.entrySet()) {
                key = (Long)entry.getKey();
                value = (Long)entry.getValue();
                BigDecimal qtyDiff = (BigDecimal)entryIdAndQty.get(key);
                BigDecimal amtDiff = (BigDecimal)entryIdAndAmt.get(key);
                if (qtyDiff == null || amtDiff == null) continue;
                Object[] param = new Object[]{qtyDiff, qtyDiff, amtDiff, amtDiff, value, key};
                entrSqlParams.add(param);
            }
            if (entrSqlParams.size() > 0) {
                fiSqlMap.put(entrySql, entrSqlParams);
            }
        }
    }

    private Map<String, List<Object[]>> buildSaloutDiferential(List<DifferentailVO> assDifferential) {
        HashMap<String, List<Object[]>> scmcSqlMap = new HashMap<String, List<Object[]>>(8);
        if (assDifferential.size() > 0) {
            String sql = "update t_im_saloutbillentry_r set fremainjoinpriceqty = fremainjoinpriceqty - ?, fjoinpriceqty = fjoinpriceqty + ? where fid = ? and fentryid = ?";
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(8);
            HashMap<Long, Long> entryIdAndSaloutId = new HashMap<Long, Long>(8);
            HashMap<Long, BigDecimal> entryIdAndQty = new HashMap<Long, BigDecimal>(8);
            for (DifferentailVO differentailVO : assDifferential) {
                BigDecimal verifyQtyDiff = differentailVO.getVerifyQtyDiff();
                if (BigDecimal.ZERO.compareTo(verifyQtyDiff) == 0) continue;
                Long id = differentailVO.getId();
                Long entryId = differentailVO.getEntryId();
                entryIdAndSaloutId.put(entryId, id);
                entryIdAndQty.merge(entryId, verifyQtyDiff, BigDecimal::add);
            }
            for (Map.Entry entry : entryIdAndSaloutId.entrySet()) {
                Long key = (Long)entry.getKey();
                Long value = (Long)entry.getValue();
                BigDecimal qtyDiff = (BigDecimal)entryIdAndQty.get(key);
                if (qtyDiff == null) continue;
                Object[] param = new Object[]{qtyDiff, qtyDiff, value, key};
                sqlParams.add(param);
            }
            if (sqlParams.size() > 0) {
                scmcSqlMap.put(sql, sqlParams);
            }
        }
        return scmcSqlMap;
    }

    private BigDecimal getUnitRateConv(DynamicObject material, DynamicObject baseUnit, DynamicObject measureUnit) {
        Long measureUnitId;
        Long baseUnitId;
        BigDecimal unitRateConv = BigDecimal.ONE;
        if (material != null && baseUnit != null && measureUnit != null && !(baseUnitId = Long.valueOf(baseUnit.getLong("id"))).equals(measureUnitId = Long.valueOf(measureUnit.getLong("id")))) {
            Long materialId = material.getLong("id");
            String convertKey = String.valueOf(baseUnitId) + measureUnitId;
            BigDecimal convertRate = this.unitRateConvMap.get(convertKey);
            if (convertRate != null) {
                unitRateConv = convertRate;
            } else {
                unitRateConv = UnitConvertHelper.getUnitRateConv(materialId, measureUnitId, baseUnitId);
                this.unitRateConvMap.put(convertKey, unitRateConv);
            }
        }
        return unitRateConv;
    }

    private void handleLinkUpNodes(String curEntity, String curEntryKey, Long curId, Long curEntryId, String targetEntity, Set<Long> ids, Set<Long> entryIds) {
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (String)curEntryKey, (Long[])new Long[]{curId}, (Long[])new Long[]{curEntryId}, null);
        if (linkUpNodes == null || linkUpNodes.isEmpty()) {
            return;
        }
        TableDefine tableDefine = EntityMetadataCache.loadMainTableDefine((String)targetEntity);
        Long upTableId = tableDefine.getTableId();
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            List<BFRowLinkUpNode> sourceNodes = FinArSaloutWfRecordWriteOffPlugin.findSourceNodes(linkUpNode, upTableId, curId);
            for (BFRowLinkUpNode sourceNode : sourceNodes) {
                ids.add(sourceNode.getRowId().getBillId());
                entryIds.add(sourceNode.getRowId().getEntryId());
            }
        }
    }

    private void handleLinkDownNodes(String curEntity, String curEntryKey, Long curId, Long curEntryId, String targetEntity, Set<Long> ids, Set<Long> entryIds) {
        List linkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)curEntity, (String)curEntryKey, (Long[])new Long[]{curId}, (Long[])new Long[]{curEntryId}, null);
        if (linkDownNodes == null || linkDownNodes.isEmpty()) {
            return;
        }
        TableDefine tableDefine = EntityMetadataCache.loadMainTableDefine((String)targetEntity);
        Long upTableId = tableDefine.getTableId();
        for (BFRowLinkDownNode linkDwonNode : linkDownNodes) {
            List<BFRowLinkDownNode> sourceNodes = FinArSaloutWfRecordWriteOffPlugin.findSourceNodes(linkDwonNode, upTableId, curId);
            for (BFRowLinkDownNode sourceNode : sourceNodes) {
                ids.add(sourceNode.getRowId().getBillId());
                entryIds.add(sourceNode.getRowId().getEntryId());
            }
        }
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(FinArSaloutWfRecordWriteOffPlugin.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }

    private static List<BFRowLinkDownNode> findSourceNodes(BFRowLinkDownNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkDownNode sNode : node.getTNodes().values()) {
                nodes.addAll(FinArSaloutWfRecordWriteOffPlugin.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }

    private List<Map<String, Object>> buildArToSalParam(List<DynamicObject> records) {
        Long[] coreIdAndEntryId;
        Long finArEntryId;
        Set seqTemp;
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(8);
        Map<Long, Boolean> assactInterMap = this.isExistInternalBusinessUnit(records);
        ArrayList<Long> finArBillIds = new ArrayList<Long>(8);
        ArrayList<Long> finArBillEntryIds = new ArrayList<Long>(8);
        HashMap<Long, BigDecimal> entryIdQAndQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> entryIdQAndAmt = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long billEntryId = entry.getLong("billentryid");
                finArBillIds.add(entry.getLong("billid"));
                finArBillEntryIds.add(billEntryId);
                entryIdQAndQty.merge(billEntryId, entry.getBigDecimal("verifybaseqty"), BigDecimal::add);
                entryIdQAndAmt.merge(billEntryId, entry.getBigDecimal("verifypricetotal"), BigDecimal::add);
            }
        }
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,sourcebilltype,entry.id,org.id,asstact.id,currency.amtprecision,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq,entry.e_conbillentity.number,entry.e_conbillnumber,entry.e_conbillrownum", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds), new QFilter("entry.id", "in", finArBillEntryIds)});
        HashSet<String> coreBillNos = new HashSet<String>(8);
        HashSet<String> conBillNos = new HashSet<String>(8);
        HashMap coreNoAndSeqs = new HashMap(8);
        HashMap conNoAndSeqs = new HashMap(8);
        HashMap<String, Long> coreNoSeqMapAndFinArEntryId = new HashMap<String, Long>(8);
        HashMap<String, Long> conNoSeqMapAndFinArEntryId = new HashMap<String, Long>(8);
        for (DynamicObject finArBill : finArBills) {
            Long entryId = finArBill.getLong("entry.id");
            String coreBillType = finArBill.getString("entry.e_corebilltype");
            String coreBillNo = finArBill.getString("entry.e_corebillno");
            int coreBillEntrySeq = finArBill.getInt("entry.e_corebillentryseq");
            if (!StringUtils.isEmpty((CharSequence)coreBillType) && !StringUtils.isEmpty((CharSequence)coreBillNo) && coreBillEntrySeq != 0) {
                coreNoSeqMapAndFinArEntryId.put(coreBillNo + coreBillEntrySeq, entryId);
                coreBillNos.add(coreBillNo);
                Set seqTemp2 = (Set)coreNoAndSeqs.get(coreBillNo);
                if (seqTemp2 == null) {
                    HashSet<Integer> seqList = new HashSet<Integer>(8);
                    seqList.add(coreBillEntrySeq);
                    coreNoAndSeqs.put(coreBillNo, seqList);
                } else {
                    seqTemp2.add(coreBillEntrySeq);
                }
            }
            String conBillType = finArBill.getString("entry.e_conbillentity.number");
            String conBillNo = finArBill.getString("entry.e_conbillnumber");
            String conBillEntrySeq = finArBill.getString("entry.e_conbillrownum");
            if (StringUtils.isEmpty((CharSequence)conBillType) || StringUtils.isEmpty((CharSequence)conBillNo) || StringUtils.isEmpty((CharSequence)conBillEntrySeq) || !conBillEntrySeq.matches("^[0-9]*$")) continue;
            conNoSeqMapAndFinArEntryId.put(conBillNo + conBillEntrySeq, entryId);
            conBillNos.add(conBillNo);
            Set seqTemp3 = (Set)conNoAndSeqs.get(conBillNo);
            if (seqTemp3 == null) {
                HashSet<String> seqList = new HashSet<String>(8);
                seqList.add(conBillEntrySeq);
                conNoAndSeqs.put(coreBillNo, seqList);
                continue;
            }
            seqTemp3.add(conBillEntrySeq);
        }
        HashMap<Long, Long[]> finArEntryIdAndCoreIdEntryId = new HashMap<Long, Long[]>(8);
        HashMap<Long, Long[]> finArEntryIdAndConIdEntryId = new HashMap<Long, Long[]>(8);
        if (coreBillNos.size() > 0) {
            DynamicObjectCollection salOrderBills = QueryServiceHelper.query((String)"sm_salorder", (String)"id,billno,billentry.id,billentry.seq", (QFilter[])new QFilter[]{new QFilter("billno", "in", coreBillNos)});
            for (DynamicObject salOrderBill : salOrderBills) {
                long salOrderId = salOrderBill.getLong("id");
                long salOrderEntryId = salOrderBill.getLong("billentry.id");
                int salOrderEntrySeq = salOrderBill.getInt("billentry.seq");
                String salOrderNo = salOrderBill.getString("billno");
                seqTemp = (Set)coreNoAndSeqs.get(salOrderNo);
                if (seqTemp == null || !seqTemp.contains(salOrderEntrySeq) || (finArEntryId = (Long)coreNoSeqMapAndFinArEntryId.get(salOrderNo + salOrderEntrySeq)) == null || finArEntryId == 0L || finArEntryIdAndCoreIdEntryId.get(finArEntryId) != null) continue;
                coreIdAndEntryId = new Long[]{salOrderId, salOrderEntryId};
                finArEntryIdAndCoreIdEntryId.put(finArEntryId, coreIdAndEntryId);
            }
        }
        if (conBillNos.size() > 0) {
            DynamicObjectCollection salContractBills = QueryServiceHelper.query((String)"conm_salcontract", (String)"id,billno,billentry.id,billentry.lineno", (QFilter[])new QFilter[]{new QFilter("billno", "in", conBillNos)});
            for (DynamicObject salContractBill : salContractBills) {
                long salConId = salContractBill.getLong("id");
                long salConEntryId = salContractBill.getLong("billentry.id");
                String salConEntrySeq = salContractBill.getString("billentry.lineno");
                String salConNo = salContractBill.getString("billno");
                seqTemp = (Set)conNoAndSeqs.get(salConNo);
                if (seqTemp == null || !seqTemp.contains(salConEntrySeq) || (finArEntryId = (Long)conNoSeqMapAndFinArEntryId.get(salConNo + salConEntrySeq)) == null || finArEntryId == 0L || finArEntryIdAndConIdEntryId.get(finArEntryId) != null) continue;
                coreIdAndEntryId = new Long[]{salConId, salConEntryId};
                finArEntryIdAndConIdEntryId.put(finArEntryId, coreIdAndEntryId);
            }
        }
        for (DynamicObject finArBill : finArBills) {
            Long billId = finArBill.getLong("id");
            String sourceBillType = finArBill.getString("sourcebilltype");
            Long entryId = finArBill.getLong("entry.id");
            Long settleOrgId = finArBill.getLong("org.id");
            Long asstactId = finArBill.getLong("asstact.id");
            int amtPrecision = finArBill.getInt("currency.amtprecision");
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            String coreBillType = finArBill.getString("entry.e_corebilltype");
            Long[] coreIdAndEntryId2 = (Long[])finArEntryIdAndCoreIdEntryId.get(entryId);
            if (coreIdAndEntryId2 == null) continue;
            Long coreBillId = coreIdAndEntryId2[0];
            Long coreBillEntryId = coreIdAndEntryId2[1];
            BigDecimal baseQty = (BigDecimal)entryIdQAndQty.get(entryId);
            BigDecimal amount = (BigDecimal)entryIdQAndAmt.get(entryId);
            Long[] conIdAndEntryId = (Long[])finArEntryIdAndConIdEntryId.get(entryId);
            Long conBillId = 0L;
            Long conBillEntryId = 0L;
            if (conIdAndEntryId != null) {
                conBillId = conIdAndEntryId[0];
                conBillEntryId = conIdAndEntryId[1];
            }
            String conbillentity = finArBill.getString("entry.e_conbillentity.number");
            if (coreBillId == 0L || coreBillEntryId == 0L || !"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType)) continue;
            String wbType = "sm_salorder".equals(coreBillType) ? "salorder" : "salcontract";
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("arinternalasst", isExistInternal);
            map.put("arasstactid", asstactId);
            map.put("arsettleorgid", settleOrgId);
            map.put("arMainBillEntity", coreBillType);
            map.put("soid", coreBillId);
            map.put("soentryid", coreBillEntryId);
            map.put("baseqty", baseQty);
            map.put("amount", amount.setScale(amtPrecision, RoundingMode.HALF_UP));
            map.put("conbillentity", conbillentity);
            map.put("conbillid", conBillId);
            map.put("conbillentryid", conBillEntryId);
            map.put("wbtype", wbType);
            map.put("ArApBillId", billId);
            if ("sm_salorder".equals(sourceBillType)) {
                map.put("sourcebilltype", "sm_salorder");
            }
            params.add(map);
        }
        return params;
    }

    private Map<Long, Boolean> isExistInternalBusinessUnit(List<DynamicObject> records) {
        Map<Long, Boolean> tempAssactMap;
        HashSet<Long> supplierIds = new HashSet<Long>(8);
        HashSet<Long> customerIds = new HashSet<Long>(8);
        for (DynamicObject adjust : records) {
            String asstactType = adjust.getString("asstacttype");
            if ("bd_supplier".equals(asstactType)) {
                supplierIds.add(adjust.getLong("asstact.id"));
            }
            if (!"bd_customer".equals(asstactType)) continue;
            customerIds.add(adjust.getLong("asstact.id"));
        }
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(records.size());
        if (!supplierIds.isEmpty() && (tempAssactMap = this.checkInternalBusinessUnit("bd_supplier", supplierIds)).isEmpty()) {
            result.putAll(tempAssactMap);
        }
        if (!customerIds.isEmpty() && (tempAssactMap = this.checkInternalBusinessUnit("bd_customer", customerIds)).isEmpty()) {
            result.putAll(tempAssactMap);
        }
        return result;
    }

    private Map<Long, Boolean> checkInternalBusinessUnit(String entityName, Set<Long> assIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(assIds.size());
        Map assactMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "in", assIds)});
        for (Map.Entry entrySet : assactMap.entrySet()) {
            DynamicObject asstact = (DynamicObject)entrySet.getValue();
            DynamicObject internalCompany = asstact.getDynamicObject("internal_company");
            if (internalCompany == null) {
                result.put(asstact.getLong("id"), Boolean.FALSE);
                continue;
            }
            if (internalCompany.getPkValue() != null && (Long)internalCompany.getPkValue() != 0L) {
                result.put(asstact.getLong("id"), Boolean.TRUE);
                continue;
            }
            result.put(asstact.getLong("id"), Boolean.FALSE);
        }
        return result;
    }

    private void disposeSalOrderService(List<Map<String, Object>> params) {
        long uniqueKey = DB.genGlobalLongId();
        for (Map<String, Object> dispose : params) {
            dispose.put("uniquekey", uniqueKey);
        }
        CommonParam param = new CommonParam();
        param.put((Object)"list", params);
        param.put((Object)"method", (Object)"wbSOAr");
        logger.info("FinArSaloutWfRecordWriteOffPlugin.disposeSalOrderService.params:" + params);
        List<String> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId").toString()).distinct().collect(Collectors.toList());
        logger.info("FinArSaloutWfRecordWriteOffPlugin.disposeSalOrderService.billid: " + arApBillIds);
        ECServiceHelper.execute("ar_salout_verify", "ar_salout_verify_wborder", "scmc", "sm", "fi", "SalWbService", arApBillIds, (Param)param, null, true);
    }

    private void disposeSalContractService(List<Map<String, Object>> params) {
        long uniqueKey = DB.genGlobalLongId();
        for (Map<String, Object> dispose : params) {
            dispose.put("uniquekey", uniqueKey);
        }
        CommonParam param = new CommonParam();
        param.put((Object)"list", params);
        param.put((Object)"method", (Object)"wbSalContAr");
        logger.info("FinArSaloutWfRecordWriteOffPlugin.disposeSalContractService.params:" + params);
        List<String> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId").toString()).distinct().collect(Collectors.toList());
        logger.info("FinArSaloutWfRecordWriteOffPlugin.disposeSalContractService.billid:" + arApBillIds);
        ECServiceHelper.execute("ar_salout_verify", "ar_salout_verify_wbcontract", "scmc", "conm", "fi", "SalConmService", arApBillIds, (Param)param, null, true);
    }

    private Object getConfirmSystemParam(Long orgId) {
        AppParam appParam = new AppParam(AR_APPID, orgId);
        appParam.setViewType("10");
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"ar_005");
    }

    private List<DifferentailVO> handleAssTailDifference(List<DynamicObject> records) {
        Long billEntryId;
        ArrayList<DifferentailVO> differentialList = new ArrayList<DifferentailVO>(8);
        HashMap<Long, BigDecimal> salEntryIdAndEntryRemainBaseQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> salEntryIdAndEntryRemainQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> salEntryIdAndEntryRemainAmt = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> salEntryIdAndEntryRemainAmtLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> salEntryIdAndEntryRemainPriceTotal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> salEntryIdAndEntryRemainPriceTotalLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> salEntryIdAndEntryRemainTax = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> salEntryIdAndEntryRemainTaxLocal = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> salIds = new HashSet<Long>(8);
        HashSet<Long> salEntryIds = new HashSet<Long>(8);
        HashSet<Long> recordIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            recordIds.add(record.getLong("id"));
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long billId = entry.getLong("assbillid");
                billEntryId = entry.getLong("assbillentryid");
                salIds.add(billId);
                salEntryIds.add(billEntryId);
                salEntryIdAndEntryRemainBaseQty.putIfAbsent(billEntryId, entry.getBigDecimal("assbillbaseqty"));
                salEntryIdAndEntryRemainQty.putIfAbsent(billEntryId, entry.getBigDecimal("assbillqty"));
                salEntryIdAndEntryRemainAmt.putIfAbsent(billEntryId, entry.getBigDecimal("assamount"));
                salEntryIdAndEntryRemainAmtLocal.putIfAbsent(billEntryId, entry.getBigDecimal("asslocamt"));
                salEntryIdAndEntryRemainPriceTotal.putIfAbsent(billEntryId, entry.getBigDecimal("asspricetaxtotal"));
                salEntryIdAndEntryRemainPriceTotalLocal.putIfAbsent(billEntryId, entry.getBigDecimal("asspricetaxtotalbase"));
                salEntryIdAndEntryRemainTax.putIfAbsent(billEntryId, entry.getBigDecimal("asstax"));
                salEntryIdAndEntryRemainTaxLocal.putIfAbsent(billEntryId, entry.getBigDecimal("assloctax"));
            }
        }
        logger.info("FinArSaloutWfRecordWriteOffPlugin.handleAssTailDiffrence.curRecord:" + recordIds);
        DynamicObjectCollection historyRecords = QueryServiceHelper.query((String)"ar_saloutwfrecord", (String)"id,entry.id,entry.assbillid,entry.assbillentryid,entry.assverifyqty,entry.assverifyamt,entry.assverifylocamt,entry.assverifypricetotal,entry.assverifylocpricetotal,entry.assverifytax,entry.assverifyloctax,entry.assverifybaseqty", (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", salIds), new QFilter("entry.assbillentryid", "in", salEntryIds), new QFilter("id", "not in", recordIds)});
        for (DynamicObject historyRecord : historyRecords) {
            Long billEntryId2 = historyRecord.getLong("entry.assbillentryid");
            BigDecimal historyVerifyBaseQty = historyRecord.getBigDecimal("entry.assverifybaseqty");
            BigDecimal historyVerifyQty = historyRecord.getBigDecimal("entry.assverifyqty");
            BigDecimal historyVerifyQAmt = historyRecord.getBigDecimal("entry.assverifyamt");
            BigDecimal historyVerifyQAmtLocal = historyRecord.getBigDecimal("entry.assverifylocamt");
            BigDecimal historyVerifyQPriceTotal = historyRecord.getBigDecimal("entry.assverifypricetotal");
            BigDecimal historyVerifyQPriceTotalLocal = historyRecord.getBigDecimal("entry.assverifylocpricetotal");
            BigDecimal historyVerifyQPriceTax = historyRecord.getBigDecimal("entry.assverifytax");
            BigDecimal historyVerifyQPriceTaxLocal = historyRecord.getBigDecimal("entry.assverifyloctax");
            salEntryIdAndEntryRemainBaseQty.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyBaseQty));
            salEntryIdAndEntryRemainQty.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQty));
            salEntryIdAndEntryRemainAmt.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQAmt));
            salEntryIdAndEntryRemainAmtLocal.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQAmtLocal));
            salEntryIdAndEntryRemainPriceTotal.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQPriceTotal));
            salEntryIdAndEntryRemainPriceTotalLocal.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQPriceTotalLocal));
            salEntryIdAndEntryRemainTax.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQPriceTax));
            salEntryIdAndEntryRemainTaxLocal.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQPriceTaxLocal));
        }
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                billEntryId = entry.getLong("assbillentryid");
                BigDecimal verifyBaseQty = entry.getBigDecimal("assverifybaseqty");
                BigDecimal billBaseQty = entry.getBigDecimal("assbillbaseqty");
                BigDecimal remainBaseQty = (BigDecimal)salEntryIdAndEntryRemainBaseQty.get(billEntryId);
                if (remainBaseQty == null || billBaseQty.compareTo(verifyBaseQty) == 0) continue;
                BigDecimal assVerifyQty = entry.getBigDecimal("assverifyqty");
                BigDecimal assVerifyAmt = entry.getBigDecimal("assverifyamt");
                BigDecimal assVerifyLocAmt = entry.getBigDecimal("assverifylocamt");
                BigDecimal assVerifyPricetotal = entry.getBigDecimal("assverifypricetotal");
                BigDecimal assVerifyLocPriceTotal = entry.getBigDecimal("assverifylocpricetotal");
                BigDecimal assVerifyTax = entry.getBigDecimal("assverifytax");
                BigDecimal assVerifyLocTax = entry.getBigDecimal("assverifyloctax");
                if (verifyBaseQty.compareTo(remainBaseQty) == 0) {
                    Map mainInfoMap;
                    Object backWriteDetailListTemp;
                    logger.info("FinArSaloutWfRecordWriteOffPlugin.handleAssTailDiffrence.entryId:" + entry.getLong("id"));
                    BigDecimal remainQty = (BigDecimal)salEntryIdAndEntryRemainQty.get(billEntryId);
                    BigDecimal remainAmt = (BigDecimal)salEntryIdAndEntryRemainAmt.get(billEntryId);
                    BigDecimal remainAmtLocal = (BigDecimal)salEntryIdAndEntryRemainAmtLocal.get(billEntryId);
                    BigDecimal remainPriceTotal = (BigDecimal)salEntryIdAndEntryRemainPriceTotal.get(billEntryId);
                    BigDecimal remainPriceTotalLocal = (BigDecimal)salEntryIdAndEntryRemainPriceTotalLocal.get(billEntryId);
                    BigDecimal remainTax = (BigDecimal)salEntryIdAndEntryRemainTax.get(billEntryId);
                    BigDecimal remainTaxLocal = (BigDecimal)salEntryIdAndEntryRemainTaxLocal.get(billEntryId);
                    entry.set("assverifyqty", (Object)remainQty);
                    entry.set("assverifyamt", (Object)remainAmt);
                    entry.set("assverifylocamt", (Object)remainAmtLocal);
                    entry.set("assverifypricetotal", (Object)remainPriceTotal);
                    entry.set("assverifylocpricetotal", (Object)remainPriceTotalLocal);
                    entry.set("assverifytax", (Object)remainTax);
                    entry.set("assverifyloctax", (Object)remainTaxLocal);
                    if (!HXLB_AR_SAL_CORE.equals(record.getLong("writeofftypeid.id"))) continue;
                    Long billId = entry.getLong("assbillid");
                    DifferentailVO vo = new DifferentailVO();
                    vo.setId(billId);
                    vo.setEntryId(billEntryId);
                    vo.setVerifyQtyDiff(remainQty.subtract(assVerifyQty));
                    differentialList.add(vo);
                    String assInfoStr = null;
                    String assWfInfo_tag = entry.getString("asswfinfo_tag");
                    if (!StringUtils.isNotEmpty((CharSequence)assWfInfo_tag) || (backWriteDetailListTemp = (mainInfoMap = (Map)SerializationUtils.fromJsonString((String)assWfInfo_tag, Map.class)).get("backWriteDetailList")) == null) continue;
                    List backWriteDetailList = (List)backWriteDetailListTemp;
                    for (Map infoMap : backWriteDetailList) {
                        Object value;
                        Object billField = infoMap.get("billField");
                        if (!"remainjoinpriceqty".equals(billField) && !"joinpriceqty".equals(billField) || (value = infoMap.get("value")) == null) continue;
                        infoMap.put("value", remainQty);
                    }
                    assInfoStr = SerializationUtils.toJsonString((Object)mainInfoMap);
                    if (!StringUtils.isNotEmpty((CharSequence)assInfoStr)) continue;
                    entry.set("asswfinfo_tag", (Object)assInfoStr);
                    continue;
                }
                salEntryIdAndEntryRemainBaseQty.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyBaseQty));
                salEntryIdAndEntryRemainQty.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyQty));
                salEntryIdAndEntryRemainAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyAmt));
                salEntryIdAndEntryRemainAmtLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyLocAmt));
                salEntryIdAndEntryRemainPriceTotal.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyPricetotal));
                salEntryIdAndEntryRemainPriceTotalLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyLocPriceTotal));
                salEntryIdAndEntryRemainTax.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyTax));
                salEntryIdAndEntryRemainTaxLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(assVerifyLocTax));
            }
        }
        return differentialList;
    }

    private List<DifferentailVO> handleMainTailDifference(List<DynamicObject> records) {
        Long billEntryId;
        ArrayList<DifferentailVO> differentialList = new ArrayList<DifferentailVO>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainBaseQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainAmt = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainAmtLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainPriceTotal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainPriceTotalLocal = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainTax = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> finEntryIdAndEntryRemainTaxLocal = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> finIds = new HashSet<Long>(8);
        HashSet<Long> finEntryIds = new HashSet<Long>(8);
        HashSet<Long> recordIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            recordIds.add(record.getLong("id"));
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long billId = entry.getLong("billid");
                billEntryId = entry.getLong("billentryid");
                finIds.add(billId);
                finEntryIds.add(billEntryId);
                finEntryIdAndEntryRemainBaseQty.putIfAbsent(billEntryId, entry.getBigDecimal("billbaseqty"));
                finEntryIdAndEntryRemainQty.putIfAbsent(billEntryId, entry.getBigDecimal("billqty"));
                finEntryIdAndEntryRemainAmt.putIfAbsent(billEntryId, entry.getBigDecimal("amount"));
                finEntryIdAndEntryRemainAmtLocal.putIfAbsent(billEntryId, entry.getBigDecimal("localamt"));
                finEntryIdAndEntryRemainPriceTotal.putIfAbsent(billEntryId, entry.getBigDecimal("pricetaxtotal"));
                finEntryIdAndEntryRemainPriceTotalLocal.putIfAbsent(billEntryId, entry.getBigDecimal("pricetaxtotalbase"));
                finEntryIdAndEntryRemainTax.putIfAbsent(billEntryId, entry.getBigDecimal("tax"));
                finEntryIdAndEntryRemainTaxLocal.putIfAbsent(billEntryId, entry.getBigDecimal("loctax"));
            }
        }
        logger.info("FinArSaloutWfRecordWriteOffPlugin.handleMainTailDiffrence.curRecord:" + recordIds);
        DynamicObjectCollection historyRecords = QueryServiceHelper.query((String)"ar_saloutwfrecord", (String)"id,entry.id,entry.billid,entry.billentryid,entry.verifyqty,entry.verifyamt,entry.verifylocamt,entry.verifypricetotal,entry.verifylocpricetotal,entry.verifytax,entry.verifyloctax,entry.verifybaseqty", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", finIds), new QFilter("entry.billentryid", "in", finEntryIds), new QFilter("id", "not in", recordIds)});
        for (DynamicObject historyRecord : historyRecords) {
            Long billEntryId2 = historyRecord.getLong("entry.billentryid");
            BigDecimal historyVerifyBaseQty = historyRecord.getBigDecimal("entry.verifybaseqty");
            BigDecimal historyVerifyQty = historyRecord.getBigDecimal("entry.verifyqty");
            BigDecimal historyVerifyQAmt = historyRecord.getBigDecimal("entry.verifyamt");
            BigDecimal historyVerifyQAmtLocal = historyRecord.getBigDecimal("entry.verifylocamt");
            BigDecimal historyVerifyQPriceTotal = historyRecord.getBigDecimal("entry.verifypricetotal");
            BigDecimal historyVerifyQPriceTotalLocal = historyRecord.getBigDecimal("entry.verifylocpricetotal");
            BigDecimal historyVerifyQPriceTax = historyRecord.getBigDecimal("entry.verifytax");
            BigDecimal historyVerifyQPriceTaxLocal = historyRecord.getBigDecimal("entry.verifyloctax");
            finEntryIdAndEntryRemainBaseQty.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyBaseQty));
            finEntryIdAndEntryRemainQty.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQty));
            finEntryIdAndEntryRemainAmt.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQAmt));
            finEntryIdAndEntryRemainAmtLocal.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQAmtLocal));
            finEntryIdAndEntryRemainPriceTotal.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQPriceTotal));
            finEntryIdAndEntryRemainPriceTotalLocal.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQPriceTotalLocal));
            finEntryIdAndEntryRemainTax.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQPriceTax));
            finEntryIdAndEntryRemainTaxLocal.computeIfPresent(billEntryId2, (k, v) -> v.subtract(historyVerifyQPriceTaxLocal));
        }
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                billEntryId = entry.getLong("billentryid");
                BigDecimal verifyBaseQty = entry.getBigDecimal("verifybaseqty");
                BigDecimal billBaseQty = entry.getBigDecimal("billbaseqty");
                BigDecimal remainBaseQty = (BigDecimal)finEntryIdAndEntryRemainBaseQty.get(billEntryId);
                if (remainBaseQty == null || billBaseQty.compareTo(verifyBaseQty) == 0) continue;
                BigDecimal verifyQty = entry.getBigDecimal("verifyqty");
                BigDecimal verifyAmt = entry.getBigDecimal("verifyamt");
                BigDecimal verifyLocAmt = entry.getBigDecimal("verifylocamt");
                BigDecimal verifyPricetotal = entry.getBigDecimal("verifypricetotal");
                BigDecimal verifyLocPriceTotal = entry.getBigDecimal("verifylocpricetotal");
                BigDecimal verifyTax = entry.getBigDecimal("verifytax");
                BigDecimal verifyLocTax = entry.getBigDecimal("verifyloctax");
                if (verifyBaseQty.compareTo(remainBaseQty) == 0) {
                    Map mainInfoMap;
                    Object backWriteDetailListTemp;
                    logger.info("FinArSaloutWfRecordWriteOffPlugin.handleMainTailDiffrence.entryId:" + entry.getLong("id"));
                    BigDecimal remainQty = (BigDecimal)finEntryIdAndEntryRemainQty.get(billEntryId);
                    BigDecimal remainAmt = (BigDecimal)finEntryIdAndEntryRemainAmt.get(billEntryId);
                    BigDecimal remainAmtLocal = (BigDecimal)finEntryIdAndEntryRemainAmtLocal.get(billEntryId);
                    BigDecimal remainPriceTotal = (BigDecimal)finEntryIdAndEntryRemainPriceTotal.get(billEntryId);
                    BigDecimal remainPriceTotalLocal = (BigDecimal)finEntryIdAndEntryRemainPriceTotalLocal.get(billEntryId);
                    BigDecimal remainTax = (BigDecimal)finEntryIdAndEntryRemainTax.get(billEntryId);
                    BigDecimal remainTaxLocal = (BigDecimal)finEntryIdAndEntryRemainTaxLocal.get(billEntryId);
                    entry.set("verifyqty", (Object)remainQty);
                    entry.set("verifyamt", (Object)remainAmt);
                    entry.set("verifylocamt", (Object)remainAmtLocal);
                    entry.set("verifypricetotal", (Object)remainPriceTotal);
                    entry.set("verifylocpricetotal", (Object)remainPriceTotalLocal);
                    entry.set("verifytax", (Object)remainTax);
                    entry.set("verifyloctax", (Object)remainTaxLocal);
                    Long billId = entry.getLong("billid");
                    DifferentailVO vo = new DifferentailVO();
                    vo.setId(billId);
                    vo.setEntryId(billEntryId);
                    vo.setVerifyQtyDiff(remainQty.subtract(verifyQty));
                    vo.setVerifyAmtDiff(remainAmt.subtract(verifyAmt));
                    differentialList.add(vo);
                    String mainInfoStr = null;
                    String mainWfInfo_tag = entry.getString("mainwfinfo_tag");
                    if (!StringUtils.isNotEmpty((CharSequence)mainWfInfo_tag) || (backWriteDetailListTemp = (mainInfoMap = (Map)SerializationUtils.fromJsonString((String)mainWfInfo_tag, Map.class)).get("backWriteDetailList")) == null) continue;
                    List backWriteDetailList = (List)backWriteDetailListTemp;
                    for (Map infoMap : backWriteDetailList) {
                        Object value;
                        Object billField = infoMap.get("billField");
                        if (("e_unverifyamt".equals(billField) || "e_verifiedamt".equals(billField) || "unverifyamount".equals(billField)) && (value = infoMap.get("value")) != null) {
                            infoMap.put("value", remainAmt);
                        }
                        if (!"e_unverifyqty".equals(billField) && !"e_verifiedqty".equals(billField) || (value = infoMap.get("value")) == null) continue;
                        infoMap.put("value", remainQty);
                    }
                    mainInfoStr = SerializationUtils.toJsonString((Object)mainInfoMap);
                    if (!StringUtils.isNotEmpty((CharSequence)mainInfoStr)) continue;
                    entry.set("mainwfinfo_tag", (Object)mainInfoStr);
                    continue;
                }
                finEntryIdAndEntryRemainBaseQty.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyBaseQty));
                finEntryIdAndEntryRemainQty.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyQty));
                finEntryIdAndEntryRemainAmt.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyAmt));
                finEntryIdAndEntryRemainAmtLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocAmt));
                finEntryIdAndEntryRemainPriceTotal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyPricetotal));
                finEntryIdAndEntryRemainPriceTotalLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocPriceTotal));
                finEntryIdAndEntryRemainTax.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyTax));
                finEntryIdAndEntryRemainTaxLocal.computeIfPresent(billEntryId, (k, v) -> v.subtract(verifyLocTax));
            }
        }
        return differentialList;
    }

    private Map<String, List<Long>> handelFinArBillVerifyStatus(List<DynamicObject> records) {
        BigDecimal unVerifyBaseQty;
        HashMap<String, List<Long>> statusAndIdMap = new HashMap<String, List<Long>>(8);
        if (records == null || records.size() < 1) {
            return statusAndIdMap;
        }
        HashMap<Long, BigDecimal> finArIdAndVerifyBaseQty = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> finArBillIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long billId = entry.getLong("billid");
                finArBillIds.add(billId);
                BigDecimal verifyBaseQty = entry.getBigDecimal("verifybaseqty");
                finArIdAndVerifyBaseQty.merge(billId, verifyBaseQty, BigDecimal::add);
            }
        }
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,entry.e_unverifybaseqty", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)});
        HashMap<Long, BigDecimal> finArIdAndUnVerifyBaseQty = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject bill : finArBills) {
            Long id = bill.getLong("id");
            unVerifyBaseQty = bill.getBigDecimal("entry.e_unverifybaseqty");
            finArIdAndUnVerifyBaseQty.merge(id, unVerifyBaseQty, BigDecimal::add);
        }
        for (Long id : finArBillIds) {
            BigDecimal verifyBaseQty = (BigDecimal)finArIdAndVerifyBaseQty.get(id);
            unVerifyBaseQty = (BigDecimal)finArIdAndUnVerifyBaseQty.get(id);
            if (verifyBaseQty == null || BigDecimal.ZERO.compareTo(verifyBaseQty) == 0) continue;
            if (unVerifyBaseQty == null) {
                unVerifyBaseQty = BigDecimal.ZERO;
            }
            if (unVerifyBaseQty.abs().compareTo(verifyBaseQty.abs()) <= 0) {
                List verified = (List)statusAndIdMap.get("verified");
                if (verified != null) {
                    verified.add(id);
                    continue;
                }
                ArrayList<Long> verifiedTemp = new ArrayList<Long>(8);
                verifiedTemp.add(id);
                statusAndIdMap.put("verified", verifiedTemp);
                continue;
            }
            List partVerify = (List)statusAndIdMap.get("partverify");
            if (partVerify != null) {
                partVerify.add(id);
                continue;
            }
            ArrayList<Long> partVerifyTemp = new ArrayList<Long>(8);
            partVerifyTemp.add(id);
            statusAndIdMap.put("partverify", partVerifyTemp);
        }
        return statusAndIdMap;
    }

    private static class DifferentailVO {
        Long id;
        Long entryId;
        BigDecimal verifyQtyDiff;
        BigDecimal verifyAmtDiff;

        private DifferentailVO() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public void setEntryId(Long entryId) {
            this.entryId = entryId;
        }

        public BigDecimal getVerifyQtyDiff() {
            return this.verifyQtyDiff;
        }

        public void setVerifyQtyDiff(BigDecimal verifyQtyDiff) {
            this.verifyQtyDiff = verifyQtyDiff;
        }

        public BigDecimal getVerifyAmtDiff() {
            return this.verifyAmtDiff;
        }

        public void setVerifyAmtDiff(BigDecimal verifyAmtDiff) {
            this.verifyAmtDiff = verifyAmtDiff;
        }
    }
}

