/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.enums.PrecisionAccountEnum;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class MateralWriteOffStrategy
extends AbstractWriteOffStrategy {
    private static final Log logger = LogFactory.getLog(MateralWriteOffStrategy.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_OM_OUT);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        HashSet<String> omproorderFileds = new HashSet<String>(16);
        omproorderFileds.add("billentry.material.masterid");
        omproorderFileds.add("billentry.configuredcode");
        omproorderFileds.add("billentry.auxpty");
        omproorderFileds.add("billentry.mversion");
        omproorderFileds.add("billentry.baseunit.precision");
        omproorderFileds.add("billentry.baseunit.precisionaccount");
        omproorderFileds.add("billentry.mainbillentryid");
        map.put("im_mdc_omproorder", omproorderFileds);
        HashSet<String> omfeedorderFileds = new HashSet<String>(16);
        omfeedorderFileds.add("billentry.material.masterid");
        omfeedorderFileds.add("billentry.configuredcode");
        omfeedorderFileds.add("billentry.auxpty");
        omfeedorderFileds.add("billentry.mversion");
        omfeedorderFileds.add("billentry.baseunit.precision");
        omfeedorderFileds.add("billentry.baseunit.precisionaccount");
        map.put("im_mdc_omfeedorder", omfeedorderFileds);
        HashSet<String> ominbillFileds = new HashSet<String>(16);
        ominbillFileds.add("billentry.completewriteoff");
        ominbillFileds.add("billentry.material.masterid");
        ominbillFileds.add("billentry.configuredcode");
        ominbillFileds.add("billentry.auxpty");
        ominbillFileds.add("billentry.mversion");
        ominbillFileds.add("billentry.baseunit.precision");
        ominbillFileds.add("billentry.baseunit.precisionaccount");
        ominbillFileds.add("billentry.mainbillentryid");
        ominbillFileds.add("billentry.outunverifybaseqty");
        map.put("im_mdc_ominbill", ominbillFileds);
        return map;
    }

    @Override
    public boolean isCompleted(List<IWriteOffQueue> candidateQueues) {
        if (candidateQueues.get(0).isEmpty() || candidateQueues.get(1).isEmpty() && candidateQueues.get(2).isEmpty()) {
            logger.info("\u5b58\u5728\u53ef\u914d\u5bf9\u7684\u6838\u9500\u5bf9\u8c61");
            return true;
        }
        logger.info("\u4e0d\u5b58\u5728\u53ef\u914d\u5bf9\u7684\u6838\u9500\u5bf9\u8c61");
        return false;
    }

    @Override
    public List<IWriteOffQueue> pickWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        logger.info("\u6311\u51fa\u6838\u9500\u5bf9\u8c61");
        HashMap<String, BigDecimal[]> materialPropor = new HashMap<String, BigDecimal[]>();
        boolean isWhole = this.isWholedWriteOff(candidateQueues);
        logger.info("\u5b8c\u5168\u6838\u9500:" + isWhole);
        BigDecimal needWriteOffNumber = this.countWriteOffNumber(candidateQueues, materialPropor);
        logger.info("\u6838\u9500\u7269\u6599\u6bd4\u4f8b\uff1a" + JSONObject.toJSONString(materialPropor));
        if (MapUtils.isEmpty(materialPropor) && !isWhole) {
            return null;
        }
        logger.info(String.format("\u672c\u6b21\u6838\u9500\u6570\u91cf\u4e3a:%s", needWriteOffNumber));
        if (!(null != needWriteOffNumber && BigDecimal.ZERO.compareTo(needWriteOffNumber) != 0 || isWhole)) {
            return null;
        }
        ArrayList<IWriteOffQueue> selectedQueues = new ArrayList<IWriteOffQueue>(10);
        HashMap<String, BigDecimal> materialQty = new HashMap<String, BigDecimal>();
        int precision = 2;
        int precisionaccount = 2;
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            if (isWhole) {
                IWriteOffQueue writeOffQueue = candidateQueue.pollQueue(isWhole, needWriteOffNumber);
                selectedQueues.add(writeOffQueue);
                continue;
            }
            BigDecimal sumPolledNumber = BigDecimal.ZERO;
            WriteOffObjectQueue writeOffQueue = new WriteOffObjectQueue();
            while (candidateQueue.size() > 0) {
                WriteOffObjectBase writeOffObject = candidateQueue.peek();
                WriteOffBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
                String billType = writeOffBillConfig.getBillType();
                if (StringUtils.isNotEmpty((String)billType) && ("im_mdc_omproorder".equals(billType) || "im_mdc_omfeedorder".equals(billType))) {
                    StringBuilder keyStrBuilder = new StringBuilder();
                    Object material = writeOffObject.getValue("material.masterid");
                    keyStrBuilder.append(material);
                    MateralWriteOffStrategy.appendKey(keyStrBuilder, writeOffObject, "configuredcode");
                    MateralWriteOffStrategy.appendKey(keyStrBuilder, writeOffObject, "auxpty");
                    MateralWriteOffStrategy.appendKey(keyStrBuilder, writeOffObject, "mversion");
                    String keyStr = keyStrBuilder.toString();
                    BigDecimal materNum = (BigDecimal)materialQty.get(keyStr);
                    sumPolledNumber = materNum != null ? materNum : BigDecimal.ZERO;
                    BigDecimal[] proportion = new BigDecimal[2];
                    BigDecimal materialNeedWrfNum = BigDecimal.ZERO;
                    BigDecimal allowWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObject);
                    BigDecimal[] materialPr = (BigDecimal[])materialPropor.get(keyStr);
                    if (materialPr != null) {
                        proportion = materialPr;
                        if (writeOffObject.getValue("baseunit.precision") != null) {
                            precision = (Integer)writeOffObject.getValue("baseunit.precision");
                        }
                        if (writeOffObject.getValue("baseunit.precisionaccount") != null) {
                            precisionaccount = Integer.parseInt(writeOffObject.getValue("baseunit.precisionaccount") + "");
                        }
                        materialNeedWrfNum = this.getPrecisionPropNumByMult(needWriteOffNumber, proportion, precision, precisionaccount);
                    } else {
                        sumPolledNumber = BigDecimal.ZERO;
                        materialNeedWrfNum = allowWriteOffNumber;
                    }
                    if (sumPolledNumber.compareTo(materialNeedWrfNum) == 0) {
                        candidateQueue.poll();
                        continue;
                    }
                    if (sumPolledNumber.add(allowWriteOffNumber).abs().compareTo(materialNeedWrfNum.abs()) <= 0) {
                        WriteOffObjectBase planWriteOffObject = candidateQueue.poll();
                        writeOffQueue.add(planWriteOffObject);
                        sumPolledNumber = sumPolledNumber.add(allowWriteOffNumber);
                        logger.info(String.format("\u6574\u4f53\u6838\u9500\u51fa\u5217\u6570\u91cf\u4e3a:%s", allowWriteOffNumber));
                    } else {
                        BigDecimal planWriteOffNumber = materialNeedWrfNum.subtract(sumPolledNumber);
                        BigDecimal returnWriteOffNumber = allowWriteOffNumber.subtract(planWriteOffNumber);
                        WriteOffObjectBase planWriteOffObject = writeOffObject.clone();
                        WriteOffObjectManager.setLogicWriteOffNumber(planWriteOffObject, planWriteOffNumber);
                        writeOffQueue.add(planWriteOffObject);
                        WriteOffObjectManager.setLogicWriteOffNumber(writeOffObject, returnWriteOffNumber);
                        logger.info(String.format("\u90e8\u5206\u6838\u9500\u51fa\u5217\u6570\u91cf\u4e3a:%s", planWriteOffNumber));
                        candidateQueue.update(writeOffObject);
                        sumPolledNumber = sumPolledNumber.add(planWriteOffNumber);
                        candidateQueue.poll();
                    }
                    materialQty.put(keyStr, sumPolledNumber);
                    continue;
                }
                BigDecimal allowWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObject);
                if (sumPolledNumber.add(allowWriteOffNumber).abs().compareTo(needWriteOffNumber.abs()) <= 0) {
                    WriteOffObjectBase planWriteOffObject = candidateQueue.poll();
                    writeOffQueue.add(planWriteOffObject);
                    sumPolledNumber = sumPolledNumber.add(allowWriteOffNumber);
                    logger.info(String.format("\u6574\u4f53\u6838\u9500\u51fa\u5217\u6570\u91cf\u4e3a:%s", allowWriteOffNumber));
                    continue;
                }
                BigDecimal planWriteOffNumber = needWriteOffNumber.subtract(sumPolledNumber);
                BigDecimal returnWriteOffNumber = allowWriteOffNumber.subtract(planWriteOffNumber);
                WriteOffObjectBase planWriteOffObject = writeOffObject.clone();
                WriteOffObjectManager.setLogicWriteOffNumber(planWriteOffObject, planWriteOffNumber);
                writeOffQueue.add(planWriteOffObject);
                WriteOffObjectManager.setLogicWriteOffNumber(writeOffObject, returnWriteOffNumber);
                logger.info(String.format("\u90e8\u5206\u6838\u9500\u51fa\u5217\u6570\u91cf\u4e3a:%s", planWriteOffNumber));
                candidateQueue.update(writeOffObject);
                break;
            }
            selectedQueues.add(writeOffQueue);
        }
        return selectedQueues;
    }

    private WriteOffBillConfig getBillConfig(WriteOffObjectBase writeOffObject) {
        return this.getTypeConfig().getBillConfigsById((Long)writeOffObject.getWfBillEntity().getPkValue());
    }

    private boolean isWholedWriteOff(List<IWriteOffQueue> candidateQueues) {
        boolean isWhole = false;
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            WriteOffObjectBase writeOffObject = writeOffQueue.peek();
            if (null == writeOffObject) {
                writeOffQueue.poll();
                continue;
            }
            WriteOffBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
            String billType = writeOffBillConfig.getBillType();
            if (!"im_mdc_ominbill".equals(billType) || !(isWhole = ((Boolean)writeOffObject.getValue("completewriteoff")).booleanValue())) continue;
            logger.info("\u59d4\u5916\u5165\u5e93\u5355:", (Object)(writeOffObject.getPkValue() + "\uff0c\u4e3a\u5b8c\u5168\u6838\u9500"));
        }
        return isWhole;
    }

    private BigDecimal countWriteOffNumber(List<IWriteOffQueue> candidateQueues, Map<String, BigDecimal[]> materialPropor) {
        BigDecimal thisSumWriteOffNumber;
        BigDecimal sumWriteOffNumber = BigDecimal.valueOf(Integer.MAX_VALUE);
        logger.info("materialPropor:" + materialPropor);
        logger.info("candidateQueues.size:" + candidateQueues.size());
        logger.info("candidateQueues:" + candidateQueues);
        HashMap<String, BigDecimal> materialQty = new HashMap<String, BigDecimal>();
        int precision = 2;
        int precisionaccount = 2;
        for (IWriteOffQueue iWriteOffQueue : candidateQueues) {
            WriteOffObjectBase writeOffObject = iWriteOffQueue.peek();
            if (null == writeOffObject) {
                iWriteOffQueue.poll();
                continue;
            }
            String billType = this.getBillConfig(writeOffObject).getBillType();
            logger.info("billType:" + billType);
            if ("im_mdc_ominbill".equals(billType)) {
                if (writeOffObject.getValue("baseunit.precision") != null) {
                    precision = (Integer)writeOffObject.getValue("baseunit.precision");
                    logger.info("precision:" + precision);
                }
                if (writeOffObject.getValue("baseunit.precisionaccount") != null) {
                    logger.info("writeOffObject.baseunit.precisionaccounts\u662f:" + writeOffObject.getValue("baseunit.precisionaccount"));
                    precisionaccount = Integer.parseInt(writeOffObject.getValue("baseunit.precisionaccount") + "");
                    logger.info("precisionaccount:" + precisionaccount);
                }
                logger.info("\u5f00\u59cb\u8c03\u7528scmc\u6839\u636e\u7ec4\u4ef6\u6e05\u5355\uff0c\u8ba1\u7b97\u7269\u6599\u5bf9\u5e94\u6bd4\u4f8b\u5fae\u670d\u52a1  ");
                logger.info("mainbillentryid:" + writeOffObject.getValue("mainbillentryid"));
                Map<String, BigDecimal[]> materialPro = this.calMaterialProportion(writeOffObject.getValue("mainbillentryid"));
                if (MapUtils.isEmpty(materialPro)) {
                    logger.info("\u7269\u6599\u5bf9\u5e94\u7684\u6bd4\u4f8b\u4e3a\u7a7a");
                    return BigDecimal.ZERO;
                }
                logger.info("\u7269\u6599\u5bf9\u5e94\u7684\u6bd4\u4f8b\u4e3a\uff1a" + JSONObject.toJSONString(materialPro));
                materialPropor.putAll(materialPro);
                JSONObject.toJSONString(materialPropor);
            }
            thisSumWriteOffNumber = iWriteOffQueue.getSumWriteOffNumber();
            logger.info("thisSumWriteOffNumber:" + thisSumWriteOffNumber);
            if (!"im_mdc_ominbill".equals(billType)) {
                List<WriteOffObjectBase> writeOffObjList = iWriteOffQueue.peekAll();
                for (WriteOffObjectBase writeOffObj : writeOffObjList) {
                    StringBuilder keyStr = new StringBuilder();
                    Object materialPk = writeOffObj.getValue("material.masterid");
                    logger.info("materialPk:" + materialPk);
                    keyStr.append(materialPk);
                    MateralWriteOffStrategy.appendKey(keyStr, writeOffObj, "configuredcode");
                    MateralWriteOffStrategy.appendKey(keyStr, writeOffObj, "auxpty");
                    MateralWriteOffStrategy.appendKey(keyStr, writeOffObj, "mversion");
                    BigDecimal materialWriteOffNumber = writeOffObj.getWriteOffNumber();
                    logger.info("materialWriteOffNumber:" + materialWriteOffNumber);
                    String key = keyStr.toString();
                    logger.info("key:" + key);
                    BigDecimal materiaNum = (BigDecimal)materialQty.get(key);
                    logger.info("materiaNum:" + materiaNum);
                    if (materiaNum != null) {
                        materialQty.put(key, materialWriteOffNumber.add(materiaNum));
                        continue;
                    }
                    materialQty.put(key, materialWriteOffNumber);
                }
                continue;
            }
            sumWriteOffNumber = thisSumWriteOffNumber;
        }
        if (MapUtils.isEmpty(materialPropor)) {
            return BigDecimal.ZERO;
        }
        for (Map.Entry entry : materialPropor.entrySet()) {
            String mapKey = String.valueOf(entry.getKey());
            logger.info("mapKey:" + mapKey);
            BigDecimal[] numProp = (BigDecimal[])entry.getValue();
            logger.info("materialQty:" + materialQty);
            if (!materialQty.containsKey(mapKey)) {
                return BigDecimal.ZERO;
            }
            thisSumWriteOffNumber = this.getPrecisionPropNum((BigDecimal)materialQty.get(mapKey), numProp, precision, precisionaccount);
            logger.info("thisSumWriteOffNumber:" + thisSumWriteOffNumber);
            if (thisSumWriteOffNumber.abs().compareTo(sumWriteOffNumber.abs()) >= 0) continue;
            sumWriteOffNumber = thisSumWriteOffNumber;
            logger.info("sumWriteOffNumber:" + sumWriteOffNumber);
        }
        logger.info("\u672c\u6b21\u6838\u9500\u6570\u91cf\uff1a" + sumWriteOffNumber);
        return sumWriteOffNumber;
    }

    private Map<String, BigDecimal[]> calMaterialProportion(Object mainId) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"MdcCalMaterialQtyService", (String)"claMaterialforpurOrder", (Object[])new Object[]{mainId});
    }

    private BigDecimal getPrecisionPropNum(BigDecimal mum, BigDecimal[] numProp, int precision, int precisionaccount) {
        BigDecimal result = mum.multiply(numProp[1]).divide(numProp[0], precision, PrecisionAccountEnum.getEnumByVal(precisionaccount));
        return result.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : result;
    }

    private BigDecimal getPrecisionPropNumByMult(BigDecimal mum, BigDecimal[] numProp, int precision, int precisionaccount) {
        BigDecimal result = mum.multiply(numProp[0]).divide(numProp[1], precision, PrecisionAccountEnum.getEnumByVal(precisionaccount));
        return result.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : result;
    }

    private static void appendKey(StringBuilder keyStr, WriteOffObjectBase writeOffObject, String field) {
        Object dymObj = writeOffObject.getValue(field);
        logger.info("dymObj:" + dymObj);
        if (ObjectUtils.isNotEmpty((Object)dymObj) && !"0".equals(dymObj.toString()) && !"0L".equals(dymObj.toString())) {
            logger.info("dymObj:" + dymObj);
            keyStr.append(",").append(dymObj);
            logger.info("AAkeyStr:" + keyStr);
        }
    }
}

