/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.BotpLinkHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class PurOmReturnWriteOffStrategy
extends AbstractWriteOffStrategy {
    private static final Log logger = LogFactory.getLog(PurOmReturnWriteOffStrategy.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_PUR_OMRETURN);
    }

    @Override
    public boolean isCompleted(List<IWriteOffQueue> candidateQueues) {
        if (candidateQueues.size() == 1) {
            return candidateQueues.get(0).isEmpty();
        }
        return candidateQueues.get(0).isEmpty() || candidateQueues.get(1).isEmpty();
    }

    @Override
    public List<IWriteOffQueue> pickWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        logger.info("PurOmReturnWriteOffStrategy:\u8fdb\u5165\u59d4\u5916\u91c7\u8d2d\u6838\u9500\uff08\u9000\uff09\u6838\u9500\u7b56\u7565\u63d2\u4ef6");
        if (candidateQueues.size() == 1) {
            return candidateQueues;
        }
        HashSet<Long> purOmInBillIds = new HashSet<Long>(16);
        HashSet<Long> purOmInBillEntryIds = new HashSet<Long>(16);
        HashMap<Object, BigDecimal> redBillSumWFQtyMap = new HashMap<Object, BigDecimal>(16);
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            Object writeOffObjBase;
            String string;
            Iterator<WriteOffObjectBase> iterator = writeOffQueue.peekAll().iterator();
            while (iterator.hasNext() && "im_ospurinbill".equals(string = ((WriteOffObjectBase)(writeOffObjBase = iterator.next())).getWFBillEntityName())) {
                purOmInBillIds.add((Long)((WriteOffObjectBase)writeOffObjBase).getWfBillPk());
                purOmInBillEntryIds.add((Long)((WriteOffObjectBase)writeOffObjBase).getPkValue());
                DynamicObject writeOffObj = ((WriteOffObjectBase)writeOffObjBase).getWriteOffObject();
                String key = writeOffObj.getString("mainbillnumber") + "#" + writeOffObj.getString("mainbillentryseq");
                BigDecimal sumWfQty = (BigDecimal)redBillSumWFQtyMap.get(key);
                BigDecimal wfNum = ((WriteOffObjectBase)writeOffObjBase).getWriteOffNumber();
                sumWfQty = sumWfQty == null ? wfNum : sumWfQty.add(wfNum);
                redBillSumWFQtyMap.put(key, sumWfQty);
            }
        }
        Map<Long, Set<String>> srcTargetIdMap = BotpLinkHelper.findSrcBillid2TargetBillAndEntryIdSet(purOmInBillIds.toArray(new Long[0]), purOmInBillEntryIds.toArray(new Long[0]), "im_ospurinbill", "im_ospurinbill");
        HashSet<Long> srcIds = new HashSet<Long>(16);
        HashSet<Long> srcEntryIds = new HashSet<Long>(16);
        for (Map.Entry entry : srcTargetIdMap.entrySet()) {
            Set srcIdKeys = (Set)entry.getValue();
            for (DynamicObject[] srcIdKey : srcIdKeys) {
                String[] srcIdArr = srcIdKey.split("#");
                srcIds.add(Long.parseLong(srcIdArr[0]));
                srcEntryIds.add(Long.parseLong(srcIdArr[1]));
            }
        }
        QFilter recordQ = new QFilter("entry.billid", "in", srcIds);
        recordQ.and("entry.billentryid", "in", srcEntryIds);
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"im_oswfrecord", (String)"entry.billid,entry.billentryid,entry.billtype,entry.qty,entry.srcbillno,entry.srcentryseq", (QFilter[])recordQ.toArray());
        if (dynamicObjectArray == null || dynamicObjectArray.length == 0) {
            logger.info("PurOmReturnWriteOffStrategy:\u672a\u627e\u5230\u6750\u6599\u6838\u9500\u8bb0\u5f55\uff1b\u84dd\u5355id " + srcIds);
            return null;
        }
        HashMap<String, BigDecimal> blueBillSumWFQtyMap = new HashMap<String, BigDecimal>(16);
        HashMap reqBillsSumWFQtyMap = new HashMap(16);
        for (DynamicObject record : dynamicObjectArray) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            String key = null;
            for (DynamicObject entry : entrys) {
                String billType = entry.getDynamicObject("billtype").getString("number");
                if (!"im_ospurinbill".equals(billType)) continue;
                key = entry.getString("srcbillno") + "#" + entry.getString("srcentryseq");
            }
            if (key == null) continue;
            for (DynamicObject entry : entrys) {
                BigDecimal reqBillEntryQty;
                Long billEntryId = entry.getLong("billentryid");
                BigDecimal wfQty = entry.getBigDecimal("qty");
                String billType = entry.getDynamicObject("billtype").getString("number");
                if ("im_ospurinbill".equals(billType)) {
                    BigDecimal blueBillWfQty = (BigDecimal)blueBillSumWFQtyMap.get(key);
                    blueBillWfQty = blueBillWfQty != null ? blueBillWfQty.add(wfQty) : wfQty;
                    blueBillSumWFQtyMap.put(key, blueBillWfQty);
                    continue;
                }
                HashMap<Long, BigDecimal> reqBillSumWFQtyMap = (HashMap<Long, BigDecimal>)reqBillsSumWFQtyMap.get(key);
                if (reqBillSumWFQtyMap == null) {
                    reqBillSumWFQtyMap = new HashMap<Long, BigDecimal>(16);
                }
                reqBillEntryQty = (reqBillEntryQty = (BigDecimal)reqBillSumWFQtyMap.get(billEntryId)) == null ? wfQty : reqBillEntryQty.add(wfQty);
                reqBillSumWFQtyMap.put(billEntryId, reqBillEntryQty);
                reqBillsSumWFQtyMap.put(key, reqBillSumWFQtyMap);
            }
        }
        ArrayList<IWriteOffQueue> removeQues = new ArrayList<IWriteOffQueue>(16);
        String key = null;
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            WriteOffObjectBase writeOffObjBase = writeOffQueue.peek();
            String entityKey = writeOffObjBase.getWFBillEntityName();
            if (!"im_ospurinbill".equals(entityKey)) continue;
            DynamicObject writeOffObj = writeOffObjBase.getWriteOffObject();
            key = writeOffObj.getString("mainbillnumber") + "#" + writeOffObj.getString("mainbillentryseq");
        }
        if (key == null) {
            removeQues.addAll(candidateQueues);
        }
        block8: for (IWriteOffQueue writeOffQueue : candidateQueues) {
            WriteOffObjectBase writeOffObjBase;
            String entityKey;
            Iterator<WriteOffObjectBase> iterator = writeOffQueue.peekAll().iterator();
            while (iterator.hasNext() && !"im_ospurinbill".equals(entityKey = (writeOffObjBase = iterator.next()).getWFBillEntityName())) {
                BigDecimal reqBillSumWFQty;
                Long reqOutBillEntryId = (Long)writeOffObjBase.getPkValue();
                BigDecimal redBillSumWFQty = (BigDecimal)redBillSumWFQtyMap.get(key);
                BigDecimal blueBillSumWFQty = (BigDecimal)blueBillSumWFQtyMap.get(key);
                BigDecimal bigDecimal = reqBillSumWFQty = reqBillsSumWFQtyMap.get(key) == null ? null : (BigDecimal)((Map)reqBillsSumWFQtyMap.get(key)).get(reqOutBillEntryId);
                if (blueBillSumWFQty == null || reqBillSumWFQty == null) {
                    removeQues.add(writeOffQueue);
                    continue block8;
                }
                int unitPrecision = 10;
                Object precisionObj = writeOffObjBase.getWriteOffObject().get("baseunit.precision");
                if (precisionObj != null) {
                    unitPrecision = (Integer)precisionObj;
                }
                WriteOffObjectManager.setLogicWriteOffNumber(writeOffObjBase, redBillSumWFQty.multiply(reqBillSumWFQty.divide(blueBillSumWFQty, 20, 4)).setScale(unitPrecision, 4));
            }
        }
        if (!removeQues.isEmpty()) {
            candidateQueues.removeAll(removeQues);
        }
        return candidateQueues;
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        HashSet<String> osReqoutBillFields = new HashSet<String>(16);
        osReqoutBillFields.add("billentry.srcbillentryseq");
        osReqoutBillFields.add("billentry.baseunit");
        osReqoutBillFields.add("billentry.baseunit.precision");
        map.put("im_osmaterialreqoutbill", osReqoutBillFields);
        return map;
    }
}

