/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.model.PurOmOrderSubListInfo;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class PurOmWriteOffStrategy
extends AbstractWriteOffStrategy {
    private static final Log logger = LogFactory.getLog(PurOmWriteOffStrategy.class);
    private Map<Long, PurOmOrderSubListInfo> subListInfoMap = new HashMap<Long, PurOmOrderSubListInfo>(16);
    private Map<Long, Map<Long, PurOmOrderSubListInfo>> supplierListInfoMap = new HashMap<Long, Map<Long, PurOmOrderSubListInfo>>(16);
    private List<IWriteOffQueue> selectQues = new ArrayList<IWriteOffQueue>(16);
    IWriteOffQueue purInQueue = null;
    IWriteOffQueue reqOutQueue = null;
    private IWriteOffQueue crtSelectPurInQue = null;
    private IWriteOffQueue crtSelectReqOutQue = null;
    private boolean isSupplierWF = false;
    private boolean isMulUnWfQueue = false;

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        HashSet<String> osPurinBillFields = new HashSet<String>(16);
        osPurinBillFields.add("billentry.isoverreceive");
        osPurinBillFields.add("billentry.mainbillid");
        osPurinBillFields.add("billentry.mainbillentryid");
        osPurinBillFields.add("billentry.srcbillentryseq");
        map.put("im_ospurinbill", osPurinBillFields);
        HashSet<String> osReqoutBillFields = new HashSet<String>(16);
        osReqoutBillFields.add("billentry.srcbillentryseq");
        map.put("im_osmaterialreqoutbill", osReqoutBillFields);
        return map;
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_OS_PURIN);
    }

    @Override
    public boolean isCompleted(List<IWriteOffQueue> candidateQueues) {
        if (candidateQueues.size() == 1) {
            return candidateQueues.get(0).isEmpty();
        }
        return candidateQueues.get(0).isEmpty() || candidateQueues.get(1).isEmpty();
    }

    @Override
    public List<IWriteOffQueue> pickWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        logger.info("PurOmWriteOffStrategy-\u8fdb\u5165\u59d4\u5916\u91c7\u8d2d\u6838\u9500\u7b56\u7565");
        if (candidateQueues.size() == 1) {
            return candidateQueues;
        }
        boolean bl = this.isSupplierWF = WriteOffTypeIdConst.HXFA_PUR_OMSUPPLILER.compareTo(schemeContextConfig.getSchemeId()) == 0;
        if (this.isSupplierWF) {
            return this.doSupplierWf(candidateQueues);
        }
        return this.doMainBillWf(candidateQueues);
    }

    private void initCrtSelectQueue(List<IWriteOffQueue> candidateQueues) {
        this.crtSelectPurInQue = null;
        this.crtSelectReqOutQue = null;
        this.purInQueue = null;
        this.reqOutQueue = null;
        this.selectQues.clear();
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            String entityKey = candidateQueue.peek().getWFBillEntityName();
            if ("im_ospurinbill".equals(entityKey)) {
                this.purInQueue = candidateQueue;
                continue;
            }
            this.reqOutQueue = candidateQueue;
        }
        if (this.purInQueue == null || this.reqOutQueue == null) {
            return;
        }
        this.isMulUnWfQueue = this.purInQueue.size() > 1;
        this.crtSelectPurInQue = this.purInQueue.simpleClone();
        this.crtSelectReqOutQue = this.reqOutQueue.simpleClone();
        this.selectQues.add(this.crtSelectPurInQue);
        this.selectQues.add(this.crtSelectReqOutQue);
    }

    private List<IWriteOffQueue> doMainBillWf(List<IWriteOffQueue> candidateQueues) {
        this.initInBillInfos(candidateQueues);
        this.initCrtSelectQueue(candidateQueues);
        if (this.selectQues.isEmpty()) {
            return null;
        }
        HashMap<Long, BigDecimal> matAndSumWfNumMap = new HashMap<Long, BigDecimal>(16);
        for (WriteOffObjectBase reqOutWfObjBase : this.reqOutQueue.peekAll()) {
            BigDecimal reqWfNum = reqOutWfObjBase.getWriteOffNumber();
            DynamicObject reqOutWfObj = reqOutWfObjBase.getWriteOffObject();
            Long reqMatId = reqOutWfObj.getLong("material.masterid");
            BigDecimal sumWfNum = (BigDecimal)matAndSumWfNumMap.get(reqMatId);
            sumWfNum = sumWfNum == null ? reqWfNum : sumWfNum.add(reqWfNum);
            matAndSumWfNumMap.put(reqMatId, sumWfNum);
        }
        boolean isPassCheck = this.doMainWfCheck(matAndSumWfNumMap);
        if (!isPassCheck) {
            logger.info("PurOmWriteOffStrategy-\u4e0d\u6ee1\u8db3\u59d4\u5916\u91c7\u8d2d\u6838\u9500\u6821\u9a8c");
            WriteOffObjectBase purWfBase = this.purInQueue.poll();
            purWfBase.setWfComplete(false);
            return null;
        }
        WriteOffObjectBase purInWfObjBase = this.purInQueue.peek();
        this.crtSelectPurInQue.add(purInWfObjBase);
        DynamicObject purInDym = purInWfObjBase.getWriteOffObject();
        this.purInQueue.poll();
        BigDecimal purInWfNum = purInWfObjBase.getWriteOffNumber();
        for (Map.Entry<Long, PurOmOrderSubListInfo> entry : this.subListInfoMap.entrySet()) {
            Long matId = entry.getKey();
            PurOmOrderSubListInfo info = entry.getValue();
            String rowCLoseStatus = info.getRowCloseStatus();
            BigDecimal reqOutSumWfNum = (BigDecimal)matAndSumWfNumMap.get(matId);
            if (reqOutSumWfNum == null) continue;
            BigDecimal qtyRatio = info.getQtyRatio();
            BigDecimal needWfNum = purInWfNum.multiply(qtyRatio);
            if (reqOutSumWfNum.compareTo(needWfNum) <= 0) {
                this.doWholeWf(matId);
                continue;
            }
            if (reqOutSumWfNum.compareTo(needWfNum) <= 0) continue;
            if ((purInDym.getBoolean("isoverreceive") || "B".equals(rowCLoseStatus)) && !this.isMulUnWfQueue) {
                this.doWholeWf(matId);
                continue;
            }
            this.doPartWf(matId, needWfNum);
        }
        if (this.crtSelectReqOutQue.isEmpty() || this.crtSelectPurInQue.isEmpty()) {
            logger.info("PurOmWriteOffStrategy-\u53c2\u4e0e\u6838\u9500\u7684\u67d0\u4e00\u65b9\u5bf9\u5217\u4e3a\u7a7a");
            return null;
        }
        return this.selectQues;
    }

    private List<IWriteOffQueue> doSupplierWf(List<IWriteOffQueue> candidateQueues) {
        this.initInBillInfos(candidateQueues);
        this.initCrtSelectQueue(candidateQueues);
        if (this.selectQues.isEmpty()) {
            return null;
        }
        HashMap<String, BigDecimal> supMatSumWfNumMap = new HashMap<String, BigDecimal>(16);
        for (WriteOffObjectBase reqOutWfObjBase : this.reqOutQueue.peekAll()) {
            Long supId;
            BigDecimal reqWfNum = reqOutWfObjBase.getWriteOffNumber();
            DynamicObject reqOutWfObj = reqOutWfObjBase.getWriteOffObject();
            Long reqMatId = reqOutWfObj.getLong("material.masterid");
            Long orgId = reqOutWfObj.getLong("settleorg");
            String key = this.buildBillKey(orgId, supId = Long.valueOf(reqOutWfObj.getLong("supplier")), reqMatId);
            BigDecimal sumWfNum = (BigDecimal)supMatSumWfNumMap.get(key);
            sumWfNum = sumWfNum == null ? reqWfNum : sumWfNum.add(reqWfNum);
            supMatSumWfNumMap.put(key, sumWfNum);
        }
        boolean isPassCheck = this.doSupWfCheck(supMatSumWfNumMap);
        if (!isPassCheck) {
            logger.info("PurOmWriteOffStrategy-\u4e0d\u6ee1\u8db3\u59d4\u5916\u91c7\u8d2d\u6838\u9500\u6821\u9a8c");
            this.purInQueue.poll();
            return null;
        }
        WriteOffObjectBase purInWfObjBase = this.purInQueue.peek();
        this.crtSelectPurInQue.add(purInWfObjBase);
        this.purInQueue.poll();
        BigDecimal purInWfNum = purInWfObjBase.getWriteOffNumber();
        DynamicObject purINWfObj = purInWfObjBase.getWriteOffObject();
        Long orgId = purINWfObj.getLong("entrysettleorg");
        Long supId = purINWfObj.getLong("supplier");
        Long orderEntryId = purINWfObj.getLong("mainbillentryid");
        Map<Long, PurOmOrderSubListInfo> matListInfoMap = this.supplierListInfoMap.get(orderEntryId);
        for (Map.Entry<Long, PurOmOrderSubListInfo> entry : matListInfoMap.entrySet()) {
            Long matId = entry.getKey();
            String key = this.buildBillKey(orgId, supId, matId);
            PurOmOrderSubListInfo info = entry.getValue();
            BigDecimal reqOutSumWfNum = (BigDecimal)supMatSumWfNumMap.get(key);
            if (reqOutSumWfNum == null) continue;
            BigDecimal qtyRatio = info.getQtyRatio();
            BigDecimal needWfNum = purInWfNum.multiply(qtyRatio);
            if (reqOutSumWfNum.compareTo(needWfNum) <= 0) {
                this.doWholeSupWf(key);
                continue;
            }
            if (reqOutSumWfNum.compareTo(needWfNum) <= 0) continue;
            this.doPartSupWf(key, needWfNum);
        }
        if (this.crtSelectReqOutQue.isEmpty() || this.crtSelectPurInQue.isEmpty()) {
            logger.info("PurOmWriteOffStrategy-\u53c2\u4e0e\u6838\u9500\u7684\u67d0\u4e00\u65b9\u5bf9\u5217\u4e3a\u7a7a");
            return null;
        }
        return this.selectQues;
    }

    private void initInBillInfos(List<IWriteOffQueue> candidateQueues) {
        this.subListInfoMap.clear();
        this.supplierListInfoMap.clear();
        HashSet<Long> orderIds = new HashSet<Long>(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            List<WriteOffObjectBase> writeOffObjBases = writeOffQueue.peekAll();
            for (WriteOffObjectBase writeOffObjBase : writeOffObjBases) {
                String entityKey = writeOffObjBase.getWFBillEntityName();
                if (!"im_ospurinbill".equals(entityKey)) continue;
                DynamicObject wfObj = writeOffObjBase.getWriteOffObject();
                orderIds.add(wfObj.getLong("mainbillid"));
                orderEntryIds.add(wfObj.getLong("mainbillentryid"));
            }
        }
        QFilter orderQ = new QFilter("id", "in", orderIds);
        orderQ.and("billentry.id", "in", orderEntryIds);
        DataSet orderDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sctm_scpo", (String)"billentry.id as orderentryid,billentry.rowclosestatus as rowclosestatus,billentry.billentry_sub.qtyratio as qtyratio,billentry.billentry_sub.submaterial as submaterial,billentry.billentry_sub.subbaseqtyup as subbaseqtyup,billentry.billentry_sub.subbaseqtydown as subbaseqtydown,billentry.billentry_sub.subdelbaseqty as subdelbaseqty", (QFilter[])orderQ.toArray(), null);
        for (Row row : orderDs) {
            Long entryId = row.getLong("orderentryid");
            Long matId = row.getLong("submaterial");
            PurOmOrderSubListInfo info = new PurOmOrderSubListInfo(matId, row.getBigDecimal("qtyratio"), row.getBigDecimal("subbaseqtyup"), row.getBigDecimal("subbaseqtydown"), row.getBigDecimal("subdelbaseqty"), row.getString("rowclosestatus"));
            if (this.isSupplierWF) {
                this.supplierListInfoMap.putIfAbsent(entryId, new HashMap(16));
                Map<Long, PurOmOrderSubListInfo> listInfoMap = this.supplierListInfoMap.get(entryId);
                listInfoMap.put(matId, info);
                continue;
            }
            this.subListInfoMap.put(matId, info);
        }
    }

    private boolean doMainWfCheck(Map<Long, BigDecimal> matAndSumWfNumMap) {
        WriteOffObjectBase purInWfObjBase = this.purInQueue.peek();
        BigDecimal purInWfNum = purInWfObjBase.getWriteOffNumber();
        for (Map.Entry<Long, PurOmOrderSubListInfo> entry : this.subListInfoMap.entrySet()) {
            Long matId = entry.getKey();
            PurOmOrderSubListInfo info = entry.getValue();
            String rowCLoseStatus = info.getRowCloseStatus();
            if ("B".equals(rowCLoseStatus) && !this.isMulUnWfQueue) continue;
            BigDecimal reqOutSumWfNum = matAndSumWfNumMap.get(matId);
            if (reqOutSumWfNum == null) {
                logger.info("PurOmWriteOffStrategy-\u672a\u83b7\u53d6\u8ba2\u5355\u53d1\u6599\u4fe1\u606f\u4e0b\u7684\u7269\u6599\u5bf9\u5e94\u7684\u9886\u6599\u5355\uff0c\u7269\u6599id:" + matId);
                return false;
            }
            BigDecimal baseQtyDown = info.getBaseQtyDown();
            BigDecimal delBaseQty = info.getDelBaseQty();
            BigDecimal qtyRatio = info.getQtyRatio();
            BigDecimal needWfNum = purInWfNum.multiply(qtyRatio);
            if (reqOutSumWfNum.compareTo(needWfNum) >= 0 || !(this.isSupplierWF ? reqOutSumWfNum.compareTo(baseQtyDown) < 0 : delBaseQty.compareTo(baseQtyDown) < 0)) continue;
            return false;
        }
        return true;
    }

    private boolean doSupWfCheck(Map<String, BigDecimal> supMatSumWfNumMap) {
        WriteOffObjectBase purInWfObjBase = this.purInQueue.peek();
        BigDecimal purInWfNum = purInWfObjBase.getWriteOffNumber();
        DynamicObject purINWfObj = purInWfObjBase.getWriteOffObject();
        Long orgId = purINWfObj.getLong("entrysettleorg");
        Long supId = purINWfObj.getLong("supplier");
        Long orderEntryId = purINWfObj.getLong("mainbillentryid");
        Map<Long, PurOmOrderSubListInfo> matListInfoMap = this.supplierListInfoMap.get(orderEntryId);
        for (Map.Entry<Long, PurOmOrderSubListInfo> entry : matListInfoMap.entrySet()) {
            boolean manualWf;
            Long matId = entry.getKey();
            String key = this.buildBillKey(orgId, supId, matId);
            PurOmOrderSubListInfo info = entry.getValue();
            BigDecimal reqOutSumWfNum = supMatSumWfNumMap.get(key);
            if (reqOutSumWfNum == null) {
                logger.info("PurOmWriteOffStrategy-\u672a\u83b7\u53d6\u8ba2\u5355\u53d1\u6599\u4fe1\u606f\u4e0b\u7684\u7269\u6599\u5bf9\u5e94\u7684\u9886\u6599\u5355\uff0c\u7269\u6599id:" + matId);
                return false;
            }
            BigDecimal baseQtyDown = info.getBaseQtyDown();
            BigDecimal qtyRatio = info.getQtyRatio();
            BigDecimal needWfNum = purInWfNum.multiply(qtyRatio);
            if (reqOutSumWfNum.compareTo(needWfNum) >= 0 || !this.isSupplierWF) continue;
            boolean bl = manualWf = !this.getExecuteContext().isFlowWriteOff();
            if (manualWf) {
                return false;
            }
            if (reqOutSumWfNum.compareTo(baseQtyDown) >= 0) continue;
            return false;
        }
        return true;
    }

    private void doWholeWf(Long matId) {
        ArrayList<WriteOffObjectBase> otherMatWfObjs = new ArrayList<WriteOffObjectBase>(16);
        for (WriteOffObjectBase reqWfObjBase : this.reqOutQueue.peekAll()) {
            DynamicObject reqOutWfObj = reqWfObjBase.getWriteOffObject();
            Long reqMatId = reqOutWfObj.getLong("material.masterid");
            if (reqMatId.compareTo(matId) == 0) {
                this.crtSelectReqOutQue.add(reqWfObjBase);
                continue;
            }
            otherMatWfObjs.add(reqWfObjBase);
        }
        this.reqOutQueue.pollAll();
        if (!otherMatWfObjs.isEmpty()) {
            this.reqOutQueue.addAll(otherMatWfObjs);
        }
    }

    private void doWholeSupWf(String key) {
        ArrayList<WriteOffObjectBase> otherMatWfObjs = new ArrayList<WriteOffObjectBase>(16);
        for (WriteOffObjectBase reqWfObjBase : this.reqOutQueue.peekAll()) {
            Long supId;
            DynamicObject reqOutWfObj = reqWfObjBase.getWriteOffObject();
            Long reqMatId = reqOutWfObj.getLong("material.masterid");
            Long orgId = reqOutWfObj.getLong("settleorg");
            String billKey = this.buildBillKey(orgId, supId = Long.valueOf(reqOutWfObj.getLong("supplier")), reqMatId);
            if (billKey.equals(key)) {
                this.crtSelectReqOutQue.add(reqWfObjBase);
                continue;
            }
            otherMatWfObjs.add(reqWfObjBase);
        }
        this.reqOutQueue.pollAll();
        if (!otherMatWfObjs.isEmpty()) {
            this.reqOutQueue.addAll(otherMatWfObjs);
        }
    }

    private void doPartWf(Long matId, BigDecimal needWfNum) {
        ArrayList<WriteOffObjectBase> leftWfObjs = new ArrayList<WriteOffObjectBase>(16);
        BigDecimal accureWfNum = BigDecimal.ZERO;
        for (WriteOffObjectBase reqWfObjBase : this.reqOutQueue.peekAll()) {
            BigDecimal reqWfNum = reqWfObjBase.getWriteOffNumber();
            DynamicObject reqOutWfObj = reqWfObjBase.getWriteOffObject();
            Long reqMatId = reqOutWfObj.getLong("material.masterid");
            if (reqMatId.compareTo(matId) != 0 || accureWfNum.compareTo(needWfNum) == 0) {
                leftWfObjs.add(reqWfObjBase);
                continue;
            }
            if (needWfNum.compareTo(accureWfNum.add(reqWfNum)) >= 0) {
                this.crtSelectReqOutQue.add(reqWfObjBase);
                accureWfNum = accureWfNum.add(reqWfNum);
                continue;
            }
            BigDecimal crtWfNum = needWfNum.subtract(accureWfNum);
            reqWfObjBase.setActualLogicWriteOffNumber(crtWfNum);
            reqWfObjBase.setCurWriteOffNumber(crtWfNum);
            this.crtSelectReqOutQue.add(reqWfObjBase);
            WriteOffObjectBase reqWfObjBaseCopy = reqWfObjBase.clone();
            reqWfObjBaseCopy.setActualLogicWriteOffNumber(reqWfNum.subtract(crtWfNum));
            reqWfObjBaseCopy.setCurWriteOffNumber(reqWfNum.subtract(crtWfNum));
            leftWfObjs.add(reqWfObjBaseCopy);
            accureWfNum = needWfNum;
        }
        this.reqOutQueue.pollAll();
        if (!leftWfObjs.isEmpty()) {
            this.reqOutQueue.addAll(leftWfObjs);
        }
    }

    private void doPartSupWf(String key, BigDecimal needWfNum) {
        ArrayList<WriteOffObjectBase> leftWfObjs = new ArrayList<WriteOffObjectBase>(16);
        BigDecimal accureWfNum = BigDecimal.ZERO;
        for (WriteOffObjectBase reqWfObjBase : this.reqOutQueue.peekAll()) {
            Long supId;
            BigDecimal reqWfNum = reqWfObjBase.getWriteOffNumber();
            DynamicObject reqOutWfObj = reqWfObjBase.getWriteOffObject();
            Long reqMatId = reqOutWfObj.getLong("material.masterid");
            Long orgId = reqOutWfObj.getLong("settleorg");
            String billKey = this.buildBillKey(orgId, supId = Long.valueOf(reqOutWfObj.getLong("supplier")), reqMatId);
            if (!billKey.equals(key) || accureWfNum.compareTo(needWfNum) == 0) {
                leftWfObjs.add(reqWfObjBase);
                continue;
            }
            if (needWfNum.compareTo(accureWfNum.add(reqWfNum)) >= 0) {
                this.crtSelectReqOutQue.add(reqWfObjBase);
                accureWfNum = accureWfNum.add(reqWfNum);
                continue;
            }
            BigDecimal crtWfNum = needWfNum.subtract(accureWfNum);
            reqWfObjBase.setActualLogicWriteOffNumber(crtWfNum);
            reqWfObjBase.setCurWriteOffNumber(crtWfNum);
            this.crtSelectReqOutQue.add(reqWfObjBase);
            WriteOffObjectBase reqWfObjBaseCopy = reqWfObjBase.clone();
            reqWfObjBaseCopy.setActualLogicWriteOffNumber(reqWfNum.subtract(crtWfNum));
            reqWfObjBaseCopy.setCurWriteOffNumber(reqWfNum.subtract(crtWfNum));
            leftWfObjs.add(reqWfObjBaseCopy);
            accureWfNum = needWfNum;
        }
        this.reqOutQueue.pollAll();
        if (!leftWfObjs.isEmpty()) {
            this.reqOutQueue.addAll(leftWfObjs);
        }
    }

    private String buildBillKey(Long orgId, Long supId, Long matId) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(String.valueOf(orgId));
        keyBuilder.append('#');
        keyBuilder.append(String.valueOf(supId));
        keyBuilder.append('#');
        keyBuilder.append(String.valueOf(matId));
        return keyBuilder.toString();
    }
}

