/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.FieldWriteBackEntity;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.FormulaTypeEnum;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.InvEntrustHelper;
import kd.sdk.mpscmm.mscommon.writeoff.params.GeneratorBillWf;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class AgencyWriteOffHelper {
    private static final Log LOG = LogFactory.getLog(AgencyWriteOffHelper.class);
    public static final String ENTITY_SALOUTBILL = "im_saloutbill";
    public static final String ENTITY_SALORDERBILL = "sm_salorder";
    public static final String ENTITY_SALESAGENCY = "sm_salesagency";
    public static final long ID_INVSCHEME_231 = 1103399833190053888L;
    public static final long ID_INVSCHEME_2311 = 1103403089127602176L;
    public static final long ID_INVSCHEME_211 = 688857787480045568L;
    public static final String DT = "billentry";
    public static final String RECORD_BILLTYPE = "billtype";

    private AgencyWriteOffHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<Long, BigDecimal> getQueueWfQty(List<IWriteOffQueue> queues, String entityName) {
        HashMap<Long, BigDecimal> agencyWfRes = new HashMap<Long, BigDecimal>(16);
        for (IWriteOffQueue queue : queues) {
            List<WriteOffObjectBase> all = queue.peekAll();
            if (all == null || all.isEmpty()) continue;
            for (WriteOffObjectBase wo : all) {
                if (!entityName.equalsIgnoreCase(wo.getWFBillEntityName())) continue;
                agencyWfRes.put((Long)wo.getPkValue(), wo.getCurWriteOffNumber());
            }
        }
        return agencyWfRes;
    }

    public static Map<Long, BigDecimal> autoBillWfQty(List<GeneratorBillWf> generateBills) {
        HashMap<Long, BigDecimal> saleBillIDs = new HashMap<Long, BigDecimal>(16);
        for (GeneratorBillWf generatorBillWf : generateBills) {
            List<DynamicObject> autoBills = generatorBillWf.getAutoDynamic();
            if (autoBills == null || autoBills.isEmpty()) continue;
            autoBills.forEach(bill -> {
                DynamicObjectCollection entry = bill.getDynamicObjectCollection(DT);
                if (entry == null || entry.isEmpty()) {
                    return;
                }
                entry.forEach(row -> saleBillIDs.put((Long)row.getPkValue(), row.getBigDecimal("baseqty")));
            });
        }
        return saleBillIDs;
    }

    public static Map<Long, Map<Long, BigDecimal>> groupWriteOff(Map<Long, BigDecimal> agencyWfRes, Map<Long, BigDecimal> salOutWfRes, boolean negate) {
        HashMap<Long, Map<Long, BigDecimal>> writeOffRes = new HashMap<Long, Map<Long, BigDecimal>>(16);
        if (agencyWfRes.isEmpty() || salOutWfRes.isEmpty()) {
            return writeOffRes;
        }
        HashMap<Long, BigDecimal> agencyRow = new HashMap<Long, BigDecimal>(16);
        agencyWfRes.forEach((k, v) -> agencyRow.put((Long)k, v.abs()));
        HashMap outBillRow = new HashMap(16);
        salOutWfRes.forEach((k, v) -> outBillRow.put(k, v.abs()));
        for (Map.Entry outBillRowEntry : outBillRow.entrySet()) {
            BigDecimal qty = (BigDecimal)outBillRowEntry.getValue();
            HashMap<Long, BigDecimal> idsMap = new HashMap<Long, BigDecimal>(16);
            Iterator it = agencyRow.entrySet().iterator();
            while (it.hasNext() && qty != null && BigDecimal.ZERO.compareTo(qty) != 0) {
                Map.Entry e = it.next();
                Long k2 = (Long)e.getKey();
                BigDecimal v2 = (BigDecimal)e.getValue();
                if (v2 == null || BigDecimal.ZERO.compareTo(v2) == 0) continue;
                if (v2.compareTo(qty) == 0) {
                    idsMap.put(k2, v2);
                    agencyRow.put(k2, v2.subtract(qty));
                    qty = BigDecimal.ZERO;
                    continue;
                }
                if (v2.compareTo(qty) > 0) {
                    idsMap.put(k2, qty);
                    agencyRow.put(k2, v2.subtract(qty));
                    qty = BigDecimal.ZERO;
                    continue;
                }
                idsMap.put(k2, v2);
                agencyRow.put(k2, BigDecimal.ZERO);
                qty = qty.subtract(v2);
            }
            if (negate) {
                idsMap.forEach((k, v) -> idsMap.put((Long)k, v.negate()));
            }
            writeOffRes.put((Long)outBillRowEntry.getKey(), (Map<Long, BigDecimal>)idsMap);
        }
        return writeOffRes;
    }

    public static Map<Long, Map<String, String>> spiltRow(Map<Long, Map<Long, BigDecimal>> relation, Map<Long, DynamicObject> autoBills) {
        if (relation.isEmpty()) {
            return new HashMap<Long, Map<String, String>>(1);
        }
        LOG.info(ResManager.loadKDString((String)("\u8c03\u7528\u5e93\u5b58\u5fae\u670d\u52a1\uff0c\u5bf9\u552e\u51fa\u5355\u62c6\u884c, \u53c2\u6570\uff1a" + relation), (String)"AgencyWriteOffHelper_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        Map<Long, Map<String, String>> res = InvEntrustHelper.salOutBillWriteBack(relation, autoBills);
        LOG.info(ResManager.loadKDString((String)("\u8c03\u7528\u5e93\u5b58\u5fae\u670d\u52a1\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + res), (String)"AgencyWriteOffHelper_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        Map<Long, String> errorRes = AgencyWriteOffHelper.getSplitErrorRes(res);
        if (!errorRes.isEmpty()) {
            LOG.info("error result" + errorRes);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9500\u552e\u51fa\u5e93\u5355\u62c6\u884c\u5931\u8d25\uff1a%s\u3002", (String)"AgencyWriteOffHelper_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), errorRes));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WRITEOFF_OPERATE", String.valueOf(true));
        option.setVariableValue("isIgnoreVirualBillValidate", String.valueOf(true));
        option.setVariableValue("isshowmessage", "false");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("ignoreValidation", "true");
        option.setVariableValue("WF", String.valueOf(false));
        Collection<DynamicObject> values = autoBills.values();
        DynamicObject[] objects = values.toArray(new DynamicObject[values.size()]);
        return res;
    }

    public static void executeOperateByWriteOff(List<Object> ids) {
        LOG.info("executeOperateByWriteOff ids = " + ids);
        if (ids == null || ids.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("writeoff_tag", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isshowmessage", String.valueOf(false));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        try (TXHandle tx = TX.notSupported();){
            List saveStatusIds;
            OperationResult submitRes;
            LOG.info("auto submit bills start");
            LOG.info("auto submit bills end");
            QFilter q1 = new QFilter("id", "in", ids);
            QFilter q2 = new QFilter("billstatus", "=", (Object)"A");
            DynamicObjectCollection queryRes = QueryServiceHelper.query((String)ENTITY_SALOUTBILL, (String)"id, billno", (QFilter[])new QFilter[]{q1, q2});
            if (queryRes != null && !queryRes.isEmpty() && (submitRes = OperationServiceHelper.executeOperate((String)"submit", (String)ENTITY_SALOUTBILL, (Object[])(saveStatusIds = queryRes.stream().map(d -> d.getLong("id")).collect(Collectors.toList())).toArray(), (OperateOption)option)) != null && !submitRes.isSuccess()) {
                LOG.info("auto submit bills res " + submitRes.isSuccess());
                List<String> errInfo = AgencyWriteOffHelper.getErrOperationResultTip(submitRes);
                throw new KDBizException(errInfo.toString());
            }
            OperationServiceHelper.executeOperate((String)"audit", (String)ENTITY_SALOUTBILL, (Object[])ids.toArray(), (OperateOption)option);
        }
    }

    public static Map<String, Map<String, List<Object[]>>> buildBackOrderSql(List<DynamicObject> saloutBills, Map<Long, BigDecimal> returnQty, List<FieldWriteBackEntity> backFields, Map<String, Map<String, List<Object[]>>> sqlMaps) {
        Map<Long, BigDecimal> writeBackOrderQty;
        LOG.info(MessageFormat.format(ResManager.loadKDString((String)"\u51c6\u5907\u53cd\u5199\u8ba2\u5355:{0} , \u53cd\u5199\u5b57\u6bb5\u4fe1\u606f\uff1a{1}", (String)"AgencyWriteOffHelper_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), returnQty, backFields));
        String dbKey = "scm";
        Map<String, List<Object[]>> sqlLists = sqlMaps.get(dbKey);
        if (sqlLists == null) {
            sqlLists = new HashMap<String, List<Object[]>>();
        }
        if (returnQty.isEmpty() || backFields.isEmpty()) {
            return sqlMaps;
        }
        if (saloutBills == null || saloutBills.isEmpty()) {
            DynamicObjectCollection saloutBillCol = QueryServiceHelper.query((String)ENTITY_SALOUTBILL, (String)AgencyWriteOffHelper.getOutBillQueryField(), (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", returnQty.keySet())});
            if (saloutBillCol == null || saloutBillCol.isEmpty()) {
                return sqlMaps;
            }
            saloutBills = new ArrayList<DynamicObject>();
            saloutBills.addAll(saloutBillCol.stream().collect(Collectors.toList()));
        }
        if ((writeBackOrderQty = AgencyWriteOffHelper.getWriteBackOrderQty(saloutBills, returnQty)).isEmpty()) {
            return sqlMaps;
        }
        QFilter q = new QFilter("billentry.id", "in", writeBackOrderQty.keySet());
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)ENTITY_SALORDERBILL, (String)AgencyWriteOffHelper.getSelectField(backFields), (QFilter[])new QFilter[]{q});
        if (orders == null || orders.length == 0) {
            return sqlMaps;
        }
        LOG.info(MessageFormat.format(ResManager.loadKDString((String)"\u5f00\u59cb\u53cd\u5199\u8ba2\u5355\u6570\u636e\uff1a{0}, \u53cd\u5199\u5b57\u6bb5\u4fe1\u606f \uff1a{1}", (String)"AgencyWriteOffHelper_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), writeBackOrderQty, backFields));
        for (DynamicObject order : orders) {
            DynamicObjectCollection billentry = order.getDynamicObjectCollection(DT);
            if (billentry == null || billentry.isEmpty()) continue;
            for (DynamicObject row : billentry) {
                BigDecimal backValue;
                Long orderRowID = (Long)row.getPkValue();
                if (!writeBackOrderQty.containsKey(orderRowID) || (backValue = writeBackOrderQty.get(orderRowID)) == null || BigDecimal.ZERO.compareTo(backValue) == 0) continue;
                sqlLists = AgencyWriteOffHelper.writeRowSql(backFields, row, backValue, sqlLists, "t_sm_salorderentry_r", "fentryid");
            }
        }
        sqlMaps.put(dbKey, sqlLists);
        LOG.info(ResManager.loadKDString((String)"\u6784\u5efa\u53cd\u5199Sql\u7ed3\u675f", (String)"AgencyWriteOffHelper_8", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        return sqlMaps;
    }

    public static void writeBackOrder(List<DynamicObject> saloutBills, Map<Long, BigDecimal> returnQty, List<FieldWriteBackEntity> backFields) {
        Map<Long, BigDecimal> writeBackOrderQty;
        LOG.info(MessageFormat.format(ResManager.loadKDString((String)"\u51c6\u5907\u53cd\u5199\u8ba2\u5355:{0} , \u53cd\u5199\u5b57\u6bb5\u4fe1\u606f\uff1a{1}", (String)"AgencyWriteOffHelper_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), returnQty, backFields));
        if (returnQty.isEmpty() || backFields.isEmpty()) {
            return;
        }
        if (saloutBills == null || saloutBills.isEmpty()) {
            DynamicObjectCollection saloutBillCol = QueryServiceHelper.query((String)ENTITY_SALOUTBILL, (String)AgencyWriteOffHelper.getOutBillQueryField(), (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", returnQty.keySet())});
            if (saloutBillCol == null || saloutBillCol.isEmpty()) {
                return;
            }
            saloutBills = new ArrayList<DynamicObject>();
            saloutBills.addAll(saloutBillCol.stream().collect(Collectors.toList()));
        }
        if ((writeBackOrderQty = AgencyWriteOffHelper.getWriteBackOrderQty(saloutBills, returnQty)).isEmpty()) {
            return;
        }
        QFilter q = new QFilter("billentry.id", "in", writeBackOrderQty.keySet());
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)ENTITY_SALORDERBILL, (String)AgencyWriteOffHelper.getSelectField(backFields), (QFilter[])new QFilter[]{q});
        if (orders == null || orders.length == 0) {
            return;
        }
        LOG.info(MessageFormat.format(ResManager.loadKDString((String)"\u5f00\u59cb\u53cd\u5199\u8ba2\u5355\u6570\u636e\uff1a{0}, \u53cd\u5199\u5b57\u6bb5\u4fe1\u606f \uff1a{1}", (String)"AgencyWriteOffHelper_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), writeBackOrderQty, backFields));
        for (DynamicObject order : orders) {
            DynamicObjectCollection billentry = order.getDynamicObjectCollection(DT);
            if (billentry == null || billentry.isEmpty()) continue;
            for (DynamicObject row : billentry) {
                BigDecimal backValue;
                Long orderRowID = (Long)row.getPkValue();
                if (!writeBackOrderQty.containsKey(orderRowID) || (backValue = writeBackOrderQty.get(orderRowID)) == null || BigDecimal.ZERO.compareTo(backValue) == 0) continue;
                AgencyWriteOffHelper.writeRow(backFields, row, backValue);
            }
        }
        SaveServiceHelper.update((DynamicObject[])orders);
        LOG.info(ResManager.loadKDString((String)"\u53cd\u5199\u8ba2\u5355\u7ed3\u675f\u3002", (String)"AgencyWriteOffHelper_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
    }

    public static Map<String, Map<String, List<Object[]>>> buildBackSendBillSql(List<DynamicObject> saloutBills, Map<Long, BigDecimal> returnQty, List<FieldWriteBackEntity> backFields, Map<String, Map<String, List<Object[]>>> sqlMaps) {
        Map<Long, BigDecimal> writeBackQtyMap;
        String dbKey = "scm";
        Map<String, List<Object[]>> sqlLists = sqlMaps.get(dbKey);
        if (sqlLists == null) {
            sqlLists = new HashMap<String, List<Object[]>>();
        }
        if (returnQty.isEmpty()) {
            return sqlMaps;
        }
        if (saloutBills == null || saloutBills.isEmpty()) {
            DynamicObjectCollection saloutBillCol = QueryServiceHelper.query((String)ENTITY_SALOUTBILL, (String)AgencyWriteOffHelper.getOutBillQueryField(), (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", returnQty.keySet())});
            if (saloutBillCol == null || saloutBillCol.isEmpty()) {
                return sqlMaps;
            }
            saloutBills = new ArrayList<DynamicObject>();
            saloutBills.addAll(saloutBillCol.stream().collect(Collectors.toList()));
        }
        if ((writeBackQtyMap = AgencyWriteOffHelper.getWriteBackSendBillQty(saloutBills, returnQty)).isEmpty()) {
            return sqlMaps;
        }
        QFilter q1 = new QFilter("billentry.id", "in", writeBackQtyMap.keySet());
        QFilter q2 = new QFilter("invscheme.id", "=", (Object)688857787480045568L);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)ENTITY_SALOUTBILL, (String)AgencyWriteOffHelper.getSelectField(backFields), (QFilter[])new QFilter[]{q1, q2});
        if (bills == null || bills.length == 0) {
            return sqlMaps;
        }
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection(DT);
            if (billentry == null || billentry.isEmpty()) continue;
            for (DynamicObject row : billentry) {
                BigDecimal backValue;
                Long sendRowID = (Long)row.getPkValue();
                if (!writeBackQtyMap.containsKey(sendRowID) || (backValue = writeBackQtyMap.get(sendRowID)) == null || BigDecimal.ZERO.compareTo(backValue) == 0) continue;
                sqlLists = AgencyWriteOffHelper.writeRowSql(backFields, row, backValue, sqlLists, "t_im_saloutbillentry_r", "fentryid");
            }
        }
        sqlMaps.put(dbKey, sqlLists);
        return sqlMaps;
    }

    public static void writeBackSendBill(List<DynamicObject> saloutBills, Map<Long, BigDecimal> returnQty, List<FieldWriteBackEntity> backFields) {
        Map<Long, BigDecimal> writeBackQtyMap;
        if (returnQty.isEmpty()) {
            return;
        }
        if (saloutBills == null || saloutBills.isEmpty()) {
            DynamicObjectCollection saloutBillCol = QueryServiceHelper.query((String)ENTITY_SALOUTBILL, (String)AgencyWriteOffHelper.getOutBillQueryField(), (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", returnQty.keySet())});
            if (saloutBillCol == null || saloutBillCol.isEmpty()) {
                return;
            }
            saloutBills = new ArrayList<DynamicObject>();
            saloutBills.addAll(saloutBillCol.stream().collect(Collectors.toList()));
        }
        if ((writeBackQtyMap = AgencyWriteOffHelper.getWriteBackSendBillQty(saloutBills, returnQty)).isEmpty()) {
            return;
        }
        QFilter q1 = new QFilter("billentry.id", "in", writeBackQtyMap.keySet());
        QFilter q2 = new QFilter("invscheme.id", "=", (Object)688857787480045568L);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)ENTITY_SALOUTBILL, (String)AgencyWriteOffHelper.getSelectField(backFields), (QFilter[])new QFilter[]{q1, q2});
        if (bills == null || bills.length == 0) {
            return;
        }
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection(DT);
            if (billentry == null || billentry.isEmpty()) continue;
            for (DynamicObject row : billentry) {
                BigDecimal backValue;
                Long sendRowID = (Long)row.getPkValue();
                if (!writeBackQtyMap.containsKey(sendRowID) || (backValue = writeBackQtyMap.get(sendRowID)) == null || BigDecimal.ZERO.compareTo(backValue) == 0) continue;
                AgencyWriteOffHelper.writeRow(backFields, row, backValue);
            }
        }
        SaveServiceHelper.update((DynamicObject[])bills);
    }

    public static void executeOperateByUnWriteOff(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("backwriteoff_tag", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isshowmessage", String.valueOf(false));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("writeOffCheck", String.valueOf(true));
        try (TXHandle tx = TX.notSupported();){
            List unAuditIds;
            OperationResult unAuditRes;
            QFilter q1 = new QFilter("id", "in", ids);
            QFilter q2 = new QFilter("billstatus", "=", (Object)"C");
            DynamicObjectCollection queryRes = QueryServiceHelper.query((String)ENTITY_SALOUTBILL, (String)"id, billno", (QFilter[])new QFilter[]{q1, q2});
            if (queryRes != null && !queryRes.isEmpty() && (unAuditRes = OperationServiceHelper.executeOperate((String)"unaudit", (String)ENTITY_SALOUTBILL, (Object[])(unAuditIds = queryRes.stream().map(d -> d.getLong("id")).collect(Collectors.toList())).toArray(), (OperateOption)option)) != null && !unAuditRes.isSuccess()) {
                List<String> errInfo = AgencyWriteOffHelper.getErrOperationResultTip(unAuditRes);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5355\u636e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002\u9519\u8bef\u539f\u56e0\uff1a%s\u3002", (String)"AgencyWriteOffHelper_6", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), errInfo));
            }
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)ENTITY_SALOUTBILL, (Object[])ids.toArray(), (OperateOption)option);
            OperationServiceHelper.executeOperate((String)"delete", (String)ENTITY_SALOUTBILL, (Object[])ids.toArray(), (OperateOption)option);
        }
    }

    public static List<DynamicObject> getOutBill(List<DynamicObject> records, long invschemeID) {
        if (records == null || records.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList entrys = new ArrayList();
        records.forEach(r -> {
            DynamicObjectCollection entry = r.getDynamicObjectCollection("entry");
            entrys.addAll(entry);
        });
        List outBillIDs = entrys.stream().filter(r -> ENTITY_SALOUTBILL.equals(r.getDynamicObject(RECORD_BILLTYPE).getString("number"))).map(r -> r.getLong("billid")).collect(Collectors.toList());
        if (outBillIDs == null || outBillIDs.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        QFilter q2 = new QFilter("invscheme.id", "=", (Object)invschemeID);
        QFilter q1 = new QFilter("id", "in", outBillIDs);
        DynamicObjectCollection res = QueryServiceHelper.query((String)ENTITY_SALOUTBILL, (String)AgencyWriteOffHelper.getOutBillQueryField(), (QFilter[])new QFilter[]{q1, q2});
        if (res == null || res.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        return res.stream().collect(Collectors.toList());
    }

    public static List<DynamicObject> getOutBill(DynamicObject record, long invschemeID) {
        if (record == null) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1);
        list.add(record);
        return AgencyWriteOffHelper.getOutBill(list, invschemeID);
    }

    public static void lockBill(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            bill.set("isverify", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    public static void unLockBill(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            ids.add((Long)bill.getPkValue());
        }
        String sql = "update t_sm_salsagency set fisverify='0' where fid in ";
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)(sql + ((Object)ids).toString().replace('[', '(').replace(']', ')')));
    }

    private static Map<Long, BigDecimal> getWriteBackSendBillQty(List<DynamicObject> saloutBills, Map<Long, BigDecimal> returnQty) {
        HashMap<Long, BigDecimal> writeBackQtyMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject outBill : saloutBills) {
            String srcbillentity = outBill.getString("billentry.srcbillentity");
            if (!ENTITY_SALOUTBILL.equals(srcbillentity)) continue;
            long srcbillentryid = outBill.getLong("billentry.srcbillentryid");
            long outBillentryId = outBill.getLong("billentry.id");
            BigDecimal addQty = returnQty.get(outBillentryId) == null ? BigDecimal.ZERO : returnQty.get(outBillentryId);
            BigDecimal srcbillQty = (BigDecimal)writeBackQtyMap.get(srcbillentryid);
            if (srcbillQty != null) {
                BigDecimal qty = srcbillQty.add(addQty);
                writeBackQtyMap.put(srcbillentryid, qty);
                continue;
            }
            writeBackQtyMap.put(srcbillentryid, addQty);
        }
        return writeBackQtyMap;
    }

    private static Map<Long, BigDecimal> getWriteBackOrderQty(List<DynamicObject> saloutBills, Map<Long, BigDecimal> returnQty) {
        HashMap<Long, BigDecimal> writeBackOrderQty = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject outBill : saloutBills) {
            String mainbillentity = outBill.getString("billentry.mainbillentity");
            if (!ENTITY_SALORDERBILL.equals(mainbillentity)) continue;
            long mainbillentryid = outBill.getLong("billentry.mainbillentryid");
            long outBillentryId = outBill.getLong("billentry.id");
            BigDecimal addQty = returnQty.get(outBillentryId) == null ? BigDecimal.ZERO : returnQty.get(outBillentryId);
            BigDecimal mainbillQty = (BigDecimal)writeBackOrderQty.get(mainbillentryid);
            if (mainbillQty != null) {
                BigDecimal qty = mainbillQty.add(addQty);
                writeBackOrderQty.put(mainbillentryid, qty);
                continue;
            }
            writeBackOrderQty.put(mainbillentryid, addQty);
        }
        return writeBackOrderQty;
    }

    private static String getSelectField(List<FieldWriteBackEntity> backFields) {
        ArrayList<String> fields = new ArrayList<String>(12);
        fields.add("qty");
        fields.add("baseqty");
        fields.add("material");
        for (FieldWriteBackEntity fw : backFields) {
            fields.add(fw.getField());
            fields.add(fw.getUnitField());
            fields.add(fw.getBaseField());
            fields.add(fw.getUnitBaseField());
        }
        return String.join((CharSequence)", ", fields);
    }

    private static String getOutBillQueryField() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        fields.add("invscheme.id");
        fields.add("billentry.remainreturnqty");
        fields.add("billentry.remainreturnbaseqty");
        fields.add("billentry.entrustverifybaseqty");
        fields.add("billentry.entrustverifyqty");
        fields.add("billentry.entrustunverifyqty");
        fields.add("billentry.entrustunverifybaseqty");
        fields.add("billentry.id");
        fields.add("billentry.mainbillentity");
        fields.add("billentry.mainbillentryid");
        fields.add("billentry.srcbillentity");
        fields.add("billentry.srcbillentryid");
        fields.add("billentry.srcbillid");
        return String.join((CharSequence)", ", fields);
    }

    private static Map<String, List<Object[]>> writeRowSql(List<FieldWriteBackEntity> backFields, DynamicObject row, BigDecimal backValue, Map<String, List<Object[]>> sqlLists, String tableName, String entryid) {
        for (FieldWriteBackEntity f : backFields) {
            StringBuilder baseQtyWriteBackSql = new StringBuilder(" update ");
            baseQtyWriteBackSql.append(tableName);
            baseQtyWriteBackSql.append(" set ");
            baseQtyWriteBackSql.append(f.getTableBaseField());
            baseQtyWriteBackSql.append(" = ");
            baseQtyWriteBackSql.append(f.getTableBaseField());
            if (f.getType() == FormulaTypeEnum.ADD) {
                baseQtyWriteBackSql.append(" + ? where ");
            } else {
                baseQtyWriteBackSql.append(" - ? where ");
            }
            baseQtyWriteBackSql.append(entryid);
            baseQtyWriteBackSql.append(" = ?;");
            List<Object[]> baseQtyWriteBackParmers = sqlLists.get(baseQtyWriteBackSql.toString());
            if (baseQtyWriteBackParmers == null) {
                baseQtyWriteBackParmers = new ArrayList<Object[]>();
            }
            Object[] baseQtyWriteBackParmer = new Object[]{backValue, row.getPkValue()};
            baseQtyWriteBackParmers.add(baseQtyWriteBackParmer);
            sqlLists.put(baseQtyWriteBackSql.toString(), baseQtyWriteBackParmers);
            DynamicObject unit = row.getDynamicObject(f.getUnitField());
            DynamicObject baseUnit = row.getDynamicObject(f.getUnitBaseField());
            DynamicObject masterMat = row.getDynamicObject("material.masterid");
            if (masterMat == null || baseUnit == null || unit == null) {
                String errMsg = ResManager.loadKDString((String)"\u6838\u9500\u53cd\u5199\u5355\u636e\u5931\u8d25\uff0c\u68c0\u6d4b\u5230\u8ba1\u91cf\u5355\u4f4d\uff0c\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"AgencyWriteOffHelper_", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
                LOG.error(errMsg);
                throw new KDBizException(errMsg);
            }
            BigDecimal fieldQty = CommonHelper.getDesQtyConv(masterMat, baseUnit, backValue, unit);
            StringBuilder qtyWriteBackSql = new StringBuilder(" update ");
            qtyWriteBackSql.append(tableName);
            qtyWriteBackSql.append(" set ");
            qtyWriteBackSql.append(f.getTableField());
            qtyWriteBackSql.append(" = ");
            qtyWriteBackSql.append(f.getTableField());
            if (f.getType() == FormulaTypeEnum.ADD) {
                qtyWriteBackSql.append(" + ? where ");
            } else {
                qtyWriteBackSql.append(" - ? where ");
            }
            qtyWriteBackSql.append(entryid);
            qtyWriteBackSql.append(" = ?;");
            List<Object[]> qtyWriteBackParmers = sqlLists.get(qtyWriteBackSql.toString());
            if (qtyWriteBackParmers == null) {
                qtyWriteBackParmers = new ArrayList<Object[]>();
            }
            Object[] qtyWriteBackParmer = new Object[]{fieldQty, row.getPkValue()};
            qtyWriteBackParmers.add(qtyWriteBackParmer);
            sqlLists.put(qtyWriteBackSql.toString(), qtyWriteBackParmers);
        }
        return sqlLists;
    }

    private static void writeRow(List<FieldWriteBackEntity> backFields, DynamicObject row, BigDecimal backValue) {
        backFields.forEach(f -> {
            BigDecimal writeBaseQty = row.getBigDecimal(f.getBaseField());
            if (writeBaseQty == null) {
                writeBaseQty = BigDecimal.ZERO;
            }
            if (f.getType() == FormulaTypeEnum.ADD) {
                writeBaseQty = writeBaseQty.add(backValue);
            } else if (f.getType() == FormulaTypeEnum.SUBTRACT) {
                writeBaseQty = writeBaseQty.subtract(backValue);
            }
            row.set(f.getBaseField(), (Object)writeBaseQty);
            DynamicObject unit = row.getDynamicObject(f.getUnitField());
            DynamicObject baseUnit = row.getDynamicObject(f.getUnitBaseField());
            DynamicObject masterMat = row.getDynamicObject("material.masterid");
            if (masterMat == null || baseUnit == null || unit == null) {
                String errMsg = ResManager.loadKDString((String)"\u6838\u9500\u53cd\u5199\u5355\u636e\u5931\u8d25\uff0c\u68c0\u6d4b\u5230\u8ba1\u91cf\u5355\u4f4d\uff0c\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"AgencyWriteOffHelper_", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
                LOG.error(errMsg);
                throw new KDBizException(errMsg);
            }
            BigDecimal fieldQty = CommonHelper.getDesQtyConv(masterMat, baseUnit, writeBaseQty, unit);
            row.set(f.getField(), (Object)fieldQty);
        });
    }

    private static List<String> getErrOperationResultTip(OperationResult res) {
        if (res == null) {
            return new ArrayList<String>();
        }
        ArrayList errInfo = new ArrayList(5);
        errInfo.addAll(res.getAllErrorInfo());
        List errValidateInfo = res.getAllErrorOrValidateInfo();
        if (errValidateInfo != null && !errValidateInfo.isEmpty()) {
            errValidateInfo.forEach(e -> errInfo.add((OperateErrorInfo)e));
        }
        ArrayList<String> errMsg = new ArrayList<String>(5);
        errInfo.forEach(info -> {
            if (ErrorLevel.Info != info.getLevel()) {
                errMsg.add(info.getMessage());
            }
        });
        if (errMsg.isEmpty()) {
            errMsg.add(res.getMessage());
        }
        return errMsg;
    }

    private static Map<Long, String> getSplitErrorRes(Map<Long, Map<String, String>> splitRes) {
        LinkedHashMap<Long, String> errorInfo = new LinkedHashMap<Long, String>(8);
        if (splitRes == null || splitRes.isEmpty()) {
            return errorInfo;
        }
        for (Map.Entry<Long, Map<String, String>> e : splitRes.entrySet()) {
            Map<String, String> v = e.getValue();
            if (!"E".equalsIgnoreCase(v.get("status"))) continue;
            errorInfo.put(e.getKey(), v.get("msg"));
        }
        return errorInfo;
    }
}

