/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffCheckPlugin;

public class KITWriteOffCheckPlugin
implements IWriteOffCheckPlugin {
    private static final Log logger = LogFactory.getLog(KITWriteOffCheckPlugin.class);
    private Map<Long, BigDecimal> childRateMap = new HashMap<Long, BigDecimal>(16);
    private String orderBillEntityNum = "sm_salorder";

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_SALE);
    }

    @Override
    public boolean check(DynamicObject recordBill) {
        logger.info("KITWriteOffCheckPlugin-\u5f00\u59cbcheck");
        if (!recordBill.getDataEntityType().getProperties().containsKey((Object)"producttype")) {
            return true;
        }
        if (!"kitparent".equals(recordBill.getString("producttype"))) {
            logger.info("KITWriteOffCheckPlugin-\u975e\u7236\u9879\u8bb0\u5f55");
            return true;
        }
        Long pid = recordBill.getLong("pid");
        BigDecimal verifyBaseQty = recordBill.getBigDecimal("verifybaseqty");
        boolean isRedBill = verifyBaseQty.compareTo(BigDecimal.ZERO) < 0;
        this.childRateMap.clear();
        this.loadOrderChildRate(pid);
        if (this.childRateMap.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"KITWriteOffCheckPlugin-\u6839\u636e\u7236\u9879ID\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u5b50\u9879\u5206\u5f55,pid:%1$s", (String)"KITWriteOffCheckPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), pid));
        }
        QFilter childBillQ = new QFilter("billentry.kitproducttype", "=", (Object)"kitchild");
        childBillQ.and("billstatus", "=", (Object)"C");
        if (isRedBill) {
            childBillQ.and("billentry.unverifyqty", "<", (Object)BigDecimal.ZERO);
        } else {
            childBillQ.and("billentry.unverifyqty", ">", (Object)BigDecimal.ZERO);
        }
        childBillQ.and("billentry.kitpid", "=", (Object)pid);
        String childSelect = "billentry.unverifybaseqty as unverifybaseqty,billentry.mainbillentryid as orderentryid,billentry.baseunit.precision as baseunitprecision";
        DataSet childDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_saloutbill", (String)childSelect, (QFilter[])childBillQ.toArray(), null);
        childDS = childDS.groupBy(new String[]{"orderentryid", "baseunitprecision"}).sum("unverifybaseqty").finish().select("orderentryid,unverifybaseqty,baseunitprecision");
        HashMap<Long, BigDecimal> orderEIdAndUnWfQtyMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, Integer> orderEIdAndUnitPrecisionMap = new HashMap<Long, Integer>(16);
        for (Row childRow : childDS) {
            orderEIdAndUnWfQtyMap.put(childRow.getLong("orderentryid"), childRow.getBigDecimal("unverifybaseqty"));
            orderEIdAndUnitPrecisionMap.put(childRow.getLong("orderentryid"), childRow.getInteger("baseunitprecision"));
        }
        for (Map.Entry<Long, BigDecimal> orderEntry : this.childRateMap.entrySet()) {
            Long orderEntryId = orderEntry.getKey();
            BigDecimal orderEntryRate = orderEntry.getValue();
            Integer baseUnitPrescision = (Integer)orderEIdAndUnitPrecisionMap.get(orderEntryId);
            int unitPrescision = baseUnitPrescision == null ? 2 : baseUnitPrescision;
            BigDecimal childNeedWfQty = verifyBaseQty.multiply(orderEntryRate).setScale(unitPrescision, RoundingMode.HALF_UP);
            BigDecimal childHasWfQty = (BigDecimal)orderEIdAndUnWfQtyMap.get(orderEntryId);
            if (childHasWfQty == null) {
                logger.info("KITWriteOffCheckPlugin-\u8ba2\u5355\u5b50\u9879\u5206\u5f55\u6ca1\u6709\u4e1a\u52a1\u6570\u636e\uff0corentryid:" + orderEntryId);
                throw new KDBizException(ResManager.loadKDString((String)"\u5957\u4ef6\u9500\u552e\u6838\u9500\u4e0d\u6ee1\u8db3\u9f50\u5957\u6761\u4ef6\uff0c\u6838\u9500\u5931\u8d25\u3002", (String)"KITWriteOffCheckPlugin_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            if (childHasWfQty.abs().compareTo(childNeedWfQty.abs()) >= 0) continue;
            logger.info("KITWriteOffCheckPlugin-\u5269\u4f59\u672a\u6838\u9500\u6570\u91cf:" + childHasWfQty + " < \u672c\u6b21\u9700\u8981\u7684\u672a\u6838\u9500\u6570\u91cf:" + childNeedWfQty);
            throw new KDBizException(ResManager.loadKDString((String)"\u5957\u4ef6\u9500\u552e\u6838\u9500\u4e0d\u6ee1\u8db3\u9f50\u5957\u6761\u4ef6\uff0c\u6838\u9500\u5931\u8d25\u3002", (String)"KITWriteOffCheckPlugin_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return true;
    }

    private void loadOrderChildRate(Long pid) {
        QFilter orderBillQ = new QFilter("billentry.producttype", "=", (Object)"kitchild");
        orderBillQ.and("billentry.kitpid", "=", (Object)pid);
        orderBillQ.and("billentry.linetype.storageout", "=", (Object)"1");
        DataSet orderBillDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.orderBillEntityNum, (String)"billentry.kitpid as pid,billentry.id as entryid,billentry.kitqty as kitqty,billentry.parentqty as parentqty", (QFilter[])orderBillQ.toArray(), null);
        for (Row row : orderBillDS) {
            Long entryId = row.getLong("entryid");
            BigDecimal kitQty = row.getBigDecimal("kitqty");
            BigDecimal parentQty = row.getBigDecimal("parentqty");
            BigDecimal qtyRate = BigDecimal.ZERO;
            if (parentQty.compareTo(BigDecimal.ZERO) != 0) {
                qtyRate = kitQty.divide(parentQty, 10, RoundingMode.HALF_UP);
            }
            this.childRateMap.put(entryId, qtyRate);
        }
    }
}

