/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.model.KITChildRecordInfo;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.PurWriteOffInvokeCalPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;

public class KITWriteOffGeneratePlugin
implements IWriteOffPlugin {
    private static final Log logger = LogFactory.getLog(PurWriteOffInvokeCalPlugin.class);
    private String orderBillEntityNum = "sm_salorder";
    private String recordEntityNum = "cal_salwfrecord";
    private String mainBillEntityNum = "im_saloutbill";
    private Map<Long, List<KITChildRecordInfo>> childRecordInfoMap = new HashMap<Long, List<KITChildRecordInfo>>(16);
    private Map<Long, BigDecimal> childRateMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, Set<Long>> orderParentChildIdMap = new HashMap<Long, Set<Long>>(16);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_SALE);
    }

    @Override
    public void afterWfRecordStrategy(List<DynamicObject> records) {
        logger.info("KITWriteOffGeneratePlugin-\u5f00\u59cb\u5957\u4ef6\u5b50\u9879\u6838\u9500\u5904\u7406");
        if (records == null || records.isEmpty()) {
            return;
        }
        if (!records.get(0).getDataEntityType().getProperties().containsKey((Object)"producttype")) {
            return;
        }
        HashSet<Object> parentRecordIds = new HashSet<Object>(16);
        for (DynamicObject record : records) {
            if (!"kitparent".equals(record.getString("producttype"))) continue;
            parentRecordIds.add(record.getPkValue());
        }
        if (parentRecordIds.isEmpty()) {
            return;
        }
        logger.info("KITWriteOffGeneratePlugin-\u7236\u9879\u6838\u9500\u8bb0\u5f55id\uff1a" + parentRecordIds);
        String recordFileds = this.getReorcdField(this.recordEntityNum);
        DynamicObject[] recordArray = BusinessDataServiceHelper.load((String)this.recordEntityNum, (String)recordFileds, (QFilter[])new QFilter("id", "in", parentRecordIds).toArray());
        HashSet<Long> pidSet = new HashSet<Long>(16);
        HashMap<Long, Boolean> pidIsRedBillMap = new HashMap<Long, Boolean>(16);
        for (DynamicObject record : recordArray) {
            Long pid = record.getLong("pid");
            boolean isRedBill = record.getBigDecimal("verifybaseqty").compareTo(BigDecimal.ZERO) < 0;
            pidSet.add(pid);
            pidIsRedBillMap.put(pid, isRedBill);
        }
        if (pidSet.isEmpty()) {
            logger.info("KITWriteOffGeneratePlugin-\u7236\u9879\u6838\u9500\u8bb0\u5f55\u672a\u8bb0\u5f55PID");
            return;
        }
        logger.info("KITWriteOffGeneratePlugin-\u7236\u9879id\u4e0e\u662f\u5426\u7ea2\u5355\u5173\u7cfb\uff1a" + pidIsRedBillMap);
        this.loadOrderChildRate(pidSet);
        DataSet childBillDS = this.getChildSalOutBillDataSet(pidSet, pidIsRedBillMap);
        this.buildChildInfo(childBillDS);
        ArrayList<DynamicObject> childRecordList = new ArrayList<DynamicObject>(16);
        for (DynamicObject parentRecord : recordArray) {
            Long pid = parentRecord.getLong("pid");
            BigDecimal parentVerifyBaseQty = parentRecord.getBigDecimal("verifybaseqty");
            Set<Long> childEntryIds = this.orderParentChildIdMap.get(pid);
            if (childEntryIds == null) continue;
            block3: for (Long childEntryId : childEntryIds) {
                List<KITChildRecordInfo> childInfos = this.childRecordInfoMap.get(childEntryId);
                if (childInfos == null) continue;
                BigDecimal rate = this.childRateMap.get(childEntryId);
                BigDecimal qtyRate = childInfos.get(0).getQty().divide(childInfos.get(0).getBaseqty(), 10, RoundingMode.HALF_UP);
                int baseUnitPrescision = childInfos.get(0).getBaseunitprecision();
                BigDecimal childVerifyBaseQty = parentVerifyBaseQty.multiply(rate).setScale(baseUnitPrescision, RoundingMode.HALF_UP);
                for (KITChildRecordInfo childInfo : childInfos) {
                    if (childInfo.isAllWf()) continue;
                    BigDecimal unVerifyBaseQty = childInfo.getUnverifybaseqty();
                    if (childVerifyBaseQty.compareTo(BigDecimal.ZERO) == 0 || unVerifyBaseQty.compareTo(BigDecimal.ZERO) == 0) continue block3;
                    DynamicObject childRecordDym = WriteOffRecordHelper.cloneRecord(parentRecord, this.recordEntityNum);
                    this.setChildRecordFields(childInfo, parentRecord, childRecordDym);
                    if (unVerifyBaseQty.abs().compareTo(childVerifyBaseQty.abs()) <= 0) {
                        childVerifyBaseQty = childVerifyBaseQty.subtract(unVerifyBaseQty);
                        childInfo.setUnverifybaseqty(BigDecimal.ZERO);
                        childInfo.setAllWf(Boolean.TRUE);
                    } else {
                        childRecordDym.set("verifyqty", (Object)childVerifyBaseQty.multiply(qtyRate).setScale(baseUnitPrescision, RoundingMode.HALF_UP));
                        childRecordDym.set("verifybaseqty", (Object)childVerifyBaseQty);
                        childInfo.setUnverifybaseqty(unVerifyBaseQty.subtract(childVerifyBaseQty));
                        childVerifyBaseQty = BigDecimal.ZERO;
                    }
                    childRecordList.add(childRecordDym);
                }
            }
        }
        if (childRecordList.isEmpty()) {
            logger.info("KITWriteOffGeneratePlugin-\u672a\u751f\u6210\u5b50\u9879\u6838\u9500\u8bb0\u5f55");
            return;
        }
        SaveServiceHelper.save((DynamicObject[])childRecordList.toArray(new DynamicObject[0]));
        String actionName = "SALEWRITEOFF";
        if ("cal_purwfrecord".equals(this.recordEntityNum)) {
            actionName = "PURWRITEOFF";
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{actionName, null, childRecordList.toArray(new DynamicObject[0])});
    }

    private String getReorcdField(String recordEntityNum) {
        StringBuilder fields = new StringBuilder();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)recordEntityNum);
        Set selectorsSet = entityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.append("billtype.number");
        fields.append("currency.amtprecision");
        fields.append("basecurrency.amtprecision");
        return fields.toString();
    }

    private void setChildRecordFields(KITChildRecordInfo childInfo, DynamicObject parentRecord, DynamicObject childRecord) {
        childRecord.set("headwfinfo", (Object)"");
        childRecord.set("headwfinfo_tag", (Object)"");
        DynamicObject childRecordEntry = (DynamicObject)childRecord.getDynamicObjectCollection("entry").get(0);
        childRecordEntry.set("wfinfo", (Object)"");
        childRecordEntry.set("wfinfo_tag", (Object)"");
        childRecordEntry.set("e_verifyamount", (Object)BigDecimal.ZERO);
        childRecordEntry.set("e_localverifyamt", (Object)BigDecimal.ZERO);
        childRecord.set("producttype", (Object)"kitchild");
        childRecord.set("material_id", (Object)childInfo.getMaterial());
        childRecord.set("billno", (Object)childInfo.getBillno());
        childRecord.set("billid", (Object)childInfo.getBillid());
        childRecord.set("billentryid", (Object)childInfo.getEntryid());
        childRecord.set("billdate", (Object)childInfo.getBookdate());
        childRecord.set("qty", (Object)childInfo.getQty());
        childRecord.set("measureunit_id", (Object)childInfo.getUnit());
        childRecord.set("baseqty", (Object)childInfo.getBaseqty());
        childRecord.set("baseunit_id", (Object)childInfo.getBaseunit());
        childRecord.set("verifyqty", (Object)childInfo.getUnverifyqty());
        childRecord.set("verifybaseqty", (Object)childInfo.getUnverifybaseqty());
    }

    private void buildChildInfo(DataSet childBillDS) {
        for (Row row : childBillDS) {
            KITChildRecordInfo childInfo = new KITChildRecordInfo();
            Long orderentryid = row.getLong("orderentryid");
            childInfo.setOrderentryid(orderentryid);
            childInfo.setOrderpid(row.getLong("orderpid"));
            childInfo.setBookdate(row.getDate("bookdate"));
            childInfo.setBillno(row.getString("billno"));
            childInfo.setBillid(row.getLong("billid"));
            childInfo.setEntryid(row.getLong("billentryid"));
            childInfo.setQty(row.getBigDecimal("qty"));
            childInfo.setBaseqty(row.getBigDecimal("baseqty"));
            childInfo.setUnverifyqty(row.getBigDecimal("unverifyqty"));
            childInfo.setUnverifybaseqty(row.getBigDecimal("unverifybaseqty"));
            childInfo.setAmount(row.getBigDecimal("amount"));
            childInfo.setMaterial(row.getLong("materialid"));
            childInfo.setUnit(row.getLong("unit"));
            childInfo.setUnitprecision(row.getInteger("unitprecision"));
            childInfo.setBaseunit(row.getLong("baseunit"));
            childInfo.setBaseunitprecision(row.getInteger("baseunitprecision"));
            childInfo.setAllWf(Boolean.FALSE);
            List<KITChildRecordInfo> infoList = this.childRecordInfoMap.get(orderentryid);
            if (infoList == null) {
                infoList = new ArrayList<KITChildRecordInfo>(16);
            }
            infoList.add(childInfo);
            this.childRecordInfoMap.put(orderentryid, infoList);
        }
    }

    private DataSet getChildSalOutBillDataSet(Set<Long> pidSet, Map<Long, Boolean> pidIsRedBillMap) {
        ArrayList<OrmInput> allBillIOs = new ArrayList<OrmInput>(16);
        String childSelect = "bookdate,billno,id as billid,billentry.id as billentryid,billentry.mainbillid as orderid,billentry.mainbillentryid as orderentryid,billentry.kitpid as orderpid,billentry.qty as qty,billentry.baseqty as baseqty,billentry.unverifyqty as unverifyqty,billentry.unverifybaseqty as unverifybaseqty,billentry.amount as amount,billentry.material.masterid as materialid,billentry.unit as unit,billentry.unit.precision as unitprecision,billentry.baseunit as baseunit,billentry.baseunit.precision as baseunitprecision";
        QFilter childBillQ = new QFilter("billentry.kitproducttype", "=", (Object)"kitchild");
        childBillQ.and("billstatus", "=", (Object)"C");
        for (Long pid : pidSet) {
            QFilter crtQfilter = childBillQ.copy();
            boolean isRedBill = pidIsRedBillMap.get(pid);
            if (isRedBill) {
                crtQfilter.and("billentry.unverifyqty", "<", (Object)BigDecimal.ZERO);
            } else {
                crtQfilter.and("billentry.unverifyqty", ">", (Object)BigDecimal.ZERO);
            }
            crtQfilter.and("billentry.kitpid", "=", (Object)pid);
            OrmInput childBillIO = new OrmInput(this.getClass().getName(), this.mainBillEntityNum, childSelect, new QFilter[]{crtQfilter});
            allBillIOs.add(childBillIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        return algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
    }

    private void loadOrderChildRate(Set<Long> pidSet) {
        QFilter orderBillQ = new QFilter("billentry.producttype", "=", (Object)"kitchild");
        orderBillQ.and("billentry.kitpid", "in", pidSet);
        orderBillQ.and("billentry.linetype.storageout", "=", (Object)"1");
        DataSet orderBillDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.orderBillEntityNum, (String)"billentry.kitpid as pid,billentry.id as entryid,billentry.kitqty as kitqty,billentry.parentqty as parentqty", (QFilter[])orderBillQ.toArray(), null);
        for (Row row : orderBillDS) {
            Long pid = row.getLong("pid");
            Long entryId = row.getLong("entryid");
            BigDecimal kitQty = row.getBigDecimal("kitqty");
            BigDecimal parentQty = row.getBigDecimal("parentqty");
            BigDecimal qtyRate = BigDecimal.ZERO;
            if (parentQty.compareTo(BigDecimal.ZERO) != 0) {
                qtyRate = kitQty.divide(parentQty, 10, RoundingMode.HALF_UP);
            }
            this.childRateMap.put(entryId, qtyRate);
            Set<Long> childEntryIdSet = this.orderParentChildIdMap.get(pid);
            if (childEntryIdSet == null) {
                childEntryIdSet = new HashSet<Long>(16);
            }
            childEntryIdSet.add(entryId);
            this.orderParentChildIdMap.put(pid, childEntryIdSet);
        }
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        Collections.singletonList("producttype");
        HashSet<String> keySet = new HashSet<String>(16);
        keySet.add("producttype");
        fieldMap.put("cal_salwfrecord", keySet);
        return fieldMap;
    }
}

