/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffPlugin;

public class PurOmUnWfExtPlugin
implements IUnWriteOffPlugin {
    private static final String REWRITE_REQBILL_SQL = "update t_im_osmreqoutbillentry_r set fosverifyqty = fosverifyqty - ?, fosverifybaseqty = fosverifybaseqty - ?,fosunverifyqty = fosunverifyqty + ?,fosunverifybaseqty = fosunverifybaseqty + ? where fentryid = ?";

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_OS_PURIN);
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        HashMap<String, Map<String, List<Object[]>>> backSqlMap = new HashMap<String, Map<String, List<Object[]>>>(16);
        HashSet<Long> recordEntryIds = new HashSet<Long>(16);
        for (DynamicObject record : records) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                String billType = entry.getDynamicObject("billtype").getString("number");
                if ("im_ospurinbill".equals(billType)) continue;
                recordEntryIds.add(entry.getLong("id"));
            }
        }
        if (recordEntryIds.isEmpty()) {
            return backSqlMap;
        }
        DataSet adjustRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_omwfadjustrecord", (String)"entryentity.recordentryid as recordentryid,entryentity.diffbaseqty as diffbaseqty,entryentity.diffqty as diffqty", (QFilter[])new QFilter("entryentity.recordentryid", "in", recordEntryIds).toArray(), null);
        adjustRecordDs = adjustRecordDs.groupBy(new String[]{"recordentryid"}).sum("diffbaseqty").sum("diffqty").finish();
        HashMap<Long, BigDecimal> diffBaseQtyMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> diffQtyMap = new HashMap<Long, BigDecimal>(16);
        for (Object row : adjustRecordDs) {
            Long recordEntryId = row.getLong("recordentryid");
            diffBaseQtyMap.put(recordEntryId, row.getBigDecimal("diffbaseqty"));
            diffQtyMap.put(recordEntryId, row.getBigDecimal("diffqty"));
        }
        if (diffBaseQtyMap.isEmpty()) {
            return backSqlMap;
        }
        ArrayList<Object[]> reWriteParamsList = new ArrayList<Object[]>(16);
        for (DynamicObject record : records) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                String billType = entry.getDynamicObject("billtype").getString("number");
                if ("im_ospurinbill".equals(billType)) continue;
                Long recordEntryId = entry.getLong("id");
                BigDecimal diffBaseQty = (BigDecimal)diffBaseQtyMap.get(recordEntryId);
                BigDecimal diffQty = (BigDecimal)diffQtyMap.get(recordEntryId);
                if (diffBaseQty == null || diffQty == null) continue;
                reWriteParamsList.add(new Object[]{diffQty, diffBaseQty, diffQty, diffBaseQty, entry.getLong("billentryid")});
            }
        }
        if (reWriteParamsList.isEmpty()) {
            return backSqlMap;
        }
        HashMap<String, ArrayList<Object[]>> reqBillSqlMap = new HashMap<String, ArrayList<Object[]>>(16);
        reqBillSqlMap.put(REWRITE_REQBILL_SQL, reWriteParamsList);
        backSqlMap.put("scm", reqBillSqlMap);
        return backSqlMap;
    }
}

